/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class HostList
extends JDialog {
    private JDialog parent;
    private TangoHost[] hosts;
    private String selectedHostName;
    private int retVal = 0;
    private JList<String> hostList;
    private JScrollPane jScrollPane1;
    private JLabel titleLabel;

    public HostList(JDialog parent, String theHost) throws DevFailed {
        super((Dialog)parent, true);
        this.parent = parent;
        this.initComponents();
        this.hosts = AstorUtil.getInstance().getTangoHostList();
        ArrayList<String> hostNames = new ArrayList<String>();
        boolean i = false;
        for (TangoHost host : this.hosts) {
            int start = host.name().lastIndexOf(47);
            if (start > 0) {
                hostNames.add(host.name().substring(start + 1));
                continue;
            }
            hostNames.add(host.name());
        }
        for (String hostName : hostNames) {
            if (!hostName.equals(theHost)) continue;
            hostNames.remove(hostName);
            break;
        }
        this.hostList.setListData((String[])hostNames.toArray(new String[hostNames.size()]));
        this.hostList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HostList.this.listSelectionPerformed(e);
            }
        });
        this.titleLabel.setText("Host List ");
        int h = 20 * hostNames.size();
        if (h > 600) {
            h = 600;
        }
        this.jScrollPane1.setPreferredSize(new Dimension(200, h));
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.hostList = new JList();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                HostList.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Hosts in control system");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostList.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HostList.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.jScrollPane1.setViewportView(this.hostList);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private TangoHost getHost(String name) {
        String deviceName = AstorUtil.getStarterDeviceHeader() + name.toLowerCase();
        for (TangoHost host : this.hosts) {
            if (!host.name().toLowerCase().equals(deviceName)) continue;
            return host;
        }
        return null;
    }

    public List<String> getServerList() throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(this.selectedHostName);
        DeviceData argOut = ApiUtil.get_db_obj().command_inout("DbGetHostServerList", argIn);
        String[] serverList = argOut.extractStringArray();
        ArrayList<String> list = new ArrayList<String>();
        for (String server : serverList) {
            if (server.startsWith("Starter/")) continue;
            list.add(server);
        }
        return list;
    }

    public String getSelectedHostName() {
        return this.selectedHostName;
    }

    private void listSelectionPerformed(MouseEvent evt) {
        System.out.println("In listSelectionPerformed() " + evt.getClickCount());
        if (evt.getClickCount() == 2) {
            this.selectedHostName = this.hostList.getSelectedValue();
            this.retVal = 0;
            this.doClose();
        }
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.selectedHostName = this.hostList.getSelectedValue();
        this.retVal = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }
}

