/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class GetTextDialog
extends JDialog {
    private int retVal = 0;
    private JTextArea textArea;
    private JLabel titleLabel;

    public GetTextDialog(JDialog parent, String title, String tip, String[] lines) {
        super((Dialog)parent, true);
        this.initComponents();
        ArrayList<String> list = new ArrayList<String>();
        if (lines != null) {
            Collections.addAll(list, lines);
        }
        this.initialize(title, tip, list);
    }

    public GetTextDialog(JFrame parent, String title, String tip, List<String> lines) {
        super((Frame)parent, true);
        this.initComponents();
        this.initialize(title, tip, lines);
    }

    private void initialize(String title, String tip, List<String> lines) {
        this.titleLabel.setText(title);
        this.textArea.setToolTipText(tip);
        if (lines != null) {
            String text = "";
            for (String line : lines) {
                text = text + line.trim() + "\n";
            }
            this.textArea.setText(text);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.textArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GetTextDialog.this.closeDialog(evt);
            }
        });
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetTextDialog.this.okBtnActionPerformed(evt);
            }
        });
        jPanel1.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GetTextDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        jScrollPane1.setPreferredSize(new Dimension(500, 300));
        this.textArea.setColumns(60);
        this.textArea.setFont(new Font("Courier", 1, 14));
        this.textArea.setRows(5);
        jScrollPane1.setViewportView(this.textArea);
        this.getContentPane().add((Component)jScrollPane1, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.retVal = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public String getText() {
        return this.textArea.getText().trim();
    }

    public List<String> getTextLines() {
        String str = this.getText();
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(str, "\n");
        while (stk.hasMoreTokens()) {
            tokens.add(stk.nextToken());
        }
        return tokens;
    }

    public String[] getTextLinesAsArray() {
        List<String> list = this.getTextLines();
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }
}

