/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.Monitor;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeviceTree
extends JTree
implements AstorDefs {
    private CtrlSystem cs;
    private Astor astor;
    private JTextArea infoLabel;
    private final String[] collections = new String[]{"Controlled Servers", "Not Controlled servers", "Devices"};
    private final int CTRL_SERVERS = 0;
    private final int N_CTRL_SERVERS = 1;
    private final int DEVICES = 2;
    private Monitor monitor;
    boolean canceled = false;
    private DefaultMutableTreeNode[] collnodes;

    public DeviceTree(Astor astor, Monitor monitor, JTextArea lbl, String title) {
        this.astor = astor;
        this.monitor = monitor;
        this.infoLabel = lbl;
        this.cs = new CtrlSystem(astor.tree.hosts.length);
        this.initComponent(title);
    }

    private void initComponent(String title) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(title);
        this.createNodes(root);
        this.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.setModel(treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
                DeviceTree.this.collapsedPerfomed(e);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DeviceTree.this.treeMouseClicked(evt);
            }
        });
    }

    private void createNodes(DefaultMutableTreeNode root) {
        this.collnodes = new DefaultMutableTreeNode[this.collections.length];
        for (int i = 0; i < this.collections.length; ++i) {
            this.collnodes[i] = new DefaultMutableTreeNode(this.collections[i]);
            root.add(this.collnodes[i]);
        }
        try {
            double ratio;
            DefaultMutableTreeNode[] s_node = new DefaultMutableTreeNode[2];
            String[] servers = ApiUtil.get_db_obj().get_server_name_list();
            for (int i = 0; i < servers.length; ++i) {
                String[] instances;
                ratio = (double)i / (double)servers.length / 2.0;
                s_node[0] = new DefaultMutableTreeNode(servers[i]);
                s_node[1] = new DefaultMutableTreeNode(servers[i]);
                for (String instance : instances = ApiUtil.get_db_obj().get_instance_name_list(servers[i])) {
                    String servname = servers[i] + "/" + instance;
                    this.canceled = this.monitor.isCanceled();
                    if (this.canceled) {
                        return;
                    }
                    this.monitor.setProgressValue(ratio, "Building for Server " + servname);
                    DbServInfo info = new DbServer(servname).get_info();
                    if (info.controlled) {
                        ++this.cs.nb_instances;
                        DbServer dbs = new DbServer(servname);
                        String[] classes = dbs.get_class_list();
                        this.cs.nb_classes += classes.length;
                        for (String classname : classes) {
                            String[] dn = dbs.get_device_name(classname);
                            this.cs.nb_devices += dn.length;
                        }
                        s_node[0].add(new DefaultMutableTreeNode(instance));
                        continue;
                    }
                    ++this.cs.not_c_instances;
                    s_node[1].add(new DefaultMutableTreeNode(instance));
                }
                if (s_node[0].getChildCount() > 0) {
                    ++this.cs.nb_servers;
                    this.collnodes[0].add(s_node[0]);
                }
                if (s_node[1].getChildCount() > 0) {
                    this.collnodes[1].add(s_node[1]);
                }
                Thread.sleep(10L);
            }
            Database dbase = ApiUtil.get_db_obj();
            String[] domain = dbase.get_device_domain("*");
            for (int i = 0; i < domain.length; ++i) {
                String[] family;
                ratio = (double)i / (double)domain.length / 2.0 + 0.5;
                DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(domain[i]);
                this.collnodes[2].add(d_node);
                String wildcard = domain[i] + "/*";
                for (String aFamily : family = dbase.get_device_family(wildcard)) {
                    String[] member;
                    this.canceled = this.monitor.isCanceled();
                    if (this.canceled) {
                        return;
                    }
                    this.monitor.setProgressValue(ratio, "Building for Device family " + domain[i] + "/" + aFamily);
                    DefaultMutableTreeNode f_node = new DefaultMutableTreeNode(aFamily);
                    d_node.add(f_node);
                    wildcard = domain[i] + "/" + aFamily + "/*";
                    for (String aMember : member = dbase.get_device_member(wildcard)) {
                        DefaultMutableTreeNode m_node = new DefaultMutableTreeNode(aMember);
                        f_node.add(m_node);
                    }
                }
                Thread.sleep(10L);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.astor, null, (DevFailed)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) < 1) {
            return;
        }
        TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
        if (path == null) {
            return;
        }
        int mask = evt.getModifiers();
        if ((mask & 0x10) != 0) {
            String deviceName;
            switch (path.getPathCount()) {
                case 5: {
                    deviceName = this.getDeviceName(path);
                    if (deviceName != null) break;
                    return;
                }
                case 4: {
                    String serverName = this.getServerName(path);
                    if (serverName == null) {
                        return;
                    }
                    deviceName = "dserver/" + serverName;
                    break;
                }
                default: {
                    return;
                }
            }
            try {
                DeviceInfo info = ApiUtil.get_db_obj().get_device_info(deviceName);
                this.infoLabel.setText(info.toString());
            }
            catch (DevFailed e) {
                this.infoLabel.setText(" ");
            }
            if (evt.getClickCount() == 2) {
                this.showHostInfoDialogForDevice(deviceName, evt);
            }
        }
    }

    public void collapsedPerfomed(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        if (path.getPathCount() > 2) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
        if (path.getPathCount() == 1) {
            this.setExpandedState(new TreePath(node.getPath()), true);
            Utils.popupMessage(this.astor, this.cs.toString(), "TangoClass.gif");
        }
    }

    String[][] getNotCtrlServers() {
        DefaultMutableTreeNode node = this.collnodes[1];
        int nbServers = node.getChildCount();
        ArrayList<String> serverNames = new ArrayList<String>();
        for (int i = 0; i < nbServers; ++i) {
            node = node.getNextNode();
            String serverName = node.toString();
            int nb_inst = node.getChildCount();
            try {
                for (int j = 0; j < nb_inst; ++j) {
                    node = node.getNextNode();
                    String server = serverName + "/" + node;
                    DbServInfo info = new DbServer(server).get_info();
                    if (info.controlled || serverName.equals("Starter")) continue;
                    serverNames.add(server);
                }
                continue;
            }
            catch (DevFailed e) {
                serverNames.add(e.errors[0].desc);
            }
        }
        String[][] result = new String[serverNames.size()][];
        for (int i = 0; i < serverNames.size(); ++i) {
            String server = (String)serverNames.get(i);
            result[i] = new String[2];
            result[i][0] = server;
            try {
                DeviceInfo info2 = new DbDevice("dserver/" + server).get_info();
                result[i][1] = info2.last_exported;
                continue;
            }
            catch (DevFailed e) {
                result[i][1] = e.errors[0].desc;
            }
        }
        return result;
    }

    private void showHostInfoDialogForDevice(String devname, MouseEvent evt) {
        try {
            String hostname = new IORdump(devname).get_host();
            if (hostname == null) {
                Except.throw_exception((String)"UNKNOWN_HOST", (String)"May be this device has never been exported !", (String)"");
            } else {
                StringTokenizer st = new StringTokenizer(hostname);
                hostname = st.nextToken();
                st = new StringTokenizer(hostname, ".");
                hostname = st.nextToken();
                this.astor.tree.setSelectionPath(hostname);
                this.astor.tree.displayHostInfo();
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private String getDeviceName(TreePath path) {
        String collec = path.getPathComponent(1).toString();
        if (!collec.equals(this.collections[2])) {
            return null;
        }
        return path.getPathComponent(2).toString() + "/" + path.getPathComponent(3).toString() + "/" + path.getPathComponent(4).toString();
    }

    private String getServerName(TreePath path) {
        String collec = path.getPathComponent(1).toString();
        if (collec.equals(this.collections[0]) && collec.equals(this.collections[1])) {
            return null;
        }
        return path.getPathComponent(2).toString() + "/" + path.getPathComponent(3).toString();
    }

    String csInfo() {
        return this.cs.toString();
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon tangoIcon = Utils.getInstance().getIcon("TransparentTango.gif", 0.15);
        private ImageIcon serv_icon = Utils.getInstance().getIcon("server.gif");
        private ImageIcon dev_icon = Utils.getInstance().getIcon("device.gif");
        private Font[] fonts = new Font[2];
        private final int TITLE = 0;
        private final int LEAF = 1;

        public TangoRenderer() {
            this.fonts[0] = new Font("helvetica", 1, 18);
            this.fonts[1] = new Font("helvetica", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(Color.white);
            if (row == 0) {
                this.setBackgroundSelectionColor(Color.white);
                this.setIcon(this.tangoIcon);
                this.setFont(this.fonts[0]);
                this.setToolTipText("Double click to popup info");
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                Object user_obj = node.getUserObject();
                switch (node.getLevel()) {
                    case 1: {
                        this.setBackgroundSelectionColor(Color.white);
                        this.setToolTipText("Tango " + user_obj.toString());
                        this.setFont(this.fonts[0]);
                        break;
                    }
                    default: {
                        this.setBackgroundSelectionColor(Color.lightGray);
                        if (leaf) {
                            TreeNode[] path = node.getPath();
                            DefaultMutableTreeNode c_node = (DefaultMutableTreeNode)path[1];
                            String collec = c_node.getUserObject().toString();
                            if (collec.equals(DeviceTree.this.collections[2])) {
                                this.setIcon(this.dev_icon);
                            } else {
                                this.setIcon(this.serv_icon);
                            }
                            this.setToolTipText("Double click to popup host window.");
                        }
                        this.setFont(this.fonts[1]);
                    }
                }
            }
            return this;
        }
    }

    class CtrlSystem {
        int nb_hosts = 0;
        int nb_servers = 0;
        int nb_instances = 0;
        int nb_classes = 0;
        int nb_devices = 0;
        int not_c_instances = 0;

        public CtrlSystem(int nb_hosts) {
            this.nb_hosts = nb_hosts;
        }

        public String toString() {
            String str = "";
            str = str + this.nb_hosts + "  Hosts controlled.\n";
            str = str + this.nb_servers + "  Different controlled servers.\n";
            str = str + this.nb_instances + "  Controlled servers/instances.\n";
            str = str + this.nb_classes + "  Controlled classes.\n";
            str = str + this.nb_devices + "  Controlled devices.\n\n";
            str = str + this.not_c_instances + "  NOT controlled servers/instances.";
            return str;
        }
    }
}

