/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class DbPollPanel
extends JDialog {
    private Component parent;
    private DeviceProxy selected_dev;
    private DeviceProxy[] devices;
    private PolledAttribute[] attlist;
    private static final String PollAttProp = "polled_attr";
    private JPanel panel = null;
    private JComboBox<String> devComboBox;
    private JScrollPane scrollPane;
    private JLabel titleLabel;

    public DbPollPanel(JFrame parent, String serverName) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.initialize(serverName);
    }

    public DbPollPanel(JDialog parent, String serverName) throws DevFailed {
        super((Dialog)parent, true);
        this.parent = parent;
        this.initialize(serverName);
    }

    private void initialize(String serverName) throws DevFailed {
        this.initComponents();
        this.titleLabel.setText("Polled Attributes For ");
        this.devices = this.getDeviceList(serverName);
        if (this.devices.length == 0) {
            Except.throw_exception((String)"NO_DEVICES", (String)("No device found for " + serverName), (String)("DbPollPanel.initialize(" + serverName + ")"));
        }
        this.buildPanel(this.devices.length - 1);
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private DeviceProxy[] getDeviceList(String serverName) {
        try {
            String[] classes;
            ArrayList<String> deviceList = new ArrayList<String>();
            DbServer dbServer = new DbServer(serverName);
            for (String className : classes = dbServer.get_class_list()) {
                String[] deviceNames = dbServer.get_device_name(className);
                deviceList.addAll(Arrays.asList(deviceNames));
            }
            DeviceProxy[] dp = new DeviceProxy[deviceList.size()];
            for (int i = 0; i < deviceList.size(); ++i) {
                this.devComboBox.addItem((String)deviceList.get(i));
                dp[i] = new DeviceProxy((String)deviceList.get(i));
            }
            this.devComboBox.setSelectedIndex(deviceList.size() - 1);
            return dp;
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
            return new DeviceProxy[0];
        }
    }

    private void buildPanel(int dev_idx) {
        this.selected_dev = this.devices[dev_idx];
        if (this.panel != null) {
            this.getContentPane().remove(this.panel);
        }
        try {
            GridBagConstraints gbc = new GridBagConstraints();
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            int y = 0;
            for (PolledAttribute att : this.attlist = this.getPolledAttributes(this.selected_dev)) {
                gbc.gridx = 0;
                gbc.gridy = y;
                gbc.fill = 2;
                panel.add((Component)att.radioButton, gbc);
                gbc.gridx = 1;
                gbc.gridy = y;
                gbc.fill = 2;
                panel.add((Component)att.textField, gbc);
                gbc.gridx = 2;
                gbc.gridy = y++;
                gbc.fill = 2;
                panel.add((Component)new JLabel("ms"), gbc);
            }
            this.scrollPane.setViewportView(panel);
            this.getContentPane().add((Component)this.scrollPane, "Center");
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
        this.pack();
        if (this.scrollPane.getHeight() > 800) {
            this.scrollPane.setPreferredSize(new Dimension(this.scrollPane.getWidth(), 800));
        }
    }

    public PolledAttribute[] getPolledAttributes(DeviceProxy dev) throws DevFailed {
        DbDatum argOut = dev.get_property(PollAttProp);
        String[] data = argOut.extractStringArray();
        if (data == null || data.length < 2) {
            return new PolledAttribute[0];
        }
        ArrayList<PolledAttribute> polledAttributeList = new ArrayList<PolledAttribute>();
        for (int i = 0; i < data.length; i += 2) {
            polledAttributeList.add(new PolledAttribute(data[i], data[i + 1]));
        }
        PolledAttribute[] polledAttributes = new PolledAttribute[polledAttributeList.size()];
        for (int i = 0; i < polledAttributeList.size(); ++i) {
            polledAttributes[i] = (PolledAttribute)polledAttributeList.get(i);
        }
        return polledAttributes;
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.devComboBox = new JComboBox();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.scrollPane = new JScrollPane();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DbPollPanel.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.devComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbPollPanel.this.devComboBoxActionPerformed(evt);
            }
        });
        topPanel.add(this.devComboBox);
        this.getContentPane().add((Component)topPanel, "North");
        okBtn.setText("Apply");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbPollPanel.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbPollPanel.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.pack();
    }

    private void devComboBoxActionPerformed(ActionEvent evt) {
        if (this.isVisible()) {
            this.buildPanel(this.devComboBox.getSelectedIndex());
        }
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        String message = "Remove polling for :\n";
        ArrayList<String> attributeList = new ArrayList<String>();
        for (PolledAttribute att : this.attlist) {
            if (att.radioButton.getSelectedObjects() == null) {
                message = message + att.name + "\n";
                continue;
            }
            attributeList.add(att.name);
            try {
                att.period = Integer.parseInt(att.textField.getText());
                attributeList.add(att.textField.getText());
            }
            catch (NumberFormatException e) {
                ErrorPane.showErrorMessage((Component)this, (String)("NumberFormatException on  attribute " + att.name), (Exception)e);
                return;
            }
        }
        System.out.println(attributeList.size());
        if (attributeList.size() < this.attlist.length * 2 && JOptionPane.showConfirmDialog(this, message, "Question", 0) != 0) {
            return;
        }
        String[] AttributeNames = new String[attributeList.size()];
        for (int i = 0; i < attributeList.size(); ++i) {
            AttributeNames[i] = (String)attributeList.get(i);
        }
        try {
            DbDatum data = new DbDatum(PollAttProp);
            data.insert(AttributeNames);
            this.selected_dev.put_property(data);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
        JOptionPane.showMessageDialog(this, "Database Updated", "", 1);
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        }
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        String serverName = null;
        if (args.length > 0) {
            serverName = args[0];
        }
        try {
            if (serverName == null) {
                Except.throw_exception((String)"NO_SERVER_NAME", (String)"Server's name ????", (String)"PollPanel.main()");
            }
            new DbPollPanel((JFrame)null, serverName).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
            System.exit(0);
        }
    }

    class PolledAttribute {
        String name;
        int period;
        JRadioButton radioButton;
        JTextField textField;

        public PolledAttribute(String name, String strperiod) {
            this.name = name;
            try {
                this.period = Integer.parseInt(strperiod);
            }
            catch (NumberFormatException e) {
                this.period = -1;
            }
            this.radioButton = new JRadioButton(name);
            this.radioButton.setSelected(true);
            this.textField = new JTextField(Integer.toString(this.period));
            this.textField.setColumns(6);
        }
    }
}

