/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;

public class CheckServer {
    private static final String[] actions = new String[]{"start", "stop", "restart", "ping"};
    private static String starter_name;
    private static String servname;
    private static String action;
    private static DeviceProxy starter;

    public CheckServer(String[] args) throws DevFailed {
        if (!this.checkSyntax(args)) {
            System.exit(0);
        }
        starter = new DeviceProxy(starter_name);
    }

    public void doAction() throws DevFailed {
        switch (action) {
            case "start": {
                this.execute("DevStart");
                System.out.println(servname + " started");
                break;
            }
            case "stop": {
                this.execute("DevStop");
                System.out.println(servname + " stopped");
                break;
            }
            case "restart": {
                this.restart();
                System.out.println(servname + " restarted");
                break;
            }
            case "ping": {
                new DeviceProxy("dserver/" + servname).ping();
                System.out.println(servname + " is alive");
            }
        }
    }

    private void execute(String cmd) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        starter.command_inout(cmd, argin);
    }

    private void restart() throws DevFailed {
        block4: {
            try {
                this.execute("DevStop");
                System.out.println(servname + " stopped");
            }
            catch (DevFailed e) {
                if (e.errors[0].reason.contains("NOT running !")) break block4;
                throw e;
            }
        }
        int nb_retries = 5;
        for (int i = 0; i < nb_retries; ++i) {
            String[] servers;
            this.sleep(1000L);
            DeviceData argin = new DeviceData();
            argin.insert(true);
            DeviceData argout = starter.command_inout("DevGetStopServers", argin);
            for (String server : servers = argout.extractStringArray()) {
                if (!server.equals(servname)) continue;
                i = nb_retries;
            }
        }
        this.execute("DevStart");
    }

    private synchronized void sleep(long ms) {
        try {
            this.wait(ms);
        }
        catch (InterruptedException e) {
            System.err.println(e.getMessage());
        }
    }

    private void displaySyntax(String script_name) {
        int start = script_name.lastIndexOf("/");
        if (start > 0) {
            script_name = script_name.substring(start + 1);
        }
        System.out.println("Syntax :");
        System.out.println(script_name + "  hosname  servname  action");
        System.out.println("\thosname  : Host name where server running");
        System.out.println("\tservname : Server name (e.g. VacGauge/sr_c02)");
        System.out.print("\taction   : ");
        for (int i = 0; i < actions.length; ++i) {
            if (i > 0) {
                System.out.print(" / ");
            }
            System.out.print(actions[i]);
        }
        System.out.println();
    }

    private boolean checkSyntax(String[] args) {
        if (args.length < 4) {
            this.displaySyntax(args[0]);
            return false;
        }
        starter_name = AstorUtil.getStarterDeviceHeader() + args[1];
        servname = args[2];
        action = args[3].toLowerCase();
        if (!servname.contains("/")) {
            System.out.println("Server name syntax error !");
            this.displaySyntax(args[0]);
            return false;
        }
        boolean found = false;
        for (int i = 0; !found && i < actions.length; ++i) {
            found = action.equals(actions[i]);
        }
        if (!found) {
            System.out.println("action name syntax error !");
            this.displaySyntax(args[0]);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            CheckServer client = new CheckServer(args);
            client.doAction();
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
    }
}

