/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AttMemoDialog
extends JDialog {
    private JDialog parent;
    private DbServer server;
    private boolean from_appli = true;
    private Memorized[] memorized;
    private static final String unknown = " ? ";
    private JLabel[] attLbl;
    private JTextField[] attVal;
    private JLabel titleLabel;
    private JPanel valuePanel;

    public AttMemoDialog(JDialog parent, DbServer server) throws DevFailed {
        super((Dialog)parent, true);
        this.parent = parent;
        this.server = server;
        this.initComponents();
        this.buildMemorizedPanel();
        this.titleLabel.setText("Memorized attributes found for " + server.name());
        this.pack();
        if (parent.getWidth() == 0) {
            this.from_appli = false;
        }
        if (this.from_appli) {
            AstorUtil.centerDialog((JDialog)this, parent);
        }
    }

    private void buildMemorizedPanel() throws DevFailed {
        this.readAttributes();
        this.attLbl = new JLabel[this.memorized.length];
        this.attVal = new JTextField[this.memorized.length];
        for (int i = 0; i < this.memorized.length; ++i) {
            GridBagConstraints gbc = new GridBagConstraints();
            int x = 0;
            int y = i + 1;
            this.attLbl[i] = new JLabel(this.memorized[i].attname);
            gbc.gridx = x++;
            gbc.gridy = y;
            gbc.fill = 2;
            this.valuePanel.add((Component)this.attLbl[i], gbc);
            gbc.gridx = x++;
            gbc.gridy = y;
            gbc.fill = 2;
            this.valuePanel.add((Component)new JLabel("  :    "), gbc);
            this.attVal[i] = new JTextField(this.memorized[i].value);
            this.attVal[i].setColumns(15);
            gbc.gridx = x++;
            gbc.gridy = y;
            gbc.fill = 2;
            this.valuePanel.add((Component)this.attVal[i], gbc);
            gbc.gridx = x;
            gbc.gridy = y;
            gbc.fill = 2;
            this.valuePanel.add((Component)new JLabel("     " + this.memorized[i].min + " < .... < " + this.memorized[i].max), gbc);
        }
    }

    private void readAttributes() throws DevFailed {
        DeviceProxy[] devices = this.getDevices();
        ArrayList<String> stringList = new ArrayList<String>();
        for (DeviceProxy device : devices) {
            String[] attlist;
            String deviceName = device.get_name();
            DeviceData argin = new DeviceData();
            String[] args = new String[]{deviceName, "*"};
            argin.insert(args);
            DeviceData argOut = ApiUtil.get_db_obj().command_inout("DbGetDeviceAttributeList", argin);
            for (String att : attlist = argOut.extractStringArray()) {
                DbAttribute db_att = device.get_attribute_property(att);
                String[] propertyList = db_att.get_property_list();
                for (int j = 0; j < propertyList.length; ++j) {
                    if (!propertyList[j].equals("__value")) continue;
                    String min = unknown;
                    if (!db_att.is_empty("min_value")) {
                        min = db_att.get_value("min_value")[0];
                    }
                    String max = unknown;
                    if (!db_att.is_empty("max_value")) {
                        max = db_att.get_value("max_value")[0];
                    }
                    stringList.add(deviceName + "/" + att);
                    stringList.add(db_att.get_string_value(j));
                    stringList.add(min);
                    stringList.add(max);
                }
            }
        }
        this.memorized = new Memorized[stringList.size() / 4];
        for (int i = 0; i < stringList.size(); i += 4) {
            this.memorized[i / 4] = new Memorized((String)stringList.get(i), (String)stringList.get(i + 1), (String)stringList.get(i + 2), (String)stringList.get(i + 3));
        }
    }

    private DeviceProxy[] getDevices() throws DevFailed {
        String[] classes;
        ArrayList<String> deviceNames = new ArrayList<String>();
        for (String aClass : classes = this.server.get_class_list()) {
            String[] devices = this.server.get_device_name(aClass);
            deviceNames.addAll(Arrays.asList(devices));
        }
        DeviceProxy[] dev = new DeviceProxy[deviceNames.size()];
        int i = 0;
        for (String deviceName : deviceNames) {
            dev[i++] = new DeviceProxy(deviceName);
        }
        return dev;
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.valuePanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AttMemoDialog.this.closeDialog(evt);
            }
        });
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttMemoDialog.this.okBtnActionPerformed(evt);
            }
        });
        jPanel1.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttMemoDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        this.valuePanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.valuePanel, "Center");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private boolean writeValues() {
        String message = "";
        for (int i = 0; i < this.attVal.length; ++i) {
            double val;
            String val_str = this.attVal[i].getText();
            Memorized memo = this.memorized[i];
            if (val_str.equals(memo.value)) continue;
            try {
                val = Double.parseDouble(val_str);
            }
            catch (NumberFormatException e) {
                Utils.popupError(this.parent, val_str + " is not a number !");
                return false;
            }
            if (!memo.min.equals(unknown)) {
                double min;
                try {
                    min = Double.parseDouble(memo.min);
                }
                catch (NumberFormatException e) {
                    Utils.popupError(this.parent, memo.min + " is not a number !");
                    return false;
                }
                if (val < min) {
                    Utils.popupError(this.parent, "Incorrect value:\n" + val_str + " is less than " + memo.min);
                    return false;
                }
            }
            if (!memo.max.equals(unknown)) {
                double max;
                try {
                    max = Double.parseDouble(memo.max);
                }
                catch (NumberFormatException e) {
                    Utils.popupError(this.parent, memo.max + " is not a number !");
                    return false;
                }
                if (val > max) {
                    Utils.popupError(this.parent, "Incorrect value:\n" + val_str + " is greater than " + memo.max);
                    return false;
                }
            }
            try {
                DbDatum data = new DbDatum("__value");
                data.insert(val_str);
                AttributeProxy att = new AttributeProxy(this.attLbl[i].getText());
                att.put_property(data);
                memo.value = val_str;
                message = message + this.attLbl[i].getText() + "  set to  " + val_str + "\n";
                continue;
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
                return false;
            }
        }
        if (message.length() > 0) {
            Utils.popupMessage(this.parent, message);
        }
        return true;
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        if (this.writeValues()) {
            this.doClose();
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (!this.from_appli) {
            System.exit(0);
        }
    }

    public void showDialog() {
        if (this.memorized.length == 0) {
            Utils.popupError(this.parent, "No memorized attribute found for " + this.server.name());
        } else {
            this.setVisible(true);
        }
    }

    public static void main(String[] args) {
        try {
            AttMemoDialog d = new AttMemoDialog(new JDialog(), new DbServer("PowerSupply/pv"));
            d.showDialog();
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
    }

    class Memorized {
        String attname;
        String value;
        String min;
        String max;

        Memorized(String attname, String value, String min, String max) {
            this.attname = attname;
            this.value = value;
            this.min = min;
            this.max = max;
        }
    }
}

