/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorCmdLine;
import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.DeviceTreeDialog;
import admin.astor.GetTextDialog;
import admin.astor.Monitor;
import admin.astor.MultiServerCommand;
import admin.astor.NewStarterDialog;
import admin.astor.OneTool;
import admin.astor.PreferenceDialog;
import admin.astor.Selector;
import admin.astor.ServerCmdThread;
import admin.astor.TangoHost;
import admin.astor.statistics.StatisticsPanel;
import admin.astor.tango_release.JTangoVersion;
import admin.astor.tools.DevBrowser;
import admin.astor.tools.IconStateDialog;
import admin.astor.tools.PopupHtml;
import admin.astor.tools.PopupTable;
import admin.astor.tools.PopupText;
import admin.astor.tools.ServerUsageDialog;
import admin.astor.tools.Utils;
import admin.astor.tools.WideSearchDialog;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.TangORBversion;
import fr.esrf.TangoDs.Except;
import fr.esrf.logviewer.Main;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Astor
extends JFrame
implements AstorDefs {
    private static String revNumber = "7.1.2  -  04-09-2017  16:34:26";
    public AstorTree tree = null;
    private boolean expanded = false;
    private JScrollPane scrollPane;
    private static DevBrowser devBrowser = null;
    static long t0;
    private String tango_host = "";
    private MultiServerCommand multiServerCommand = null;
    private static int jarUsed;
    public static int rwMode;
    private String[] htmlHelps = null;
    private int nb_def_tools = 1;
    private List<OneTool> app_tools = new ArrayList<OneTool>();
    private List<ActionListener> tools_al = new ArrayList<ActionListener>();
    private Main logviewer = null;
    private static String searched_host;
    private WideSearchDialog wide_search_dlg = null;
    private JMenuItem aboutBtn;
    private JMenuItem accessControlBtn;
    private JPanel bottomPanel;
    private JMenuItem changeTgHostBtn;
    private JMenu cmdMenu;
    private JMenuItem ctrlPreferenceBtn;
    private JMenuItem deviceBrowserBtn;
    private JMenuItem distributionBtn;
    private JMenuItem exitBtn;
    private JMenuItem expandBtn;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem jiveMenuItem;
    private JMenuItem logviewerMenuItem;
    private JLabel modeLabel;
    private JMenuItem multiServersCmdItem;
    private JMenuItem newBranchBtn;
    private JMenuItem newHostBtn;
    private JMenuItem principleBtn;
    private JMenuItem releaseNoteBtn;
    private JMenuItem starterEventsItem;
    private JMenuItem starterNoEventsItem;
    private JMenuItem stateIconsBtn;
    private JMenuItem tangorbBtn;
    private JLabel titleLabel;
    private JMenu toolsMenu;
    private JPanel topPanel;
    private JMenuItem usePreferenceBtn;
    private JMenu viewMenu;

    public Astor() throws DevFailed {
        t0 = System.currentTimeMillis();
        this.initComponents();
        AstorUtil.getInstance().initIcons();
        this.customizeMenu();
        this.setTitle("TANGO Manager - " + revNumber);
        this.setControlSystemTitle();
        this.buildTree();
        ImageIcon icon = Utils.getInstance().getIcon("astor.png");
        this.setIconImage(icon.getImage());
        jarUsed = JTangoVersion.getInstance().getJarFileType();
        this.tangorbBtn.setText(JTangoVersion.JarUsed[jarUsed] + " Version");
        this.centerWindow();
        System.out.println("Version: " + this.getClass().getPackage().getImplementationVersion());
        try {
            this.tango_host = ApiUtil.get_db_obj().get_tango_host();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    private void centerWindow() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrsize = toolkit.getScreenSize();
        Dimension appsize = this.getSize();
        Point p = new Point();
        p.x = (scrsize.width - appsize.width) / 2;
        p.y = (scrsize.height - appsize.height) / 2;
        this.setLocation(p);
    }

    private void setControlSystemTitle() throws DevFailed {
        String name = AstorUtil.getControlSystemName();
        if (name != null && name.length() > 0) {
            this.titleLabel.setText(name);
            this.topPanel.setVisible(true);
        } else {
            this.topPanel.setVisible(false);
        }
    }

    private void buildTree() throws DevFailed {
        String title = "Astor (TANGO Manager)";
        int end = revNumber.indexOf("-");
        if (end > 0) {
            title = title + " - " + revNumber.substring(0, end).trim();
        }
        JSmoothProgressBar myBar = new JSmoothProgressBar();
        myBar.setStringPainted(true);
        myBar.setBackground(Color.lightGray);
        myBar.setProgressBarColors(Color.gray, Color.gray, Color.gray);
        ImageIcon icon = Utils.getInstance().getIcon("TangoLogo.gif");
        Splash splash = new Splash(icon, Color.black, myBar);
        splash.setTitle(title);
        splash.setMessage("Starting....");
        splash.setVisible(true);
        try {
            if (this.tree != null) {
                this.tree.stopThreads();
                this.scrollPane.remove(this.tree);
                this.remove(this.scrollPane);
            }
            this.tree = new AstorTree(this, splash);
            this.scrollPane = new JScrollPane();
            this.scrollPane.setPreferredSize(AstorUtil.getPreferredSize());
            this.scrollPane.setViewportView(this.tree);
            this.getContentPane().add((Component)this.scrollPane, "Center");
            this.expanded = false;
            this.pack();
            this.manageAccessControlMenu(this.tree.isAccessControlled());
        }
        catch (DevFailed e) {
            splash.setVisible(false);
            throw e;
        }
    }

    Dimension getTreeSize() {
        return this.scrollPane.getPreferredSize();
    }

    void setTreeSize(Dimension d) {
        this.scrollPane.setPreferredSize(d);
        this.pack();
    }

    private void customizeMenu() {
        this.fileMenu.setMnemonic('F');
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.ctrlPreferenceBtn.setMnemonic('P');
        this.ctrlPreferenceBtn.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        String s = System.getProperty("NO_PREF");
        if (s != null && s.toLowerCase().equals("true")) {
            this.ctrlPreferenceBtn.setEnabled(false);
        }
        this.ctrlPreferenceBtn.setEnabled(rwMode == 0);
        this.usePreferenceBtn.setEnabled(rwMode == 0);
        this.changeTgHostBtn.setMnemonic('T');
        this.changeTgHostBtn.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.viewMenu.setMnemonic('V');
        this.newBranchBtn.setMnemonic('N');
        this.newBranchBtn.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.deviceBrowserBtn.setMnemonic('B');
        this.deviceBrowserBtn.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.expandBtn.setMnemonic('E');
        this.expandBtn.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.toolsMenu.setMnemonic('T');
        this.multiServersCmdItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.jiveMenuItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.logviewerMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.multiServersCmdItem.setEnabled(rwMode == 0);
        this.jiveMenuItem.setEnabled(rwMode != 2);
        this.accessControlBtn.setEnabled(rwMode != 2);
        this.cmdMenu.setMnemonic('C');
        this.cmdMenu.setEnabled(rwMode != 2);
        this.newHostBtn.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.nb_def_tools = this.toolsMenu.getItemCount();
        this.buildToolsItems();
        this.buildAdditionnalHelps();
        this.expandBtn.setVisible(false);
        this.modeLabel.setText(strMode[rwMode]);
        this.bottomPanel.setVisible(rwMode != 0);
    }

    private void manageAccessControlMenu(boolean isAccessControlled) {
        if (isAccessControlled) {
            this.accessControlBtn.setMnemonic('A');
            this.accessControlBtn.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            this.accessControlBtn.setVisible(true);
            System.out.println("AccessControl is active");
        } else {
            this.accessControlBtn.setVisible(false);
        }
    }

    private void buildAdditionnalHelps() {
        this.htmlHelps = AstorUtil.getHtmlHelps();
        if (this.htmlHelps == null) {
            return;
        }
        if (this.htmlHelps.length == 0) {
            return;
        }
        this.helpMenu.add(new JSeparator());
        for (int i = 0; i < this.htmlHelps.length / 2; ++i) {
            JMenuItem mi = new JMenuItem();
            mi.setText(this.htmlHelps[2 * i]);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Astor.this.htmlHelpsItemActionPerformed(evt);
                }
            });
            this.helpMenu.add(mi);
        }
    }

    private void htmlHelpsItemActionPerformed(ActionEvent evt) {
        String str = evt.getActionCommand();
        String cmd = null;
        for (int i = 0; i < this.htmlHelps.length; ++i) {
            if (!str.equals(this.htmlHelps[i]) || i >= this.htmlHelps.length - 1) continue;
            cmd = this.htmlHelps[i + 1];
        }
        if (cmd == null) {
            Utils.popupError(this, "No command found for item  '" + str + "'");
        }
        System.out.println(cmd);
        AstorUtil.showInHtmBrowser(cmd);
    }

    private void buildToolsItems() {
        for (int i = this.toolsMenu.getItemCount(); i > this.nb_def_tools; --i) {
            JMenuItem mi = this.toolsMenu.getItem(i - 1);
            mi.removeActionListener(this.tools_al.get(i - this.nb_def_tools - 1));
            this.toolsMenu.remove(i - 1);
        }
        this.app_tools.clear();
        this.tools_al.clear();
        String[] str_tools = AstorUtil.getTools();
        if (str_tools != null) {
            for (int i = 0; i < str_tools.length; i += 2) {
                OneTool t = new OneTool(str_tools[i], str_tools[i + 1]);
                this.app_tools.add(t);
                JMenuItem mi = new JMenuItem();
                mi.setText(t.name);
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        Astor.this.toolsItemActionPerformed(evt);
                    }
                };
                mi.addActionListener(al);
                this.tools_al.add(al);
                this.toolsMenu.add(mi);
            }
        }
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.bottomPanel = new JPanel();
        this.modeLabel = new JLabel();
        JMenuBar menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.changeTgHostBtn = new JMenuItem();
        this.ctrlPreferenceBtn = new JMenuItem();
        this.usePreferenceBtn = new JMenuItem();
        this.exitBtn = new JMenuItem();
        this.viewMenu = new JMenu();
        this.deviceBrowserBtn = new JMenuItem();
        JMenuItem refreshBtn = new JMenuItem();
        this.expandBtn = new JMenuItem();
        JMenuItem startupErrorBtn = new JMenuItem();
        this.cmdMenu = new JMenu();
        JMenuItem startServersBtn = new JMenuItem();
        JMenuItem stopServersBtn = new JMenuItem();
        this.newHostBtn = new JMenuItem();
        this.newBranchBtn = new JMenuItem();
        this.toolsMenu = new JMenu();
        JMenu findMenu = new JMenu();
        JMenuItem findHostItem = new JMenuItem();
        JMenuItem findObjectByFilterItem = new JMenuItem();
        JMenuItem tangoStatBtn = new JMenuItem();
        this.multiServersCmdItem = new JMenuItem();
        JMenuItem serverUsageMenuItem = new JMenuItem();
        this.jiveMenuItem = new JMenuItem();
        this.accessControlBtn = new JMenuItem();
        JMenuItem statisticsBtn = new JMenuItem();
        this.logviewerMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.principleBtn = new JMenuItem();
        this.distributionBtn = new JMenuItem();
        this.stateIconsBtn = new JMenuItem();
        this.tangorbBtn = new JMenuItem();
        this.starterEventsItem = new JMenuItem();
        this.starterNoEventsItem = new JMenuItem();
        JMenuItem faultyListItem = new JMenuItem();
        this.releaseNoteBtn = new JMenuItem();
        this.aboutBtn = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Astor.this.exitForm(evt);
            }
        });
        this.titleLabel.setFont(new Font("Tahoma", 1, 18));
        this.topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)this.topPanel, "North");
        this.modeLabel.setFont(new Font("Tahoma", 1, 12));
        this.bottomPanel.add(this.modeLabel);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.fileMenu.setText("File");
        this.changeTgHostBtn.setText("Change Tango Host");
        this.changeTgHostBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.changeTgHostBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.changeTgHostBtn);
        this.ctrlPreferenceBtn.setText("Ctrl System Preferences");
        this.ctrlPreferenceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.ctrlPreferenceBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.ctrlPreferenceBtn);
        this.usePreferenceBtn.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.usePreferenceBtn.setMnemonic('U');
        this.usePreferenceBtn.setText("User Preferences");
        this.usePreferenceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.usePreferenceBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.usePreferenceBtn);
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.exitBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitBtn);
        menuBar.add(this.fileMenu);
        this.viewMenu.setText("View");
        this.deviceBrowserBtn.setText("Event Manager");
        this.deviceBrowserBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.deviceBrowserBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.deviceBrowserBtn);
        refreshBtn.setText("Update Tree from database");
        refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.refreshBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(refreshBtn);
        this.expandBtn.setText("Expand Tree");
        this.expandBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.expandBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.expandBtn);
        startupErrorBtn.setText("Startup Errors");
        startupErrorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.startupErrorBtnActionPerformed(evt);
            }
        });
        this.viewMenu.add(startupErrorBtn);
        menuBar.add(this.viewMenu);
        this.cmdMenu.setText("Command");
        startServersBtn.setText("Start All Controlled Servers");
        startServersBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.startServersBtnActionPerformed(evt);
            }
        });
        this.cmdMenu.add(startServersBtn);
        stopServersBtn.setText("Stop All Controlled Servers");
        stopServersBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.stopServersBtnActionPerformed(evt);
            }
        });
        this.cmdMenu.add(stopServersBtn);
        this.newHostBtn.setText("Add a New Host");
        this.newHostBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.newHostBtnActionPerformed(evt);
            }
        });
        this.cmdMenu.add(this.newHostBtn);
        this.newBranchBtn.setText("Add a New Branch");
        this.newBranchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.newBranchBtnActionPerformed(evt);
            }
        });
        this.cmdMenu.add(this.newBranchBtn);
        menuBar.add(this.cmdMenu);
        this.toolsMenu.setText("Tools");
        findMenu.setText("Find");
        findHostItem.setText("Host by Name");
        findHostItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.findHostItemActionPerformed(evt);
            }
        });
        findMenu.add(findHostItem);
        findObjectByFilterItem.setText("Device/Server/Class by Filter");
        findObjectByFilterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.findObjectByFilterItemActionPerformed(evt);
            }
        });
        findMenu.add(findObjectByFilterItem);
        this.toolsMenu.add(findMenu);
        tangoStatBtn.setText("Ctrl System Info");
        tangoStatBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.tangoStatBtnActionPerformed(evt);
            }
        });
        this.toolsMenu.add(tangoStatBtn);
        this.multiServersCmdItem.setText("Multi Servers Command");
        this.multiServersCmdItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.multiServersCmdItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.multiServersCmdItem);
        serverUsageMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        serverUsageMenuItem.setText("Server Usage");
        serverUsageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.serverUsageMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(serverUsageMenuItem);
        this.jiveMenuItem.setText("Jive");
        this.jiveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.jiveMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.jiveMenuItem);
        this.accessControlBtn.setText("Access Control");
        this.accessControlBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.accessControlBtnActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.accessControlBtn);
        statisticsBtn.setText("Server Statistics");
        statisticsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.statisticsBtnActionPerformed(evt);
            }
        });
        this.toolsMenu.add(statisticsBtn);
        this.logviewerMenuItem.setText("LogViewer");
        this.logviewerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.logviewerMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.logviewerMenuItem);
        menuBar.add(this.toolsMenu);
        this.helpMenu.setText("Help");
        this.principleBtn.setText("Principle");
        this.principleBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.principleBtn);
        this.distributionBtn.setText("Servers Distribution");
        this.distributionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.distributionBtn);
        this.stateIconsBtn.setText("State Icons");
        this.stateIconsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.stateIconsBtn);
        this.tangorbBtn.setText("TangORB revision");
        this.tangorbBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.tangorbBtn);
        this.starterEventsItem.setText("Hosts Controlled on Events");
        this.starterEventsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.starterEventsItem);
        this.starterNoEventsItem.setText("Hosts Controlled on Polling");
        this.starterNoEventsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.starterNoEventsItem);
        faultyListItem.setText("Faulty Host List");
        faultyListItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.faultyListItemhelpActionPerformed(evt);
            }
        });
        this.helpMenu.add(faultyListItem);
        this.releaseNoteBtn.setText("Release Note");
        this.releaseNoteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.releaseNoteBtn);
        this.aboutBtn.setText("About");
        this.aboutBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Astor.this.helpActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutBtn);
        menuBar.add(this.helpMenu);
        this.setJMenuBar(menuBar);
        this.pack();
    }

    private void ctrlPreferenceBtnActionPerformed(ActionEvent evt) {
        try {
            PreferenceDialog dialog = new PreferenceDialog(this);
            dialog.setVisible(true);
            this.setControlSystemTitle();
            if (dialog.isLastCollectionsChanged()) {
                this.refreshBtnActionPerformed(null);
            }
        }
        catch (DevFailed e) {
            System.err.println(e.errors[0].desc);
        }
    }

    private void usePreferenceBtnActionPerformed(ActionEvent evt) {
        List<String> knownTangoHosts = AstorUtil.getAllKnownTangoHosts();
        GetTextDialog dlg = new GetTextDialog(this, "List of User Tango Hosts", null, knownTangoHosts);
        if (dlg.showDialog() == 0) {
            knownTangoHosts = dlg.getTextLines();
            try {
                AstorUtil.saveUserKnownTangoHost(knownTangoHosts);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    private void startupErrorBtnActionPerformed(ActionEvent evt) {
        if (this.tree.subscribeErrWindow == null) {
            Utils.popupMessage(this, "No error at startup.");
        } else {
            this.tree.subscribeErrWindow.setVisible(true);
        }
    }

    private void accessControlBtnActionPerformed(ActionEvent evt) {
        this.tree.startTACpanel();
    }

    private void changeTgHostBtnActionPerformed(ActionEvent evt) {
        try {
            List<String> knownTangoHosts = AstorUtil.getAllKnownTangoHosts();
            Selector tangoHostSelector = new Selector((JFrame)this, "Tango Host  (e.g.  hal:2001)", knownTangoHosts, this.tango_host);
            ATKGraphicsUtils.centerDialog((Dialog)tangoHostSelector);
            final String newTangoHost = tangoHostSelector.showDialog();
            if (newTangoHost == null || newTangoHost.length() == 0) {
                return;
            }
            String[] tgh_arr = newTangoHost.split(":");
            if (tgh_arr.length != 2) {
                Utils.popupError(this, "Input syntax error\n" + newTangoHost + "\n is not a valid TANGO_HOST");
                return;
            }
            ApiUtil.get_db_obj((String)tgh_arr[0], (String)tgh_arr[1]);
            if (this.tango_host.equals(newTangoHost)) {
                return;
            }
            final String rights = rwMode == 0 ? "-rw" : (rwMode == 1 ? "-db_ro" : "-ro");
            new Thread(){

                @Override
                public void run() {
                    try {
                        String cmd = "java -DTANGO_HOST=" + newTangoHost + " admin.astor.Astor " + rights;
                        AstorUtil.executeShellCmd(cmd);
                    }
                    catch (DevFailed | IOException | InterruptedException e) {
                        ErrorPane.showErrorMessage((Component)new JFrame(), (String)"Cannot fork", (Exception)e);
                    }
                }
            }.start();
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot change TANGO_HOST", (Exception)e);
        }
    }

    private void logviewerMenuItemActionPerformed(ActionEvent evt) {
        if (this.logviewer == null) {
            this.logviewer = new Main((JFrame)this);
        }
        this.logviewer.setVisible(true);
        this.logviewer.toFront();
    }

    private void jiveMenuItemActionPerformed(ActionEvent evt) {
        this.tree.displayJiveAppli();
    }

    private void findHostItemActionPerformed(ActionEvent evt) {
        String hostname = (String)JOptionPane.showInputDialog(this, "Host Name ?", "Input Dialog", 1, null, null, searched_host);
        if (hostname != null) {
            try {
                this.tree.setSelectionRoot();
                this.tree.setSelectionPath(hostname);
                this.tree.displayHostInfo();
                searched_host = hostname;
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    private void tangoStatBtnActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "The System Information needs to browse Database\n        and it could take a long time !\n\nStart it any way ?", "Confirm Dialog", 0) == 0) {
            new DeviceTreeDialog(this);
        }
    }

    private void toolsItemActionPerformed(ActionEvent evt) {
        String toolName = evt.getActionCommand();
        try {
            OneTool toolApplication = this.getToolApplication(toolName);
            System.out.println("Starting " + toolApplication.classname);
            if (toolApplication.jframe != null) {
                toolApplication.jframe.setVisible(true);
            } else {
                Constructor<?>[] constructors;
                Class<?> _class = Class.forName(toolApplication.classname);
                boolean found = false;
                for (Constructor<?> constructor : constructors = _class.getDeclaredConstructors()) {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 1 || parameterTypes[0] != JFrame.class) continue;
                    toolApplication.setJFrame((JFrame)constructor.newInstance(this));
                    toolApplication.jframe.setVisible(true);
                    found = true;
                }
                if (!found) {
                    throw new Exception("Cannot find constructor for " + toolApplication.classname);
                }
            }
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, null, (Exception)e);
        }
    }

    private OneTool getToolApplication(String name) throws Exception {
        for (OneTool oneTool : this.app_tools) {
            if (!oneTool.name.equals(name)) continue;
            return oneTool;
        }
        throw new Exception(name + " tool not found");
    }

    void removeHost(String hostname) {
        if (JOptionPane.showConfirmDialog(this, "Are you sure to want to remove " + hostname, "Confirm Dialog", 0) != 0) {
            return;
        }
        String serverName = "Starter/" + hostname;
        String adminDevice = "dserver/" + serverName;
        String deviceName = AstorUtil.getStarterDeviceHeader() + hostname;
        try {
            DeviceProxy dev = new DeviceProxy(deviceName);
            dev.delete_property("StartDsPath");
            dev.delete_property("HostCollection");
            dev.delete_property("HostUsage");
            dev.delete_property("UseEvents");
            Database db = ApiUtil.get_db_obj((String)AstorUtil.getTangoHost());
            db.delete_server(serverName);
            db.delete_device(deviceName);
            db.delete_device(adminDevice);
            JOptionPane.showMessageDialog(this, hostname + " has been removed !", "Command Done", 1);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot remove host", (DevFailed)e);
        }
        try {
            this.buildTree();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void newHostBtnActionPerformed(ActionEvent evt) {
        this.addNewHost(null);
    }

    void addNewHost(TangoHost h) {
        NewStarterDialog dialog = new NewStarterDialog(this, h, this.tree.getCollectionList(), this.tree.hosts, true);
        dialog.setVisible(true);
        if (dialog.getValue() == 0) {
            try {
                this.buildTree();
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    void editHostProperties(TangoHost host) {
        NewStarterDialog dialog = new NewStarterDialog(this, host, this.tree.getCollectionList(), this.tree.hosts, false);
        dialog.setVisible(true);
    }

    private void stopServersBtnActionPerformed(ActionEvent evt) {
        new ServerCmdThread(this, this.tree.hosts, 1).start();
    }

    private void startServersBtnActionPerformed(ActionEvent evt) {
        new ServerCmdThread(this, this.tree.hosts, 0).start();
    }

    private void newBranchBtnActionPerformed(ActionEvent evt) {
        String branch_name = (String)JOptionPane.showInputDialog(this, "New Branch Name", "Input Dialog", 1, null, null, "");
        if (branch_name != null) {
            this.tree.addBranch(branch_name);
        }
    }

    private void helpActionPerformed(ActionEvent evt) {
        JMenuItem item = (JMenuItem)evt.getSource();
        if (item == this.principleBtn) {
            Utils.popupMessage(this, "", "principle.gif");
        } else if (item == this.distributionBtn) {
            new HostsScanThread(this, this.tree.hosts).start();
        } else if (item == this.stateIconsBtn) {
            new IconStateDialog(this).setVisible(true);
        } else if (item == this.releaseNoteBtn) {
            new PopupHtml(this).show("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<html>\n<head>\n<title> Release Note </title>\n</head>\n<body text=\"#000000\" bgColor=\"#FFFFFF\" link=\"#0000FF\" vLink=\"#7F00FF\" aLink=\"#FF0000\">\n<p><!-------TITLE------></p>\n<center>\t<h2>Astor Release Notes </h2>\n\t(Generated 04-09-2017  16:34:26)</center><br>\n<li><b>Astor-7.1.2 -  04/09/17:</b><br>&nbsp; &nbsp; &nbsp; Add a global check for several instances for a server in servers statistics.<br><li><b>Astor-7.1.1 -  31/08/17:</b><br>&nbsp; &nbsp; &nbsp; add a missing icon file<br><li><b>Astor-7.1.0 -  31/08/17:</b><br>&nbsp; &nbsp; &nbsp; Manage the Starter check for several instances for a server.<br><li><b>Astor-7.0.14 -  04/05/17:</b><br>&nbsp; &nbsp; &nbsp; Update the release number in display.<br><li><b>Astor-7.0.13 -  27/04/17:</b><br>&nbsp; &nbsp; &nbsp; Fix a NPE<br><li><b>Astor-7.0.12 -  16/02/17:</b><br>&nbsp; &nbsp; &nbsp; Improve check host name when create/clone host object<br><li><b>Astor-7.0.11 -  01/02/17:</b><br>&nbsp; &nbsp; &nbsp; Improve startup, level management when start more than 4 servers.<br><li><b>Astor-7.0.10 -  16/01/17:</b><br>&nbsp; &nbsp; &nbsp; Fix bug in Start/Stop all servers for several hosts<br><li><b>Astor-7.0.9 -  09/01/17:</b><br>&nbsp; &nbsp; &nbsp; Fix a bug in Change TANGO_HOST<br><li><b>Astor-7.0.8 -  06/01/17:</b><br>&nbsp; &nbsp; &nbsp; Add DBBench call to monitor database.<br><li><b>Astor-7.0.7 -  04/01/17:</b><br>&nbsp; &nbsp; &nbsp; Fix problem in TANGO release<br>&nbsp; &nbsp; &nbsp; Check if host is alive before openning a terminal<br><li><b>Astor-7.0.6 -  15/12/16:</b><br>&nbsp; &nbsp; &nbsp; Remove old CVS references<br>&nbsp; &nbsp; &nbsp; Improve resize host info dialog.<br>&nbsp; &nbsp; &nbsp; fix a problem in help for server TANGO release<br><li><b>Astor-7.0.5 -  02/12/16:</b><br>&nbsp; &nbsp; &nbsp; Fix a bug in launching JSSHTerminal.<br><li><b>Astor-7.0.4 -  01/12/16:</b><br>&nbsp; &nbsp; &nbsp; JSSHTerminal is now used for remote login (JSSHTerminal.jar must be added in CLASSPATH)<br><li><b>Astor-7.0.3 -  28/11/16:</b><br>&nbsp; &nbsp; &nbsp; Add a button to start/stop servers on all levels.<br><li><b>Astor-7.0.2 -  24/11/16:</b><br>&nbsp; &nbsp; &nbsp; Fix a bug in last branches management.<br><li><b>Astor-7.0.1 -  18/11/16:</b><br>&nbsp; &nbsp; &nbsp; Maven project<br><li><b>Astor-7.0.0 -  26/08/16:</b><br>&nbsp; &nbsp; &nbsp; Java-7 syntax compatibility.<br><li><b>Astor-6.7.1 -  28/06/16:</b><br>&nbsp; &nbsp; &nbsp; Fix a little bug in startup level management.<br><li><b>Astor-6.7.0 -  27/01/16:</b><br>&nbsp; &nbsp; &nbsp; Starter domain name could be set with a class property.<br>&nbsp; &nbsp; &nbsp; Improve &rdquo;Tango release for servers&rdquo; feature<br><li><b>Astor-6.6.6 -  30/06/15:</b><br>&nbsp; &nbsp; &nbsp; Java-7 compatibility.<br>&nbsp; &nbsp; &nbsp; Manage polling for Tango-9 feature.<br>&nbsp; &nbsp; &nbsp; Improve Tango release for servers.<br>&nbsp; &nbsp; &nbsp; Add a compatibility to read JTango release.<br>&nbsp; &nbsp; &nbsp; Update file headers.<br><li><b>Astor-6.6.5 -  08/01/15:</b><br>&nbsp; &nbsp; &nbsp; Improve Server Usage utility<br><li><b>Astor-6.6.4 -  08/01/15:</b><br>&nbsp; &nbsp; &nbsp; Improve the statup level change.<br><li><b>Astor-6.6.3 -  17/12/14:</b><br>&nbsp; &nbsp; &nbsp; Several invokeLater() methods added.<br><li><b>Astor-6.6.2 -  18/11/14:</b><br>&nbsp; &nbsp; &nbsp; ULong management added to event tester.<br><li><b>Astor-6.6.1 -  04/11/14:</b><br>&nbsp; &nbsp; &nbsp; Faulty host list added to help menu.<br><li><b>Astor-6.6.0 -  01/10/14:</b><br>&nbsp; &nbsp; &nbsp; Server Tango release manage Tango-9 and IDL5<br><li><b>Astor-6.5.1 -  05/08/14:</b><br>&nbsp; &nbsp; &nbsp; Improve Last Branches management.<br><li><b>Astor-6.5.0 -  19/04/14:</b><br>&nbsp; &nbsp; &nbsp; Manage OFF state for Starter devices.<br>&nbsp; &nbsp; &nbsp; Improve DbPollPanel class.<br><li><b>Astor-6.4.6 -  29/01/14:</b><br>&nbsp; &nbsp; &nbsp; Package ctrl_system_info added to the jar file.<br><li><b>Astor-6.4.5 -  10/01/14:</b><br>&nbsp; &nbsp; &nbsp; Fix a problem on starter properties (HostUsage and Family)<br>&nbsp; &nbsp; &nbsp; Clean compilation warnings.<br><li><b>Astor-6.4.3 -  07/01/14:</b><br>&nbsp; &nbsp; &nbsp; Remove warning on tools launch.<br><li><b>Astor-6.4.2 -  29/10/13:</b><br>&nbsp; &nbsp; &nbsp; Try to fix infinite ping loop.<br><li><b>Astor-6.4.1 -  25/10/13:</b><br>&nbsp; &nbsp; &nbsp; Replace dancers by official Tango logo.<br>&nbsp; &nbsp; &nbsp; Cleanup part of code.<br><li><b>Astor-6.4.0 -  24/09/13:</b><br>&nbsp; &nbsp; &nbsp; Fix a problem in Tango releases help.<br>&nbsp; &nbsp; &nbsp; fix a problem on resize with java-7<br><li><b>Astor-6.3.9 -  30/08/13:</b><br>&nbsp; &nbsp; &nbsp; Fix problem in pool threads management using new syntax.<br>&nbsp; &nbsp; &nbsp; Improve sort methods.<br>&nbsp; &nbsp; &nbsp; ServerStatePanel is now an astor.tools class (not from tool_panels package)<br><li><b>Astor-6.3.7 -  09/08/13:</b><br>&nbsp; &nbsp; &nbsp; Improve UnAvailableHostsDialog class.<br><li><b>Astor-6.3.6 -  12/06/13:</b><br>&nbsp; &nbsp; &nbsp; Server list to be started can now be taken from another host.<br><li><b>Astor-6.3.5 -  28/05/13:</b><br>&nbsp; &nbsp; &nbsp; Update splash screen with new logos.<br><li><b>Astor-6.3.4 -  16/05/13:</b><br>&nbsp; &nbsp; &nbsp; Minor changes.<br><li><b>Astor-6.3.3 -  30/04/13:</b><br>&nbsp; &nbsp; &nbsp; Add a tool to export server from database to another one.<br><li><b>Astor-6.3.2 -  03/04/13:</b><br>&nbsp; &nbsp; &nbsp; Add a display for statistics reset by host.<br><li><b>Astor-6.3.1 -  19/03/13:</b><br>&nbsp; &nbsp; &nbsp; Fix a problem when starter is killed.<br><li><b>Astor-6.3.0 -  06/03/13:</b><br>&nbsp; &nbsp; &nbsp; implement READ_ONLY, DB_READ_ONLY, READ_WRITE modes.<br><li><b>Astor-6.2.2 -  21/01/13:</b><br>&nbsp; &nbsp; &nbsp; Fix a bug in adding item on TAC<br><li><b>Astor-6.2.1 -  14/01/13:</b><br>&nbsp; &nbsp; &nbsp; Pb on notif icon fixed.<br><li><b>Astor-6.2.0 -  07/01/13:</b><br>&nbsp; &nbsp; &nbsp; Group management added on TAC panel.<br><li><b>Astor-6.1.2 -  26/10/12:</b><br>&nbsp; &nbsp; &nbsp; Fix a problem when too much devices in SubDevices.<br><li><b>Astor-6.1.1 -  26/10/12:</b><br>&nbsp; &nbsp; &nbsp; HostInfoDialog can be run in stand alone.<br><li><b>Astor-6.1.0 -  24/10/12:</b><br>&nbsp; &nbsp; &nbsp; Tango release for servers tool added.<br><li><b>Astor-6.0.6 -  09/10/12:</b><br>&nbsp; &nbsp; &nbsp; Pb with back slash fixed (?)<br><li><b>Astor-6.0.5 -  21/08/12:</b><br>&nbsp; &nbsp; &nbsp; Open Jive on a selected server.<br><li><b>Astor-6.0.4 -  24/05/12:</b><br>&nbsp; &nbsp; &nbsp; Distribution release.<br><li><b>Astor-6.0.3 -  05/04/12:</b><br>&nbsp; &nbsp; &nbsp; Add a control system name management.<br>&nbsp; &nbsp; &nbsp; User preferences for tango host list added.<br><li><b>Astor-6.0.1 -  02/04/12:</b><br>&nbsp; &nbsp; &nbsp; Problem when removing server info fixed.<br><li><b>Astor-6.0.0 -  08/02/12:</b><br>&nbsp; &nbsp; &nbsp; Comptibility with TangORB-8.x (ZMQ event system or supposed to be).<br><li><b>Astor-5.5.4 -  06/12/11:</b><br>&nbsp; &nbsp; &nbsp; Create a Thread to update splash screen (to boost startup).<br><li><b>Astor-5.5.3 -  07/09/11:</b><br>&nbsp; &nbsp; &nbsp; ServerUsage tool added.<br><li><b>Astor-5.5.2 -  26/07/11:</b><br>&nbsp; &nbsp; &nbsp; Statistics on one host added.<br><li><b>Astor-5.5.1 -  12/04/11:</b><br>&nbsp; &nbsp; &nbsp; Auto start info added to statistics tool.<br><li><b>Astor-5.5.0 -  01/04/11:</b><br>&nbsp; &nbsp; &nbsp; Statistics tools added.<br><li><b>Astor-5.4.1 -  14/03/11:</b><br>&nbsp; &nbsp; &nbsp; Pb on TangoHost.getFamily() (if not defined) fixed.<br><li><b>Astor-5.4.0 -  11/02/11:</b><br>&nbsp; &nbsp; &nbsp; Pb with TAC when adding addresses on &rdquo;All Users&rdquo; fixed.<br>&nbsp; &nbsp; &nbsp; No reference on app_util classes any more.<br>&nbsp; &nbsp; &nbsp; Change splash screen image.<br><li><b>Astor-5.3.7 -  24/01/11:</b><br>&nbsp; &nbsp; &nbsp; Constructor added.<br><li><b>Astor-5.3.6 -  13/01/11:</b><br>&nbsp; &nbsp; &nbsp; Pb on black box reader thread fixed.<br><li><b>Astor-5.3.5 -  10/01/11:</b><br>&nbsp; &nbsp; &nbsp; TAC is now displayed as database servers.<br>&nbsp; &nbsp; &nbsp; StartServersAtStarteup starter class property management added.<br>&nbsp; &nbsp; &nbsp; Display access mode in Tango Access panel.<br><li><b>Astor-5.3.4 -  04/01/11:</b><br>&nbsp; &nbsp; &nbsp; Do not try to subscribe on Starter events if starter device not exported.<br><li><b>Astor-5.3.3 -  21/12/10:</b><br>&nbsp; &nbsp; &nbsp; Little tool to un-export devices registred on unreachable hosts added.<br><li><b>Astor-5.3.2 -  16/12/10:</b><br>&nbsp; &nbsp; &nbsp; Add a password for AccessControl tool.<br><li><b>Astor-5.3.1 -  02/12/10:</b><br>&nbsp; &nbsp; &nbsp; Constructors added in  PoolThreadsManager to be launched from Jive.<br><li><b>Astor-5.3.0 -  30/11/10:</b><br>&nbsp; &nbsp; &nbsp; For multi servers command, if the command is done through the starter,<br>&nbsp; &nbsp; &nbsp; it is done by a thread and a delay has been added between servers.<br><li><b>Astor-5.2.11 -  29/11/10:</b><br>&nbsp; &nbsp; &nbsp; Multi servers command added.<br>&nbsp; &nbsp; &nbsp; Uptime for servers added.<br><li><b>Astor-5.2.10 -  08/10/10:</b><br>&nbsp; &nbsp; &nbsp; Change default view in Polling Profiler.<br><li><b>Astor-5.2.9 -  01/09/10:</b><br>&nbsp; &nbsp; &nbsp; Minor change (traces removed and added).<br><li><b>Astor-5.2.8 -  17/06/10:</b><br>&nbsp; &nbsp; &nbsp; Pb on display startup level dialog in case of many devices fixed.<br><li><b>Astor-5.2.7 -  17/06/10:</b><br>&nbsp; &nbsp; &nbsp; Start new server can take several servers (multiple selection).<br><li><b>Astor-5.2.6 -  04/06/10:</b><br>&nbsp; &nbsp; &nbsp; Global command to change startup level added.<br><li><b>Astor-5.2.5 -  08/04/10:</b><br>&nbsp; &nbsp; &nbsp; Minor bugs fixed.<br><li><b>Astor-5.2.4 -  05/01/10:</b><br>&nbsp; &nbsp; &nbsp; Best management of subscribe error window at startup.<br><li><b>Astor-5.2.3 -  18/08/09:</b><br>&nbsp; &nbsp; &nbsp; Bug in Device Dependencies fixed (infinite loop)<br><li><b>Astor-5.2.2 -  02/06/09:</b><br>&nbsp; &nbsp; &nbsp; Bug on host.check_notifyd fixed.<br><li><b>Astor-5.2.1 -  15/05/09:</b><br>&nbsp; &nbsp; &nbsp; Remove serialization between HostStateThread and HostInfoDialogVector.<br><li><b>Astor-5.2.0 -  18/04/09:</b><br>&nbsp; &nbsp; &nbsp; Tango-7 tools accessible.<br>&nbsp; &nbsp; &nbsp; Device dependencies (sub-devices) tool added.<br>&nbsp; &nbsp; &nbsp; MySqlUtil feature added.<br><li><b>Astor-5.1.3 -  30/01/09:</b><br>&nbsp; &nbsp; &nbsp; Black box management added for database.<br>&nbsp; &nbsp; &nbsp; Black box management tool improved.<br>&nbsp; &nbsp; &nbsp; Find TANGO object by filter added.<br><li><b>Astor-5.1.2 -  16/01/09:</b><br>&nbsp; &nbsp; &nbsp; Black box management added for host and Server.<br>&nbsp; &nbsp; &nbsp; Starter logging display added for host and server.<br>&nbsp; &nbsp; &nbsp; Splash screen use ATK one.<br><li><b>Astor-5.1.1 -  17/12/08:</b><br>&nbsp; &nbsp; &nbsp; Add a scroll pane in HostInfoDialog in case of too big dialog.<br><li><b>Astor-5.1.0 -  09/10/08:</b><br>&nbsp; &nbsp; &nbsp; Pool thread management added but not accessible.<br>&nbsp; &nbsp; &nbsp; New version and tests for access.<br><li><b>Astor-5.0.5 -  12/09/08:</b><br>&nbsp; &nbsp; &nbsp; Bug in server info (if not running) fixed.<br><li><b>Astor-5.0.4 -  16/06/08:</b><br>&nbsp; &nbsp; &nbsp; Level trees are now displayed on 2 rows.<br><li><b>Astor-5.0.3 -  22/05/08:</b><br>&nbsp; &nbsp; &nbsp; Host info dialog servers are managed in a jtree.<br><li><b>Astor-5.0.2 -  07/05/08:</b><br>&nbsp; &nbsp; &nbsp; Host info dialog line management changed.<br>&nbsp; &nbsp; &nbsp; Browse Database option added in DB popup menu.<br><li><b>Astor-5.0.1 -  10/04/08:</b><br>&nbsp; &nbsp; &nbsp; Branch info modified.<br>&nbsp; &nbsp; &nbsp; Table of hosts and servers added.<br><li><b>Astor-5.0.0 -  27/03/08:</b><br>&nbsp; &nbsp; &nbsp; Compatibility with Starter 4.0 and after only !<br>&nbsp; &nbsp; &nbsp; Better management of server list.<br>&nbsp; &nbsp; &nbsp; Server state MOVING managed.<br>&nbsp; &nbsp; &nbsp; Hard kill added on servers.<br>&nbsp; &nbsp; &nbsp; New features on polling profiler.<br><li><b>Astor-4.5.7 -  12/12/07:</b><br>&nbsp; &nbsp; &nbsp; Reset buttons added in event configuration panel.<br><li><b>Astor-4.5.6 -  07/11/07:</b><br>&nbsp; &nbsp; &nbsp; Display host info if OSManage DS  is running on host.<br>&nbsp; &nbsp; &nbsp; Display host's state on HotInfoDialog.<br><li><b>Astor-4.5.5 -  11/09/07:</b><br>&nbsp; &nbsp; &nbsp; Db attribute polling panel added.<br>&nbsp; &nbsp; &nbsp; Bug on repeate error window when refresh tree fixed.<br><li><b>Astor-4.5.4  -  04/09/07:</b><br>&nbsp; &nbsp; &nbsp; Set attribute polled names in lower case in new starter creation.<br><li><b>Astor-4.5.3  -  20/08/07:</b><br>&nbsp; &nbsp; &nbsp; ServStatePanel added on HostInfoDialog (Check states option).<br><li><b>Astor-4.5.2  -  27/04/07:</b><br>&nbsp; &nbsp; &nbsp; Display host panel available for stopped server from Device Browser.<br><li><b>Astor-4.5.1  -  04/04/07:</b><br>&nbsp; &nbsp; &nbsp; Database attribute properties editor added.<br><li><b>Astor-4.5.0  -  27/03/07:</b><br>&nbsp; &nbsp; &nbsp; Preferences dialog added.<br><li><b>Astor-4.4.4  -  08/03/07:</b><br>&nbsp; &nbsp; &nbsp; LastCollections property is managed.<br><li><b>Astor-4.4.3  -  22/01/07:</b><br>&nbsp; &nbsp; &nbsp; Remove watch dog on host thread.<br><li><b>Astor-4.4.2  -  17/01/07:</b><br>&nbsp; &nbsp; &nbsp; Html helps added.<br>&nbsp; &nbsp; &nbsp; Startup error message added in view menu.<br><li><b>Astor-4.4.1  -  08/01/07:</b><br>&nbsp; &nbsp; &nbsp; Disable Start Server button if Starter is MOVING.<br><li><b>Astor-4.4.0  -  25/09/06:</b><br>&nbsp; &nbsp; &nbsp; Access control tool added.<br><li><b>Astor-4.3.2:</b><br>&nbsp; &nbsp; &nbsp; Bug fixed in miscellaneous host collection.<br><li><b>Astor-4.3.1:</b><br>&nbsp; &nbsp; &nbsp; Moving state added for collection.<br>&nbsp; &nbsp; &nbsp; In StartAll command a sleep(500) has been added between two hosts.<br><li><b>Astor-4.3.0:</b><br>&nbsp; &nbsp; &nbsp; Moving state added for startup phase.<br><li><b>Astor-4.2.3:</b><br>&nbsp; &nbsp; &nbsp; Host info panel modified to use icons.<br><li><b>Astor-4.2.2:</b><br>&nbsp; &nbsp; &nbsp; Backward compatibilty for jive fixed.<br><li><b>Astor-4.2.1:</b><br>&nbsp; &nbsp; &nbsp; Icons have been changed.<br>&nbsp; &nbsp; &nbsp; Some minor changes.<br><li><b>Astor-4.2.0:</b><br>&nbsp; &nbsp; &nbsp; Polling profiler added.<br><li><b>Astor-4.1.4:</b><br>&nbsp; &nbsp; &nbsp; Open/Save menu added on event tester window.<br><li><b>Astor-4.1.3:</b><br>&nbsp; &nbsp; &nbsp; History added on event management.<br>&nbsp; &nbsp; &nbsp; The maximum servers displayed in horizontal on HostInfoDialog window has been set to 5.<br><li><b>Astor-4.1.2:</b><br>&nbsp; &nbsp; &nbsp; Bug fixed in Device browser in member device name.<br><li><b>Astor-4.1.1:</b><br>&nbsp; &nbsp; &nbsp; Change TANGO_HOST added (needs TangORB-4.7.7 or later).<br><li><b>Astor-4.1.0:</b><br>&nbsp; &nbsp; &nbsp; DevBrowser and MkStarter utilities added.<br><li><b>Astor-4.0.9:</b><br>&nbsp; &nbsp; &nbsp; Minor changes for EventTester compatibility<br><li><b>Astor-4.0.8:</b><br>&nbsp; &nbsp; &nbsp; Screen position modified for dialogs.<br><li><b>Astor-4.0.7:</b><br>&nbsp; &nbsp; &nbsp; Search if host already exist before creation.<br><li><b>Astor-4.0.6:</b><br>&nbsp; &nbsp; &nbsp; Search by host name added.<br><li><b>Astor-4.0.5:</b><br>&nbsp; &nbsp; &nbsp; Can change memorized attribute value.<br><li><b>Astor-4.0.4:</b><br>&nbsp; &nbsp; &nbsp; Bug in server architecture fixed.<br><li><b>Astor-4.0.3:</b><br>&nbsp; &nbsp; &nbsp; Minor changes, RemoteCmd property added.<br><li><b>Astor-4.0.2:</b><br>&nbsp; &nbsp; &nbsp; Server architecture display addded.<br><li><b>Astor-4.0.1:</b><br>&nbsp; &nbsp; &nbsp; DevWizard calls addded.<br><li><b>Astor-4.0.0:</b><br>&nbsp; &nbsp; &nbsp; Possibility to controle two database servers added.<br></body>\n</html>\n");
        } else if (item == this.tangorbBtn) {
            this.displayTangORBversion();
        } else if (item == this.aboutBtn) {
            this.displayAboutAstor();
        } else if (item == this.starterEventsItem) {
            this.displaySubscribedHostList(true);
        } else if (item == this.starterNoEventsItem) {
            this.displaySubscribedHostList(false);
        } else {
            Utils.popupMessage(this, "Not implemented yet !");
        }
    }

    private void displayTangORBversion() {
        String message;
        int width = 400;
        int height = 200;
        if (jarUsed == 0) {
            message = JTangoVersion.getInstance().toString();
            String jarName = JTangoVersion.getInstance().getJarFileName();
            int size = jarName.length() * 9;
            if (size > width) {
                width = size;
            }
        } else {
            TangORBversion tangorb;
            try {
                tangorb = new TangORBversion();
            }
            catch (Exception e) {
                ErrorPane.showErrorMessage((Component)this, (String)"Cannot check TangORB revision", (Exception)e);
                return;
            }
            message = tangorb.jarfile + ":\n\n" + tangorb;
        }
        PopupText txt = new PopupText(this, true);
        txt.setFont(new Font("Courier", 1, 14));
        txt.show(message, width, height);
        AstorUtil.centerDialog((JDialog)txt, this);
    }

    private void displayAboutAstor() {
        String message = "           Astor  (Tango Manager) \n\nThis programme is used to control, start and stop\n           the TANGO device servers. \n\n" + revNumber + "\n\n" + "Pascal Verdier - Software Engineering Group - ESRF";
        Utils.popupMessage(this, message, "TangoClass.gif");
    }

    private void displaySubscribedHostList(boolean onEvt) {
        String title;
        ArrayList<String> hostsList = new ArrayList<String>();
        for (TangoHost host : this.tree.hosts) {
            if (onEvt) {
                if (!host.onEvents) continue;
                hostsList.add(host.getName() + " " + host.eventSource);
                continue;
            }
            if (host.onEvents) continue;
            hostsList.add(host.getName());
        }
        StringBuilder message = new StringBuilder();
        if (hostsList.size() == 0) {
            title = "There is no host controlled " + TangoHost.controlMethod(onEvt);
        } else if (hostsList.size() == this.tree.hosts.length) {
            title = "All hosts are controlled " + TangoHost.controlMethod(onEvt);
        } else {
            title = "On " + this.tree.hosts.length + " hosts,\n" + hostsList.size() + "  are controlled " + TangoHost.controlMethod(onEvt);
            for (String hostName : hostsList) {
                message.append(hostName).append('\n');
            }
        }
        if (message.length() == 0) {
            Utils.popupMessage(this, title);
        } else {
            PopupText ppt = new PopupText(this, true);
            ppt.setTitle(title);
            ppt.addText(message.toString());
            ppt.setSize(360, 400);
            ppt.setVisible(true);
        }
    }

    private void expandBtnActionPerformed(ActionEvent evt) {
        this.expanded = !this.expanded;
        this.tree.expand(this.expanded);
        if (this.expanded) {
            this.expandBtn.setText("Collapse Tree");
        } else {
            this.expandBtn.setText("Expand Tree");
        }
    }

    private void deviceBrowserBtnActionPerformed(ActionEvent evt) {
        if (devBrowser == null) {
            devBrowser = new DevBrowser(this);
        }
        devBrowser.setVisible(true);
    }

    private void refreshBtnActionPerformed(ActionEvent evt) {
        try {
            this.buildTree();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void exitBtnActionPerformed(ActionEvent evt) {
        this.doExit();
    }

    private void exitForm(WindowEvent evt) {
        this.doExit();
    }

    private void findObjectByFilterItemActionPerformed(ActionEvent evt) {
        if (this.wide_search_dlg == null) {
            this.wide_search_dlg = new WideSearchDialog(this);
        }
        this.wide_search_dlg.setVisible(true);
    }

    private void multiServersCmdItemActionPerformed(ActionEvent evt) {
        try {
            if (this.multiServerCommand == null) {
                this.multiServerCommand = new MultiServerCommand(this);
            }
            this.multiServerCommand.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void statisticsBtnActionPerformed(ActionEvent evt) {
        StatisticsPanel statisticsPanel = new StatisticsPanel(this);
        statisticsPanel.readAndDisplayStatistics(null);
        statisticsPanel.setVisible(true);
    }

    private void serverUsageMenuItemActionPerformed(ActionEvent evt) {
        try {
            new ServerUsageDialog(this).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void faultyListItemhelpActionPerformed(ActionEvent evt) {
        StringBuilder sb = new StringBuilder();
        for (TangoHost host : this.tree.hosts) {
            if (host.state != 5) continue;
            sb.append(host.getName()).append('\n');
        }
        PopupText popupText = new PopupText(this, true);
        popupText.setTitle("Faulty host list");
        popupText.addText(sb.toString());
        popupText.setSize(360, 400);
        popupText.setVisible(true);
    }

    private void stopThreads() {
        System.out.println("Astor exiting....");
        if (this.tree != null && this.tree.hosts != null) {
            for (TangoHost host : this.tree.hosts) {
                host.stopThread();
                if (!host.onEvents) continue;
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        System.out.println(" ");
    }

    public void doExit() {
        if (devBrowser != null && devBrowser.isVisible()) {
            this.setVisible(false);
        } else {
            this.setVisible(false);
            this.stopThreads();
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            switch (args[0]) {
                case "-ro": {
                    System.out.println("Astor is in READ_ONLY mode !!!");
                    rwMode = 2;
                    break;
                }
                case "-db_ro": {
                    System.out.println("Astor is in DB_READ_ONLY mode !!!");
                    rwMode = 1;
                    break;
                }
                case "-rw": {
                    System.out.println("Astor is in READ_WRITE mode !!!");
                    rwMode = 0;
                    break;
                }
                default: {
                    try {
                        new AstorCmdLine(args);
                    }
                    catch (DevFailed e) {
                        Except.print_exception((Exception)((Object)e));
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        e.printStackTrace();
                    }
                    System.exit(0);
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                long t0 = System.currentTimeMillis();
                try {
                    Astor astor = new Astor();
                    astor.setVisible(true);
                }
                catch (DevFailed e) {
                    System.err.println(e.errors[0].desc);
                    if (e.errors[0].desc.indexOf("Controlled access service defined in Db but unreachable") > 0) {
                        e.errors[0].desc = "Controlled access service defined in Db but unreachable\nAstor cannot be configured from database !";
                    }
                    ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
                    System.exit(-1);
                }
                catch (HeadlessException | InternalError e) {
                    System.err.println(e.getMessage());
                }
                long t1 = System.currentTimeMillis();
                System.out.println("Build  GUI :" + (t1 - t0) + " ms");
            }
        });
    }

    static {
        rwMode = 0;
        searched_host = "";
    }

    private class HostsScanThread
    extends Thread {
        private JFrame parent;
        private TangoHost[] hosts;

        HostsScanThread(JFrame parent, TangoHost[] hosts) {
            this.parent = parent;
            this.hosts = hosts;
        }

        @Override
        public void run() {
            String[][] list = new String[this.hosts.length][];
            String message = "Scanning hosts...";
            Monitor monitor = new Monitor(this.parent, message);
            double ratio = 0.01;
            monitor.setProgressValue(ratio, "Starting...");
            try {
                HostsScanThread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                int nb_serv = 0;
                for (int i = 0; i < this.hosts.length; ++i) {
                    ratio = (1.0 + 1.0 * (double)i) / (double)this.hosts.length;
                    monitor.setProgressValue(ratio, "Reading " + this.hosts[i].getName());
                    String[] servers = this.hosts[i].getServerAttribute();
                    list[i] = new String[2];
                    list[i][0] = this.hosts[i].getName();
                    list[i][1] = "" + servers.length;
                    nb_serv += servers.length;
                }
                String title = nb_serv + " servers   on " + this.hosts.length + " hosts";
                String[] cols = new String[]{"Names", "Nb Servers"};
                PopupTable table = new PopupTable(this.parent, title, cols, list);
                table.setColumnWidth(new int[]{200, 100});
                table.setVisible(true);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"", (DevFailed)e);
            }
        }
    }
}

