/***********************************************************/
/* Signal monitoring aplication                            */
/* File : sgmon_tools.c                                    */
/* Descr: This module contains utility function            */
/* Date : 25/02/99                                         */
/***********************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "xrga_tools.h"

/*********************************/
/* ToLower : tolower on a string */
/*********************************/
void ToLower(char *s) {
  int i,l;
  l=strlen(s);

  for(i=0;i<l;i++)
    s[i]=tolower(s[i]);
}

/**********************/
/* Free string arrary */
/**********************/
void FreeStringArray(char ***ptr,long *nb)
{
  int i;

  if(*nb>0 || *ptr!=NULL) {
    for(i=0;i<*nb;i++)
      free((*ptr)[i]);
    free(*ptr);
  }
  *ptr=NULL;
  *nb=0;
}

/**********************************************************************/
/* Func   : DevExtractField()                                         */
/* Descr  : Return each field of a device name                        */
/* Arg in : full signal name                                          */
/* Arg out: domain name , family name , member name (malloc)          */
/**********************************************************************/
void DevExtractField(char *dev_name,
                      char **nethost,
                      char **domain,
                      char **family,
                      char **member)
{
  int pos;
  int pos0;
  int pos2;
  int pos3;

  pos0=0;
  if( strncmp( dev_name , "//" , 2)==0 )
  {
    pos=pos0=2;
    while( dev_name[pos]!='/' ) pos++;
  
    *nethost=(char *)malloc(pos-pos0+1);
    strncpy(*nethost,&(dev_name[pos0]),pos-pos0);
    (*nethost)[pos-pos0]=0;
    
    pos++;
    pos0=pos;
  } else {
    *nethost=NULL;
  }

  pos=pos0;

  while( dev_name[pos]!='/' ) pos++;

  *domain=(char *)malloc(pos-pos0+1);
  strncpy(*domain,&(dev_name[pos0]),pos-pos0);
  (*domain)[pos-pos0]=0;

  pos++;
  pos2=pos;
  while( dev_name[pos2]!='/' ) pos2++;

  *family=(char *)malloc(pos2-pos+1);
  strncpy(*family,&(dev_name[pos]),pos2-pos);
  (*family)[pos2-pos]=0;

  pos2++;
  pos3=pos2;
  while( dev_name[pos3]!='/' && pos3<strlen(dev_name) ) pos3++;

  *member=(char *)malloc(pos3-pos2+1);
  strncpy(*member,&(dev_name[pos2]),pos3-pos2);
  (*member)[pos3-pos2]=0;
}

/**********************************************************************/
/* Func   : DevNSExtract()                                            */
/* Descr  : Extarct last field of a signal name.                      */
/* Arg in : s1 - full signal name                                     */
/* Arg out: devname - signal name (malloc)                            */
/**********************************************************************/
void DevNSExtract(char *s1,char ** devname)
{
  int pos=0;
  int nbs=0;
  int ls1;
  char *t;

  ls1=strlen(s1);
  t=s1;

  if(ls1>2)
  {
    if(s1[0]=='/' && s1[1]=='/')
    {
      pos=2;t+=2;
      while( (pos<ls1) && (s1[pos]!='/') )
      {
        pos++;t++;
      }
      if(s1[pos]=='/') { pos++;t++; }
    }
  }

  while( (pos<ls1) && (nbs<3) )
  {
    if(s1[pos]=='/') nbs++;
    t++;
    pos++;
  }

  if(nbs==3) {
  *devname=(char *)malloc(strlen(t)+1);
  strcpy(*devname,t);
  }else
  {
    *devname=NULL;
  }

}

/**********************************************************************/
/* Func   : DevNExtract()                                             */
/* Descr  : Extarct device name of a signal.                          */
/* Arg in : full signal name                                          */
/* Arg out: device name (malloc)                                      */
/**********************************************************************/
void DevNExtract(char *s1,char ** devname)
{
  int pos=0;
  int nbs=0;
  int ls1;

  ls1=strlen(s1);

  if(ls1>2)
  {
    if(s1[0]=='/' && s1[1]=='/')
    {
      pos=2;
      while( (pos<ls1) && (s1[pos]!='/') )
        pos++;
      if(s1[pos]=='/') pos++;
    }
  }

  while( (pos<ls1) && (nbs<3) )
  {
    if(s1[pos]=='/') nbs++;
    if(nbs<3) pos++;
  }

  *devname=(char *)malloc(pos+1);
  (*devname)[pos]=0;
  strncpy(*devname,s1,pos);

}

/***************************************************/
/* FreeTree : Free all memory allocated for a tree */
/***************************************************/
void FreeTree(struct node *root) {
  if( root==NULL ) {
    return;
  } else {
    FreeTree( root->sub_list );
    FreeTree( root->next );
    free( root );
  }
}

/******************************************/
/* InsertList : Insert a string into a    */
/*              sorted linked string list */
/*              and return pointer on the */
/*              item                      */
/******************************************/
struct node *InsertList(struct node **root,char *str,char *n) {

  struct node *created;
  struct node *elem;
  struct node *last;
  int  found=1;

  elem=*root;
  last=NULL;

  /* Seacrh for insertion position */

  while( elem!=NULL && found>0 )
  {
    found=strcasecmp(str,elem->name);
    if( found>0 ) {
      last=elem;
      elem=elem->next;
    }
  }

  if( found==0 ) return elem;

  /* Create new cell */

  created=(struct node *)malloc(sizeof(struct node));
  strcpy(created->name,str);
  if( n!=NULL ) strcpy(created->nethost,n);
  else          strcpy(created->nethost,"");
  created->sub_list=NULL;
  created->next=elem;

  if( last==NULL )
    *root=created;
  else
    last->next=created;

  return created;
}

/***********************************************/
/* AddTree() : Add a device name into the tree */
/***********************************************/
void AddTree(struct node **Tree,char *dev_name) {

  struct node *p_domain;
  struct node *p_family;
  struct node *p_member;
  char *domain;
  char *family;
  char *member;
  char *nethost;

  DevExtractField(dev_name,&nethost,&domain,&family,&member);
  p_domain = InsertList( Tree , domain , nethost );
  p_family = InsertList( &(p_domain->sub_list) , family , NULL);
  p_member = InsertList( &(p_family->sub_list) , member , NULL);

  free(domain);
  free(family);
  free(member);
  safe_free((void **)&nethost);
}

/*****************************************************/
/* Return nethost according to domain                */
/*****************************************************/
char *GetNethost(struct node *Tree,char *domain) {

  struct node *elem;
  int found=0;
  elem=Tree;
  
  /* Seacrh for insertion position */

  while( elem!=NULL && found==0 )
  {
    found=(strcasecmp(domain,elem->name)==0);
    if( !found ) 
      elem=elem->next;
  }

  if( found ) {
    if( strlen(elem->nethost)==0 ) {
      return NULL;
    } else {
      return elem->nethost;
    }
  } else {
    return NULL;
  }

}

/*********************************/
/* Add one selection into a list */
/*********************************/
int AddSelection(char **list,int *nbs,char *sel,int max,char *err_str)
{
  char tmp[128];
  int i=0;
  int trouve=0;
  int nb;

  nb=*nbs;

  if(nb>=max) {
    sprintf(err_str,"Too many signal in the list (%d MAX)",max);
    return 0;
  }

  while(i<nb && !trouve)
  {
    trouve=( strcasecmp( list[i],sel )==0 );
    if(!trouve) i++;
  }

  if(trouve) {
    sprintf(err_str,"%s signal is already in the list",list[i]);
    return 0;
  }

  list[nb]=strdup(sel);
  *nbs=nb+1;
  return 1;
}

/*********************************/
/* Duplicate a DevVarStringArray */
/*********************************/
void DuplicateStringArray( DevVarStringArray *dest,
                           DevVarStringArray src )
{
  int i;

  dest->length=src.length;
  dest->sequence=(char **)malloc(src.length * sizeof(char *));

  for(i=0;i<src.length;i++)
  {
    dest->sequence[i]=(char *)malloc(strlen(src.sequence[i])+1);
    strcpy(dest->sequence[i],src.sequence[i]);
  }
}

/********************************************/
/* Free a pointer and set it to null        */
/********************************************/
void safe_free( void **ptr )
{
   if( *ptr != NULL )
   {
     free(*ptr);
     *ptr=NULL;
   }
}

/*******************************/
/* Convert a float into string */
/*******************************/
char *F2S(double v) {
  static char tmp[64];
  sprintf(tmp,"%g",v);
  return &(tmp[0]);
}

/***************************************/
/* Return TRUE or FALSE according to b */
/***************************************/
char *ToBool(Boolean b) {
  static char tmp[64];
  if(b) sprintf(tmp,"TRUE");
  else  sprintf(tmp,"FALSE");
  return &(tmp[0]);
}
