/*----------------------------------------------------------------------
 File : xrga_dev.h
 Description : This module contains procedures for RGA and PPAS device 
               management.

 Author : JL PONS
 Date :   06/2000
 Project : RGA and PPAS application

-----------------------------------------------------------------------*/

typedef struct {
  short AlarmStatus;
  short Multiplier;
  short Enable;
  short mass;
  short Range;
  short AutoRange;
  short HighAlarm;
  short LowAlarm;
} TRGA_channel;


void xrga_dev_init();
long xrga_dev_init_dev_list();
void xrga_dev_get_domain_list(char ***,long *);
long xrga_dev_get_family_list(char *,char ***,long *);
long xrga_dev_get_member_list(char *,char *,char ***,long *);
void xrga_dev_get_rga_status( char *,int  *,int  *,int  *,char *,
			      char *,int  *,char *,char *,char *,char *);
int  xrga_dev_get_data(int *,float *,float *);
int  xrga_dev_is_ppas_present();
int  xrga_dev_set_rga_mode(int);
void xrga_dev_get_rga_scan(int *);
int xrga_dev_get_mass_indx(int);
void xrga_dev_set_rga_param( int , int , int , int , int , int , int , int , int );
void xrga_dev_get_ppas_status(int *,int *,char *);
void xrga_dev_set_ppas_mode(int);
void xrga_dev_get_ppas_conditions( char **r,char **t);
void xrga_dev_reset_rga();
int xrga_dev_build_sgmon_config_file( char * );
int xrga_dev_get_last_alarm(int *,int *,int *,int *,float *,float *,int *);
