/*
 * README: This file is appended to at file generation time.
 * Edits can be made throughout the file
 */
/*
 * Generated by the ICS Builder Xcessory (BX).
 *
 * Builder Xcessory Version 5.0.3
 * Code Generator Xcessory 5.0.1 (09/29/98) Script Version 5.0.3
 *
 */
#include <Xm/Xm.h>

/*
 * Standard includes for builtins.
 */
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "xrga_tools.h"
#include "xrga_gui.h"
#include "xrga_dev.h"

/*
 * Macros to make code look nicer between ANSI and K&R.
 */
#ifndef ARGLIST
#if (NeedFunctionPrototypes == 0)
#define PROTOTYPE(p)	()
#define ARGLIST(p)	p
#define ARG(a, b)	a b;
#define GRA(a, b)	a b;
#define UARG(a, b)      a b;
#define GRAU(a, b)      a b;
#else
#define PROTOTYPE(p)	p
#define ARGLIST(p)	(
#define ARG(a, b)	a b,
#define GRA(a, b)	a b)
#ifdef __cplusplus
#define UARG(a, b)      a,
#define GRAU(a, b)      a)
#else
#define UARG(a, b)      a b,
#define GRAU(a, b)      a b)
#endif
#endif
#endif

Widget		BxFindTopShell PROTOTYPE((Widget));
WidgetList	BxWidgetIdsFromNames PROTOTYPE((Widget, char*, char*));

extern XtAppContext app_ctx;
void xrga_cb_monitor_rga(XtPointer , XtIntervalId *);
void xrga_cb_update_rga_status();
void xrga_cb_update_rga_values();
extern current_rga_mode;

extern int cur_firstmass;
extern int cur_lastmass;

Widget mwin;
Widget errwin;
Widget errwin_txt;
Widget mesgwin;
Widget mesgwin_txt;
Widget selwin;
Widget selwin_domain_list;
Widget selwin_family_list;
Widget selwin_member_list;
Widget mainsb;

Widget rgast_frame;
Widget rgast_mode_label;
Widget rgast_filament1_label;
Widget rgast_filament2_label;
Widget rgast_multiplier_label;
Widget rgast_multiplier_volt_text;
Widget rgast_multiplier_gain_text;
Widget rgast_range_text;
Widget rgast_autorange_label;
Widget rgast_accuracy_text;
Widget rgast_end_mass_text;
Widget rgast_start_mass_text;
Widget rgast_scan_bar_f;
Widget rgast_scan_bar_b;

Widget ppasctrl_frame;
Widget ppasst_frame;
Widget ppasst_mode_lb;

Widget rgaset_win;
Widget rgaset_mode_label;
Widget rgaset_lastmass_text;
Widget rgaset_multgain_text;
Widget rgaset_range_text;
Widget rgaset_multvolt_text;
Widget rgaset_accuray_text;
Widget rgaset_filament_om;
Widget rgaset_multiplier_tb;
Widget rgaset_filament_pdm;
Widget rgaset_range_tb;
Widget rgaset_firstmass_text;

Widget gopt_win;
Widget gopt_xmin_text;
Widget gopt_ymin_text;
Widget gopt_xtitle_text;
Widget gopt_ytitle_text;
Widget gopt_xmax_text;
Widget gopt_ymax_text;
Widget gopt_header_text;
Widget gopt_xscale_frame;
Widget gopt_yscale_frame;
Widget gopt_xautoscale_tb;
Widget gopt_yautoscale_tb;
Widget gopt_ygrid_tb;
Widget gopt_xgrid_tb;

Widget Tcond[13];
Widget Trelay[5];

Widget ppascond_frame;
Widget ppascond_t_text[13];
Widget ppascond_r_text[5];
Widget ppascond_t_frame[13];
Widget ppascond_r_frame[5];

char **list_domain=NULL;
long nb_domain=0;
char current_domain[30];

char **list_family=NULL;
long nb_family=0;
char current_family[30];

char **list_member=NULL;
long nb_member=0;
char current_member[30];

int old_scan=0;
int old_mode=0;
int stop_moni=0;

void xrga_cb_update_ppas_status();

/**************************************************************************************/
/* Widget creation callbacks                                                          */
/**************************************************************************************/

void xrga_cb_selection_win_create( Widget w, XtPointer client_data, XtPointer call_data)
{ selwin=w;}

void xrga_cb_family_list_create( Widget w, XtPointer client_data, XtPointer call_data)
{ selwin_family_list=w;}

void xrga_cb_member_list_create( Widget w, XtPointer client_data, XtPointer call_data)
{ selwin_member_list=w;}

void xrga_cb_domain_list_create( Widget w, XtPointer client_data, XtPointer call_data)
{ selwin_domain_list=w;}

void xrga_cb_menu_bar_create( Widget w, XtPointer client_data, XtPointer call_data)
{
  Pixel u;
  XtVaGetValues( w , XmNbackground , &u , NULL );
  XtVaSetValues( XtParent(w) , XmNbackground , u , NULL );
}

void xrga_cb_error_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ errwin_txt=w; }

void xrga_cb_error_win_create( Widget w, XtPointer client_data, XtPointer call_data)
{ errwin=w; }

void xrga_cb_mainsb_create( Widget w, XtPointer client_data, XtPointer call_data)
{ mainsb=w; }

void xrga_cb_mainwin_create( Widget w, XtPointer client_data, XtPointer call_data)
{ mwin=w; }

void xrga_cb_message_win_create( Widget w, XtPointer client_data, XtPointer call_data)
{ mesgwin=w; }

void xrga_cb_message_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ mesgwin_txt=w; }

void xrga_cb_rga_status_mode_label_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_mode_label =w; }

void xrga_cb_rga_status_multiplier_label_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_multiplier_label =w; }

void xrga_cb_rga_status_multiplier_volt_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_multiplier_volt_text =w; }

void xrga_cb_rga_status_multiplier_gain_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_multiplier_gain_text =w; }

void xrga_cb_rga_status_range_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_range_text =w; }

void xrga_cb_rga_status_auto_range_label_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_autorange_label =w; }

void xrga_cb_rga_status_accuray_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_accuracy_text =w; }

void xrga_cb_rga_status_frame_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_frame =w; }

void xrga_cb_rga_status_end_mass_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_end_mass_text =w; }

void xrga_cb_rga_status_start_mass_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_start_mass_text =w; }

void xrga_cb_rga_status_filament1_label_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_filament1_label =w; }

void xrga_cb_rga_status_filament2_label_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_filament2_label =w; }

void xrga_cb_rga_status_progress_bar_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_scan_bar_b=w; }

void xrga_cb_rga_status_progress_frame_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgast_scan_bar_f=w; }

void xrga_cb_graph_frame_create( Widget w, XtPointer client_data, XtPointer call_data)
{ xrga_gui_create_graph(w); }

void xrga_cb_ppas_status_t_create( Widget w, XtPointer client_data, XtPointer call_data)
{ Tcond[(int)client_data-1]=w; }

void xrga_cb_ppas_status_r_create( Widget w, XtPointer client_data, XtPointer call_data)
{ Trelay[(int)client_data-1]=w; }

void xrga_cb_ppas_frame_ctrl_create( Widget w, XtPointer client_data, XtPointer call_data)
{ ppasctrl_frame=w; }
void xrga_cb_ppas_frame_status_create( Widget w, XtPointer client_data, XtPointer call_data)
{ ppasst_frame=w; }

void xrga_cb_ppas_status_mode_label_create( Widget w, XtPointer client_data, XtPointer call_data)
{ ppasst_mode_lb=w; }

void xrga_cb_rga_setting_mode_label_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgaset_mode_label=w; }

void xrga_cb_rga_setting_lastmass_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgaset_lastmass_text=w; }

void xrga_cb_rga_setting_multgain_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgaset_multgain_text=w; }

void xrga_cb_rga_setting_range_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgaset_range_text=w; }

void xrga_cb_rga_setting_multvolt_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgaset_multvolt_text=w; }

void xrga_cb_rga_setting_frame_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgaset_win=w; }

void xrga_cb_rga_setting_accuray_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgaset_accuray_text=w; }

void xrga_cb_rga_setting_filament_om_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgaset_filament_om=w; }

void xrga_cb_rga_setting_mutilplier_tb_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgaset_multiplier_tb=w; }

void xrga_cb_rga_setting_filament_pdm_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgaset_filament_pdm=w; }

void xrga_cb_rga_setting_range_tb_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgaset_range_tb=w; }

void xrga_cb_rga_setting_firstmass_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ rgaset_firstmass_text=w; }

void xrga_cb_graph_options_frame_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_win=w; }

void xrga_cb_graph_xmin_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_xmin_text=w; }

void xrga_cb_graph_ymin_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_ymin_text =w; }

void xrga_cb_graph_xtitle_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_xtitle_text =w; }

void xrga_cb_graph_ytitle_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_ytitle_text =w; }

void xrga_cb_graph_xmax_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_xmax_text =w; }

void xrga_cb_graph_ymax_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_ymax_text =w; }

void xrga_cb_graph_header_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_header_text =w; }

void xrga_cb_graph_xscale_frame_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_xscale_frame =w; }

void xrga_cb_graph_yscale_frame_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_yscale_frame =w; }

void xrga_cb_graph_xautoscale_tb_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_xautoscale_tb =w; }

void xrga_cb_graph_yautoscale_tb_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_yautoscale_tb =w; }

void xrga_cb_graph_ygrid_tb_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_ygrid_tb =w; }

void xrga_cb_graph_xgrid_tb_create( Widget w, XtPointer client_data, XtPointer call_data)
{ gopt_xgrid_tb =w; }

void xrga_cb_ppas_cond_frame_create( Widget w, XtPointer client_data, XtPointer call_data)
{ ppascond_frame=w; }

void xrga_cb_ppas_cond_r_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ ppascond_r_text[(int)client_data-1]=w; }

void xrga_cb_ppas_cond_t_text_create( Widget w, XtPointer client_data, XtPointer call_data)
{ ppascond_t_text[(int)client_data-1]=w; }

void xrga_cb_ppas_cond_r_frame_create( Widget w, XtPointer client_data, XtPointer call_data)
{ ppascond_r_frame[(int)client_data-1]=w; }

void xrga_cb_ppas_cond_t_frame_create( Widget w, XtPointer client_data, XtPointer call_data)
{ ppascond_t_frame[(int)client_data-1]=w; }

/**************************************************************************************/


void
xrga_cb_errors_pb_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  xrga_gui_show_err();
}

void xrga_cb_exit_pb_act( Widget w, XtPointer client_data, XtPointer call_data)
{ exit(0); }

void xrga_cb_select_rga_pb_act( Widget w, XtPointer client_data, XtPointer call_data)
{

  xrga_gui_watch_cursor(mwin);

  FreeStringArray(&list_domain,&nb_domain);
  FreeStringArray(&list_family,&nb_family);
  FreeStringArray(&list_member,&nb_member);

  if( xrga_dev_init_dev_list()<0)
  {
    xrga_gui_arrow_cursor(mwin);
    return;
  }

  xrga_dev_get_domain_list(&list_domain,&nb_domain);

  xrga_gui_set_list( selwin_domain_list , list_domain , nb_domain);
  xrga_gui_set_list( selwin_family_list , list_family , nb_family);
  xrga_gui_set_list( selwin_member_list , list_member , nb_member);

  XtManageChild( selwin );
  xrga_gui_arrow_cursor(mwin);
}

void xrga_cb_domain_list_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct    *selbox_cbs;
  char *sel;
  Boolean                         xms_status;
  long error=0;

  selbox_cbs = (XmSelectionBoxCallbackStruct *) call_data;
  xms_status = XmStringGetLtoR( selbox_cbs->value, XmFONTLIST_DEFAULT_TAG,
                                                      &sel);
  if (xms_status != False)
  {
    strcpy(current_domain,sel);
    free(sel);

    FreeStringArray(&list_family,&nb_family);
    FreeStringArray(&list_member,&nb_member);

    if( xrga_dev_get_family_list(current_domain,&list_family,&nb_family)<0)
    {
      return;
    }

    xrga_gui_set_list( selwin_family_list , list_family , nb_family);
    xrga_gui_set_list( selwin_member_list , list_member , nb_member);

  } 
}

void xrga_cb_update_rga_status();

void xrga_cb_family_list_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct    *selbox_cbs;
  char *sel;
  Boolean                         xms_status;

  selbox_cbs = (XmSelectionBoxCallbackStruct *) call_data;
  xms_status = XmStringGetLtoR( selbox_cbs->value, XmFONTLIST_DEFAULT_TAG,
                                                      &sel);
  if (xms_status != False)
  {
    strcpy(current_family,sel);
    free(sel);

    FreeStringArray(&list_member,&nb_member);

    if( xrga_dev_get_member_list(current_domain,current_family,
                           &list_member,&nb_member)<0)
    {
      return;
    }

    xrga_gui_set_list( selwin_member_list , list_member , nb_member);

  }
}

/***************************************************************************/
/* Update RGA status frame                                                 */
/***************************************************************************/

void xrga_cb_member_list_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  XmSelectionBoxCallbackStruct    *selbox_cbs;
  char *sel;
  Boolean                         xms_status;
  char tmp[128];

  selbox_cbs = (XmSelectionBoxCallbackStruct *) call_data;
  xms_status = XmStringGetLtoR( selbox_cbs->value, XmFONTLIST_DEFAULT_TAG,
                                                      &sel);
  if (xms_status != False)
  {
    strcpy(current_member,sel);
    free(sel);
  }

  xrga_gui_watch_cursor(mwin);
  xrga_gui_watch_cursor(selwin);

  xrga_dev_import_rga(current_domain,current_family,current_member);
  XtUnmanageChild( selwin );

  sprintf(tmp,"xrga [%s/%s/%s]",current_domain,current_family,current_member);
  xrga_gui_set_app_title(tmp);
 
  if( (current_rga_mode == 4) ||
      (current_rga_mode == 9) )
    xrga_gui_set_graph_plot();
  else
    xrga_gui_set_graph_bar();

  xrga_cb_update_rga_status();
  xrga_cb_update_ppas_status();
  xrga_cb_update_rga_values();
  old_scan=0;
  old_mode=current_rga_mode;

  XtSetSensitive( ppasctrl_frame , xrga_dev_is_ppas_present() );
  XtSetSensitive( ppasst_frame   , xrga_dev_is_ppas_present() );

  xrga_gui_arrow_cursor(mwin);
  xrga_gui_arrow_cursor(selwin);
  
  XtUnmanageChild(rgaset_win);
  
  if(stop_moni) {
    XtAppAddTimeOut(app_ctx,1000,xrga_cb_monitor_rga,NULL);
    stop_moni=0;
  }
}

/*****************************************************/
/* Update the status frame of the RGA                */
/*****************************************************/
void xrga_cb_update_rga_status() {

 char mode[32];
 int  filament1=0;
 int  filament2=0;
 int  multiplier=0;
 char multiplier_volt[32];
 char multiplier_gain[32];
 int  autorange=0; 
 char range[32];
 char accuracy[32];
 char start_mass[32];
 char end_mass[32];


 strcpy(mode,"Unknown");
 strcpy(multiplier_volt,"---");
 strcpy(multiplier_gain,"---");
 strcpy(range,"---");
 strcpy(accuracy,"---");
 strcpy(start_mass,"---");
 strcpy(end_mass,"---");

 xrga_dev_get_rga_status( mode , &filament1 ,&filament2 ,
			  &multiplier , multiplier_volt ,
			  multiplier_gain,&autorange,
			  range,accuracy,start_mass,end_mass );

 xrga_gui_set_label( rgast_mode_label , mode );
 switch(filament1) {
   case 0: xrga_gui_set_label( rgast_filament1_label , "---");break;
   case 1: xrga_gui_set_label( rgast_filament1_label , "Off");break;
   case 2: xrga_gui_set_label( rgast_filament1_label , "On");break;
 }
 switch(filament2) {
   case 0: xrga_gui_set_label( rgast_filament2_label , "---");break;
   case 1: xrga_gui_set_label( rgast_filament2_label , "Off");break;
   case 2: xrga_gui_set_label( rgast_filament2_label , "On");break;
 }
 XtVaSetValues( rgast_multiplier_volt_text , XmNvalue , multiplier_volt , NULL );
 XtVaSetValues( rgast_multiplier_gain_text , XmNvalue , multiplier_gain , NULL );
 switch(autorange) {
   case 0: xrga_gui_set_label( rgast_autorange_label , "---");break;
   case 1: xrga_gui_set_label( rgast_autorange_label , "Off");break;
   case 2: xrga_gui_set_label( rgast_autorange_label , "On");break;
 }
 switch(multiplier) {
   case 0: xrga_gui_set_label( rgast_multiplier_label , "---");break;
   case 1: xrga_gui_set_label( rgast_multiplier_label , "Off");break;
   case 2: xrga_gui_set_label( rgast_multiplier_label , "On");break;
 }

 XtVaSetValues( rgast_accuracy_text , XmNvalue , accuracy , NULL );
 XtVaSetValues( rgast_start_mass_text , XmNvalue , start_mass , NULL );
 XtVaSetValues( rgast_end_mass_text , XmNvalue , end_mass , NULL );
 XtVaSetValues( rgast_range_text , XmNvalue , range , NULL );

}

/*****************************************************/
/* Update spectrum of the RGA                        */
/*****************************************************/
void xrga_cb_update_rga_values()
{
  static float values[256];
  static float mass[256];
  int nb=0;

    if( xrga_dev_get_data(&nb,mass,values)==1 )
      xrga_gui_update_graph(nb,mass,values);

}

/*****************************************************/
/* Update the status frame of the PPAS               */
/*****************************************************/
void xrga_cb_update_ppas_status() {

  static int cond[12];
  static int relay[4];
  int i;
  char mode[64];

  memset( cond  , 0 , 12*sizeof(int) );
  memset( relay , 0 , 4*sizeof(int) );

  xrga_dev_get_ppas_status(cond,relay,mode);
  for(i=0;i<4;i++)  xrga_gui_set_relay_background(Trelay[i],relay[i]);
  for(i=0;i<12;i++) xrga_gui_set_cond_background(Tcond[i],cond[i]);

  xrga_gui_set_label( ppasst_mode_lb , mode );
}

/*****************************************************/
/* Update callback (XRGA)                            */
/*****************************************************/
void xrga_cb_monitor_rga(XtPointer client_data, XtIntervalId *id)
{
  int s;
  float b;

  /* Update scan idx */

  xrga_dev_get_rga_scan(&s);

  switch(current_rga_mode) {
    case 2: b=s/(float)(cur_lastmass-cur_firstmass);break;
    case 3: b=s/12.0;break;
    case 4: b=s/256.0;break;
    case 9: b=s/100.0;break;
    default: b=0.0;break;
  }


  if(s!=-1) {
    
    /* update spectrum */

    if( s<old_scan ) {

      xrga_cb_update_rga_status();

      /* Check if the mode has been changed */

      if( current_rga_mode != old_mode )
      {
	switch(current_rga_mode) {
	  case 2:
	  case 3:
	    xrga_gui_set_graph_bar();
	    break;
	  default:
            xrga_gui_set_graph_plot();
	    break;
	}
	old_mode=current_rga_mode;

      }

      xrga_cb_update_rga_values();
      xrga_cb_update_ppas_status();
    }
    old_scan=s;

  }

  xrga_gui_set_bar( rgast_scan_bar_f,rgast_scan_bar_b,b );
  
  if(!stop_moni) XtAppAddTimeOut(app_ctx,1000,xrga_cb_monitor_rga,NULL);
}

void xrga_cb_start_monitor() {
  XtAppAddTimeOut(app_ctx,5000,xrga_cb_monitor_rga,NULL);
}

/**********************************************************/
/* Control button                                         */
/**********************************************************/

/*************** RGA ****************/
void xrga_cb_rga_peakjump_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  xrga_gui_clear_graph();
  if( xrga_dev_set_rga_mode(3) )
    xrga_gui_scan_in_progress();
  xrga_cb_update_rga_status();
  xrga_gui_set_graph_bar();
  old_scan=0;
  old_mode=current_rga_mode;
  if(stop_moni) {
    XtAppAddTimeOut(app_ctx,1000,xrga_cb_monitor_rga,NULL);
    stop_moni=0;
  }
}

void xrga_cb_rga_barchart_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  xrga_gui_clear_graph();
  if( xrga_dev_set_rga_mode(2) )
    xrga_gui_scan_in_progress();
  xrga_cb_update_rga_status();
  xrga_gui_set_graph_bar();
  old_scan=0;
  old_mode=current_rga_mode;
  if(stop_moni) {
    XtAppAddTimeOut(app_ctx,1000,xrga_cb_monitor_rga,NULL);
    stop_moni=0;
  }
}

void xrga_cb_rga_analog_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  xrga_gui_clear_graph();
  if( xrga_dev_set_rga_mode(4) )
    xrga_gui_scan_in_progress();
  
  xrga_dev_set_one_rga_param(1,1);   /* Multip[lier */
  xrga_dev_set_one_rga_param(4,1);   /* First Mass  */
  xrga_dev_set_one_rga_param(5,64);  /* Last Mass   */
  xrga_dev_set_one_rga_param(7,1);   /* Autorange   */

  xrga_cb_update_rga_status();
  xrga_gui_set_graph_plot();
  old_scan=0;
  old_mode=current_rga_mode;
  if(stop_moni) {
    XtAppAddTimeOut(app_ctx,1000,xrga_cb_monitor_rga,NULL);
    stop_moni=0;
  }
}


void xrga_cb_rga_setting_act( Widget w, XtPointer client_data, XtPointer call_data)
{
 char mode[32];
 int  filament1=0;
 int  filament2=0;
 int  multiplier=0;
 char multiplier_volt[32];
 char multiplier_gain[32];
 int  autorange=0; 
 char range[32];
 char accuracy[32];
 char start_mass[32];
 char end_mass[32];

 if( current_rga_mode == 9 ) {
   xrga_gui_adderr_man( "Cannot set param in PPAS mode" );
   return;
 }

 stop_moni=1;

 strcpy(mode,"Unknown");
 strcpy(multiplier_volt,"---");
 strcpy(multiplier_gain,"---");
 strcpy(range,"---");
 strcpy(accuracy,"---");
 strcpy(start_mass,"---");
 strcpy(end_mass,"---");

 xrga_dev_get_rga_status( mode , &filament1 ,&filament2 ,
			  &multiplier , multiplier_volt ,
			  multiplier_gain,&autorange,
			  range,accuracy,start_mass,end_mass );

 xrga_gui_set_label( rgaset_mode_label , mode );

 xrga_gui_om_set( rgaset_filament_om , 0);

 if( filament1==2 ) 
    xrga_gui_om_set( rgaset_filament_om , 1);

 if( filament2==2 )
    xrga_gui_om_set( rgaset_filament_om , 2);

 XtVaSetValues( rgaset_multvolt_text , XmNvalue , multiplier_volt , NULL );
 XtVaSetValues( rgaset_multgain_text , XmNvalue , multiplier_gain , NULL );

 switch(autorange) {
   case 0: XtVaSetValues(rgaset_range_tb , XmNset , False,NULL);break;
   case 1: XtVaSetValues(rgaset_range_tb , XmNset , False,NULL);break;
   case 2: XtVaSetValues(rgaset_range_tb , XmNset , True ,NULL);break;
 }

 switch(multiplier) {
   case 0: XtVaSetValues(rgaset_multiplier_tb , XmNset , False,NULL);break;
   case 1: XtVaSetValues(rgaset_multiplier_tb , XmNset , False,NULL);break;
   case 2: XtVaSetValues(rgaset_multiplier_tb , XmNset , True ,NULL);break;
 }

 XtVaSetValues( rgaset_accuray_text , XmNvalue , accuracy , NULL );
 XtVaSetValues( rgaset_firstmass_text , XmNvalue , start_mass , NULL );
 XtVaSetValues( rgaset_lastmass_text , XmNvalue , end_mass , NULL );
 XtVaSetValues( rgaset_range_text , XmNvalue , range , NULL );

 XtManageChild( rgaset_win );

}

int get_int( int *v,Widget w )
{
  char *s;
  XtVaGetValues( w, XmNvalue , &s , NULL);

  if( sscanf( s, "%d" , v )==0 )
  {
    return 0;
  }
  return 1;

}

void xrga_cb_rga_setting_apply_pb_act( Widget w, XtPointer client_data, XtPointer call_data)
{

int multiplier=0;
int accuracy=0;
int firstmass=0;
int lastmass=0;
int range=0;
int autorange=0;
int multvolt=0;
int multgain=0;
int filament=0;
int s;

  /* Get filament */

 filament = xrga_gui_om_pos( rgaset_filament_om ); 
 
 if( !get_int( &multgain , rgaset_multgain_text ) )
   xrga_gui_adderr_man( "Invalid multiplier gain value" );
  
 if( !get_int( &multvolt , rgaset_multvolt_text ) )
   xrga_gui_adderr_man( "Invalid multiplier voltage value" );

 if( !get_int( &accuracy , rgaset_accuray_text ) )
   xrga_gui_adderr_man( "Invalid accuracy value" );

 if( current_rga_mode != 3 ) /* We are not in peak jump mode */
 {
   if( !get_int( &firstmass , rgaset_firstmass_text ) )
     xrga_gui_adderr_man( "Invalid first mass value" );
   if( !get_int( &lastmass , rgaset_lastmass_text ) )
     xrga_gui_adderr_man( "Invalid last mass value" );
   if( !get_int( &range , rgaset_range_text ) )
     xrga_gui_adderr_man( "Invalid range value" );
   XtVaGetValues( rgaset_multiplier_tb , XmNset , &multiplier , NULL);
   XtVaGetValues( rgaset_range_tb , XmNset , &autorange , NULL );
 }

 xrga_dev_set_rga_param( multiplier, accuracy,
    firstmass, lastmass, range, autorange, multvolt,
    multgain, filament);

 xrga_cb_update_rga_status();

 /* Check if the scanning has not restarted */
 
 xrga_dev_get_rga_scan(&s);
 if( s<old_scan ) old_scan=0;

 XtUnmanageChild(rgaset_win);
 stop_moni=0;
 XtAppAddTimeOut(app_ctx,1000,xrga_cb_monitor_rga,NULL);
}



void xrga_cb_graph_options_pb_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  xrga_gui_display_graph_options();
}

void xrga_cb_graph_apply_pb_act( Widget w, XtPointer client_data, XtPointer call_data)
{ 
  xrga_gui_apply_graph_options();
}


void
xrga_cb_graph_xautoscale_tb_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  int a;
  XtVaGetValues(w,XmNset , &a,NULL);
  if( a )
    XtSetSensitive(gopt_xscale_frame,False);
  else
    XtSetSensitive(gopt_xscale_frame,True);
}

void
xrga_cb_graph_yautoscale_tb_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  int a;
  XtVaGetValues(w,XmNset , &a,NULL);
  if( a )
    XtSetSensitive(gopt_yscale_frame,False);
  else
    XtSetSensitive(gopt_yscale_frame,True);
}


void
xrga_cb_mainsb_act( Widget w, XtPointer client_data, XtPointer call_data)
{
    XmAnyCallbackStruct *acs = (XmAnyCallbackStruct*)call_data;
}

/************************** PPAS command button ***************************/

void xrga_cb_ppas_control_pb_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  if(current_rga_mode!=9) xrga_dev_set_ppas_mode(2);
  if(stop_moni) {
    xrga_cb_update_rga_values();
    xrga_cb_update_rga_status();
    XtAppAddTimeOut(app_ctx,1000,xrga_cb_monitor_rga,NULL);
    stop_moni=0;
  }
}

void xrga_cb_ppas_bypass_pb_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  xrga_dev_set_ppas_mode(1);
  if(stop_moni) {
    XtAppAddTimeOut(app_ctx,1000,xrga_cb_monitor_rga,NULL);
    stop_moni=0;
  }
}

void xrga_cb_ppas_getalarm_pb_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  static int cond[12];
  static int relay[4];
  int i,start,end;
  char mode[64];
  char bur[400];
  char but[1200];
  static float values[256];
  static float mass[256];
  int nb=0;
  char *r[4];
  char *t[12];

  if( current_rga_mode != 9 ) {
   xrga_gui_adderr_man( "Can read last alarm only in CONTROL mode" );
   return;
  }

  memset( cond  , 0 , 12*sizeof(int) );
  memset( relay , 0 , 4*sizeof(int) );

  for(i=0;i<4;i++) { r[i]=&(bur[i*100]);strcpy(r[i],""); }
  for(i=0;i<12;i++){ t[i]=&(but[i*100]); strcpy(t[i],""); }

  if( xrga_dev_get_last_alarm(cond,relay, &start,&end,mass,values,&nb) )
  {
    stop_moni=1;
    xrga_gui_set_graph_plot();
    xrga_gui_update_graph(nb,mass,values);
  
    for(i=0;i<4;i++)  xrga_gui_set_relay_background(Trelay[i],relay[i]);
    for(i=0;i<12;i++) xrga_gui_set_cond_background(Tcond[i],cond[i]);
    xrga_gui_set_label( rgast_mode_label , "Last Alarm" );
  }

}

void xrga_cb_ppas_conditions_pb_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  static int cond[12];
  static int relay[4];
  int i,start,end;
  char mode[64];
  char bur[400];
  char but[1200];
  static float values[256];
  static float mass[256];
  int nb=0;
 
  char *r[4];
  char *t[12];
  
  if( current_rga_mode != 9 ) {
   xrga_gui_adderr_man( "Can read condition only in CONTROL mode" );
   return;
  }

  memset( cond  , 0 , 12*sizeof(int) );
  memset( relay , 0 , 4*sizeof(int) );

  for(i=0;i<4;i++) { r[i]=&(bur[i*100]);strcpy(r[i],""); }
  for(i=0;i<12;i++){ t[i]=&(but[i*100]); strcpy(t[i],""); }

  if( !stop_moni ) {
    xrga_dev_get_ppas_status(cond,relay,mode);
  } else {
    xrga_dev_get_last_alarm(cond,relay, &start,&end,mass,values,&nb);
  }
  
  xrga_dev_get_ppas_conditions(r,t);

  for(i=0;i<4;i++)  {
    xrga_gui_set_relay_background(ppascond_r_frame[i],relay[i]);
    XtVaSetValues(ppascond_r_text[i],XmNvalue,r[i],NULL);
  }
  for(i=0;i<12;i++) {
    xrga_gui_set_cond_background(ppascond_t_frame[i],cond[i]);
    XtVaSetValues(ppascond_t_text[i],XmNvalue,t[i],NULL);
  }

  XtManageChild(ppascond_frame);
}


void
xrga_cb_rga_setting_reset_pb_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  xrga_gui_watch_cursor(mwin);
  xrga_gui_watch_cursor(rgaset_win);
  xrga_dev_reset_rga();
  xrga_gui_arrow_cursor(mwin);
  xrga_gui_arrow_cursor(rgaset_win);
}

void xrga_cb_rga_setting_dismiss_pb_act( Widget w, XtPointer client_data, XtPointer call_data)
{
  stop_moni=0;
  XtUnmanageChild(rgaset_win);
  XtAppAddTimeOut(app_ctx,1000,xrga_cb_monitor_rga,NULL);
}

void
xrga_cb_rgamon_pb_act( Widget w, XtPointer client_data, XtPointer call_data)
{
 pid_t pid;
 
 xrga_dev_build_sgmon_config_file( "/tmp/rga.conf" );

 pid=fork();

 if(pid==0)
 {
   execlp("sgmon","sgmon","-config_file_name","rga.conf",
                          "-config_file_path","/tmp","-start",NULL);
   exit(0);
 }

 if(pid==-1)
 {
   xrga_gui_adderr_man("Unable to execute 'sgmon'");
   return;
 }

 
 xrga_gui_show_message("Starting sgmon.\nIt may take few seconds.If nothing\nhappens check that sgmon is\nproperly installed");
}

