/*static char RcsId[] = "$Header:$";*/

/*********************************************************************
 *
 * File:	Template_sub.c
 *
 * Project:	<PROJECT> 
 *
 * Description:	subprocess for the Template server.	
 *
 * Author(s);	<AUTHOR> 
 *
 * Original:	<DATE>	
 *
 * $Log:$
 * 
 * 
 * Copyright (c) 1992 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 * File generated by the Automatic Class Generation Tool, <REVISION>
 * (<GENERATIONDATE>).
 *
 *********************************************************************/

#include <Admin.h>
#include <errno.h>
#include <signal.h>
#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <DevServerP.h>
#include <TemplateP.h>
#include <Template.h>
#include <dataport.h>

/*
 * Needed to use Dataport
 *
 */

void	clean_exit();

Dataport	*dp_sub; /* Identifier of the shared memory of the subprocess */
Sharedstruct	*shared;

/************************************************************************
Function   :	main()

Description:	

Arg(s) In  :	unsigned	int	argc;
		char			**argv;

Arg(s) Out :
*************************************************************************/

main(argc, argv)
   unsigned        int     argc;
   char                    **argv;
{
   long		i;
   static	long	error;

/*
 * Install signal interception routine
 */   
#ifdef OSK
	intercept(clean_exit);
#else
	signal(SIGINT, clean_exit);
	signal(SIGKILL, clean_exit);
	signal(SIGHUP, clean_exit);
	signal(SIGTERM, clean_exit);
#endif /* OSK */
	
   printf("Subprocess is now up and running\n");

   	/* Initialize values in subprocess */
   
   printf("dataport %s \n", argv[1]);
   fflush(stdout);

   dp_sub	= OpenDataport(argv[1], sizeof(Sharedstruct));
   if(dp_sub == NULL)
   {
		printf("Template_sub: can't open dataport --> exit\n");
   	exit(0);
   }
   shared	= (Sharedstruct *)&(dp_sub->body);

   	/*------ Main Acquisition Loop -------*/

   for(;;)
   {

   	/*
   	 * Insert here your acquisition routines 
   	 */

   	sleep(2);
   	StoreResult();	/* Store result */
   } /* end infinite loop of acquisitions */

   /*------ End Infinite Loop  -------*/
}

/************************************************************************
Function   :	StoreResult()

Description:	This routine show how to store values in the dataport

Arg(s) In  :

Arg(s) Out :
*************************************************************************/

int	StoreResult()
{
   struct	timeval	sub_time;
   struct	timezone tzp;

   gettimeofday(&sub_time, &tzp);
   if(AccessDataport(dp_sub)==-1)
   {
		printf("Template_sub: can't access dataport --> exit\n");
   	exit(0);   	
   }
   shared->time = sub_time.tv_sec;

   /*
    * Insert here your code to fill the shared structure; 
    */

   shared->value++;

   if(ReleaseDataport(dp_sub)==-1)
   {
		printf("Template_sub: can't release dataport --> exit\n");
   	exit(0);
   }
}


void clean_exit(signum)
int	signum;
{
/*
 * Insert here your code for a clean exit
 */	
	printf("Template_sub receives the signal %d and died\n", signum);

}
