/*static char RcsId[] = "$Header: Template.c,v 1.1 96/03/15 02:32:25 fladmark Exp $";*/
/*********************************************************************
 *
 *File:		Template.c
 *
 *Project:	<PROJECT>
 *
 *Description:	<CLASSDESC>
 *
 *Author(s):	<AUTHOR>
 *
 *Original:	<DATE>
 *
 *$Log:	Template.c,v $
 * Revision 1.1  96/03/15  02:32:25  02:32:25  fladmark ()
 * Initial revision
 *  
 *
 *Copyright(c) 1994 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 *File generated by the Automatic Class Generation Tool, <REVISION>
 * (<GENERATIONDATE>)
 *
 *********************************************************************/
#include <signal.h>
#include <errno.h>
#include <strings.h>
#include <ctype.h>
#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <Admin.h>
#include <dataport.h>

#include <DevServerP.h>
#include <TemplateP.h>
#include <Template.h>

/*
 * Needed to use Dataport
 *
 */
char	*subprocname	= "Template_sub";
struct	timeval	time_now;
struct	timezone tzp;
extern char **_environ;
extern int os9forkc();
/*
 * public methods
 */

static	long	class_initialise();
static	long	object_create();
static	long	object_initialise();
static	long	object_destroy();
static	long	state_handler();

static	DevMethodListEntry methods_list[] = {
   {DevMethodClassInitialise,	class_initialise},
  	{DevMethodInitialise,		object_initialise},
  	{DevMethodCreate,				object_create},
  	{DevMethodDestroy,			object_destroy},
  	{DevMethodStateHandler,		state_handler},
   };


TemplateClassRec templateClassRec = {
   /* n_methods */        sizeof(methods_list)/sizeof(DevMethodListEntry),
   /* methods_list */     methods_list,
   };

TemplateClass templateClass = (TemplateClass)&templateClassRec;

/*
 * public commands
 */

<CMDDECLARATION>
static	long	dev_status();
static	long	dev_state();


static	DevCommandListEntry commands_list[] = {
CMDLIST
  	{<CMDNAME>, <CMDROUTINE>, <ARGINTYPE>, <ARGOUTTYPE>},
END
   {DevState,  dev_state,  D_VOID_TYPE, D_SHORT_TYPE},
   {DevStatus, dev_status, D_VOID_TYPE, D_STRING_TYPE}
};

static long n_commands = sizeof(commands_list)/sizeof(DevCommandListEntry);

/*
 * reserve space for a default copy of the template object
 */

static TemplateRec templateRec;
static Template template = (Template)&templateRec;

/*
 * Template resource tables used to access the static database
 *
 */

db_resource res_object[] = {
RES_OBJECT
   {"<RESNAME>",	<RESTYPE>, NULL},
END
   	};
int res_object_size = sizeof(res_object)/sizeof(db_resource);

db_resource res_class[] = {
   {"state",       D_LONG_TYPE, NULL},
RES_CLASS
   {"<RESNAME>",   <RESTYPE>, NULL},
END
   	};
int res_class_size = sizeof(res_class)/sizeof(db_resource);


/*======================================================================
 Function:      static long class_initialise()

 Description:	routine to be called the first time a device is 
		created which belongs to this class (or is a subclass
		thereof. This routine will be called only once.

 Arg(s) In:	none

 Arg(s) Out:	long *error - pointer to error code, in case routine fails
 =======================================================================*/
static long class_initialise(error)
long *error;
{


/*
 * TemplateClass is a subclass of the DevServerClass
 */

   templateClass->devserver_class.superclass = devServerClass;
   templateClass->devserver_class.class_name = (char*)malloc(sizeof("TemplateClass")+1);
   sprintf(templateClass->devserver_class.class_name,"TemplateClass");
   templateClass->devserver_class.class_inited = 1;
   templateClass->devserver_class.n_commands = n_commands;
   templateClass->devserver_class.commands_list = commands_list;

/*
 * initialise template with default values. these will be used
 * for every Template object created.
 */

   template->devserver.class_pointer = (DevServerClass)templateClass;

<CFINITIALISE>
   template->devserver.state = DEVON;

/*
 * Interrogate the static database for default values
 *
 */

   res_class[0].resource_adr	= &(template->devserver.n_state);
RESVALUECLASS
   res_class[<INDICE>].resource_adr	= &(templateClass->template_class.<OBJECTFIELDS>);
END

   if(db_getresource("CLASS/Template/DEFAULT", res_class, res_class_size, error))
   {
   	return(DS_NOTOK);
   }
   return(DS_OK);
}

/*======================================================================
 Function:      static long object_create()

 Description:	routine to be called on creation of a device object

 Arg(s) In:	char *name - name to be given to device

 Arg(s) Out:	DevServer *ds_ptr - pointer to created device
		long *error - pointer to error code, in case routine fails
 =======================================================================*/
static long object_create(name, ds_ptr, error)
char *name;
DevServer *ds_ptr;
long *error;
{
   Template ds;

   ds = (Template)malloc(sizeof(TemplateRec));

/*
 * initialise device with default object
 */

   *(TemplateRec*)ds = *(TemplateRec*)template;

/*
 * finally initialise the non-default values
 */

   ds->devserver.name = (char*)malloc(strlen(name)+1);
   sprintf(ds->devserver.name,"%s",name);

   *ds_ptr = (DevServer)ds;
   return(DS_OK);
}

/*============================================================================
Function:	static long object_initialise()

Description:	routine to be called on initialisation of a device object

Arg(s) In:	Template ds	- object to initialise

Arg(s) Out:
		long *error     - pointer to error code, in case routine fails
 ===========================================================================*/
static long object_initialise(ds, error)
Template ds;
long  *error;
{
   long	time_diff;
   char	*argblk[4];
   char *dev_namept, *dp_namept;
   Dataport *dp;
   Sharedstruct *shared;
   char dpname[10];
   short nbchar;
	unsigned short		pid;

<OFINITIALISE>

RESVALUEOBJECT
   res_object[<INDICE>].resource_adr        = &(ds->template.<OBJECTFIELDS>);
END
   
   if(db_getresource(ds->devserver.name, res_object, res_object_size, error))
   {
   	return(DS_NOTOK);
   }

/*
 * Now create the datataport and fork the sub-process.
 *****************************************************/
/*
 * build the name of the dataport starting from the device name.
 * the name is composed with the lasts alphanumerical characters of the device
 * name, followed by "_dp"
 */
   sprintf(dpname,"0123456_dp");
   dp_namept = &dpname[7];
   dev_namept=ds->devserver.name+strlen(ds->devserver.name); /* point on the last letter */
   nbchar=0;
   while(nbchar<7 || dev_namept==ds->devserver.name)
   {
      dev_namept--;
      if(isalnum(*dev_namept))
      {
         dp_namept--;
         nbchar++;
         *dp_namept=*dev_namept;
      }
   }
   strcpy(ds->template.dataport,dp_namept);
   printf("\t\tdataport %s ",ds->template.dataport);
/* 
 * If dataport exists, destroy it.
 **********************************
 */

   if((dp = OpenDataport(ds->template.dataport,sizeof(Sharedstruct))) != NULL)
   {
   	CloseDataport(dp, dpname);
      printf("already existed, destroyed ,");
		sleep(4); /* Let the sub-process the time to notice the absence of dataport
						 and to die */  
   }
/* 
 * create a new dataport
 **********************************
 */

   dp = CreateDataport(dpname, sizeof(Sharedstruct));
   if (dp==NULL)
   {
      printf("can't be created\n");
      return(DS_NOTOK);
   }
   shared = (Sharedstruct *)&(dp->body);
   if (AccessDataport(dp) == -1)
   {
   	printf("Can't access Dataport, errno = % d\n", errno);
   	*error = DevErr_CommandFailed;
   	return (DS_NOTOK);
   }	
/*
 * Initialize the shared values now 
 *
 */
   shared->time	= 0;
   shared->value 	= 0;
   shared->serverpid	= getpid();

/* Insert here the other initializations of the shared values */

   if (ReleaseDataport(dp) == -1)
   {
   	printf("Can't release Dataport, errno = % d\n", errno);
   	*error = DevErr_CommandFailed;
		return (DS_NOTOK);
   }
   ds->template.dp = dp;
   ds->template.shared = shared;

   printf("Forking subprocess \n");
   fflush(stdout);

   argblk[0] = subprocname;
   argblk[1] = ds->template.dataport;
   argblk[2] = 0;
   argblk[3] = 0;
   printf("%s %s \n",argblk[0],argblk[1]);
   
#ifdef NOFORK
   printf(" The sub process has not been forked and should be started by hand\n");
#else   
#ifdef (_UCC)

   if((pid = os9exec(os9forkc,	/* Function to use for creation		*/
   		argblk[0],	/* Program to create			*/
   		argblk,		/* program's arguments list		*/
   		_environ,	/* Pass servers environment variables	*/
   		0,		/* Additional memory			*/
   		0,		/* Use server's priority		*/
   		3)) == -1)	/* Pass server's path			*/
   {
   	*error  = DevErr_DeviceOpen;
   	return(DS_NOTOK);
   }

#else /* _UCC */

   pid = fork();
   if(pid == 0)
   {
   	execlp(argblk[0], argblk[0], argblk[1],NULL); 
   }
   else if(pid == -1)
   {
   	*error  = DevErr_DeviceOpen;
   	return(DS_NOTOK);   	
   }	
#endif /* _UCC */

   ds->template.dp = dp;
   ds->template.shared = shared;
	ds->template.pid = pid;

#endif /* NOFORK */
   return(DS_OK);
}

/*============================================================================
Function:	static long object_destroy()

Description:	routine to be called to destroy the a device object

Arg(s) In:	Template ds	- object to initialise

Arg(s) Out:
		long *error     - pointer to error code, in case routine fails
 ===========================================================================*/
static long object_destroy(ds, error)
Template ds;
long  *error;
{
/*
 * Kill the sub-process and free the shared memory (close the dataport)
 */
 
	kill(ds->template.pid,SIGQUIT);
	if (CloseDataport(ds->template.dp, ds->template.dataport) == -1)
	{
		printf("Can't close Dataport %s, errno = %d\n", ds->template.dataport, errno);
		*error = DevErr_CommandFailed;
		return (DS_NOTOK);
	}
	return (DS_OK);
}

/*======================================================================
 Function:      static long state_handler()

 Description:	this routine is reserved for checking wether the command
		requested can be executed in the present state.

 Arg(s) In:	Template ds - device on which command is to executed
		DevCommand cmd - command to be executed

 Arg(s) Out:	long *error - pointer to error code, in case routine fails
 =======================================================================*/
static long state_handler( ds, cmd, error)
Template ds;
DevCommand cmd;
long *error;
{
   long int p_state, n_state;
   long iret = DS_OK;
/*
 * Get here the real state of the physical device
 *
 *  example:
 *  ds->devserver.state=get_state();
 */

   p_state = ds->devserver.state;

/*
 * Before checking out the state machine assume that the state doesn't
 * change i.e. new state == old state
 *
 */

   n_state = p_state;

   switch (p_state)
   {
    
<STATEHANDLER>
   	default:
   		*error = DevErr_UnrecognisedState;
   		iret = DS_NOTOK;
   		break;
   }
   ds->devserver.n_state = n_state;

   return(iret);
}

COMMAND_HEADER
/*============================================================================
 Function:      static long <CMDROUTINE>()

 Description: <CMDDESC>
   	
 Arg(s) In:   Template 	ds - 
	      <argintype>  *argin  - <ARGINDESC>
   				  
 Arg(s) Out:  <argouttype> *argout - <ARGOUTDESC>
	      long	   *error  - pointer to error code, in case routine
				     fails. Error code(s) :
<errorslist>
 ============================================================================*/
static long  <CMDROUTINE>(ds, argin, argout, error)

Template 	ds;
<argintype> 	*argin;
<argouttype> 	*argout;
long 		*error;
{
#ifdef PRINT
   printf("Template, <CMDROUTINE>(), entered\n");
#endif /*PRINT*/

/*
 * Insert here the code of the command
 */

   ds->devserver.state = ds->devserver.n_state;
   return(DS_OK);
}

END
/*============================================================================
 Function:      static long dev_state()

 Description:	dummy routine to read state of template

 Arg(s) In:	 Template 	ds 	- 
		 DevVoid  	*argin  - none
   				  
 Arg(s) Out:	 DevShort	*argout - returned state 
		 long *error - 	pointer to error code, in case routine fails

============================================================================*/
static long dev_state(ds, argin, argout, error)

Template	ds;
DevVoid		*argin;
DevShort	*argout;
long		*error;
{
   *argout	= ds->devserver.state;
   return(DS_OK);
}

/*============================================================================
 Function:      static long dev_status()

 Description:	dummy routine to return state as an ASCII string

 Arg(s) In:	 Template 	ds 	- 
		 DevVoid  	*argin  - none
   				  
 Arg(s) Out:	 DevString	*argout - contains string 
============================================================================*/
static long dev_status(ds, argin, argout, error)

Template        ds;
DevVoid         *argin;
DevString	*argout;
long		*error;
{

   static	char	str[80];
   sprintf(str,"The device is :%s\n", DEVSTATES[ds->devserver.state]);
   *argout = str;
   return (DS_OK);
}

/*
 * Now, two examples of commmand to know how to read or set a 
 * value of the shared structure.
 *
 */

/*============================================================================
 Function:      static long dev_writevalue()

 Description:	dummy routine to set value in the shared structure 

 Arg(s) In:	 Template 	ds 	- 
		 DevLong  	*argin  - the new value for the "value" field 
   				  
 Arg(s) Out:	 DevVoid	*argout - None 
				error code : devErr_NoData
============================================================================*/
/******************************************************************************
static long dev_writevalue(ds, argin, argout, error)

Template        ds;
DevLong         *argin;
DevVoid		*argout;
long		*error;
{

   long	time_diff;
   Sharedstruct *shared;
   shared=ds->template.shared;
   gettimeofday(&time_now, &tzp);
   if (AccessDataport(dp) == -1)
   {
   	printf("Can't access Dataport, errno = % d\n", errno);
   	*error = DevErr_CommandFailed;
   	return (DS_NOTOK);
   }	
   shared->value = *argin;
   time_diff = time_now.tv_sec - shared->time;
   if (ReleaseDataport(dp) == -1)
   {
   	printf("Can't release Dataport, errno = % d\n", errno);
   	*error = DevErr_CommandFailed;
		return (DS_NOTOK);
   }
   if(time_diff > 4)
   {
   	*error = DevErr_NoData;
   	return(DS_NOTOK);
   }

   return (DS_OK);
}
*******************************************************************************/



/*============================================================================
 Function:      static long dev_readvalue()

 Description:	dummy routine to read the value of the "value" field 
		in the shared structure. It's just an example.

 Arg(s) In:	 Template 	ds 	- 
		 DevVoid  	*argin  - none
   				  
 Arg(s) Out:	 DevLong	*argout - contains the value
============================================================================*/
/****************************************************************************
static long dev_readvalue(ds, argin, argout, error)

Template        ds;
DevVoid         *argin;
DevLong		*argout;
long		*error;
{

   long	time_diff;
   Sharedstruct *shared;
   shared = ds->template.shared;

   gettimeofday(&time_now, &tzp);
   if (AccessDataport(dp) == -1)
   {
   	printf("Can't access Dataport, errno = % d\n", errno);
   	*error = DevErr_CommandFailed;
   	return (DS_NOTOK);
   }	
   *argout = shared->value;
   time_diff = time_now.tv_sec - shared->time;
   if (ReleaseDataport(dp) == -1)
   {
   	printf("Can't release Dataport, errno = % d\n", errno);
   	*error = DevErr_CommandFailed;
		return (DS_NOTOK);
   }
   if(time_diff > 4)
   {
   	*error = DevErr_NoData;
   	return(DS_NOTOK);
   }
   return (DS_OK);
}
*****************************************************************************/
