/*static char RcsId[] = "$Header: Template.c,v 1.5 96/12/18 09:43:01 fladmark Exp $";*/
/*********************************************************************
 *
 *File:		Template.c
 *
 *Project:	<PROJECT>
 *
 *Description:	<CLASSDESC>
 *
 *Author(s):	<AUTHOR>
 *
 *Original:	<DATE>
 *
 *$Log:	Template.c,v $
 * Revision 1.5  96/12/18  09:43:01  09:43:01  fladmark (I.Fladmark)
 * *** empty log message ***
 * 
 * Revision 1.3  96/03/15  02:30:22  02:30:22  fladmark ()
 * Updated with prototyping.
 * 
 *
 *Copyright(c) 1994 by European Synchrotron Radiation Facility, 
 *                     Grenoble, France
 *
 *File generated by the Automatic Class Generation Tool, <REVISION>
 * (<GENERATIONDATE>)
 *
 *********************************************************************/

#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <Admin.h>

#include <DevServerP.h>
#include <TemplateP.h>
#include <Template.h>

/*
 * public methods
 */

static long class_initialise(long *error);
static long object_create(char *name,DevServer *ds_ptr,long *error);
static long object_initialise(Template ds,long *error);
static long state_handler(Template ds,DevCommand cmd,long *error);

static	DevMethodListEntry methods_list[] = {
   	{DevMethodClassInitialise,	class_initialise},
   	{DevMethodInitialise,		object_initialise},
  	{DevMethodCreate,		object_create},
   	{DevMethodStateHandler,		state_handler},
   };


TemplateClassRec templateClassRec = {
   /* n_methods */        sizeof(methods_list)/sizeof(DevMethodListEntry),
   /* methods_list */     methods_list,
   };

TemplateClass templateClass = (TemplateClass)&templateClassRec;

/*
 * public commands
 */

<CMDDECLARATION>
static long dev_status(Template ds,DevVoid * argin,DevString *argout,long *error);
static long dev_state(Template ds,DevVoid *argin,DevShort *argout,long *error);


static	DevCommandListEntry commands_list[] = {
CMDLIST
   	{<CMDNAME>, <CMDROUTINE>, <ARGINTYPE>, <ARGOUTTYPE>},
END
   	{DevState, dev_state, D_VOID_TYPE, D_SHORT_TYPE},
   	{DevStatus, dev_status, D_VOID_TYPE, D_STRING_TYPE}
};

static long n_commands = sizeof(commands_list)/sizeof(DevCommandListEntry);

/*
 * reserve space for a default copy of the template object
 */

static TemplateRec templateRec;
static Template template = (Template)&templateRec;

/*
 * Template resource tables used to access the static database
 *
 */

db_resource res_object[] = {
RES_OBJECT
   {"<RESNAME>",	<RESTYPE>, NULL},
END
   	};
int res_object_size = sizeof(res_object)/sizeof(db_resource);


db_resource res_class[] = {
   {"state",       D_LONG_TYPE, NULL},
RES_CLASS
   {"<RESNAME>",   <RESTYPE>, NULL},
END
   	};
int res_class_size = sizeof(res_class)/sizeof(db_resource);


/*======================================================================
 Function:      static long class_initialise()

 Description:	routine to be called the first time a device is 
 		created which belongs to this class (or is a subclass
		thereof. This routine will be called only once.

 Arg(s) In:	none

 Arg(s) Out:	long *error - pointer to error code, in case routine fails
 =======================================================================*/

static long class_initialise(long *error)
{

/*
 * TemplateClass is a subclass of the DevServerClass
 */

   templateClass->devserver_class.superclass = devServerClass;
   templateClass->devserver_class.class_name = (char*)malloc(sizeof("TemplateClass")+1);
   sprintf(templateClass->devserver_class.class_name,"TemplateClass");
   templateClass->devserver_class.class_inited = 1;
   templateClass->devserver_class.n_commands = n_commands;
   templateClass->devserver_class.commands_list = commands_list;

/*
 * initialise template with default values. these will be used
 * for every Template object created.
 */

   template->devserver.class_pointer = (DevServerClass)templateClass;

<CFINITIALISE>
   template->devserver.state = DEVON;

/*
 * Interrogate the static database for default values
 *
 */

   res_class[0].resource_adr	= &(template->devserver.n_state);
RESVALUECLASS
   res_class[<INDICE>].resource_adr	= &(templateClass->template_class.<OBJECTFIELDS>);
END

   if(db_getresource("CLASS/Template/DEFAULT", res_class, res_class_size, error))
   {
      return(DS_NOTOK);
   }

   return(DS_OK);
}

/*======================================================================
 Function:	static long object_create()

 Description:	routine to be called on creation of a device object

 Arg(s) In:	char *name - name to be given to device

 Arg(s) Out:	DevServer *ds_ptr - pointer to created device
		long *error - pointer to error code, in case routine fails
 =======================================================================*/

static long object_create(char *name,DevServer *ds_ptr,long *error)
{
   Template ds;

   ds = (Template)malloc(sizeof(TemplateRec));

/*
 * initialise device with default object
 */

   *(TemplateRec*)ds = *(TemplateRec*)template;

/*
 * finally initialise the non-default values
 */

   ds->devserver.name = (char*)malloc(strlen(name)+1);
   sprintf(ds->devserver.name,"%s",name);

   *ds_ptr = (DevServer)ds;

   return(DS_OK);
}

/*============================================================================

Function:	static long object_initialise()

Description:	routine to be called on initialisation of a device object

Arg(s) In:	Template ds	- object to initialise

Arg(s) Out:

		long *error     - pointer to error code, in case routine fails
=============================================================================*/
static long object_initialise(Template ds,long *error)
{

<OFINITIALISE>

RESVALUEOBJECT
   res_object[<INDICE>].resource_adr        = &(ds->template.<OBJECTFIELDS>);
END
   
   if(db_getresource(ds->devserver.name, res_object, res_object_size, error))
   {
   	return(DS_NOTOK);
   }
   return(DS_OK);
}

/*======================================================================
 Function:      static long state_handler()

 Description:	this routine is reserved for checking wether the command
		requested can be executed in the present state.

 Arg(s) In:	Template ds - device on which command is to executed
		DevCommand cmd - command to be executed

 Arg(s) Out:	long *error - pointer to error code, in case routine fails
 =======================================================================*/

static long state_handler(Template ds,DevCommand cmd,long *error)
{
   long int p_state, n_state;
   long iret = DS_OK;
/*
 * Get here the real state of the physical device
 *
 *  example:
 *  ds->devserver.state=get_state();
 */
   p_state = ds->devserver.state;

/*
 * Before checking out the state machine assume that the state doesn't
 * change i.e. new state == old state
 *
 */

   n_state = p_state;

   switch (p_state)
   {
    
<STATEHANDLER>
   	default:
   		*error = DevErr_UnrecognisedState;
   		iret = DS_NOTOK;
   		break;
   }
   ds->devserver.n_state = n_state;

   return(iret);
}

COMMAND_HEADER
/*============================================================================
 Function:      static long <CMDROUTINE>()

 Description:	 <CMDDESC>
   	
 Arg(s) In:	 Template 	ds 	- 
		 <argintype>  	*argin  - <ARGINDESC>
   				  
 Arg(s) Out:	 <argouttype>	*argout - <ARGOUTDESC>
		 long		*error	- pointer to error code, in case
		 			routine fails. Error code(s):
<errorslist>
 ============================================================================*/

static long  <CMDROUTINE>(Template ds,<argintype> *argin,<argouttype> *argout,long *error)
{

#ifdef PRINT
   printf("Template, <CMDROUTINE>(), entered\n");
#endif /*PRINT*/

/*
 *
 * Insert here the code of the command
 *
 */

   ds->devserver.state =  ds->devserver.n_state;        
   return(DS_OK);
}

END
/*============================================================================
 Function:      static long dev_state()

 Description:	return the state of the device

 Arg(s) In:	 Template 	ds 	- 
		 DevVoid  	*argin  - none
   				  
 Arg(s) Out:	 DevShort	*argout - returned state 
		 long *error - 	pointer to error code, in case routine fails

============================================================================*/

static long dev_state(Template ds,DevVoid *argin,DevShort *argout,long *error)
{
   *argout	= ds->devserver.state;
   return(DS_OK);
}

/*============================================================================
 Function:      static long dev_status()

 Description:	return state of the device as an ASCII string

 Arg(s) In:	 Template 	ds 	- 
		 DevVoid  	*argin  - none
   				  
 Arg(s) Out:	 DevString	*argout - contains string 
============================================================================*/

static long dev_status(Template ds,DevVoid * argin,DevString *argout,long *error)
{
   static	char	str[80];

   sprintf(str,"The device is :%s\n", DEVSTATES[ds->devserver.state]);
   *argout = str;
   return (DS_OK);
}

