#
# RcsID = " $Header$ ";
#
#*********************************************************************
#
# File:          Makefile 
#
# Project:       <PROJECT>
#
# Description:   GNU Makefile for Template device server
#
# Author(s):     <AUTHOR>
#
# Original:   	<DATE>
#
# $Log$
#
# Copyright (c) 1996 by European Synchrotron Radiation Facility,
#                       Grenoble, France
#
#**********************************************************************
#       GNU Makefile Generated by the Automatic Class Generation Tool, <REVISION>
#                                       <GENERATIONDATE>.
#

#---------------------------------------------------------------------
#	This Makefile works with the GNU make (sometimes called gmake)
#	It makes use of the GNU make conditional statements to support
#	multiple platforms. To use this makefile for a particular platform
#	call GNU make with the appropriate symbol for that platform
#	defined e.g. "gmake __hp9000s700=1 unix=1 all". The following symbols
#	are used to identify the following platforms :
#
#	__hp9000s700	=	HPUX 9000 series 700 
#	_solaris	=	Solaris 
#	sun		=	SunOS
#	_UCC		=	OS9 Fastrak Ultra-C Compiler
#	unix		=	various unix flavours (Solaris, HPUX, Lynx, Linux)
#	lynx		=	LynxOS
#	
#--------------------------------------------------------------------
#
#       The variables DSHOME is passed to the Makefile
#       as input argument or via the environment.
#
#	For UltraC use the settings for the environment variables:
#	MWOS	 =	/usr/local/MWOS 
#   	PATH     =	$PATH:$MWOS/UNIX/bin/hp97k 
#   	CDEF 	 =	$MWOS/OS9/SRC/DEFS 
#   	CDEFESRF =	/usr/local/os9/dd/DEFS 
#   	CLIB 	 =	$MWOS/OS9/LIB 
#   	CLIBESRF =	/usr/local/os9/dd/LIB 
#
#--------------------------------------------------------------------
#
ifdef _UCC
LIB_HOME     =  $(DSHOME)/lib/os9/ucc
OBJS_HOME    =  $(DSHOME)/lib/os9/ucc/objs
INSTALL_HOME =  $(DSHOME)/bin/os9/ucc
endif
ifdef lynx
LIB_HOME     =  $(DSHOME)/lib/lynxos
INSTALL_HOME =  $(DSHOME)/bin/lynxos
endif
ifdef __hp9000s700
LIB_HOME     =  $(DSHOME)/lib/s700
INSTALL_HOME =  $(DSHOME)/bin/s700
endif
ifdef sun
LIB_HOME     =  $(DSHOME)/lib/sun4
INSTALL_HOME =  $(DSHOME)/bin/sun4
endif
ifdef _solaris
LIB_HOME     =  $(DSHOME)/lib/solaris
INSTALL_HOME =  $(DSHOME)/bin/solaris
endif


#---------------------------------------------------------------------
# All include file and standard library pathes
#
#		make sure to get always the new include files 
#		under ../include
#

INCLDIRS =  	-I ../include \
		-I $(DSHOME)/include \
		-I $(DSHOME)/include/private

#---------------------------------------------------------------------
# All necessary compiler flags for UNIX and OS9
#
ifdef _UCC
#               The C Compiler for OS9
CC =       	/usr/local/MWOS/UNIX/bin/hp97k/xcc

#                	Libraries
LIBDIRS =       -L $(LIB_HOME) -L $(CLIB)

LFLAGS =   	$(LIBDIRS) \
		-l dsclass \
		-l dsapi \
		-l dsxdr \
		-l dbapi \
		-l dcapi \
		-l rpclib.l \
		-l netdb_small.l \
		-l socklib.l \
		-l sys_clib.l \
		-l unix.l

ICODE_LFLAGS = 	$(LIBDIRS) \
                -Wi,-l=$(LIB_HOME)/libdsapi.il \
                -Wi,-l=$(LIB_HOME)/libdsxdr.il \
                -Wi,-l=$(LIB_HOME)/libdbapi.il \
                -Wi,-l=$(LIB_HOME)/libdcapi.il \
                -l dsapi \
                -l rpclib.l \
                -l netdb.l \
                -l socklib.l \
                -l sys_clib.l

#              	Compiler Flags with ANSI standart for OS9
CFLAGS =       	-mode=c89 -i -to osk -tp 020 $(INCLDIRS)
ICODE_CFLAGS =  -mode=c89 -i -j -O 7 -to osk -tp 020 $(INCLDIRS)
NAME =       	-o $@
endif

ifdef unix
#               The C Compilers for UNIX
ifdef sun
CC      =       /usr/lang/acc
endif
ifdef _solaris
CC      =       /opt/SUNWspro/SC4.0/bin/cc
endif
ifdef lynx
CC      =       gcc
endif
ifdef __hpux
CC      =       /bin/cc
endif

#                       Libraries
LIBDIRS =       -L $(LIB_HOME)
ifdef _solaris
LFLAGS = 	$(LIBDIRS) -ldsclass -ldsapi -ldbapi -ldsxdr -ldcapi -lnsl -lsocket
else
LFLAGS = 	$(LIBDIRS) -ldsclass -ldsapi -ldbapi -ldsxdr -ldcapi -lm
endif

NAME =       	-o 
endif

#            	Compiler flags with ANSI standart for UNIX
ifdef __hpux
CFLAGS = 	-Aa -D_HPUX_SOURCE $(INCLDIRS)
endif
ifdef sun
CFLAGS = 	-Aa $(INCLDIRS)
endif
ifdef _solaris
CFLAGS  =       -Xa $(INCLDIRS)
endif
ifdef lynx
CFLAGS  =       -ansi -Dlynx -Dunix -X $(INCLDIRS)
endif


#---------------------------------------------------------------------
# RCS options to lock and check out a version.
# Or to check in a new version.
#
#               RCS lock options
RCSLOCK =      	co -l -r$(VERSION)
#               RCS check out options
RCSCO   =      	co -r$(VERSION)
#               RCS check in options
RCSCI   =      	ci -u -f -s"Rel" -r$(VERSION) -m"$(LOCKMSG)"

#---------------------------------------------------------------------
# Class library
# The object file representing the class has
# to be added to the class library.
#
CLASS_LIB  = libdsclass.a
CLASS_OBJS = Template.o

#
#---------------------------------------------------------------------
# All Files needed for the Server and the client
#
#               all include files
INCL     =	TemplateP.h \
		Template.h

#               source files
SRC	 =	Template.c \
		startup.c \
		template_menu.c 

#               object files
SVC_OBJS =	Template.o \
		startup.o

SVC_ICODE =	Template.ic \
		startup.ic

CLN_OBJS =	template_menu.o 

#---------------------------------------------------------------------
# What has to be made
#
#		Names of executables in the home directory
SERVER	 = 	Templateds 
CLIENT	 = 	template_menu	

#		Names of executables 
#		and include files in the installation directories
SVC_INST   = 	$(SERVER)
CLN_INST   = 	$(CLIENT)
INCL_INST  =	Template.h
INCLP_INST = 	TemplateP.h


#---------------------------------------------------------------------
# build server and client
#

ifdef _UCC
#               Rule for making OS-9 relocatable files
.SUFFIXES: .ic .o .c
.c.ic:
		$(CC) $(CFLAGS) -efe $<
.c.o:
		$(CC) $(CFLAGS) -c $<
	
	
all:		$(SERVER) $(CLIENT)

$(SERVER):  	$(SVC_OBJS)
		$(CC) $(CFLAGS) $(NAME) $(SVC_OBJS) $(LFLAGS)

$(CLIENT):  	$(CLN_OBJS)
		$(CC) $(CFLAGS) $(NAME) $(CLN_OBJS) $(LFLAGS)

icode:		$(SVC_ICODE)
		echo Linking with icode libraries!
		$(CC) $(ICODE_CFLAGS) -o $(SERVER) $(SVC_ICODE) $(ICODE_LFLAGS)
endif


ifdef unix
all:		$(SERVER) $(CLIENT) 

$(SERVER):  	$(SVC_OBJS) 
		$(CC) $(CFLAGS) $(NAME) $@ $(SVC_OBJS) $(LFLAGS)
$(CLIENT):  	$(CLN_OBJS) 
		$(CC) $(CFLAGS) $(NAME) $@ $(CLN_OBJS) $(LFLAGS)
endif


# 		Add object file representing the class
#		to the class library.
#
$(CLASS_LIB):	$(CLASS_OBJS) 
ifdef _UCC
#		For os9 all object files are kept are
#		kept in a special directory, because
#		the library has to be built by a cat
#		of all object files.
#
		cp $(CLASS_OBJS) $(OBJS_HOME)
		libgen -c $(OBJS_HOME)/?*.o -o=$(OBJS_HOME)/$(CLASS_LIB)
		cp $(OBJS_HOME)/$(CLASS_LIB) $(LIB_HOME)
		rm -rf $(OBJS_HOME)/$(CLASS_LIB)
endif
ifdef unix
		ar rv $(LIB_HOME)/$(CLASS_LIB) $(CLASS_OBJS)
endif


#
# 		install executables		
#
ifdef _UCC
install:	$(SERVER) $(CLIENT) $(CLASS_LIB)
		cp $(SERVER) $(INSTALL_HOME)/$(SVC_INST)
		cp $(CLIENT) $(INSTALL_HOME)/$(CLN_INST)
endif
ifdef unix
install:	$(SERVER) $(CLIENT)
		cp $(SERVER) $(INSTALL_HOME)/$(SVC_INST)
		cp $(CLIENT) $(INSTALL_HOME)/$(CLN_INST)
endif
#
#		install include files
#
		rm -f $(DSHOME)/include/$(INCL_INST)
		cp ../include/$(INCL_INST) $(DSHOME)/include
		chmod 664 $(DSHOME)/include/$(INCL_INST)
		rm -f $(DSHOME)/include/private/$(INCLP_INST)
		cp ../include/$(INCLP_INST) $(DSHOME)/include/private
		chmod 664 $(DSHOME)/include/private/$(INCLP_INST)


clean:	
		-rm -f $(SVC_OBJS) 
		-rm -f $(CLN_OBJS) 
		-rm -f $(SVC_ICODE)
		-rm -f *.i


clobber:	clean
		-rm -f $(SERVER) 
		-rm -f $(CLIENT) 


lock:
		$(RCSLOCK) $(SRC)
		cd ../include; $(RCSLOCK) $(INCL); cd ../src

co:
		$(RCSCO) $(SRC)
		cd ../include; $(RCSCO) $(INCL); cd ../src

ci:
		$(RCSCI) $(SRC)
		cd ../include; $(RCSCI) $(INCL); cd ../src
