#
# RcsID = " $Header$ ";
#
#*********************************************************************
#
# File:          Makefile 
#
# Project:       <PROJECT>
#
# Description:   Makefile for Template device server
#
# Author(s):     <AUTHOR>
#
# Original:   	<DATE>
#
# $Log$
#
# Copyright (c) 1990 by European Synchrotron Radiation Facility,
#                       Grenoble, France
#
#**********************************************************************
#       Makefile Generated by the Automatic Class Generation Tool, <REVISION>
#                                       <GENERATIONDATE>.
#

#---------------------------------------------------------------------
#	You have to pass the name of the executable t uxmake or uccmake.
#	Ex.	uxmake DevServer
#	or 	uccmake DevServer
#	
#	this Makefile works for unix and os9 device servers.
#--------------------------------------------------------------------
#
#       The variables DSHOME is passed to the Makefile
#       as input argument or via the environment.
#
#	For UltraC use the settings for the environment variables:
#	MWOS	 =	/usr/local/MWOS 
#   	PATH     =	$PATH:$MWOS/UNIX/bin/hp97k 
#   	CDEF 	 =	$MWOS/OS9/SRC/DEFS 
#   	CDEFESRF =	/usr/local/os9/dd/DEFS 
#   	CLIB 	 =	$MWOS/OS9/LIB 
#   	CLIBESRF =	/usr/local/os9/dd/LIB 
#
#
# Home Directories
#

#if defined (_UCC)
LIB_HOME     =  $(DSHOME)/lib/os9/ucc
OBJS_HOME    =  $(DSHOME)/lib/os9/ucc/objs
INSTALL_HOME =  $(DSHOME)/bin/os9/ucc
ESRF_LIB     =  /usr/local/os9/dd/LIB
#endif
#if defined (lynx)
LIB_HOME     =  $(DSHOME)/lib/lynxos
INSTALL_HOME =  $(DSHOME)/bin/lynxos
#endif
#if defined (__hp9000s300)
LIB_HOME     =  $(DSHOME)/lib/s300
INSTALL_HOME =  $(DSHOME)/bin/s300
#endif
#if defined (__hp9000s700)
LIB_HOME     =  $(DSHOME)/lib/s700
INSTALL_HOME =  $(DSHOME)/bin/s700
#endif
#if defined (__hp9000s800)
LIB_HOME     =  $(DSHOME)/lib/s800
INSTALL_HOME =  $(DSHOME)/bin/s800
#endif
#if defined (sun)
LIB_HOME     =  $(DSHOME)/lib/sun4
INSTALL_HOME =  $(DSHOME)/bin/sun4
#endif
#if defined (solaris2)
LIB_HOME     =  $(DSHOME)/lib/solaris2
INSTALL_HOME =  $(DSHOME)/bin/solaris2
#endif


#---------------------------------------------------------------------
# All include file and standard library pathes
#
#		make sure to get always the new include files 
#		under ../include
#

INCLDIRS =  	-I ../include \
		-I ../../include \
		-I $(DSHOME)/include \
		-I $(DSHOME)/include/private

#---------------------------------------------------------------------
# All necessary compiler flags for UNIX and OS9
#
#if defined (_UCC)
#               The C Compiler for OS9
CC =       	/usr/local/MWOS/UNIX/bin/hp97k/xcc

#                	Libraries
LIBDIRS =       -L $(LIB_HOME) -L $(CLIB)

LFLAGS =   	$(LIBDIRS) \
		-l dsapi \
		-l dsxdr \
		-l dbapi \
		-l csutil \
		-l rpclib.l \
		-l netdb.l \
		-l socklib.l \
		-l sys_clib020.l

ICODE_LFLAGS = 	$(LIBDIRS) \
                -Wi,-l=$(LIB_HOME)/libdsapi.il \
                -Wi,-l=$(LIB_HOME)/libdsxdr.il \
                -Wi,-l=$(LIB_HOME)/libdbapi.il \
                -l dsapi \
                -l csutil \
                -l rpclib.l \
                -l netdb.l \
                -l socklib.l \
                -l sys_clib.l

#               	Compiler Flags
CFLAGS =       	-mode=c89 -i -to osk -tp 020 $(INCLDIRS)
NAME =       	-o $@
#endif

#if defined (unix)
#               The C Compiler for HPUX
CC =       	/bin/cc
#if defined (lynx)
CC      =       gcc
#endif

#                       Libraries
LIBDIRS =       -L $(LIB_HOME)
LFLAGS = 	$(LIBDIRS) -ldsapi -ldbapi -ldsxdr

NAME =       	-o 
#endif

#            		Optimizer and ANSI standart for UNIX
#if defined (__hpux)
CFLAGS = 	-O -Aa -DOPERATOR -D_HPUX_SOURCE $(INCLDIRS)
#endif
#if defined (sun)
CFLAGS = 	-O $(INCLDIRS)
#endif
#if defined (lynx)
CFLAGS  =       -Dlynx -Dunix -ansi -X $(INCLDIRS)
#endif


#---------------------------------------------------------------------
# RCS options to lock and check out a version.
# Or to check in a new version.
#
#               RCS lock options
RCSLOCK =      	co -l -r$(VERSION)
#               RCS check out options
RCSCO   =      	co -r$(VERSION)
#               RCS check in options
RCSCI   =      	ci -u -f -s"Rel" -r$(VERSION) -m"$(LOCKMSG)"

#---------------------------------------------------------------------
# Class library
# The object file representing the class has
# to be added to the class library.
#
CLASS_LIB = libdsclass.a
CLASS_OBJS = Template.o

#
#---------------------------------------------------------------------
# All Files needed for the Server and the client
#
#               all include files
INCL     =	TemplateP.h \
		Template.h

#               source files
SRC	 =	Template.c \
		startup.c \
		pg_menu.c 

#               object files
SVC_OBJS =	Template.o \
		startup.o 

SVC_ICODE =	Template.i \
		startup.i 

CLN_OBJS =	Template_menu.o 

#---------------------------------------------------------------------
# What has to be made
#
#		Names of executables in the home directory
SERVER	 = 	Template 
CLIENT	 = 	Template_menu	

#		Names of executables 
#		and include files in the installation directories
SVC_INST   = 	$(SERVER)
CLN_INST   = 	$(CLIENT)
INCL_INST  =	Template.h
INCLP_INST = 	TemplateP.h


#---------------------------------------------------------------------
# build server and client
#

#if defined (_UCC)
#               Rule for making OS-9 relocatable files
.SUFFIXES: .i .c
.c.i:
	
	
$(SERVER):  	$(SVC_OBJS)
		$(CC) $(CFLAGS) $(NAME) $(SVC_OBJS) $(LFLAGS)

$(CLIENT):  	$(CLN_OBJS)
		$(CC) $(CFLAGS) $(NAME) $(CLN_OBJS) $(LFLAGS)

icode:		$(SVC_ICODE)
		echo Linking Template with icode libraries!
		$(CC) $(CFLAGS) -o $(SERVER) $(SVC_ICODE) $(ICODE_LFLAGS)

$(SVC_ICODE):
		$(CC) $(CFLAGS) -P $? -o $@
#endif


#if defined (unix)
$(SERVER):  	$(SVC_OBJS)
		$(CC) $(CFLAGS) $(NAME) $@ $(SVC_OBJS) $(LFLAGS)
$(CLIENT):  	$(CLN_OBJS) 
		$(CC) $(CFLAGS) $(NAME) $@ $(CLN_OBJS) $(LFLAGS)
#endif


# 		Add object file representing the class
#		to the class library.
#
$(CLASS_LIB):	$(CLASS_OBJS) 
#if defined (_UCC)
#		For os9 all object files are kept are
#		kept in a special directory, because
#		the library has to be built by a cat
#		of all object files.
#
		cp $(CLASS_OBJS) $(OBJS_HOME)
		libgen -c $(OBJS_HOME)/?*.o -o=$(OBJS_HOME)/$(CLASS_LIB)
		cp $(OBJS_HOME)/$(CLASS_LIB) $(LIB_HOME)
		rm -rf $(OBJS_HOME)/$(CLASS_LIB)
#endif
#if defined (unix)
		ar rv $(LIB_HOME)/$(CLASS_LIB) $(CLASS_OBJS)
#endif


#
# 		install executables		
#
#if defined (_UCC)
install:	$(SERVER) $(CLIENT) $(CLASS_LIB)
		cp $(SERVER) $(INSTALL_HOME)/$(SVC_INST)
		cp $(CLIENT) $(INSTALL_HOME)/$(CLN_INST)
#endif
#if defined (unix)
install:	$(SERVER) $(CLIENT) $(CLASS_LIB)
		cp $(SERVER) $(INSTALL_HOME)/$(SVC_INST)
		cp $(CLIENT) $(INSTALL_HOME)/$(CLN_INST)
#endif
#
#		install include files
#
		rm -f $(DSHOME)/include/$(INCL_INST)
		cp ../include/$(INCL_INST) $(DSHOME)/include
		chmod 664 $(DSHOME)/include/$(INCL_INST)
		rm -f $(DSHOME)/include/private/$(INCLP_INST)
		cp ../include/$(INCLP_INST) $(DSHOME)/include/private
		chmod 664 $(DSHOME)/include/private/$(INCLP_INST)


clean:	
		-rm -f $(SVC_OBJS) 
		-rm -f $(CLN_OBJS) 
		-rm -f $(SVC_ICODE)
		-rm -f *.ic


clobber:	clean
		-rm -f $(SERVER) 
		-rm -f $(CLIENT) 


lock:
		$(RCSLOCK) $(SRC)
		cd ../include; $(RCSLOCK) $(INCL); cd ../src

co:
		$(RCSCO) $(SRC)
		cd ../include; $(RCSCO) $(INCL); cd ../src

ci:
		$(RCSCI) $(SRC)
		cd ../include; $(RCSCI) $(INCL); cd ../src
#
#

