// video_synopsis.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "video_synopsis.h"
#include <ddraw.h>
#include "graphics.h"
#include "gui.h"
#include "gif.h"
#include "dev.h"
#include "anim.h"
#include "ftp.h"
#include "Log.h"
#include <Excpt.h>
#include <io.h>

// From dev.cpp
extern char ftp_user[];
extern char ftp_pass[];
extern char ftp_site[];
extern char ftp_path[];

extern char ftp2_user[];
extern char ftp2_pass[];
extern char ftp2_site[];
extern char ftp2_path[];


HWND hwnd;
long    AppActive = 0;
long    err = DD_OK;    // error code of gui module
int     pause=0;

PIXEL   *shutdown_img[50];
int      nb_shutdown_img;


extern char *GetDDErrorMsg(int code);

//**************************************************************
// This function is called if the initialization function fails
//**************************************************************
BOOL initFail(char *errmsg)
{

    MessageBox( hwnd,errmsg, "VIDEO SYNOPSIS" , MB_OK | MB_ICONERROR | MB_SYSTEMMODAL);
    return FALSE;
} /* initFail */

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ************************************
// Message management procedure
// ************************************
long FAR PASCAL WindowProc( HWND hWnd, UINT message, 
                            WPARAM wParam, LPARAM lParam )
{
	_startdbgProc("WindowProc");
    switch( message )
    {
    case WM_ACTIVATEAPP:
        AppActive = 1;
        break;

    case WM_SETCURSOR:
        SetCursor(NULL);
        _enddbgProc();
        return TRUE;

    case WM_CREATE:
        break;

    case WM_KEYDOWN:
        switch( wParam )
        {
        case VK_ESCAPE:
        case VK_F12:
			lpDD->Release();
            PostMessage(hWnd, WM_CLOSE, 0, 0);
            break;
        case VK_F1:
  		  pause=!pause;
          break;
        }
        break;

    case WM_DESTROY:
        PostQuitMessage( 0 );
        break;
    }

    _enddbgProc();
    return DefWindowProc(hWnd, message, wParam, lParam);

} /* WindowProc */

//**************************************************
//  Save image on FTP serveur
// mode=0 : Normal mode
// mode=1 : Shutdown mode
//**************************************************
void SaveImages(int mode) {

	int ok=0;
	int greyscale=(mode==1)?2:0;

    //Save high part
    ok=SaveGifFromRGB(lpDDSBack, 0,0,800,300,   400,150, "img1.gif",1,3,greyscale);
    if(!ok) Log(GifErrorMessage,0);
    if(ok)  SaveByFtp( "img1.gif" , ftp_site , ftp_user , ftp_pass , ftp_path );
    remove("img1.gif");

    ok=SaveGifFromRGB(lpDDSBack, 0,0,804,304,   140,56, "img1small.gif",4,3,greyscale);
    if(!ok) Log(GifErrorMessage,0);
    if(ok)  SaveByFtp( "img1small.gif" , ftp_site , ftp_user , ftp_pass , ftp_path );
    remove("img1small.gif");

    ok=SaveGifFromRGB(lpDDSBack, 0,300,800,300, 400,150,"img2.gif",1,3,greyscale);
    if( !ok ) Log(GifErrorMessage,0);
    if(ok) SaveByFtp( "img2.gif" , ftp_site , ftp_user , ftp_pass , ftp_path);
    remove("img2.gif");

    if(mode) ok=SaveGifFromRGB(lpDDSBack   , 0,300,800,300, 400,150,"img3.gif",1,3,greyscale);
	else     ok=SaveGifFromRGB(lpDDSPrimary, 0,300,800,300, 400,150,"img3.gif",1,3,greyscale);

    if( !ok ) Log(GifErrorMessage,0);
    if(ok) SaveByFtp( "img3.gif" , ftp_site , ftp_user , ftp_pass , ftp_path);
    remove("img3.gif");

}

//**************************************************
// UpdateGui :  Routine called every 2 second
//**************************************************
void UpdateGui()
{
  _startdbgProc("UpdateGui");
  static int count=0;
  static int first_call=1;
  static int mode=0;
  static DWORD t1;
  static DWORD ti_start=0;
  static int fExtra=0;
  static int fShutdown=0;
  static int inShutdown=0;
  static int x_msg;
  static int y_msg;

  static EXTRA_INFO ei;
  static int extra;
  static int mCount;
  static PIXEL *nImage=NULL;

  DWORD    t2;
  int      switch_now;
  int	   sr_mode;

  if(AppActive) {

	//*************************************
	// Initialise drawing at the first call
	//*************************************
	if( first_call )
	{
		mode=0;
		count=0;
		err=DD_OK;
		t1=GetTickCount();
		gui_restore();
		EK(err) err=gui_init_draw();
		first_call=0;
		ei.nb_image=0;
		extra=0;
        x_msg = rand() % 370;
        y_msg = rand() % 420;
	}

	dev_get_sr_mode(&sr_mode);

	if( sr_mode==3 && nb_shutdown_img>0 ) {

	  //-------------------------------------
	  // Shutdown mode
	  //-------------------------------------
	  if(!inShutdown ) {
	    mode=0;
		fShutdown=0;
		extra=0;
	    nImage = shutdown_img[0];
        x_msg = rand() % 370;
        y_msg = rand() % 420;
		mCount = 3;
	    inShutdown=1;
	  }

  	  EK(err) err=gui_draw_shutdown(lpDDSBack,nImage,x_msg,y_msg);
	  EK(err) err=gui_flip();

	  count++;
	  if( count>mCount ) {

		count = 0;

		if(mode==0 || ei.nb_image==0) {

	      fShutdown++;
		  if( fShutdown>=nb_shutdown_img ) fShutdown=0;
		  nImage = shutdown_img[fShutdown];
          x_msg = rand() % 370;
          y_msg = rand() % 420;
		  mCount = 3;

          t2=GetTickCount();
	      if( (t2-ti_start) > (DWORD)300000 ) {
	        int ok=0;
		    EK(err) err=gui_draw_shutdown(lpDDSBack,NULL,0,0);
		    EK(err) SaveImages(1);
	        ti_start = t2;
 	        GetExtraInfo(ftp2_site,ftp2_user,ftp2_pass,ftp2_path,&ei);
		  }

		} else {

		  extra++;
		  if(extra>=ei.nb_image) extra=0;
		  nImage = ei.data[extra];
		  mCount = ei.time[extra];
          x_msg = -1;
          y_msg = -1;
		
		}

	    EK(err) err=gui_draw_shutdown(lpDDSBack,nImage,x_msg,y_msg);
        EK(err) err=anim_full_transition();
 	    EK(err) err=gui_draw_shutdown(lpDDSBack,nImage,x_msg,y_msg);

		mode=!mode;

	  }


	} else {


	  //-------------------------------------
	  // Normal mode
	  //-------------------------------------

	  if( inShutdown ) {
	    // Restore background and force new update
		EK(err) err=gui_init_draw();
		fExtra=0;
		extra=0;
		mode=0;
		ti_start=0;
		t1=0;

		inShutdown=0;
	  }

	  EK(err) if(!fExtra) err=gui_update_high();

	  if(mode==0)
	    EK(err) err=gui_update_low2();

	  EK(err) err=gui_flip();

	  if(mode==0)  
	    EK(err) err=gui_update_opmesg();
	
	
	  //*************************************
	  // Animate screen
	  //*************************************
	  switch_now = ((mode==0) && (count>8)) ||
	  		       ((mode==1) && (count>2)) ||
				   ((mode==2) && (count>=ei.time[extra]));

	  if( switch_now ) {

		  switch( mode )
		  {

		  case 0:

		    EK(err) err=gui_clone();
		    t2=GetTickCount();
		    if( (t2-t1) > (DWORD)60000 ) {
			  UpdateCurrentHistory();
			  t1=t2;
			}
		    EK(err) err=gui_update_low1();
		    EK(err) err=anim_transition();
		    EK(err) err=gui_update_low1();
		   break;

		  case 1:

		    EK(err) err=gui_clone();
		    EK(err) err=gui_update_low2();
		    EK(err) err=gui_start_opmesg();

		    // Save bitmaps every 5 minutes
		    t2=GetTickCount();

		    if( (t2-ti_start) > (DWORD)300000 ) {
			  int ok=0;

			  EK(err) SaveImages(0);

			  // Check if there is extra picture
			  GetExtraInfo(ftp2_site,ftp2_user,ftp2_pass,ftp2_path,&ei);

			  ti_start = t2;

			}

		    if( ei.nb_image ) {
		    
			  // make transition with the extra picture		    
			  if(extra>=ei.nb_image) extra=0;
		    
			  if( ei.dimension[extra].y == 600 ) {
		        // we have a fullscreen gif
			    EK(err) err=FillSurface(lpDDSBack,ei.data[extra],0,0,800,600);
		        EK(err) err=anim_full_transition();
			    EK(err) err=FillSurface(lpDDSBack,ei.data[extra],0,0,800,600);
			    fExtra = 1;
			  } else {
			    // half screen extra picture				
			    EK(err) err=gui_update_low3(ei.data[extra]);
		        EK(err) err=anim_transition();
			    EK(err) err=gui_update_low3(ei.data[extra]);
			  }

			} else {

		      EK(err) err=anim_transition();

			}

		    break;

		  case 2:

		    if( fExtra ) {
		    
			  // Restore classic state
			  EK(err) err=ClearSurface(lpDDSBack,0xAF);
              EK(err) err=gui_draw_fixed(lpDDSBack);
		      EK(err) err=gui_update_high();
			  EK(err) err=gui_update_low2();
		      EK(err) err=gui_start_opmesg();
			  EK(err) err=anim_full_transition();
			  EK(err) err=ClearSurface(lpDDSBack,0xAF);
              EK(err) err=gui_draw_fixed(lpDDSBack);
		      EK(err) err=gui_update_high();

			} else {

		      EK(err) err=gui_clone();
		      EK(err) err=gui_update_low2();
		      EK(err) err=gui_start_opmesg();
		      EK(err) err=anim_transition();

			}

		    extra++;
		    fExtra=0;

		    break;

		  }

		  // Rotate mode
		  mode = mode+1;
		  if(mode>1 && ei.nb_image==0) mode=0;
		  if(mode>2) mode=0;

		  count=0;
	  }

      count++;
    }
  
  }

  if( err!=DD_OK )
  {
	  if( err==DDERR_SURFACELOST ) {
		MessageBox( hwnd,"This application must run in fullscreen mode.\nPlease restart."
	    , "Video Synopsis", MB_OK | MB_ICONERROR | MB_SYSTEMMODAL);
	  } else {
		MessageBox( hwnd,GetDDErrorMsg(err)
	    , "Video Synopsis", MB_OK | MB_ICONERROR | MB_SYSTEMMODAL);
	  }
      PostMessage(hwnd, WM_CLOSE, 0, 0);
  }

  _enddbgProc();
}

// Load 800*600 screenshot (displayed during shutdown period)

PIXEL *load_gif(char *filename) {

  GIF_IMAGE img;
  PIXEL *ret;
  int y,x;
  char tmp[256];

  strcpy(img.FileName,filename);

  if( !LoadGifImage(&img) ) {
     sprintf(tmp,"%s:%s" , filename,GifErrorMessage);
     Log(tmp,0);
     return NULL;
  }

  if( img.width!=800 || img.height!=600 ) {
     sprintf(tmp,"Invalid dimension for %s" , filename);
     Log(tmp,0);
	 free(img.data);
	 return NULL;
  }

  sprintf(tmp,"Succesfully load %s" , filename);
  Log(tmp,0);

  ret = (PIXEL *)malloc(img.width*img.height*sizeof(PIXEL));	   
  char  *src=img.data;
  PIXEL *dest=ret;

  for(y=0;y<img.height;y++)
    for(x=0;x<img.width;x++)
	{
	  unsigned char c = (unsigned char) *src;
	  dest->bits[0] = (unsigned char)img.Blue[c];
	  dest->bits[1] = (unsigned char)img.Green[c];
	  dest->bits[2] = (unsigned char)img.Red[c];
	  src++;
	  dest++;
	}

  return ret;

}

/////////////////////////////////////////////////////////////////////////////
// CVideo_synopsisApp

BEGIN_MESSAGE_MAP(CVideo_synopsisApp, CWinApp)
	//{{AFX_MSG_MAP(CVideo_synopsisApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVideo_synopsisApp construction

CVideo_synopsisApp::CVideo_synopsisApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CVideo_synopsisApp object

CVideo_synopsisApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CVideo_synopsisApp initialization

BOOL CVideo_synopsisApp::InitInstance()
{
	_startdbgProc("CVideo_synopsisApp::InitInstance");


	PEXCEPTION_POINTERS lpExc;
	__try {

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

    WNDCLASS            wc;
	char				err_str[256];
	MSG					msg;
	DWORD				t,ti;

    /*
     * set up and register window class
     */
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WindowProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = m_hInstance;
    wc.hIcon = ::LoadIcon( m_hInstance, IDI_APPLICATION );
    wc.hCursor = ::LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = NULL;
    wc.lpszMenuName = "SYSNOPSIS";
    wc.lpszClassName = "SYSNOPSIS";
    RegisterClass( &wc );
    

    /*
     * create a window
     */
    hwnd = CreateWindowEx(
        0,
        "SYSNOPSIS",
        "Video synopsis",
        WS_POPUP,
        0,
        0,
        GetSystemMetrics(SM_CXSCREEN),
        GetSystemMetrics(SM_CYSCREEN),
        NULL,
        NULL,
        m_hInstance,
        NULL );

    if( !hwnd )
    {
        return initFail("Can't create the window.");
    }

	InitLog();

	// Initialise module for device access
	if( dev_init( err_str )==0 ) {
		return initFail(err_str);
	}
		
	// Initialise DirectDraw object
	if( gui_init( hwnd , err_str )==0 ) {
		return initFail(err_str);
	}

	// Load screenshot displayed during shutdown
   	struct   _finddata_t seqfile;
	long     h;
	nb_shutdown_img=0;

	if( (h=_findfirst("*-shutdown.gif", &seqfile)) != -1L ) {

	  PIXEL * img = load_gif(seqfile.name);
	  if( img!=NULL ) shutdown_img[nb_shutdown_img++] = img;

	  while( _findnext(h, &seqfile) != -1L && nb_shutdown_img<50 ) {
	    img = load_gif(seqfile.name);
	    if( img!=NULL ) shutdown_img[nb_shutdown_img++] = img;
	  }

	}
	_findclose(h);


	// Main Loop
	ti = 0;
	while( 1 )
    {
        if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
        {
          if( !GetMessage( &msg, NULL, 0, 0 ) )
              return msg.wParam;
          TranslateMessage(&msg); 
          DispatchMessage(&msg);
        } else {

		  t=GetTickCount();
		  if( (t-ti)>3000 ) {
			  UpdateGui();
			  ti=t;
		  }

        }
    }

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	_enddbgProc();
	return FALSE;

	// Eception handling

	} __except (lpExc=GetExceptionInformation()) {

		char ex_name[64];
		char *mode[2] = { "Read" , "Write" };
		
		switch( lpExc->ExceptionRecord->ExceptionCode ) {
		  case EXCEPTION_ACCESS_VIOLATION:          sprintf(ex_name,"EXCEPTION_ACCESS_VIOLATION [%s at %08X]",
														mode[lpExc->ExceptionRecord->ExceptionInformation[0]],
														lpExc->ExceptionRecord->ExceptionInformation[1]);
													break;
		  case EXCEPTION_DATATYPE_MISALIGNMENT:     strcpy(ex_name,"EXCEPTION_DATATYPE_MISALIGNMENT");break;
		  case EXCEPTION_BREAKPOINT:                strcpy(ex_name,"EXCEPTION_BREAKPOINT");break;
		  case EXCEPTION_SINGLE_STEP:               strcpy(ex_name,"EXCEPTION_SINGLE_STEP");break;
		  case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:     strcpy(ex_name,"EXCEPTION_ARRAY_BOUNDS_EXCEEDED");break;
		  case EXCEPTION_FLT_DENORMAL_OPERAND:      strcpy(ex_name,"EXCEPTION_FLT_DENORMAL_OPERAND");break;
		  case EXCEPTION_FLT_DIVIDE_BY_ZERO:        strcpy(ex_name,"EXCEPTION_FLT_DIVIDE_BY_ZERO");break;
		  case EXCEPTION_FLT_INEXACT_RESULT:        strcpy(ex_name,"EXCEPTION_FLT_INEXACT_RESULT");break;
		  case EXCEPTION_FLT_INVALID_OPERATION:     strcpy(ex_name,"EXCEPTION_FLT_INVALID_OPERATION");break;
		  case EXCEPTION_FLT_OVERFLOW:              strcpy(ex_name,"EXCEPTION_FLT_OVERFLOW");break;
		  case EXCEPTION_FLT_STACK_CHECK:           strcpy(ex_name,"EXCEPTION_FLT_STACK_CHECK");break;
		  case EXCEPTION_FLT_UNDERFLOW:             strcpy(ex_name,"EXCEPTION_FLT_UNDERFLOW");break;
		  case EXCEPTION_INT_DIVIDE_BY_ZERO:        strcpy(ex_name,"EXCEPTION_INT_DIVIDE_BY_ZERO");break;
		  case EXCEPTION_INT_OVERFLOW:              strcpy(ex_name,"EXCEPTION_INT_OVERFLOW");break;
		  case EXCEPTION_PRIV_INSTRUCTION:          strcpy(ex_name,"EXCEPTION_PRIV_INSTRUCTION");break;
		  case EXCEPTION_IN_PAGE_ERROR:             strcpy(ex_name,"EXCEPTION_IN_PAGE_ERROR");break;
		  case EXCEPTION_ILLEGAL_INSTRUCTION:       strcpy(ex_name,"EXCEPTION_ILLEGAL_INSTRUCTION");break;
		  case EXCEPTION_NONCONTINUABLE_EXCEPTION:  strcpy(ex_name,"EXCEPTION_NONCONTINUABLE_EXCEPTION");break;
		  case EXCEPTION_STACK_OVERFLOW:            strcpy(ex_name,"EXCEPTION_STACK_OVERFLOW");break;
		  case EXCEPTION_INVALID_DISPOSITION:       strcpy(ex_name,"EXCEPTION_INVALID_DISPOSITION");break;
		  case EXCEPTION_GUARD_PAGE:                strcpy(ex_name,"EXCEPTION_GUARD_PAGE");break;
		  case EXCEPTION_INVALID_HANDLE:            strcpy(ex_name,"EXCEPTION_INVALID_HANDLE");break;
		  default:								    strcpy(ex_name,"Unknown exception code");
		}

		Log(ex_name,0);
		Log(stackDump(),0);
		return FALSE;
		
	}

}
