/*==========================================================================
 *
 *  File:       graphics.h
 *  Author:		JL PONS
 *  Project:	CTRM Video synopsis
 *  Content:    Low level graphic routines
 *  Date:		June 1998
 *
 ***************************************************************************/
#ifndef GRAPHICSH
#define GRAPHICSH

#include <ddraw.h>
#include "color.h"

extern LPDIRECTDRAW            lpDD;           // DirectDraw object
extern LPDIRECTDRAWSURFACE     lpDDSPrimary;   // DirectDraw primary surface
extern LPDIRECTDRAWSURFACE     lpDDSBack;      // DirectDraw back surface
extern HBITMAP				   back_bm;		   // Background bitmap
extern HFONT				   def_font;       // default font
extern HFONT				   current_font;   // Current field font
extern HFONT				   text_font;	   // Text font
extern HFONT				   mode_font;	   // mode font
extern HFONT				   small_font;
extern HFONT				   bl_font;		   // font for bm and id

#define EK(err) if(err==DD_OK)

//***************************************************************
// Definitions of PIXEL
//***************************************************************
#ifdef _24BITS

  typedef struct {
	unsigned char bits[3];
  } PIXEL;

#else

  typedef struct {
	unsigned char bits[4];
  } PIXEL;

#endif

int graphics_init( HWND hwnd , char *err_str );
long ClearSurface(LPDIRECTDRAWSURFACE lpDD,BYTE graylevel);
long FillSurface(LPDIRECTDRAWSURFACE lpDD,PIXEL *src,int x,int y,int w,int h);
long gprint(LPDIRECTDRAWSURFACE lpDD , char *msg ,
			int x , int y , HFONT fnt,
			DWORD bkcolor , DWORD frcolor);

long gprint_trans(LPDIRECTDRAWSURFACE lpDD , char *msg ,
			      int x , int y , HFONT fnt,
			      DWORD frcolor);

long Line(LPDIRECTDRAWSURFACE lpDD, 
		  int x1, int y1 ,int x2, int y2,DWORD color);

long LineDot(LPDIRECTDRAWSURFACE lpDD, 
		  int x1, int y1 ,int x2, int y2,DWORD color);

long FillRect(LPDIRECTDRAWSURFACE pdds, 
			  int x1, int y1 ,int x2, int y2,DWORD color);

long Fill(LPDIRECTDRAWSURFACE pdds, 
		  HRGN rgn,DWORD color);

long SaveBitmap(IDirectDrawSurface *pdds,int y1,int y2,char *filename);

long SaveGifFromRGB(IDirectDrawSurface *pdds,
					int xs,int ys,
					int ws,int hs,
					int w,int h,
					char *filename,
					int nbstep,
					int how,
					int palmode);

long measure_text(LPDIRECTDRAWSURFACE lpDDS , char *msg , HFONT fnt,int *widht,int *height);

long DarkenRect(LPDIRECTDRAWSURFACE lpDD,int x1,int y1,int x2,int y2);

#endif