/*================================================================
 *
 *  File:       ftp.cpp
 *  Author:		JL PONS
 *  Project:	CTRM Video synopsis
 *  Content:    File transfert routines
 *  Date:		May 1999
 *
 *  Implementation using Platform SDK
 ******************************************************************/
#include "stdafx.h"

#include <ddraw.h>
#include "ftp.h"
#include "gif.h"
#include "Log.h"
#include <wininet.h>

#define SAFE_FREE(x) if(x) { free(x);x=NULL; }

// -------------------------------------------------------------------------------------
// Open FTP and upload images
// Return FALSE when failed
// -------------------------------------------------------------------------------------
long SaveByFtp( char *filename , char *ftp_site , char *user , char *passwd ,char *path)
{
	_startdbgProc("SaveByFtp");

   char err_str[1024];
   char fullname[512];

   // ---- Open Internet session -----------------------------------------------------------
   HINTERNET iSession = InternetOpen("VideoSynopsis",INTERNET_OPEN_TYPE_DIRECT,NULL,NULL,0);

   if( iSession == NULL ) {
	 LPVOID  lpMsgBuf;
	 FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
		NULL,
		GetLastError(),
		0,	// Default language 
		(LPTSTR) & lpMsgBuf,
		0,
		NULL );
	 sprintf(err_str,"InternetOpen failed:%s",(LPTSTR)lpMsgBuf);
	 Log(err_str,0);
	 _enddbgProc();
	 return FALSE;
   }

   // ---- Open FTP session -----------------------------------------------------------------
   HINTERNET fSession = InternetConnect(iSession,ftp_site,INTERNET_DEFAULT_FTP_PORT,
										user,passwd,INTERNET_SERVICE_FTP,0,0);

   if( fSession==NULL ) {
	 LPVOID  lpMsgBuf;
	 FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
		NULL,
		GetLastError(),
		0,	// Default language 
		(LPTSTR) & lpMsgBuf,
		0,
		NULL );
	 sprintf(err_str,"InternetConnect(ftp://%s) failed:%s",ftp_site,(LPTSTR)lpMsgBuf);	 
 	 Log(err_str,0);
	 InternetCloseHandle(iSession);
	 _enddbgProc();
	 return FALSE;
   }

   // ---- Copy the file --------------------------------------------------------------------
   sprintf(fullname,"%s/%s",path,filename);

   BOOL fStatus = FtpPutFile(fSession,filename,fullname,INTERNET_FLAG_DONT_CACHE,0);

   if( !fStatus ) {
	 LPVOID  lpMsgBuf;
	 FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
		NULL,
		GetLastError(),
		0,	// Default language 
		(LPTSTR) & lpMsgBuf,
		0,
		NULL );
	 sprintf(err_str,"FtpPutFile(ftp://%s/%s failed:%s",ftp_site,fullname,(LPTSTR)lpMsgBuf);	 
 	 Log(err_str,0);
	 InternetCloseHandle(fSession);
	 InternetCloseHandle(iSession);
     _enddbgProc();
	 _enddbgProc();
	 return FALSE;
   }


   // Close Handles
   InternetCloseHandle(fSession);
   InternetCloseHandle(iSession);

   _enddbgProc();
   return TRUE;
}

// -------------------------------------------------------------------------------------
// Get extra images by Ftp
// Return TRUE when extra images are found.
// -------------------------------------------------------------------------------------
long GetExtraInfo(char *ftp_site,char *user,char *passwd,char *path,EXTRA_INFO *ei)
{
	_startdbgProc("GetExtraInfo");

   char  err_str[1024];
   char  search_str[512];
   char  tmp[512];
   int   i,x,y;
   BOOL ok;
   int   nb_file=0;
   char *filenames[50];
   WIN32_FIND_DATA FindFileData;
   unsigned char c;

   // ---- Free old data -------------------------------------------------------------------
   for(i=0;i<ei->nb_image;i++) SAFE_FREE( ei->data[i] );
   ei->nb_image=0;

   // ---- Open Internet session -----------------------------------------------------------
   HINTERNET iSession = InternetOpen("VideoSynopsis",INTERNET_OPEN_TYPE_DIRECT,NULL,NULL,0);

   if( iSession == NULL ) {
	 LPVOID  lpMsgBuf;
	 FormatMessage(
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
		NULL,
		GetLastError(),
		0,	// Default language 
		(LPTSTR) & lpMsgBuf,
		0,
		NULL );
	 sprintf(err_str,"InternetOpen failed:%s",(LPTSTR)lpMsgBuf);	 
 	 Log(err_str,0);
	 _enddbgProc();
	 return FALSE;
   }

   // ---- Open FTP session -----------------------------------------------------------------
   HINTERNET fSession = InternetConnect(iSession,ftp_site,INTERNET_DEFAULT_FTP_PORT,
										user,passwd,INTERNET_SERVICE_FTP,0,0);

   if( fSession==NULL ) {

	 DWORD winErrorCode = GetLastError();
	 DWORD iErrorCode=0;
	 char  eBuff[1024];
	 DWORD bLength=1024;

     if( InternetGetLastResponseInfo(&iErrorCode,eBuff,&bLength) )
	 {
	  sprintf(err_str,"InternetConnect(ftp://%s) failed:%s",ftp_site,eBuff);
	 } else {
	  sprintf(err_str,"InternetConnect(ftp://%s) failed:win_error_core = %d",ftp_site,winErrorCode);
	 }

 	 Log(err_str,0);
	 InternetCloseHandle(iSession);
	 _enddbgProc();
	 return FALSE;
   }

   // ---- Get images ------------------------------------------------------------------------
   nb_file=0;ok=TRUE;
   sprintf( search_str , "%s/info*.gif" , path );

   HINTERNET searchSession = FtpFindFirstFile(fSession,search_str,&FindFileData,INTERNET_FLAG_DONT_CACHE,0);

   if( searchSession == NULL ) {
     InternetCloseHandle(fSession);
     InternetCloseHandle(iSession);
	 _enddbgProc();
	 return FALSE;
   }

   while( ok ) {
     filenames[nb_file++] = strdup( FindFileData.cFileName );
	 ok = InternetFindNextFile(searchSession,(LPVOID)(&FindFileData));
   }

   InternetCloseHandle(searchSession);

   // ---- Decode images ---------------------------------------------------------------------
   for(i=0;i<nb_file;i++) {
	   
	   // Copy the file 
	   BOOL fStatus = FtpGetFile(fSession,filenames[i],filenames[i],0,FILE_ATTRIBUTE_NORMAL,INTERNET_FLAG_DONT_CACHE,0);

       if( !fStatus ) {
	     LPVOID  lpMsgBuf;
	     FormatMessage(
		    FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
		    NULL,
		    GetLastError(),
		    0,	// Default language 
		    (LPTSTR) & lpMsgBuf,
		    0,
		    NULL );
	     sprintf(err_str,"FtpGetFile(ftp://%s/%s failed:%s",ftp_site,filenames[i],(LPTSTR)lpMsgBuf);	 
 	     Log(err_str,0);
	     InternetCloseHandle(fSession);
	     InternetCloseHandle(iSession);
 	     _enddbgProc();
	     return FALSE;
	   }
	   
	   // Decode the pciture	   
	   GIF_IMAGE img;

	   strcpy(img.FileName,filenames[i]);
	   if( !LoadGifImage(&img) ) {
	     sprintf(err_str,"LoadGifFile(%s) failed:%s",filenames[i],GifErrorMessage);	 
	 	 Log(err_str,0);
		 InternetCloseHandle(fSession);
	     InternetCloseHandle(iSession);
	     _enddbgProc();
	     return FALSE;
	   }

	   // Check dimension
	   if( img.width!=800 || (img.height!=300 && img.height!=600) ) {
	     sprintf(err_str,"%s invalid dimension (%d,%d) required (800,600) or (800,300)",
			             filenames[i],img.width,img.height);	 
	 	 Log(err_str,0);
		 free(img.data);
		 InternetCloseHandle(fSession);
	     InternetCloseHandle(iSession);
	     _enddbgProc();
	     return FALSE;
	   }


	   // Build EXTRA picture
	   ei->data[i] = (PIXEL *)malloc(img.width*img.height*sizeof(PIXEL));	   
	   char  *src=img.data;
	   PIXEL *dest=ei->data[i];

	   for(y=0;y<img.height;y++)
	     for(x=0;x<img.width;x++)
		 {
			 c = (unsigned char) *src;
			 dest->bits[0] = (unsigned char)img.Blue[c];
			 dest->bits[1] = (unsigned char)img.Green[c];
			 dest->bits[2] = (unsigned char)img.Red[c];
			 src++;
			 dest++;
		 }

	   ei->dimension[i].x = img.width;
	   ei->dimension[i].y = img.height;

	   char *p = strchr(filenames[i],'-');
	   strcpy(err_str,"");
	   x=0;
	   if( p ) {
		   p++;
		   while( (*p!=0) && (*p>='0') && (*p<='9') ) {
		     err_str[x]=*p;
		     x++;p++;
		   }
		   err_str[x] = 0;
	   }
	   ei->time[i] = atoi(err_str)/3 + 1;

	   // Free img
	   free(img.data);

       sprintf(tmp,"Succesfully load %s" , filenames[i]);
       Log(tmp,0);


   }

   ei->nb_image = nb_file;

   // Free filename
   for(i=0;i<nb_file;i++) SAFE_FREE(filenames[i]);

   // Close Handles
   InternetCloseHandle(fSession);
   InternetCloseHandle(iSession);

   _enddbgProc();
   return TRUE;

}