/*================================================================
 *
 *  File:       dev.cpp
 *  Author:		JL PONS
 *  Project:	CTRM Video synopsis
 *  Content:    Device access routines
 *  Date:		June 1998
 *
 ******************************************************************/
#include "stdafx.h"

#include <API.h>
#include <DevServer.h>
#include <DevErrors.h>
#include <CntrlDsNumbers.h>
#include <MachStat.h>

#include "dev.h"
#include "gui.h"
#include "Log.h"

devserver machstat;

int   Hist_Nb;
float Hist_Vl[10000];
long  Hist_Tm[10000];

int BM[33];
int ID[33];

float signals[100];
char  *format[100];
char  *unit[100];
DevVarStringArray sig_prop={0,NULL};

char ftp_user[128];
char ftp_pass[128];
char ftp_site[128];
char ftp_path[128];

char ftp2_user[128];
char ftp2_pass[128];
char ftp2_site[128];
char ftp2_path[128];


int get_res_app(char *name,char *prop,long *error) {

   _startdbgProc("get_res_app");

   db_resource res_app[1];
   DevString str=NULL;

   res_app[0].resource_name=name;
   res_app[0].resource_type=D_STRING_TYPE;
   res_app[0].resource_adr=&str;

   if( db_getresource( MACH_STAT_NAME , res_app , 1 , error )<0 )
   {
	   _enddbgProc();
	   return 0;
   }

   if(!str) {
	   *error=409;
	   _enddbgProc();
	   return 0;
   }

   strcpy(prop,str);

   free(str);

   _enddbgProc();
   return 1;

}

//****************************************************
//* Initialise device access
//****************************************************
int dev_init(char *err_str) {
   
   _startdbgProc("dev_init");

   long error=0;
   unsigned int i,j,nu_of_prop;
   DevVarDoubleArray hist={0,NULL};
   DevVarLongArray   larr={0,NULL};
   char *tmp;

  /*
   *  init application variables
   */
 
  rpc_nt_init();

  if( db_import(&error)<0 )
  {
	 sprintf(err_str,"db_import() failed: %s",
	         dev_error_str(error));
	 _enddbgProc();
	 return 0;
  }

  if( !get_res_app("ftp_user" , ftp_user , &error) )
  {
	 sprintf(err_str,"%s/ftp_user : %s",
	         MACH_STAT_NAME , dev_error_str(error));
	 _enddbgProc();
	 return 0;
  }

  if( !get_res_app("ftp_site" , ftp_site , &error) )
  {
	 sprintf(err_str,"%s/ftp_site : %s",
	         MACH_STAT_NAME , dev_error_str(error));
	 _enddbgProc();
	 return 0;
  }

  if( !get_res_app("ftp_pass" , ftp_pass , &error) )
  {
	 sprintf(err_str,"%s/ftp_pass : %s",
	         MACH_STAT_NAME , dev_error_str(error));
	 _enddbgProc();
	 return 0;
  }

  if( !get_res_app("ftp_path" , ftp_path , &error) )
  {
	 sprintf(err_str,"%s/ftp_path : %s",
	         MACH_STAT_NAME , dev_error_str(error));
	 _enddbgProc();
	 return 0;
  }

  if( !get_res_app("ftp2_user" , ftp2_user , &error) )
  {
	 sprintf(err_str,"%s/ftp2_user : %s",
	         MACH_STAT_NAME , dev_error_str(error));
	 _enddbgProc();
	 return 0;
  }

  if( !get_res_app("ftp2_site" , ftp2_site , &error) )
  {
	 sprintf(err_str,"%s/ftp2_site : %s",
	         MACH_STAT_NAME , dev_error_str(error));
	 _enddbgProc();
	 return 0;
  }

  if( !get_res_app("ftp2_pass" , ftp2_pass , &error) )
  {
	 sprintf(err_str,"%s/ftp2_pass : %s",
	         MACH_STAT_NAME , dev_error_str(error));
	 _enddbgProc();
	 return 0;
  }

  if( !get_res_app("ftp2_path" , ftp2_path , &error) )
  {
	 sprintf(err_str,"%s/ftp2_path : %s",
	         MACH_STAT_NAME , dev_error_str(error));
	 _enddbgProc();
	 return 0;
  }

  /*
   *  import the device
   */

  if ( dev_import(MACH_STAT_NAME,READ_ACCESS, &machstat, &error) < 0 )
  {
	 sprintf(err_str,"Error when importing %s\n%s",MACH_STAT_NAME,
	         dev_error_str(error));
	 _enddbgProc();
	 return 0;
  }

  /*
  if (dev_rpc_protocol (machstat, D_TCP, &error) < 0 )
  {
	 sprintf(err_str,"Error when switching to TCP on %s\n%s",MACH_STAT_NAME,
	         dev_error_str(error));
	 _enddbgProc();
	 return 0;
  }
  */

  // ---------------------------------------------------------
  // Initialise BM and ID table with 0 when not defined else 1

  for( i=1 ; i<=32 ; i++) { BM[i]=0; ID[i]=0; };

  if(dev_putget(machstat , DevReadBMStatus , NULL , D_VOID_TYPE , 
		        &larr , D_VAR_LONGARR , &error ) == DS_OK )
  {
    for( i=0 ; i<larr.length ; i+=2 )
	  BM[larr.sequence[i]]=1;

	if( dev_xdrfree(D_VAR_LONGARR , &larr ,&error)<0 )
	  {
	  }
  }

  larr.length=0;
  larr.sequence=NULL;

  if(dev_putget(machstat , DevReadIDStatus , NULL , D_VOID_TYPE , 
		        &larr , D_VAR_LONGARR , &error ) == DS_OK )
  {
    for( i=0 ; i<larr.length ; i+=2 )
	  ID[larr.sequence[i]]=1;

	if( dev_xdrfree(D_VAR_LONGARR , &larr ,&error)<0 )
	  {
	  }

  }

  // ---------------------------------------------------------
  // Initialise current history

  Hist_Nb=0;

  if(dev_putget(machstat , DevReadHistory , NULL , D_VOID_TYPE , 
		        &hist , D_VAR_DOUBLEARR , &error ) == DS_OK )
  {
    for( i=0 ; i<hist.length ; i+=2 )
	{
		Hist_Tm[Hist_Nb]=(long)hist.sequence[i];
		Hist_Vl[Hist_Nb]=(float)hist.sequence[i+1];
		Hist_Nb++;
	}

	if( dev_xdrfree(D_VAR_DOUBLEARR , &hist ,&error) )
	{
	}

  }

  // ---------------------------------------------------------
  // Initialise signal properties

  if(dev_putget(machstat , DevGetSigConfig , NULL , D_VOID_TYPE , 
		        &sig_prop , D_VAR_STRINGARR , &error ) == DS_OK )
  {
	nu_of_prop=atoi(sig_prop.sequence[0]);

    for( j=0,i=1 ; i<sig_prop.length ; j++,i+=nu_of_prop )
	{
       format[j]=sig_prop.sequence[i+3];
       unit[j]=sig_prop.sequence[i+2];

	   if( strcmp( unit[j] , "micron" )==0 )
	   {
		   tmp=(char *)malloc(3);
		   tmp[0]=(char)181;
		   tmp[1]='m';
		   tmp[2]=0;
		   unit[j]=tmp;
	   }

	}

	for(i=0;i<j;i++) signals[i]=65536.0;

	// don't free the sig_prop array !
	// It will be used latter
  
  } else {
  	  
	  sprintf(err_str,"Error when getting signal properties from %s\n%s",
		      MACH_STAT_NAME,
	          dev_error_str(error));
	  _enddbgProc();
	  return 0;

  }


  _enddbgProc();
  return 1;
}

void dev_update_signals()
{
	_startdbgProc("dev_update_signals");

	DevVarFloatArray sig={0,NULL};
	long error=0;
	unsigned int i;

	//* Call to device server

	if(dev_putget(machstat , DevReadSigValues , NULL , D_VOID_TYPE , 
		          &sig , D_VAR_FLOATARR , &error ) < 0 )
	{
		// Log error
		Log("dev_update_signals",error);
		for(i=0;i<100;i++) signals[i]=65536.0;
	} else {
		
		// Update local signal array
		for(i=0;i<sig.length;i++) signals[i]=sig.sequence[i];

		// Free array
		if( dev_xdrfree(D_VAR_FLOATARR, &sig , &error)<0 )
		{
		}
		
	}

	_enddbgProc();
}

void Cut(char *s,int c) {

  _startdbgProc("Cut");

  if( (int)strlen(s)>c ) s[c]='\0';
  _enddbgProc();
}

void dev_get_current(char *ret) {

  _startdbgProc("dev_get_current");
  
  char tmpf[64];

  if( signals[0] >= 65536.0 ) {
    sprintf(ret,"---.-- %s",unit[0]);
  } else {
	sprintf(tmpf,"%s %s",format[0],unit[0]);
    sprintf(ret,tmpf,signals[0]);
  }

  Cut( ret , 9 );
  _enddbgProc();
}

void dev_get_lifetime(char *ret)
{
    _startdbgProc("dev_get_lifetime");

	int sec,h,m;
	long error=0;

	if( signals[1] == 65536.0 ) {

	  strcpy(ret,"---h --m");
	
	} else {

	  sec=(int)(signals[1]);
	  h=sec/3600;
	  m=(sec - h*3600) / 60;

	  sprintf(ret,"%3dh %02dm",h,m);
	}

    Cut( ret , 8 );
	_enddbgProc();
}

void dev_get_tuneh(char *ret) {
  _startdbgProc("dev_get_tuneh");

  if( signals[2] >= 65536.0 ) {
    sprintf(ret,"-.----");
  } else {
    sprintf(ret,format[2],signals[2]);
  }

  Cut( ret , 6 );
  _enddbgProc();
}

void dev_get_tunev(char *ret) {

  _startdbgProc("dev_get_tunev");

  if( signals[3] >= 65536.0 ) {
    sprintf(ret,"-.----");
  } else {
    sprintf(ret,format[3],signals[3]);
  }

  Cut( ret , 6 );
  _enddbgProc();
}

void dev_get_orbitrmsh(char *ret) {
  _startdbgProc("dev_get_orbitrmsh");

  char tmpf[64];

  if( signals[4] >= 65536.0 ) {
    sprintf(ret,"---.-- %s",unit[4]);
  } else {
	sprintf(tmpf,"%s %s",format[4],unit[4]);
    sprintf(ret,tmpf,signals[4]);
  }

  Cut( ret , 10 );
  _enddbgProc();
}

void dev_get_orbitrmsv(char *ret) {

  _startdbgProc("dev_get_orbitrmsv");
  char tmpf[64];

  if( signals[5] >= 65536.0 ) {
    sprintf(ret,"---.-- %s",unit[5]);
  } else {
	sprintf(tmpf,"%s %s",format[5],unit[5]);
    sprintf(ret,tmpf,signals[5]);
  }

  Cut( ret , 10 );
  _enddbgProc();
}

void dev_get_orbitpeakh(char *ret) {
  _startdbgProc("dev_get_orbitpeakh");
  char tmpf[64];

  if( signals[6] >= 65536.0 ) {
    sprintf(ret,"---.-- %s",unit[6]);
  } else {
	sprintf(tmpf,"%s %s",format[6],unit[6]);
    sprintf(ret,tmpf,signals[6]);
  }

  Cut( ret , 10 );
  _enddbgProc();
}
void dev_get_orbitpeakv(char *ret) {
 
  _startdbgProc("dev_get_orbitpeakv");
  char tmpf[64];

  if( signals[7] >= 65536.0 ) {
    sprintf(ret,"---.-- %s",unit[7]);
  } else {
	sprintf(tmpf,"%s %s",format[7],unit[7]);
    sprintf(ret,tmpf,signals[7]);
  }

  Cut( ret , 10 );
  _enddbgProc();
}

void dev_get_dipolenmr(char *ret) {
  _startdbgProc("dev_get_dipolenmr");
  char tmpf[64];

  if( signals[8] >= 65536.0 ) {
    sprintf(ret,"-.------ %s",unit[8]);
  } else {
	sprintf(tmpf,"%s %s",format[8],unit[8]);
    sprintf(ret,tmpf,signals[8]);
  }

  Cut( ret , 10 );
  _enddbgProc();
}

void dev_get_dipolehall(char *ret) {
   _startdbgProc("dev_get_dipolehall");
   char tmpf[64];

  if( signals[9] >= 65536.0 ) {
    sprintf(ret,"-.------ %s",unit[9]);
  } else {
	sprintf(tmpf,"%s %s",format[9],unit[9]);
    sprintf(ret,tmpf,signals[9]);
  }

  Cut( ret , 10 );
  _enddbgProc();
}

void dev_get_emitd9x(char *ret) {
  _startdbgProc("dev_get_emitd9x");
  char tmpf[64];

  if( signals[10] >= 65536.0 ) {
    sprintf(ret,"---.-- %s",unit[10]);
  } else {
	sprintf(tmpf,"%s %s",format[10],unit[10]);
    sprintf(ret,tmpf,signals[10]);
  }

  Cut( ret , 10 );
  _enddbgProc();
}

void dev_get_emitd9z(char *ret) {
  _startdbgProc("dev_get_emitd9z");
  char tmpf[64];

  if( signals[11] >= 65536.0 ) {
    sprintf(ret,"---.-- %s",unit[11]);
  } else {
	sprintf(tmpf,"%s %s",format[11],unit[11]);
    sprintf(ret,tmpf,signals[11]);
  }

  Cut( ret , 10 );
  _enddbgProc();
}

void dev_get_emitid8x(char *ret) {
  _startdbgProc("dev_get_emitid8x");
  char tmpf[64];

  if( signals[12] >= 65536.0 ) {
    sprintf(ret,"---.-- %s",unit[12]);
  } else {
	sprintf(tmpf,"%s %s",format[12],unit[12]);
    sprintf(ret,tmpf,signals[12]);
  }

  Cut( ret , 10 );
  _enddbgProc();
}

void dev_get_emitid8z(char *ret) {
  _startdbgProc("dev_get_emitid8z");
  char tmpf[64];

  if( signals[13] >= 65536.0 ) {
    sprintf(ret,"---.-- %s",unit[13]);
  } else {
	sprintf(tmpf,"%s %s",format[13],unit[13]);
    sprintf(ret,tmpf,signals[13]);
  }

  Cut( ret , 10 );
  _enddbgProc();
}

void dev_get_avpress(char *ret) {
  _startdbgProc("dev_get_avpress");

  char tmpf[64];
  double v;
  int exp;

  if( signals[14] >= 65536.0 ) {
    sprintf(ret,"---.-- %s",unit[14]);
  } else {
	v=signals[14];
	exp=0;
	while( v<1.0 )
	{
		exp++;
		v=v*10.0;
	}
	sprintf(tmpf,"%.2fe-%d",v,exp);
    sprintf(ret,"%s %s",tmpf,unit[14]);

  }

  Cut( ret , 13 );
  _enddbgProc();
}

//*****************************************************
//* Return current opperator message
//*****************************************************
void dev_get_opp_message(char *ret_msg) {
	_startdbgProc("dev_get_opp_message");

	DevString mesg=NULL;
	long error=0;
	int i;

	//* Call to device server

	if(dev_putget(machstat , DevReadOpMesg , NULL , D_VOID_TYPE , 
		          &mesg , D_STRING_TYPE , &error ) < 0 )
	{
		Log("dev_get_opp_message",error);
		sprintf(ret_msg,"Unknown");
	} else {
		strcpy(ret_msg,mesg);
		
		// Remove extra character
		for(i=0;i<(int)strlen(ret_msg);i++) 
			if( ret_msg[i]<32 ) ret_msg[i]=32;

		// Free string
		if( dev_xdrfree(D_STRING_TYPE , &mesg , &error)<0 )
		{
		}

	}

  _enddbgProc();
}

//*****************************************************
//* Return filling mode
//*****************************************************
void dev_get_filling_mode(char *ret_msg) {
    _startdbgProc("dev_get_filling_mode");

	DevString mesg=NULL;
	long error=0;
	int i;

	//* Call to device server

	if(dev_putget(machstat , DevReadFillMode , NULL , D_VOID_TYPE , 
		          &mesg , D_STRING_TYPE , &error ) < 0 )
	{
		Log("dev_get_filling_mode",error);
		sprintf(ret_msg,"Unknown");
	} else {
		strcpy(ret_msg,mesg);

		// Remove extra character and force length
		Cut(ret_msg,12);

		for(i=0;i<(int)strlen(ret_msg);i++) 
			if( ret_msg[i]<32 ) ret_msg[i]=32;

		// Free string
		if( dev_xdrfree(D_STRING_TYPE , &mesg , &error)<0 )
		{
		}

	}

    _enddbgProc();
}

//*****************************************************
// Returns the date of the next shutdown
//*****************************************************
void dev_get_nextrundate(char *ret_date) {

    _startdbgProc("dev_get_nextrundate");

	long error=0;
	DevVarLongArray larr={0,NULL};

	//* Call to device server

	if(dev_putget(machstat , DevGetRunDate , NULL , D_VOID_TYPE , 
		          &larr , D_VAR_LONGARR , &error ) < 0 )
	{
	  Log("dev_get_nextrundate",error);
	  sprintf(ret_date,"-- --- ----");
	} else {
	  char *dt = ctime(&(larr.sequence[0]));

	  ret_date[0] = dt[8];
	  ret_date[1] = dt[9];
	  ret_date[2] = ' ';
	  ret_date[3] = dt[4];
	  ret_date[4] = dt[5];
	  ret_date[5] = dt[6];
	  ret_date[6] = ' ';
	  ret_date[7] =  dt[20];
	  ret_date[8] =  dt[21];
	  ret_date[9] =  dt[22];
	  ret_date[10] = dt[23];
	  ret_date[11] = 0;

	  dev_xdrfree(D_VAR_LONGARR , &larr ,&error);
	}

    _enddbgProc();

}

//*****************************************************
//* Return SR mode
//*****************************************************
void dev_get_sr_mode(int *mode) {
     _startdbgProc("dev_get_sr_mode");

	long md;
	long error=0;

	//* Call to device server

	if(dev_putget(machstat , DevReadDelivery , NULL , D_VOID_TYPE , 
		          &md , D_LONG_TYPE , &error ) < 0 )
	{
		Log("dev_get_sr_mode",error);
		md=0;
	}

	*mode = md;

	/*
	switch( md ) {
	  case 1: strcpy(mdr,"USM");break;
	  case 2: strcpy(mdr,"MDT");break;
	  case 3: strcpy(mdr,"SHUTDOWN");break;
	  case 4: strcpy(mdr,"SAFETY");break;
	  case 5: strcpy(mdr,"ID TEST");break;

	  default:	
		  strcpy(mdr,"Unknown");
	}

    Cut( mdr , 12 );
	*/

  _enddbgProc();
}


//*****************************************************
//* return BM status
//*****************************************************
void dev_get_BM_status(long *status) {
    _startdbgProc("dev_get_BM_status");

	long error=0;
	DevVarLongArray larr={0,NULL};
	unsigned int i;

	//* Call to device server

	if(dev_putget(machstat , DevReadBMStatus , NULL , D_VOID_TYPE , 
		          &larr , D_VAR_LONGARR , &error ) < 0 )
	{
	  Log("dev_get_BM_status",error);
	  for(i=1;i<=32;i++)
	   status[i]=-1;
	} else {

	  for(i=0;i<larr.length;i+=2)
	    status[larr.sequence[i]]=larr.sequence[i+1];

	  if( dev_xdrfree(D_VAR_LONGARR , &larr ,&error)<0 )
	  {
	  }
	}

  _enddbgProc();
}

//*****************************************************
//* return ID status
//*****************************************************
void dev_get_ID_status(long *status) {
    _startdbgProc("dev_get_ID_status");

	long error=0;
	DevVarLongArray larr={0,NULL};
	unsigned int i;

	//* Call to device server

	if(dev_putget(machstat , DevReadIDStatus , NULL , D_VOID_TYPE , 
		          &larr , D_VAR_LONGARR , &error ) < 0 )
	{
	  Log("dev_get_ID_status",error);
	  for(i=1;i<=32;i++)
	   status[i]=-1;
	} else {

	  for(i=0;i<larr.length;i+=2)
	    status[larr.sequence[i]]=larr.sequence[i+1];

	  if( dev_xdrfree(D_VAR_LONGARR , &larr ,&error)<0 )
  	  {
	  }

	}

  _enddbgProc();
}

//******************************************************
// Update Current history
//******************************************************
void UpdateCurrentHistory()
{
    _startdbgProc("UpdateCurrentHistory");

	long error=0;
	double cur;
	long tm;
	int j,i,too_old;

	// Get current value
	if( (cur=(double)signals[0]) == 65536.0 ) 
	{ return; }

	// Get time stamp
	if(dev_putget(machstat , DevGetTime , NULL , D_VOID_TYPE , 
		          &tm , D_LONG_TYPE , &error ) < 0 )
	{
		return;
	}

	//Remove old data from history

	i=0;
	too_old=1;

	while( i<Hist_Nb && too_old )
	{
	  too_old=Hist_Tm[i]<(tm-28800);
	  if (too_old) i++;
	}

	if( i>0 ) {

	  for( j=i ; j<Hist_Nb ; j++)
	  {
	    Hist_Vl[j-i]=Hist_Vl[j];
	    Hist_Tm[j-i]=Hist_Tm[j];
	  }
	  Hist_Nb-=i;

	}

	// Add New data
	if(cur<0.0) cur=0.0;
	Hist_Vl[Hist_Nb]=(float)cur;
	Hist_Tm[Hist_Nb]=tm;

	Hist_Nb++;
  _enddbgProc();
}

//**************************************************
// Return remote system time
//**************************************************
void dev_get_sys_time(char *tm)
{
    _startdbgProc("dev_get_sys_time");

	long tme;
	char *ct;
	long error=0;

	if(dev_putget(machstat , DevGetTime , NULL , D_VOID_TYPE , 
		          &tme , D_LONG_TYPE , &error ) < 0 )
	{
	  // Get the local time
	  Log("dev_get_sys_time",error);
	  tme = time(NULL);
 	  ct=ctime((time_t *)&tme);
	  strncpy(tm,ct,16);
	  tm[16]=0;
	} else {
 	  ct=ctime((time_t *)&tme);
	  strncpy(tm,ct,16);
	  tm[16]=0;
	}

  _enddbgProc();

}

//**************************************************
// Return since message
//**************************************************
void dev_get_since(char *ret_msg)
{
    _startdbgProc("dev_get_since");
	DevString mesg=NULL;
	long error=0;
	int i;

	//* Call to device server

	if(dev_putget(machstat , DevReadSince , NULL , D_VOID_TYPE , 
		          &mesg , D_STRING_TYPE , &error ) < 0 )
	{
	  Log("dev_get_since",error);
	  sprintf(ret_msg,"Unknown");
	} else {
		strcpy(ret_msg,mesg);
		Cut(ret_msg,21);
		
		// Remove extra character
		for(i=0;i<(int)strlen(ret_msg);i++) 
			if( ret_msg[i]<32 ) ret_msg[i]=32;

		// Free string
		if( dev_xdrfree(D_STRING_TYPE , &mesg , &error)<0 )
		{
		}

	}

  _enddbgProc();
}

#include "color.h"

// Return color acording to FE status
DWORD FEcolor( long status ) {

	  switch( status )
	  {
		  
	      case  DEVOPEN:      return GREEN;
		  case  DEVCLOSE:     return WHITE;
		  case  DEVAUTOMATIC: return DARK_GREEN;
		  case  DEVFAULT:     return RED;
		  case  DEVDISABLED:  return MAGENTA;
		  case  DEVMOVING:    return BLUE;

		  default: return GREY;
	  }

}