// 
// Direct Draw Error string function
//
#include "stdafx.h"
#include <DDRAW.H>
#include <stdio.h>
#include "Log.h"

char *GetDDErrorMsg(int code) {
	_startdbgProc("GetDDErrorMsg");

	static char tmp[256];

	switch( code ) {

	case DDERR_ALREADYINITIALIZED:
		strcpy(tmp,"This object is already initialized.");
		break;

	case DDERR_CANNOTATTACHSURFACE:
		strcpy(tmp,"This surface can not be attached to the requested surface.");
		break;

	case DDERR_CANNOTDETACHSURFACE:	
		strcpy(tmp,"This surface can not be detached from the requested surface.");
		break;

	case DDERR_CURRENTLYNOTAVAIL:	
		strcpy(tmp,"Support is currently not available.");
		break;

	case DDERR_EXCEPTION:	
		strcpy(tmp,"An exception was encountered while performing the requested operation.");
		break;

	case DDERR_GENERIC:	
		strcpy(tmp,"Generic failure.");
		break;			

	case DDERR_HEIGHTALIGN:	
		strcpy(tmp,"Height of rectangle provided is not a multiple of reqd alignment");
		break;		

	case DDERR_INCOMPATIBLEPRIMARY:	
		strcpy(tmp,"Unable to match primary surface creation request with existing primary surface.");
		break;	

	case DDERR_INVALIDCAPS:	
		strcpy(tmp,"One or more of the caps bits passed to the callback are incorrect.");
		break;		

	case DDERR_INVALIDCLIPLIST:	
		strcpy(tmp,"DirectDraw does not support provided Cliplist.");
		break;			

	case DDERR_INVALIDMODE:	
		strcpy(tmp,"DirectDraw does not support the requested mode");
		break;			

	case DDERR_INVALIDOBJECT:	
		strcpy(tmp,"DirectDraw received a pointer that was an invalid DIRECTDRAW object.");
		break;			

	case DDERR_INVALIDPARAMS:	
		strcpy(tmp,"One or more of the parameters passed to the function are incorrect.");
		break;			

	case DDERR_INVALIDPIXELFORMAT:	
		strcpy(tmp,"pixel format was invalid as specified");
		break;	

	case DDERR_INVALIDRECT:	
		strcpy(tmp,"Rectangle provided was invalid.");
		break;		

	case DDERR_LOCKEDSURFACES:	
		strcpy(tmp,"Operation could not be carried out because one or more surfaces are locked");
		break;		

	case DDERR_NO3D:	
		strcpy(tmp,"There is no 3D present.");
		break;			

	case DDERR_NOALPHAHW:	
		strcpy(tmp,"Operation could not be carried out because there is no alpha accleration hardware present or available.");
		break;			

	case DDERR_NOCLIPLIST:	
		strcpy(tmp,"No clip list available");
		break;		

	case DDERR_NOCOLORCONVHW:	
		strcpy(tmp,"Operation could not be carried out because there is no color conversion hardware present or available.");
		break;		


	case DDERR_NOCOOPERATIVELEVELSET:	
		strcpy(tmp,"Create function called without DirectDraw object method SetCooperativeLevel being called.");
		break;		

	case DDERR_NOCOLORKEY:	
		strcpy(tmp,"Surface doesn't currently have a color key");
		break;			

	case DDERR_NOCOLORKEYHW:	
		strcpy(tmp,"Operation could not be carried out because there is no hardware support of the dest color key.");
		break;			

	case DDERR_NODIRECTDRAWSUPPORT:	
		strcpy(tmp,"No DirectDraw support possible with current display driver");
		break;	

	case DDERR_NOEXCLUSIVEMODE:	
		strcpy(tmp,"Operation requires the application to have exclusive mode but the application does not have exclusive mode.");
		break;		

	case DDERR_NOFLIPHW:	
		strcpy(tmp,"Flipping visible surfaces is not supported.");
		break;				

	case DDERR_NOGDI:	
		strcpy(tmp,"There is no GDI present.");
		break;			

	case DDERR_NOMIRRORHW:	
		strcpy(tmp,"Operation could not be carried out because there is no hardware present or available.");
		break;			

	case DDERR_NOTFOUND:	
		strcpy(tmp,"Requested item was not found");
		break;				

	case DDERR_NOOVERLAYHW:	
		strcpy(tmp,"Operation could not be carried out because there is no overlay hardware present or available.");
		break;			

	case DDERR_NORASTEROPHW:	
		strcpy(tmp,"Operation could not be carried out because there is no appropriate raster op hardware present or available.");
		break;			

	case DDERR_NOROTATIONHW:	
		strcpy(tmp,"Operation could not be carried out because there is no rotation hardware present or available.");
		break;		

	case DDERR_NOSTRETCHHW:	
		strcpy(tmp,"Operation could not be carried out because there is no hardware support for stretching");
		break;			

	case DDERR_NOT4BITCOLOR:	
		strcpy(tmp,"DirectDrawSurface is not in 4 bit color palette and the requested operation requires 4 bit color palette.");
		break;			

	case DDERR_NOT4BITCOLORINDEX:	
		strcpy(tmp,"DirectDrawSurface is not in 4 bit color index palette and the requested operation requires 4 bit color index palette.");
		break;			

	case DDERR_NOT8BITCOLOR:	
		strcpy(tmp,"DirectDraw Surface is not in 8 bit color mode and the requested operation equires 8 bit color.");
		break;			

	case DDERR_NOTEXTUREHW:	
		strcpy(tmp,"Operation could not be carried out because there is no texture mapping hardware present or available.");
		break;			

	case DDERR_NOVSYNCHW:	
		strcpy(tmp,"Operation could not be carried out because there is no hardware support for vertical blank synchronized operations.");
		break;				

	case DDERR_NOZBUFFERHW:	
		strcpy(tmp,"Operation could not be carried out because there is no hardware support or zbuffer blting.");
		break;			

	case DDERR_NOZOVERLAYHW:	
		strcpy(tmp,"Overlay surfaces could not be z layered based on their BltOrder because the hardware does not support z layering of overlays");
		break;		

	case DDERR_OUTOFCAPS:	
		strcpy(tmp,"The hardware needed for the requested operation has already been allocated.");
		break;				

	case DDERR_OUTOFMEMORY:	
		strcpy(tmp,"DirectDraw does not have enough memory to perform the operation.");
		break;			

	case DDERR_OUTOFVIDEOMEMORY:	
		strcpy(tmp,"DirectDraw does not have enough memory to perform the operation.");
		break;			

	case DDERR_OVERLAYCANTCLIP:	
		strcpy(tmp,"hardware does not support clipped overlays");
		break;		

	case DDERR_OVERLAYCOLORKEYONLYONEACTIVE:	
		strcpy(tmp,"Can only have ony color key active at one time for overlays");
		break;	

	case DDERR_PALETTEBUSY:	
		strcpy(tmp,"Access to this palette is being refused because the palette is already locked by another thread.");
		break;			

	case DDERR_COLORKEYNOTSET:	
		strcpy(tmp,"No src color key specified for this operation.");
		break;			

	case DDERR_SURFACEALREADYATTACHED:	
		strcpy(tmp,"This surface is already attached to the surface it is being attached to.");
		break;		


	case DDERR_SURFACEALREADYDEPENDENT:	
		strcpy(tmp,"This surface is already a dependency of the surface it is being made a dependency of.");
		break;		

	case DDERR_SURFACEBUSY:	
		strcpy(tmp,"Access to this surface is being refused because the surface is already locked by another thread.");
		break;		

	case DDERR_CANTLOCKSURFACE:	
		strcpy(tmp,"Access to this surface is being refused because no driver exists which can supply a pointer to the surface.");
		break;                  

	case DDERR_SURFACEISOBSCURED:	
		strcpy(tmp,"Access to Surface refused because Surface is obscured.");
		break;			

	case DDERR_SURFACELOST:	
		strcpy(tmp,"Access to this surface is being refused because the surface is gone.");
		break;		

	case DDERR_SURFACENOTATTACHED:	
		strcpy(tmp,"The requested surface is not attached.");
		break;	

	case DDERR_TOOBIGHEIGHT:	
		strcpy(tmp,"Height requested by DirectDraw is too large.");
		break;			

	case DDERR_TOOBIGSIZE:	
		strcpy(tmp,"Size requested by DirectDraw is too large. The individual height and width are OK.");
		break;			

	case DDERR_TOOBIGWIDTH:	
		strcpy(tmp,"Width requested by DirectDraw is too large.");
		break;		

	case DDERR_UNSUPPORTED:	
		strcpy(tmp,"Action not supported.");
		break;		

	case DDERR_UNSUPPORTEDFORMAT:	
		strcpy(tmp,"FOURCC format requested is unsupported by DirectDraw");
		break;			

	case DDERR_UNSUPPORTEDMASK:	
		strcpy(tmp,"Bitmask in the pixel format requested is unsupported by DirectDraw");
		break;			

	case DDERR_VERTICALBLANKINPROGRESS:	
		strcpy(tmp,"Vertical blank is in progress");
		break;	

	case DDERR_WASSTILLDRAWING:	
		strcpy(tmp,"Informs DirectDraw that the previous Blt which is transfering information to or from this Surface is incomplete.");
		break;			

	case DDERR_XALIGN:	
		strcpy(tmp,"Rectangle provided was not horizontally aligned on reqd. boundary");
		break;				

	case DDERR_INVALIDDIRECTDRAWGUID:	
		strcpy(tmp,"The GUID passed to DirectDrawCreate is not a valid DirectDraw driver identifier.");
		break;		

	case DDERR_DIRECTDRAWALREADYCREATED:	
		strcpy(tmp,"A DirectDraw object representing this driver has already been created for this process.");
		break;	

	case DDERR_NODIRECTDRAWHW:	
		strcpy(tmp,"A hardware only DirectDraw object creation was attempted but the driver did not support any hardware.");
		break;			

	case DDERR_PRIMARYSURFACEALREADYEXISTS:	
		strcpy(tmp,"This process already has created a primary surface");
		break;	

	case DDERR_NOEMULATION:	
		strcpy(tmp,"Software emulation not available.");
		break;			

	case DDERR_REGIONTOOSMALL:	
		strcpy(tmp,"Region passed to Clipper::GetClipList is too small.");
		break;			

	case DDERR_CLIPPERISUSINGHWND:	
		strcpy(tmp,"An attempt was made to set a clip list for a clipper object that is already monitoring an hwnd.");
		break;	

	case DDERR_NOCLIPPERATTACHED:	
		strcpy(tmp,"No clipper object attached to surface object");
		break;			

	case DDERR_NOHWND:	
		strcpy(tmp,"Clipper notification requires an HWND or no HWND has previously been set as the CooperativeLevel HWND.");
		break;			

	case DDERR_HWNDSUBCLASSED:	
		strcpy(tmp,"HWND used by DirectDraw CooperativeLevel has been subclassed, this prevents DirectDraw from restoring state.");
		break;		

	case DDERR_HWNDALREADYSET:	
		strcpy(tmp,"The CooperativeLevel HWND has already been set. It can not be reset while the process has surfaces or palettes created.");
		break;			

	case DDERR_NOPALETTEATTACHED:	
		strcpy(tmp,"No palette object attached to this surface.");
		break;			

	case DDERR_NOPALETTEHW:	
		strcpy(tmp,"No hardware support for 16 or 256 color palettes.");
		break;			

	case DDERR_BLTFASTCANTCLIP:	
		strcpy(tmp,"If a clipper object is attached to the source surface passed into a BltFast call.");
		break;			

	case DDERR_NOBLTHW:	
		strcpy(tmp,"No blter.");
		break;				

	case DDERR_NODDROPSHW:	
		strcpy(tmp,"No DirectDraw ROP hardware.");
		break;			

	case DDERR_OVERLAYNOTVISIBLE:	
		strcpy(tmp,"GetOverlayPosition is called on a hidden overlay");
		break;			

	case DDERR_NOOVERLAYDEST:	
		strcpy(tmp,"GetOverlayPosition is called on a overlay that UpdateOverlay has never been called on to establish a destionation.");
		break;			

	case DDERR_INVALIDPOSITION:	
		strcpy(tmp,"Position of the overlay on the destionation is no longer legal for that destionation.");
		break;			

	case DDERR_NOTAOVERLAYSURFACE:	
		strcpy(tmp,"Overlay member is called for a non-overlay surface");
		break;		

	case DDERR_EXCLUSIVEMODEALREADYSET:	
		strcpy(tmp,"An attempt was made to set the cooperative level when it was already set to exclusive.");
		break;		

	case DDERR_NOTFLIPPABLE:	
		strcpy(tmp,"An attempt has been made to flip a surface that is not flippable.");
		break;		

	case DDERR_CANTDUPLICATE:	
		strcpy(tmp,"Can't duplicate primary & 3D surfaces, or surfaces that are implicitly created.");
		break;			

	case DDERR_NOTLOCKED:	
		strcpy(tmp,"Surface was not locked.  An attempt to unlock a surface that was not locked at all, or by this process, has been attempted.");
		break;				

	case DDERR_CANTCREATEDC:	
		strcpy(tmp,"Windows can not create any more DCs");
		break;		

	case DDERR_NODC:	
		strcpy(tmp,"No DC was ever created for this surface.");
		break;			

	case DDERR_WRONGMODE:	
		strcpy(tmp,"This surface can not be restored because it was created in a different mode.");
		break;				

	case DDERR_IMPLICITLYCREATED:	
		strcpy(tmp,"This surface can not be restored because it is an implicitly created surface.");
		break;		

	case DDERR_NOTPALETTIZED:	
		strcpy(tmp,"The surface being used is not a palette-based surface");
		break;		

	case DDERR_UNSUPPORTEDMODE:	
		strcpy(tmp,"The display is currently in an unsupported mode");
		break;			

	case DDERR_NOMIPMAPHW:	
		strcpy(tmp,"Operation could not be carried out because there is no mip-map texture mapping hardware present or available.");
		break;			

	case DDERR_INVALIDSURFACETYPE:	
		strcpy(tmp,"The requested action could not be performed because the surface was of the wrong type.");
		break;                

	case DDERR_DCALREADYCREATED:	
		strcpy(tmp,"A DC has already been returned for this surface. Only one DC can be retrieved per surface.");
		break;		

	case DDERR_CANTPAGELOCK:	
		strcpy(tmp,"The attempt to page lock a surface failed.");
		break;		

	case DDERR_CANTPAGEUNLOCK:	
		strcpy(tmp,"The attempt to page unlock a surface failed.");
		break;		

	case DDERR_NOTPAGELOCKED:	
		strcpy(tmp,"An attempt was made to page unlock a surface with no outstanding page locks.");
		break;			

	case DDERR_NOTINITIALIZED:	
		strcpy(tmp,"An attempt was made to invoke an interface member of a DirectDraw object created by CoCreateInstance() before it was initialized.");
		break;              

    default :
		sprintf(tmp,"Unknown error number %d",code);
		break;
	}

	_enddbgProc();
	return tmp;
}
