/*================================================================
 *
 *  File:       gui.cpp
 *  Author:		JL PONS
 *  Project:	CTRM Video synopsis
 *  Content:    Animation routines
 *  Date:		June 1998
 *
 ******************************************************************/
#undef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#include "stdafx.h"
#include <ddraw.h>
#include "anim.h"
#include "graphics.h"
#include <stdio.h>
#include <math.h>
#include "Log.h"

#define PI 3.141592653589

extern char *GetDDErrorMsg(int code);

static WORD  f_prog[800*2];
static PIXEL src1[800*600];
static PIXEL src2[800*600];
static PIXEL dst[800*600];
static BYTE  fx[800*600];


extern void  asm_fade(BYTE *src1,BYTE *src2,BYTE *dst,int pos,int h,WORD *f_prog);
extern void  asm_fade2(BYTE *src1,BYTE *src2,BYTE *dst,WORD t,int h);
extern void  asm_fade3(BYTE *src1,BYTE *src2,BYTE *dst,BYTE *fx,WORD t);


//****************************************
// Scrool img1 to img2
// int frame                : frame number
// LPDIRECTDRAWSURFACE lpDD : Surface 
// HBM img1					: 1rst image
// HBM img2					: 2nd image
//****************************************
void hscrolling_step(int frame,
					 LPDIRECTDRAWSURFACE lpDD , 
			         HBITMAP img1 , HBITMAP img2 ,
					 int y,int h)
{
	int i;
	i = frame * 20;

	HDC hdc_dest;
	HDC hdc_src;

    hdc_src = CreateCompatibleDC( NULL );
    if ( lpDD->GetDC(&hdc_dest) == DD_OK)
	{
	  // Blit fist image
	  SelectObject( hdc_src, img1);
	  BitBlt( hdc_dest,i,y,800-i,h, 
		      hdc_src,0,0, SRCCOPY );

	  // Blit second image
	  SelectObject( hdc_src, img2);
	  BitBlt( hdc_dest,0,y,i,h, 
		      hdc_src,800-i,0, SRCCOPY );

	  lpDD->ReleaseDC(hdc_dest);
	}
    DeleteDC(hdc_src);

}


//****************************************
// Vetrical Scrool img1 to img2
// int frame                : frame number
// LPDIRECTDRAWSURFACE lpDD : Surface 
// HBM img1					: 1rst image
// HBM img2					: 2nd image
//****************************************
void vscrolling_step(int frame,
					LPDIRECTDRAWSURFACE lpDD , 
			        HBITMAP img1 , HBITMAP img2 )
{
	static int vpos;
	HDC hdc_dest;
	HDC hdc_src;

	if(frame == 0 ) {
		vpos=300;
	} else {
		if( frame % 2 ) vpos -= 8;
		else            vpos -= 7;
	}


    hdc_src = CreateCompatibleDC( NULL );
    if ( lpDD->GetDC(&hdc_dest) == DD_OK)
	{
	  // Blit first image
	  SelectObject( hdc_src, img1);
	  BitBlt( hdc_dest,0,300,800,vpos, 
		      hdc_src,0,300-vpos, SRCCOPY );

	  // Blit second image
	  SelectObject( hdc_src, img2);
	  BitBlt( hdc_dest,0,300+vpos,800,300-vpos, 
		      hdc_src,0,0, SRCCOPY );

	  lpDD->ReleaseDC(hdc_dest);
	}
    DeleteDC(hdc_src);

}

//****************************************
// Scrool (scan_line) img1 to img2
// int frame     : frame number
// LPDIRECTDRAWSURFACE lpDD : Surface 
// HBM img1					: 1rst image
// HBM img2					: 2nd image
//****************************************
void scan_scrolling_step(int frame,
					     LPDIRECTDRAWSURFACE lpDD , 
			             HBITMAP img1 , HBITMAP img2 )
{
	int i,j;
	HDC hdc_dest;
	HDC hdc_src;
	
	i=frame*20;

    hdc_src = CreateCompatibleDC( NULL );
    if ( lpDD->GetDC(&hdc_dest) == DD_OK)
	{

	  for(j=0 ; j < 300 ; j+=2 )
	  {
	    if( (j/2) % 2 ) {

	      // Blit first image
	      SelectObject( hdc_src, img1);
	      BitBlt( hdc_dest,i,300+j,800-i,2, 
		          hdc_src,0,j, SRCCOPY );
		  
		  // Blit second image
	      SelectObject( hdc_src, img2);
	      BitBlt( hdc_dest,0,300+j,i,2, 
		          hdc_src,800-i,j, SRCCOPY );

		} else {

		  // Blit first image
		  SelectObject( hdc_src, img1);
	      BitBlt( hdc_dest,0,300+j,800-i,2, 
		          hdc_src,i,j, SRCCOPY );
		
		  // Blit second image
	      SelectObject( hdc_src, img2);
	      BitBlt( hdc_dest,800-i,300+j,i,2, 
		          hdc_src,0,j, SRCCOPY );

		}

	  }
	  lpDD->ReleaseDC(hdc_dest);

	}
    DeleteDC(hdc_src);

}

//****************************************
// Go to img2 from img1 radomly
// int frame                : frame number
// LPDIRECTDRAWSURFACE lpDD : Surface 
// HBM img1					: 1rst image
// HBM img2					: 2nd image
//****************************************
unsigned short permutx[9600];
unsigned short permuty[9600];

void random_init()
{
	int i,j,k;
	unsigned short tx,ty;
	
	// Initialise permut arrays

	k=0;
	for(i=0;i<160;i++)
	  for(j=0;j<60;j++)
	  {
		  permutx[k]=i*5;
		  permuty[k]=j*5;
		  k++;
	  }

	// do some randow swap
	// to make a permutation

	for(i=0;i<9600;i++)
	{
		k=rand() % 9600;

		tx=permutx[i];
		ty=permuty[i];

		permutx[i]=permutx[k];
		permuty[i]=permuty[k];

		permutx[k]=tx;
		permuty[k]=ty;
	}

}

void random_step(int frame,
				 LPDIRECTDRAWSURFACE lpDD , 
			     HBITMAP img1 , HBITMAP img2 , int y)
{
	int i,o,k;
	HDC hdc_dest;
	HDC hdc_src;
	int h=600;
	if(y==300) h=300;

	if(frame==0) {
		random_init();
      
		hdc_src = CreateCompatibleDC( NULL );
        if ( lpDD->GetDC(&hdc_dest) == DD_OK)
		{
	      // Blit first image
	      SelectObject( hdc_src, img1);
	      BitBlt( hdc_dest,0,y,800,h, 
		       hdc_src,0,0, SRCCOPY );
	      lpDD->ReleaseDC(hdc_dest);
        }
        DeleteDC(hdc_src);

	} else if(frame==1) {

		hdc_src = CreateCompatibleDC( NULL );
        if ( lpDD->GetDC(&hdc_dest) == DD_OK)
		{
	      // Blit first image
	      SelectObject( hdc_src, img1);
	      BitBlt( hdc_dest,0,y,800,h, 
		       hdc_src,0,0, SRCCOPY );

          SelectObject( hdc_src, img2);

		  for(i=y,o=0;i<600;i+=300,o+=300)
		    for( k=0 ; k<240 ; k++)
	          BitBlt( hdc_dest,permutx[k],permuty[k]+i,5,5, 
		        hdc_src,permutx[k],permuty[k]+o, SRCCOPY );

	      lpDD->ReleaseDC(hdc_dest);
        }
        DeleteDC(hdc_src);
	
	
	} else {

        hdc_src = CreateCompatibleDC( NULL );
        if ( lpDD->GetDC(&hdc_dest) == DD_OK)
		{
	      // Blit second image
          SelectObject( hdc_src, img2);
		  for(i=y,o=0;i<600;i+=300,o+=300)
	        for( k=(frame-2)*240 ; k<frame*240 ; k++)
	          BitBlt( hdc_dest,permutx[k],permuty[k]+i,5,5,
		        hdc_src,permutx[k],permuty[k]+o, SRCCOPY );

	      lpDD->ReleaseDC(hdc_dest);
		}
        DeleteDC(hdc_src);

	}

}

//****************************************
// Scrool (scan_line) img1 to img2
// int frame     : frame number
// LPDIRECTDRAWSURFACE lpDD : Surface 
// HBM img1					: 1rst image
// HBM img2					: 2nd image
//****************************************
int linepos[40];

void scan_scrolling2_step(int frame,int height,
		  				  LPDIRECTDRAWSURFACE lpDD , 
						  HBITMAP img1 , HBITMAP img2 )
{
	int i,j;
	HDC hdc_dest;
	HDC hdc_src;
	int nbl = height / 15;

	if(frame==0) 
      for(i=0;i<nbl;i++) linepos[i]=0;

	hdc_src = CreateCompatibleDC( NULL );
    if ( lpDD->GetDC(&hdc_dest) == DD_OK)
	{
	
	  for(j=0 ; j < nbl ; j++ )
	  {

		// Draw fisrt part of img2
		SelectObject( hdc_src, img2);
	       BitBlt( hdc_dest,0,j*15+(600-height),linepos[j],15, 
		           hdc_src,400-linepos[j],j*15, SRCCOPY );


		// Draw img1
		SelectObject( hdc_src, img1);
	       BitBlt( hdc_dest,linepos[j],j*15+(600-height),2*(400-linepos[j]),15, 
		           hdc_src,linepos[j],j*15, SRCCOPY );


		// Draw second part of img2
		SelectObject( hdc_src, img2);
	       BitBlt( hdc_dest,800-linepos[j],j*15+(600-height),linepos[j],15, 
		           hdc_src,400,j*15, SRCCOPY );


	  }
	  lpDD->ReleaseDC(hdc_dest);
    }
    DeleteDC(hdc_src);

	// Imcrement linepos

	for( i=0 ; i<20 ; i++ )
	  if( frame>=20-i && frame<40-i ) linepos[i]+=20;

	for( i=20 ; i<nbl ; i++ )
	  if( frame>=40-i && frame<60-i ) linepos[59-i]+=20;

}

//****************************************
// Scrool img1 to img2
// int frame     : frame number
// LPDIRECTDRAWSURFACE lpDD : Surface 
// HBM img1					: 1rst image
// HBM img2					: 2nd image
//****************************************
void hscrolling2_step(int frame,
 		  				  LPDIRECTDRAWSURFACE lpDD , 
						  HBITMAP img1 , HBITMAP img2 )
{
	int i;
	i = frame * 10;

	HDC hdc_dest;
	HDC hdc_src;

	hdc_src = CreateCompatibleDC( NULL );
    if ( lpDD->GetDC(&hdc_dest) == DD_OK)
	{
	  // Draw img1
	  SelectObject( hdc_src, img1);
	       BitBlt( hdc_dest,i,300,800-2*i,300, 
		           hdc_src,i,0, SRCCOPY );

	  // Draw fisrt part of img2
	  SelectObject( hdc_src, img2);
	       BitBlt( hdc_dest,0,300,i,300, 
		           hdc_src,400-i,0, SRCCOPY );

	  // Draw second part of img2
	  SelectObject( hdc_src, img2);
	       BitBlt( hdc_dest,800-i,300,i,300, 
		           hdc_src,400,0, SRCCOPY );

	  lpDD->ReleaseDC(hdc_dest);
    }
    DeleteDC(hdc_src);

}

//****************************************
// Scrool img1 to img2
// int frame     : frame number
// LPDIRECTDRAWSURFACE lpDD : Surface 
// HBM img1					: 1rst image
// HBM img2					: 2nd image
//****************************************
void vscrolling2_step(int frame,
 		  			  LPDIRECTDRAWSURFACE lpDD , 
					  HBITMAP img1 , HBITMAP img2 )					
{
	static int vpos;

	if(frame == 0 ) {
		vpos=0;
	} else {
		if( (frame % 4) == 3) vpos += 3;
		else                  vpos += 4;
	}

	HDC hdc_dest;
	HDC hdc_src;

	hdc_src = CreateCompatibleDC( NULL );
    if ( lpDD->GetDC(&hdc_dest) == DD_OK)
	{
	  // Draw img1
	  SelectObject( hdc_src, img1);
	       BitBlt( hdc_dest,0,300+vpos,800,300-2*vpos, 
		           hdc_src,0,vpos, SRCCOPY );

	  // Draw fisrt part of img2
	  SelectObject( hdc_src, img2);
	       BitBlt( hdc_dest,0,300,800,vpos, 
		           hdc_src,0,150-vpos, SRCCOPY );

	  // Draw second part of img2
	  SelectObject( hdc_src, img2);
	       BitBlt( hdc_dest,0,600-vpos,800,vpos, 
		           hdc_src,0,150, SRCCOPY );

	  lpDD->ReleaseDC(hdc_dest);
    }
    DeleteDC(hdc_src);

}

//****************************************
// Go to img2 from img1 by quater square
// int frame     : frame number
// LPDIRECTDRAWSURFACE lpDD : Surface 
// HBM img1					: 1rst image
// HBM img2					: 2nd image
//****************************************
void square_step(int frame,
  				  LPDIRECTDRAWSURFACE lpDD , 
				  HBITMAP img1 , HBITMAP img2 )
{
	static int vpos;
	static int xpos;
	HDC hdc_dest;
	HDC hdc_src;

	if(frame == 0 ) {
		vpos=0;
		xpos=0;
	} else {
		if( (frame % 4) == 3) vpos += 3;
		else                  vpos += 4;
		xpos+=10;
	}


	hdc_src = CreateCompatibleDC( NULL );
    if ( lpDD->GetDC(&hdc_dest) == DD_OK)
	{
	  if( frame<2 ) {
	    // Draw img1
	    SelectObject( hdc_src, img1);
	       BitBlt( hdc_dest,0,300,800,300, 
		           hdc_src,0,0, SRCCOPY );
	  }

	  // Draw top left of img2
	  SelectObject( hdc_src, img2);
	       BitBlt( hdc_dest,0,300,xpos,vpos, 
		           hdc_src,400-xpos,150-vpos, SRCCOPY );

	  // Draw top right of img2
	       BitBlt( hdc_dest,800-xpos,300,xpos,vpos, 
		           hdc_src,400,150-vpos, SRCCOPY );

	  // Draw bottom left of img2
	       BitBlt( hdc_dest,0,600-vpos,xpos,vpos, 
		           hdc_src,400-xpos,150, SRCCOPY );

	  // Draw bottom right of img2
	       BitBlt( hdc_dest,800-xpos,600-vpos,xpos,vpos, 
		           hdc_src,400,150, SRCCOPY );

	  lpDD->ReleaseDC(hdc_dest);
    }
    DeleteDC(hdc_src);


}

//****************************************
// Go to img2 from img1 by stretching img2
// int frame     : frame number
// LPDIRECTDRAWSURFACE lpDD : Surface 
// HBM img1					: 1rst image
// HBM img2					: 2nd image
//****************************************
void strech_step(int frame,
  				  LPDIRECTDRAWSURFACE lpDD , 
				  HBITMAP img1 , HBITMAP img2 )
{
	static int vpos;
	static int xpos;
	HDC hdc_dest;
	HDC hdc_src;

	if(frame == 0 ) {
		vpos=0;
		xpos=0;
	} else {
		if( (frame % 4) == 3) vpos += 3;
		else                  vpos += 4;
		xpos+=10;
	}


	hdc_src = CreateCompatibleDC( NULL );
    if ( lpDD->GetDC(&hdc_dest) == DD_OK)
	{
	  if( frame<2 ) {
	    // Draw img1
	    SelectObject( hdc_src, img1);
	       BitBlt( hdc_dest,0,300,800,300, 
		           hdc_src,0,0, SRCCOPY );
	  }

	  // Strech img2
	  SetStretchBltMode( hdc_src , HALFTONE );
	  SelectObject( hdc_src, img2);
	       StretchBlt( hdc_dest,400-xpos,450-vpos,2*xpos,2*vpos, 
		               hdc_src,0,0,800,300, SRCCOPY );

	  lpDD->ReleaseDC(hdc_dest);
    }
    DeleteDC(hdc_src);

}


//****************************************
// Go to img2 from img1 squares
// int frame     : frame number
// LPDIRECTDRAWSURFACE lpDD : Surface 
// HBM img1					: 1rst image
// HBM img2					: 2nd image
//****************************************
int posx[40]={0,1,2,3,4,5,6,7,8,9,9,8,7,6,5,4,3,2,1,0,0,0,1,2,4,5,7,8,9,9,8,7,5,4,2,1,3,3,6,6 };
int posy[40]={0,1,2,3,2,1,0,1,2,3,0,1,2,3,2,1,0,1,2,3,1,2,3,3,3,3,3,3,2,1,0,0,0,0,0,0,1,2,2,1 };


void square2_step(int frame,
  				  LPDIRECTDRAWSURFACE lpDD , 
				  HBITMAP img1 , HBITMAP img2 )
{

	HDC hdc_dest;
	HDC hdc_src;

	hdc_src = CreateCompatibleDC( NULL );
    if ( lpDD->GetDC(&hdc_dest) == DD_OK)
	{

	  if( frame==0 ) {
	    // Draw img1
	    SelectObject( hdc_src, img1);
	       BitBlt( hdc_dest,0,300,800,300, 
		           hdc_src,0,0, SRCCOPY );
	  } else if ( frame==1 ) {
	    // Draw img1
	    SelectObject( hdc_src, img1);
	       BitBlt( hdc_dest,0,300,800,300, 
		           hdc_src,0,0, SRCCOPY );

	    // Draw img2
	    SelectObject( hdc_src, img2);
	       BitBlt( hdc_dest,80*posx[0],75*posy[0]+300,80,75, 
		               hdc_src,80*posx[0],75*posy[0], SRCCOPY );
      } else {
	    // Draw img2
	    SelectObject( hdc_src, img2);
	       BitBlt( hdc_dest,80*posx[frame-2],75*posy[frame-2]+300,80,75, 
		               hdc_src,80*posx[frame-2],75*posy[frame-2], SRCCOPY );
	    // Draw img2
	    SelectObject( hdc_src, img2);
	       BitBlt( hdc_dest,80*posx[frame-1],75*posy[frame-1]+300,80,75, 
		               hdc_src,80*posx[frame-1],75*posy[frame-1], SRCCOPY );

	  }

	  lpDD->ReleaseDC(hdc_dest);

    }
    DeleteDC(hdc_src);

}

// **********************************************************
// fading
// **********************************************************


void progfading_step(int frame,int height,
  			  	     LPDIRECTDRAWSURFACE lpDDs , 
				     HBITMAP img1 , HBITMAP img2 )
{
	int i;

	if( frame==0 ) {
		
		// Get bitmap data
		#ifdef _24BITS
		GetBitmapBits(img1,800*height*3,(void *)(src1) );
		GetBitmapBits(img2,800*height*3,(void *)(src2) );
        #else
		GetBitmapBits(img1,800*height*4,(void *)(src1) );
		GetBitmapBits(img2,800*height*4,(void *)(src2) );
        #endif		
		
		// Initialise fading function
		for (i=0;i<800*2;i++ )
		{
			if( i<=800 )      f_prog[i] = 0x0100;
			else if (i<=950)  f_prog[i] = (WORD)( ( cos((double)(i-800)*PI/150.0)+1.0 )*128.0 );
			else              f_prog[i] = 0x0000;
		}
		
	}


	if(frame<40) {
	  asm_fade( (BYTE *)src1,(BYTE *)src2,(BYTE *)dst, (20*frame) , height , f_prog );
      FillSurface(lpDDs,dst,0,600-height,800,height);
	} else {
      FillSurface(lpDDs,src2,0,600-height,800,height);
	}

}

void fading_step(int frame,
  		  	     LPDIRECTDRAWSURFACE lpDDs , 
			     HBITMAP img1 , HBITMAP img2 , int h )
{

	if( frame==0 ) {
		
		// Get bitmap data
		#ifdef _24BITS
		GetBitmapBits(img1,800*h*3,(void *)(src1) );
		GetBitmapBits(img2,800*h*3,(void *)(src2) );
        #else
		GetBitmapBits(img1,800*h*4,(void *)(src1) );
		GetBitmapBits(img2,800*h*4,(void *)(src2) );
        #endif		
				
	}


	if(frame<40) {
	  asm_fade2( (BYTE *)src1,(BYTE *)src2,(BYTE *)dst, (WORD)((double)frame/40.0*256.0) , h );
      FillSurface(lpDDs,dst,0,(h==300)?300:0,800,h);
	} else {
      FillSurface(lpDDs,src2,0,(h==300)?300:0,800,h);
	}

}


//**********************************************
// Get HBM from a DD surface
//**********************************************
long GetData( HBITMAP *hbm , LPDIRECTDRAWSURFACE lpDD , int y , int h )
{
  HRESULT dderr;
  HDC hdc_src;
  HDC hdc_dest;

  hdc_dest = CreateCompatibleDC( NULL );

  if ((dderr = lpDD->GetDC(&hdc_src)) == DD_OK)
  {
	  SelectObject( hdc_dest, *hbm);
	  BitBlt( hdc_dest,0,0,800,h, 
		      hdc_src,0,y, SRCCOPY );
	  lpDD->ReleaseDC(hdc_src);
  }

  DeleteDC(hdc_dest);

  return dderr;
}

//*********************************************************
// Make a transition between two buffer (front and back)
// Full screen mode
//*********************************************************
long anim_full_transition()
{
  int frame;
  static int n_anim=0;
  long err = DD_OK;

  HBITMAP img1;
  HBITMAP img2;

  //********************************
  // Memory front and back buffer
  //********************************
  
  #ifdef _24BITS
    img1 = CreateBitmap(800 , 600 , 1 , 24 ,NULL);
    img2 = CreateBitmap(800 , 600 , 1 , 24 ,NULL);
  #else 
    img1 = CreateBitmap(800 , 600 , 1 , 32 ,NULL);
    img2 = CreateBitmap(800 , 600 , 1 , 32 ,NULL);
  #endif

  EK(err) err=GetData( &img1 , lpDDSPrimary , 0 , 600);
  EK(err) err=GetData( &img2 , lpDDSBack    , 0 , 600);

  if( err!=DD_OK ) return err;

  for( frame=0 ; frame<=40 ; frame++ )
  {

	// Make animation on back buffer
	
	switch(n_anim) {
	case 0:
      scan_scrolling2_step(frame,600,lpDDSBack,img1,img2);
	  break;
	case 1:
      random_step(frame,lpDDSBack,img1,img2,0);
	  break;
	case 2:
      fading_step(frame,lpDDSBack,img1,img2,600);
	  break;
	case 3:
      hscrolling_step(frame,lpDDSBack,img1,img2,0,600);
	  break;
	case 4:
  	  progfading_step(frame,600,lpDDSBack,img1,img2);
	  break;

	}

    lpDDSPrimary->Flip( NULL, DDFLIP_WAIT  );
  }

  DeleteObject(img1);
  DeleteObject(img2);

  n_anim++;
  if(n_anim>=5) n_anim=0;

  return DD_OK;

}


//*********************************************************
// Make a transition between two buffer (front and back)
//*********************************************************
long anim_transition()
{
  _startdbgProc("anim_transition");

  int frame;
  static int n_anim=0;
  long err = DD_OK;

  HBITMAP img1;
  HBITMAP img2;

  //********************************
  // Memory front and back buffer
  //********************************
	
  #ifdef _24BITS
    img1 = CreateBitmap(800 , 300 , 1 , 24 ,NULL);
    img2 = CreateBitmap(800 , 300 , 1 , 24 ,NULL);
  #else 
    img1 = CreateBitmap(800 , 300 , 1 , 32 ,NULL);
    img2 = CreateBitmap(800 , 300 , 1 , 32 ,NULL);
  #endif

  EK(err) err=GetData( &img1 , lpDDSPrimary , 300 , 300);
  EK(err) err=GetData( &img2 , lpDDSBack    , 300 , 300);

  if( err!=DD_OK ) {
    _enddbgProc();
	return err;
  }

  for( frame=0 ; frame<=40 ; frame++ )
  {

	// Make animation on back buffer
	
	switch(n_anim) {
	case 0:
      random_step(frame,lpDDSBack,img1,img2,300);
	  break;

	case 1:
      fading_step(frame,lpDDSBack,img1,img2,300);
	  break;

	case 2:
      vscrolling2_step(frame,lpDDSBack,img1,img2);
	  break;
	
	case 3:
      scan_scrolling2_step(frame,300,lpDDSBack,img1,img2);
	  break;
	
	case 4:
      hscrolling2_step(frame,lpDDSBack,img1,img2);
	  break;
	
	case 5:
      square_step(frame,lpDDSBack,img1,img2);
	  break;
	
	case 6:
  	  progfading_step(frame,300,lpDDSBack,img1,img2);
	  break;

	case 7:
      strech_step(frame,lpDDSBack,img1,img2);
	  break;

	case 8:
      square2_step(frame,lpDDSBack,img1,img2);
	  break;

	case 9:
      vscrolling_step(frame,lpDDSBack,img1,img2);
	  break;

	case 10:
      hscrolling_step(frame,lpDDSBack,img1,img2,300,300);
	  break;

	case 11:
      scan_scrolling_step(frame,lpDDSBack,img1,img2);
	  break;

	}

    lpDDSPrimary->Flip( NULL, DDFLIP_WAIT  );
  }

  DeleteObject(img1);
  DeleteObject(img2);

  n_anim++;
  if(n_anim>=11) n_anim=0;

  _enddbgProc();
  return DD_OK;
}
