#include "stdafx.h"
#include "Log.h"

#define LOG1_NAME "c:\\synopsis1.log"
#define LOG2_NAME "c:\\synopsis2.log"
#define LOG3_NAME "c:\\synopsis3.log"

FILE *logFile;
char *stack[1000];
int  nb_proc=0;

void Log(char *msg,long code) {

	time_t now = time(NULL);
	char tmp[128];
	strcpy(tmp,ctime(&now));
	tmp[24]=0;

	logFile=fopen(LOG1_NAME,"a");
	if(logFile) {
	  if(code!=0) fprintf(logFile,"%s:%s failed with %d\n",tmp,msg,code);
	  else        fprintf(logFile,"%s:%s\n",tmp,msg);
	  fclose(logFile);
	}

}

void InitLog() {
	// Rotate log
	remove(LOG3_NAME);
	rename(LOG2_NAME,LOG3_NAME);
	rename(LOG1_NAME,LOG2_NAME);
	Log("video synopsis started",0);
}

void _startdbgProc(char *name) {
  if( nb_proc<1000 ) {
    stack[nb_proc]=strdup(name);
    nb_proc++;
  }
}

void _enddbgProc() {
  if( nb_proc>1 ) {
    nb_proc--;
    free(stack[nb_proc]);
  }
}

char *stackDump() {
  int i;
  
  char tmp[65536];
  strcpy(tmp,"Stack dump:\n");
  for(i=0;i<nb_proc;i++) {
    strcat(tmp,stack[i]);
	strcat(tmp,"\n");
  }

  return strdup(tmp);
}