proc WhichDevCmd { device } {
##############################################################################
# NAME:     WhichDevCmd display a formated list of cmds, argin, argout of an exported device
# SYNOPSIS: WhichDevCmd device_name
# DESCRIPTION: send a " dev_io status error $device_name ? " that will 
#                   send a cmd_querry to this device
#              Output of dev_io (a list) is formatted to be readable
#              The result is displayed into the xterm from which this command was initiated
# ARGIN:    device; a device name that should already be exported
# ARGOUT:   None
# RETURN:   None
# ERROR :   errors detected by cmd_querry are displayed 
# GLOBAL_CREATED: None
# SEE ALSO: 
##############################################################################

set cmds [dev_io status error $device ?]
if { $status != 0} {
  puts "cmd_querry failed: $error"
  return
}


# calculate the length max for the 1st field (cmd name)
set maxfield1 0
for {set i 0} {$i <= [expr [llength $cmds] -3]} {incr i 3} {
  set lfield [string length [lindex $cmds $i]]
  if { $lfield >= $maxfield1 } {
    set maxfield1 $lfield
}
}
incr maxfield1 2


# calculate the length max for the 2nd field (argin )
set maxfield2 0
for {set i 1} {$i <= [expr [llength $cmds] -2]} {incr i 3} {
  set lfield [string length [lindex $cmds $i]]
  if { $lfield >= $maxfield2 } {
    set maxfield2 $lfield
}
}
incr maxfield2 2

# calculate the length max for the 3rd field (argout)
set maxfield3 0
for {set i 2} {$i <= [expr [llength $cmds] -1]} {incr i 3} {
  set lfield [string length [lindex $cmds $i]]
  if { $lfield >= $maxfield3 } {
    set maxfield3 $lfield
}
}
incr maxfield3 2



puts [format "%-[subst $maxfield1]s%-[subst $maxfield2]s%-[subst $maxfield3]s" \
              cmd_name argin_type argout_type]
set max_tot [expr $maxfield1 + $maxfield2 + $maxfield3 -2]
set tiret =
for {set i 1} {$i <= $max_tot} {incr i} {
  puts -nonewline $tiret
}
puts " "
for {set i  0} {$i <=[llength $cmds] } {incr i 3} {
  set j $i
  puts -nonewline [format "%-[subst $maxfield1]s" [lindex $cmds $j]]  ; incr j
  puts -nonewline [format "%-[subst $maxfield2]s" [lindex $cmds $j]]  ; incr j
  puts [format "%-[subst $maxfield3]s" [lindex $cmds $j]]; incr j
}



} ;# ends proc WhichDevCmd

### Create the packge rrap
package provide rrap 2.3
