proc ShowProc { procname} {
#+############################################################################
#NAME:     ShowProc. Print the body and default args of a procedure
#SYNOPSIS: ShowProc procedure_name
#DESCRIPTION: This procedure lists the definition of the requested procedure
#             and the default values of arguments if any. If the procedure
#             is not already loaded, then loads it. 
#ARGIN:    The name of the procedure to be listed
#ARGOUT:   NONE
#RETURN:   NONE
#ERROR :   If the procedure is not reachable then print:
#          "procedure_name" isn't a procedure  
#GLOBAL_CREATED: NONE
#GLOBAL_USED: NONE
#GLOBAL_MODIFIED: NONE
#SEE ALSO: ListProc
#SOURCE FILE:
#AUTHOR: G. Pepellin (adaptation of a contribution from Lance Ellinghouse
#        who wrote it using Tcl extended capabilities)
#$Date: 98/08/03 11:54:10 $
#$Revision: 2.3 $
#-############################################################################

 set l [ info procs $procname ]
  if { [llength $l] == 0 } {
    auto_load $procname
  }
	set arglist [info args $procname]
	set nargs {}
	while {[llength $arglist] > 0} {
		set varg [lindex $arglist 0]
		set arglist [lreplace $arglist 0 0 ]
		if [info default $procname $varg defarg] {
			set nargs [format {%s \{%s %s\}} $nargs $varg $defarg]
		} else {
			set nargs [format {%s %s} $nargs $varg]
		}
	} ;# ends while loop
#    format "proc %s \{%s\} \{%s\}\n" $procname $nargs [info body $procname]
     puts [format "proc %s \{%s\} \{%s\}\n" $procname $nargs [info body $procname]]
} ;# ends proc ShowProc


proc getProcSource { procname} {
#+############################################################################
#NAME:     getProcSource. 
#SYNOPSIS: getProcSource procedure_name
#DESCRIPTION: Derived from ShowProc but put the source code into a returned
#             list rather than printing it. 
#ARGIN:    The name of the procedure to be listed
#ARGOUT:   NONE
#RETURN:   NONE
#ERROR :   If the procedure is not reachable then print:
#          "procedure_name" isn't a procedure  
#GLOBAL_CREATED: NONE
#GLOBAL_USED: NONE
#GLOBAL_MODIFIED: NONE
#SEE ALSO: ListProc
#SOURCE FILE:
#AUTHOR: G. Pepellin (adaptation of a contribution from Lance Ellinghouse
#        who wrote it using Tcl extended capabilities)
#$Date: 98/08/03 11:54:10 $
#$Revision: 2.3 $
#-############################################################################
global MAIN_APPL_NAME
 set l [ info procs $procname ]
  if { [llength $l] == 0 } {
    auto_load $procname
  }
	set arglist [info args $procname]
	set nargs {}
	while {[llength $arglist] > 0} {
		set varg [lindex $arglist 0]
		set arglist [lreplace $arglist 0 0 ]
		if [info default $procname $varg defarg] {
			set nargs [format {%s \{%s %s\}} $nargs $varg $defarg]
		} else {
			set nargs [format {%s %s} $nargs $varg]
		}
	} ;# ends while loop
  # first put the result into a temp fi;e
  set fname /tmp/$MAIN_APPL_NAME.help.[pid]
  catch {exec rm -f $fname}
  set fid [open $fname w]
  puts $fid [format "proc %s \{%s\} \{%s\}\n" $procname $nargs [info body $procname]]
    set l [lappend toto]
  close $fid
  # read the tmp file to buid a well formed Tcl list
  set fid [open $fname r]
  while { [gets $fid line] >= 0} {
    lappend l $line
  }
  close $fid
  return $l
} ;# ends proc getProcSource


proc PublicTclProcs {} {
#+############################################################################
#NAME: PublicTclProcs  lists the public procedures (starting with upper-case)
#SYNOPSIS: PublicTclProcs
#DESCRIPTION: 
#ARGIN:    NONE
#ARGOUT:   NONE
#RETURN:   NONE
#ERROR :   NONE 
#GLOBAL_CREATED: NONE
#GLOBAL_USED: auto_index
#GLOBAL_MODIFIED: NONE
#SEE ALSO:
#SOURCE FILE:
#AUTHOR: G. Pepellin
#$Date: 98/08/03 11:54:10 $
#$Revision: 2.3 $
#-############################################################################

global auto_index
 return [lsort [array names auto_index \[A-Z\]*]]

} ;# ends proc PublicTclProcs


proc ShowAllProcs {{file_name NONE}} {
#+############################################################################
#NAME:     ShowAllProcs ?file_name?
#SYNOPSIS: ShowAllProcs
#DESCRIPTION: 
#ARGIN:    NONE
#ARGOUT:   NONE
#RETURN:   NONE
#ERROR :   NONE
#GLOBAL_CREATED: NONE
#GLOBAL_USED: NONE
#GLOBAL_MODIFIED: NONE
#SEE ALSO: PublicTclProcs
#SOURCE FILE:
#AUTHOR: G. Pepellin
#$Date: 98/08/03 11:54:10 $
#$Revision: 2.3 $
#-############################################################################
  if { $file_name == "NONE"  } {
    set l [PublicTclProcs]
    foreach elt $l {
      ShowProc $elt
    }
  } else {
    puts "print into the file \"$file_name\" requested. NOT YET IMPLEMENTED"
  }


} ;# ends proc ShowAllProcs

### Create the packge rrap
package provide rrap 2.3
