proc Confirm { msg } {
#---------------------------------------------------------------------
# Proc name  : Confirm  msg 
# Description: works only on stdin, stdout
#              Prompt the operator printing the message "msg" and read
#                an answer that can be either "y", "yes"
#                "n", "no" or "\" to abort. (lower and upper cases are valid) 
# Argin : "msg" is the message to be printed
# Argout: NONE
# Return:  1 "yes" (or any derivtives forms) is answered
#          0 "no"  (or any derivtives forms) is answered
#         -1 if abort "\" is requested
# Error : None
# Global created: None
# See also: promtI promtpIL promtpF PromptFL promtpS
#----------------------------------------------------------------------
  
  while {1} {
  puts -nonewline "$msg \[y n\]: " 
  flush stdout
  set str [string tolower [gets stdin]] ;# to force the entry into lower cases
  if {$str == "\\"} { break} 
  if {$str == "y" || $str == "yes" } { return 1 }
  if {$str == "n" || $str == "no" } { return 0 } else {
    puts "Please answer y | yes | n | no (upper or lower cases)"
  }
  };# ends while  
  return -1 
} ;# ends proc Confirm msg


proc PromptS {msg  answer} {
#---------------------------------------------------------------------
# Proc name  : PromptS  msg answer
# Description: works only on stdin, stdout
#              Prompt the operator printing the message "msg" and read
#                a string.
# Argin : "msg" is the message to be printed
# Argout: "answer" is the variable that will hold the result. 
# Return:  0 if a string is entered
#         -1 if the operator cancels the entry hitting "\". In this case
#            "answer" is not set. The abort character "\" has a signification
#            when if it is the only one char of the string. That means that
#            \toto or to\to are valid strings.
# Error : None
# Global created: None
# See also: promtI promtpIL promtpF PromptFL
#----------------------------------------------------------------------
  
  upvar $answer a
  set abort "\\"
  puts -nonewline "$msg "
  flush stdout
  set str [gets stdin]
  if {$str == $abort } {return -1} else {set a $str ; return 0}
}




proc PromptF {msg answer} {
#---------------------------------------------------------------------
# Proc name  : PromptF  msg answer
# Description: works only on stdin, stdout
#              Prompt the operator printing the message "msg" and read
#                a float. The string representing the entry is fully parsed.
#              The procedure loops till a valid floating point value is
#                entered or the operator hits "\" to abort the entry              
#              A float that is to big with respectto the internal 
#                representation (a double) is refused.   
#
# Argin : "msg" is the message to be printed
# Argout: "answer" is the variable that will hold the result. 
# Return:  0 if a valid floating point value is entered.
#         -1 if the operator cancels the entry hitting "\". In this case
#            "answer" is not set.
# Error : None
# Global created: None
# See also: promtFL promtpI promtpIL PromptS
#----------------------------------------------------------------------

  upvar $answer a
  set abort "\\"
  set abort_requested 0
  set error_1 "floating-point value too large to represent"
  set error_2 "integer value too large to represent"
  
  while { $abort_requested == 0 } { 
    puts -nonewline "$msg ($abort to abort): "
    flush stdout  
    set str [gets stdin]
    # a trick to check if the integer is not to big with respect to
    #  the internal representation (2**32 -1)
    set code [catch {expr $str + 0} code_str]
    if { ($code_str == $error_1) || ($code_str == $error_2) } {    
      puts " +++ SORRY but $code_str"
      continue
     } else {
       if {$str == $abort } {set abort_requested 1 ; break}     
       switch -regexp -- $str {
         (^[-+]?[0-9]+$) { #comment
           set a $str
           return 0
           }              
         (^[-+]?[0-9]+[.][0-9]*$) {       
           set a $str
           return 0
           }
         (^[-+]?[0-9]*[.][0-9]+$) {       
           set a $str
           return 0
           }           
         (^[-+]?[0-9]*[.][0-9]+[eE][+-]?[0-9]+$) {
           set a $str
           return 0
           }
         (^[-+]?[0-9]+[.]?[0-9]*[eE][+-]?[0-9]+$) {
           set a $str
           return 0
           }                     
       default {
         puts "+++ SORRY but $str is not a float +++"
         }
  
       } ; # ends switch -regexp -- $str 
      };# ends else clause of if {$code_str == "integer ... }     
  };# ends while {abort_requested == 0}
  return -1 ;# Entry aborted by operator
} ;# ends proc PromptF {msg answer}

#         (^[-+]?[eE][+-]?[0-9]+$) {
#           set a $str
#           return 0
#           }     
#

proc PromptFL { msg answer min_val max_val default_val } {
#---------------------------------------------------------------------
# Proc name  : PromptFL  msg answer min_val max_val default_val
# Description: works only on stdin, stdout
#              Prompt the operator printing the message "msg" and read
#                a float. The string representing the entry is fully parsed.
#              The procedure loops till a valid floating point value 
#                (syntactically speaking AND into the bounds) is
#                entered or the operator hits "\" to abort the entry              
#              A float that is to big with respectto the internal 
#                representation (a double) is refused. 
#              When a syntactically valid float is got, it is compared
#                to the limits "main_val" and "max_val" and refused
#                if it is out of bounds
#              Hitting "return" without any value will set "answer" to
#                "default_val" 
#
# Argin : "msg" is the message to be printed
#         "min_val", "max_val" are the bounds of the float value.
#         "default_val" is the result when the operator hits "return"
#                      rather than a value.
# Argout: "answer" is the variable that will hold the result. 
# Return:  0 if a valid floating point value is entered.
#         -1 if the operator cancels the entry hitting "\". In this case
#            "answer" is not set.
# Error : None
# Global created: None
# See also: promtF promtpI promtpIL PromptS
#
#----------------------------------------------------------------------
  upvar $answer a
  set abort "\\"
  set abort_requested 0
  set error_1 "floating-point value too large to represent"
  set error_2 "integer value too large to represent"

  while { $abort_requested == 0 } { 
    puts -nonewline "$msg ($abort abort\
                           Min $min_val \
                            Max $max_val \
                            Default $default_val): "
    flush stdout  
    set str [gets stdin]
    # a trick to check if the float is not to big with respect to
    #  the internal representation (a double)
    set code [catch {expr $str + 0} code_str]
    if { ($code_str == $error_1) || ($code_str == $error_2) } {
      puts " +++ SORRY but $code_str"
      continue
     } else {
       if {$str == $abort } {set abort_requested 1 ; break} 
       if { [string length $str] == 0 } { set a $default_val ; return 0 }
       set no_default 1           
       switch -regexp -- $str {
         (^[-+]?[0-9]+$) {
           set a $str              
           }
                         
         (^[-+]?[0-9]+[.][0-9]*$) {       
           set a $str
           }
         (^[-+]?[0-9]*[.][0-9]+$) {       
           set a $str
           }           
         (^[-+]?[0-9]*[.][0-9]+[eE][+-]?[0-9]+$) {
           set a $str
           }
         (^[-+]?[0-9]+[.]?[0-9]*[eE][+-]?[0-9]+$) {
           set a $str
           }                      
       default {
         set no_default 0
         puts "+++ SORRY but $str is not a float +++"
         }
  
       } ; # ends switch -regexp -- $str 
       if {$no_default == 1 } {
         if { $str > $max_val || $str < $min_val } {
           puts "+++ SORRY Float is out of bounds "
         } else { return 0} 
       }
      };# ends else clause of if {$code_str == $error_1 .... }     
  };# ends while {abort_requested == 0}
  return -1 ;# Entry aborted by operator
} ;# ends proc PromptFL {msg answer}



proc PromptI {msg answer} {
#---------------------------------------------------------------------
# Proc name  : PromptI  msg answer
# Description: works only on stdin, stdout
#              Prompt the operator printing the message "msg" and read
#                an integer. The string representing the entry is fully parsed.
#              The procedure loops till a valid integer value is
#                entered or the operator hits "\" to abort the entry              
#              An integer that is to big with respectto the internal 
#                representation (a long) is refused.   
#
# Argin : "msg" is the message to be printed
# Argout: "answer" is the variable that will hold the result. 
# Return:  0 if a valid integer value is entered.
#         -1 if the operator cancels the entry hitting "\". In this case
#            "answer" is not set.
# Error : None
# Global created: None
# See also: promtIL promtpF promtpFL PromptS
#----------------------------------------------------------------------
  upvar $answer a
  set abort "\\"
  set abort_requested 0

  while { $abort_requested == 0 } { 
    puts -nonewline "$msg ($abort to abort): "
    flush stdout  
    set str [gets stdin]
    # a trick to check if the integer is not to big with respect to
    #  the internal representation (2**32 -1)
    set code [catch {expr $str + 0} code_str]
    if {$code_str == "integer value too large to represent"} {
      puts " +++ SORRY but $code_str"
      continue
     } else {
       if {$str == $abort } {set abort_requested 1 ; break} 
       switch -regexp -- $str {
         (^[-+]?[0-9]+$) {
           set a $str
           return 0
           }    
       default {
         puts "+++ SORRY but $str is not an interger +++"
         }
  
       } ; # ends switch -regexp -- $str 
      };# ends else clause of if {$code_str == "integer ... }     
  };# ends while {abort_requested == 0}
  return -1 ;# Entry aborted by operator
} ;# ends proc PromptI {msg answer}




proc PromptIL {msg answer min_val max_val default_val} {
#---------------------------------------------------------------------
# Proc name  : PromptIL  msg answer min_val max_val default_val
# Description: works only on stdin, stdout
#              Prompt the operator printing the message "msg" and read
#                an integer. The string representing the entry is fully parsed.
#              The procedure loops till a valid integer value 
#                (syntactically speaking AND into the bounds) is
#                entered or the operator hits "\" to abort the entry              
#              An integer that is to big with respect to the internal 
#                representation (a long) is refused. 
#              When a syntactically valid integer is got, it is compared
#                to the limits "main_val" and "max_val" and refused
#                if it is out of bounds
#              Hitting "return" without any value will set "answer" to
#                "default_val" 
#
# Argin : "msg" is the message to be printed
#         "min_val", "max_val" are the bounds of the integer value.
#         "default_val" is the result when the operator hits "return"
#                      rather than a value.
# Argout: "answer" is the variable that will hold the result. 
# Return:  0 if a valid integer value is entered.
#         -1 if the operator cancels the entry hitting "\". In this case
#            "answer" is not set.
# Error : None
# Global created: None
# See also: promtI promtpF promtpFL PromptS
#
#----------------------------------------------------------------------
  upvar $answer a
  set abort "\\"
  set abort_requested 0
  
  while { $abort_requested == 0 } {

     puts -nonewline "$msg ($abort to abort)\
                           (Min= $min_val \
                            Max= $max_val \
                            Default= $default_val): "
     flush stdout
     set str [gets stdin]
      # a trick to check if the integer is not to big with respect to
      #  the internal representation (2**32 -1)
     set code [catch {expr $str + 0} code_str]
     if {$code_str == "integer value too large to represent"} {
       puts " +++ SORRY BUT $code_str"
       continue 
      } else {
     if {$str == $abort } {set abort_requested 1 ; break}
     if { [string length $str] == 0 } { set a $default_val ; return 0 }     
      switch -regexp -- $str {
        (^[-+]?[0-9]+$) {
        if { $str > $max_val || $str < $min_val } {
          puts "=== SORRY Integer is out of bounds +++"
        } else { set a $str; return 0 }

        }
    
       default {
        puts " +++ SORRY but $str is not an interger"
       }
  
     }  ; # ends switch -regexp -- $str       
     } ; # ends else/if $code_str == "intege ... 
  };# ends while {abort_requested == 0}
  return -1 ;# Entry aborted by operator
} ;# ends proc PromptIL {msg answer min_val max_val default_val}


### Create the packge rrap
package provide rrap 2.3

