proc PrintList {this_list} {
#+############################################################################
#NAME:     PrintList. Print on stdout the content of a list 
#SYNOPSIS: PrintList $list_name
#DESCRIPTION: For each element of this_list the indice of element is printed
#             at the beginning of the line: elti: content 
#ARGIN:    The list to be printed passed by value: $list_name
#ARGOUT:   NONE
#RETURN:   NONE
#ERROR :   If the requested list does not exits then the message: 
#          'can't read "list_name": no such variable' is printed on stdout
#           
#GLOBAL_CREATED: NONE
#GLOBAL_USED: NONE
#GLOBAL_MODIFIED: NONE
#SEE ALSO:
#SOURCE FILE:
#AUTHOR: G. Pepellin
#$Date: 98/08/03 11:54:03 $
#$Revision: 2.3 $
#-############################################################################

set i 0
foreach element $this_list {
  puts "elt$i: $element"
  incr i
}
} ;# ends proc PrintList


proc RemoveEmptyListElt {this_list} {
#+############################################################################
#NAME:     RemoveEmptyListElt  Remove empty elements of a list
#SYNOPSIS: set list_out  [RemoveEmptyListElt $list_in] or
#          set list_in   [RemoveEmptyListElt $list_in] 
#DESCRIPTION: 
#ARGIN:    The list to be cleaned passed by value: $list_in
#ARGOUT:   NONE
#ARGOUT:   NONE
#RETURN:   The cleaned list. Could be the same.
#ERROR :   if the requested list does not exits then the message: 
#          'can't read "list_in": no such variable' is printed on stdout 
#GLOBAL_CREATED: NONE
#GLOBAL_USED: NONE
#GLOBAL_MODIFIED: NONE
#SEE ALSO:
#SOURCE FILE:
#AUTHOR: G. Pepellin
#$Date: 98/08/03 11:54:03 $
#$Revision: 2.3 $
#-############################################################################

foreach elt $this_list {
  set cleaned_list {}
  if { [llength $elt] != 0} { lappend cleaned_list $elt }
}
return $cleaned_list

} ;# ends proc RemoveEmptyListElt


proc ReverseList {this_list} {
#+############################################################################
#NAME:     ReverseList. Reverse a list. The last element becomes the 1st.
#SYNOPSIS: set list_out [ReverseList $list_in] or
#          set list_in  [ReverseList $list_in]
#DESCRIPTION: 
#ARGIN:    The list to be reversed passed by value: $list_in
#ARGOUT:   NONE
#RETURN:   The reversed list
#ERROR :   if the requested list does not exits then the message: 
#          'can't read "list_in": no such variable' is printed on stdout
#GLOBAL_CREATED: NONE
#GLOBAL_USED: NONE
#GLOBAL_MODIFIED: NONE
#SEE ALSO:
#SOURCE FILE:
#AUTHOR: G. Pepellin
#$Date: 98/08/03 11:54:03 $
#$Revision: 2.3 $
#-############################################################################

  set lreversed ""
  set i [expr [llength $this_list] -1]
  while {$i >= 0} {
    lappend lreversed [lindex $this_list $i]
    incr i -1
  }
  return $lreversed 

} ;# ends proc ReverseList 

### Create the packge rrap
package provide rrap 2.3
