proc setDefaultOption {} {
#+############################################################################
#NAME:     setDefaultOption defines default look & feel options for an application
#SYNOPSIS: setDefaultOption
#DESCRIPTION: defines default look & feel options for the application
#ARGIN:    NONE
#ARGOUT:   NONE 
#RETURN:   NONE
#ERROR :   NONE
#GLOBAL_CREATED: NONE 
#GLOBAL_USED:  NONE
#GLOBAL_MODIFIED: NONE
#PROCEDURE_CALLED: NONE 
#SEE ALSO:
#SOURCE FILE:
#MAIN_AUTHOR: G. Pepellin
#-############################################################################
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }

#default options for all classes
option add *font *helvetica-bold-r-*-*-12*
option add *background grey80

#defaults options for menubutton class
#option add *Menubutton.background "#9F9BBF"
option add *Menubutton.background grey80
option add *Menubutton.relief "groove"
option add *Menubutton.foreground "Black"
option add *Menubutton.font "*helvetica-bold-r-*-*-12*"
option add *Menubutton.disabledforeground "Grey"

#defaults options for menu class
option add *Menu.background "#9F9BBF"
option add *Menu.foreground "White"
option add *Menu.font "*helvetica-bold-r-*-*-12*"
option add *Menu.disabledforeground grey

#default options for class: Button
option add *Button.relief raised
#option add *Button.background #9F9BBF
option add *Button.background grey80
option add *Button.disabledForeground "Grey"

#default options for class: Entry
option add *Entry.relief sunken

#default options for class: Label
option add *Label.foreground black
option add *Label.font *helvetica-bold-r-*-*-12*

#default options for class: Frame
option add *Frame.background grey80
option add *Frame.relief sunken

### Check if the application provides its own options
if { [info procs userAppOption] == "userAppOption" } { userAppOption }

} ;# ends proc setDefaultOption 


proc onVersion {} {
#+############################################################################
# Proc name 	: onVersion
# Description	: Open a window and display the current application version
# Argin 	: None     
# Argout	: None
# Error	 	: None
# Return 	: None
# Global created: None
#-############################################################################
# Generic globals used
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }

global tcl_version tk_version  
global MAIN_AUTHOR  TclTacoApi_version LIBDSAPI_VER LIBDBAPI_VER LIBDCAPI_VER LIBDSXDR_VER

### get tcltaco version
tcltaco_ver
catch {destroy .wHonV}

toplevel .wHonV  	  ;# Create a new window
wm title .wHonV "$MAIN_WINDOW_TITLE: Help on Versions" ;# Title the new window
PositionToplevelWindow . .wHonV 100 100
wm transient .wHonV .

# A frame to hold the scrolled text
set frt [frame .wHonV.frt]
set wtext [CreateScrolledText $frt]
$wtext configure -bg White

# A frame to hold buttons and buttons definition
set frb [frame .wHonV.frb]
button $frb.dismiss -text "Dismiss" -command {destroy .wHonV}
pack $frb.dismiss  -anchor w

# Pack tje main frame
pack $frt $frb

#Fill the text widgets with versions
$wtext insert end "Application name:    $MAIN_APPL_NAME\n"
$wtext insert end "Application version:    $MAIN_APPL_VERSION\n"
$wtext insert end "Author:     $MAIN_AUTHOR"
$wtext insert end "\n++++++ This application was developped using the following shared libraries versions:\n\n"
$wtext insert end "   tcl: $tcl_version    tk: $tk_version\n"
$wtext insert end "   Tcl-TACO interface libTclTacoApi:    $TclTacoApi_version\n"
$wtext insert end "   TACO libraries:    libdsapi.$LIBDSAPI_VER\n"
$wtext insert end "                             libdbapi.$LIBDBAPI_VER\n"
$wtext insert end "                             libdcapi.$LIBDCAPI_VER\n"
$wtext insert end "                             libdsxdr.$LIBDSXDR_VER\n"

checkLibs $wtext
} ;# ends porc onVersion                                                      

proc checkLibs {w} {
  global tcl_platform tcl_version tk_version
  
  ### to be platform independent
  set suffix bof
  switch $tcl_platform(os) {
    HP-UX {set suffix sl}
    default {$w insert end " Platform $tcl_platform(os) not supported yet"}
  }  
  
  $w insert end "\n++++++ The TclTk interpreters and the shared libraries versions running on [exec uname -n] are:\n\n"
  ### TclTk interpreters
  $w insert end "      TclTk interpreters:   tcl version: $tcl_version  tk version: $tk_version\n\n"
  ### Tcl-Taco interface
  $w insert end "      Tcl-TACO interface:   "  
  # Check libTclTacoApi
  set pipe [open "|/usr/bin/ident /usr/local/lib/libtcltacoapi.$suffix" ]
  while { [gets $pipe line] >= 0} {lappend l $line}
  catch {close $pipe} ; unset pipe
  foreach line $l {
    set found [regexp {[.]*dev_io.c[.]*} $line]
    if {$found == 1} break
  }
  if {$found == 1} {
    $w insert end "   libTclTacoApi version:   [lindex $line 2]\n"
  } else {$w insert end "   libTclTacoApi not found\n"} 

  ### Taco libs  
  $w insert end "\n      TACO libraries:\n"
  # Check libdsapi
  set pipe [open "|/usr/bin/ident /usr/local/lib/libdsapi.$suffix" ]
  while { [gets $pipe line] >= 0} {lappend l $line}
  catch {close $pipe} ; unset pipe
  foreach line $l {
    set found [regexp {[.]*dev_api.c[.]*} $line]
    if {$found == 1} break
  }
  if {$found == 1} {
    $w insert end "           libdsapi version:   [lindex $line 2]\n"
  } else {$w insert end "   libdsapi not found\n"}
  
  # Check libdbapi
  set pipe [open "|/usr/bin/ident /usr/local/lib/libdbapi.$suffix" ]
  while { [gets $pipe line] >= 0} {lappend l $line}
  catch {close $pipe} ; unset pipe
  foreach line $l {
    set found [regexp {[.]*setacc_cli.c[.]*} $line]
    if {$found == 1} break
  }
  if {$found == 1} {
    $w insert end "           libdbapi version:   [lindex $line 2]\n"
  } else {$w insert end "   libdbapi not found\n"} 

  # Check libdcapi
  set pipe [open "|/usr/bin/ident /usr/local/lib/libdcapi.$suffix" ]
  while { [gets $pipe line] >= 0} {lappend l $line}
  catch {close $pipe} ; unset pipe
  foreach line $l {
    set found [regexp {[.]*dcwr_cli.c[.]*} $line]
    if {$found == 1} break
  }
  if {$found == 1} {
    $w insert end "           libdcapi version:   [lindex $line 2]\n"
  } else {$w insert end "   libdcapi not found\n"}

  # Check libdsxdr
  set pipe [open "|/usr/bin/ident /usr/local/lib/libdsxdr.$suffix" ]
  while { [gets $pipe line] >= 0} {lappend l $line}
  catch {close $pipe} ; unset pipe
  foreach line $l {
    set found [regexp {[.]*DevXdrKernel.c[.]*} $line]
    if {$found == 1} break
  }
  if {$found == 1} {
    $w insert end "           libdsxdr version:   [lindex $line 2]\n"
  } else {$w insert end "   libdsxdr not found\n"}  
  
} ;# ends proc checkLibs

proc onApplication {} {
#+###########################################################################
# File		: onapplication.tk
# Author	: Denis Beauvois
# Date		: july, 1996
# Proc name 	: onApplication 
# Description	: Open a window and display the help file  
#		: The help file is named in the MAIN_HELP_FILE global variable 
# Argin 	: None     
# Argout	: None 
# Error	 	: if an error occures it'is recorded
# Return 	: None
# Global created: None
#-###########################################################################

#Generic globals
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }
  if {$MAIN_HELP_FILE == "internal"} {
    append internalHelp $MAIN_APPL_NAME Help
    $internalHelp
    return
  }
  if {$MAIN_HELP_FILE == "no_help_file"} { 
    tk_messageBox -message "No help file was provided \n(should be the 5th argument of CreateMainWindow)" \
                  -title "$MAIN_APPL_NAME" \
                  -icon warning 
  } else {
  catch {destroy .wHelponApplication}
  toplevel .wHelponApplication 
  wm title .wHelponApplication "$MAIN_WINDOW_TITLE: Help on application" 
  wm transient .wHelponApplication .
  PositionToplevelWindow .wHelponApplication .wHelponApplication 100 100
  if {[ReadFileIntoTextWidget .wHelponApplication $MAIN_HELP_FILE] != $OK} {destroy .wHelponApplication}    
  }                                                  

} ;# ends proc onApplication

proc AddNewError {message} {
#+############################################################################
#NAME:     AddNewError
#SYNOPSIS: AddNewError message
#DESCRIPTION: Highlight menubar->view to red 
#              Add $message into the error window.
#              If the original error message does not include the date (unlike
#                errors generated by TACO) you can add the date like this:
#                AddNewError "[GetDAte] this is a time stamped error" 
#ARGIN:    message: text of the error 
#ARGOUT:   None
#RETURN:   None
#ERROR :   None
#GLOBAL_CREATED: None
#GLOBAL_USED: MAIN_ERROR_NB  MAIN_CURR_ERRORS MAIN_MAX_ERRORS MAIN_LIST_ERRORS
#             MAIN_NEW_ERROR
#GLOBAL_MODIFIED: MAIN_NEW_ERROR
#PROCEDURE_CALLED: none
#SEE ALSO:
#SOURCE FILE:
#Author: G. Pepellin
#$Date: 98/08/03 11:54:00 $
#$Revision: 2.3 $
#-############################################################################

# Generic globals
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }
global MAIN_LIST_ERRORS 

  .menubar.view configure -fg red
  incr MAIN_ERROR_NB 
  if { $MAIN_CURR_ERRORS < $MAIN_MAX_ERRORS} {
    incr MAIN_CURR_ERRORS
  } else { set MAIN_LIST_ERRORS [lreplace $MAIN_LIST_ERRORS 0 0  ] }
  set line "$MAIN_ERROR_NB> $message \n"
  lappend MAIN_LIST_ERRORS $line
  set MAIN_NEW_ERROR $TRUE 
  update idletasks      
 
} ;# ends  proc AddNewError



proc viewError {} {
#+###########################################################################
# File		: viewerror.tk
# Author	: G. Pepellin 
# Date		: july, 1996
# Proc name 	: viewError V 
# Description	:
#                
#               
# ARGIN 	: message 
# Argout	: None
# Error	 	: None
# Return 	: None
# Global created: None 
#-##########################################################################

# Generic globals
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }
global MAIN_LIST_ERRORS 

.menubar.view configure -fg Black
catch {destroy .wTempError}   
UpdateStatusbar " "
toplevel .wTempError ; wm title .wTempError "$MAIN_WINDOW_TITLE: Error window"
PositionToplevelWindow . .wTempError 100 100
set littlefont "*helvetica-bold-r-*-*-6*"
  set f1 [frame .wTempError.fr1]
  scrollbar $f1.scroll -relief flat -width 12 \
                       -command "$f1.text yview"  
  pack $f1.scroll -side right -fill y 
                                   
  text $f1.text -bd 1 -relief raised -yscroll "$f1.scroll set" \
                      -wrap word 

  pack $f1.text -expand yes -fill both
  pack $f1 -expand yes -fill both

 set f [frame .wTempError.buttons -relief raised -borderw 1]
 pack $f -side bottom -fill x
 button $f.dismiss \
        -text "Dismiss" -font $littlefont -padx 1 -pady 1 \
        -command {destroy .wTempError
                  set MAIN_ERROR_WIN_OPENED $FALSE
                 }

 button $f.clear \
        -text "Clear errors" -font $littlefont -padx 1 -pady 1 \
  			-command {
  			           set MAIN_LIST_ERRORS [list {}]
  			           set MAIN_LIST_ERRORS [RemoveEmptyListElt $MAIN_LIST_ERRORS]
  			           set MAIN_ERROR_NB 0
  			           set MAIN_CURR_ERRORS 0
  			           .wTempError.fr1.text configure -state normal
  			           .wTempError.fr1.text delete 1.0 end
  			           .wTempError.fr1.text configure -state disabled
  			           UpdateStatusbar ""
  			         }
 
 button $f.onfly  \
        -text "Live" -font $littlefont -padx 1 -pady 1 \
        -disabledforeground "Grey" \
        -command { .wTempError.buttons.freeze configure -state normal 
                   .wTempError.buttons.onfly configure -state disabled 
                   set MAIN_ERROR_WIN_FROZEN $FALSE
                   set MAIN_NEW_ERROR $TRUE
                 }
                        
 button $f.freeze  \
        -text "Freeze" -font $littlefont -padx 1 -pady 1 \
        -disabledforeground "Grey" \
        -state disabled \
        -command { .wTempError.buttons.onfly configure -state normal 
                   .wTempError.buttons.freeze configure -state disabled 
                   set MAIN_ERROR_WIN_FROZEN $TRUE
                 }
 button $f.nberr \
        -text "Max errors $MAIN_MAX_ERRORS" -font $littlefont -padx 1 -pady 1 \
        -command {TopEntryWindow  .wTempError \
                                  "nb of max maintained errors" \
                                  MAIN_MAX_ERRORS $MAIN_MAX_ERRORS \
                                  integer 1 500 
                  .wTempError.buttons.nberr configure -text "Max errors\n $MAIN_MAX_ERRORS"
                 }
                        
 button $f.print \
        -text "Print" -font $littlefont -padx 1 -pady 1 \
        -command printError

 button $f.save -font $littlefont -padx 1 -pady 1 \
        -text  "Save" \
        -command {set ret "xxx"
                  set ret [tk_getSaveFile \
                           -initialdir [exec pwd] \
                           -title "Save errors "]
                  if { $ret != "" } {
                  set fid [open $ret a+]
                  foreach line $MAIN_LIST_ERRORS {
                    set lline [lreplace $line 0 0 ]
                    puts $fid $lline 
                  }
                  close $fid
                 }
                 }

# pack $f.dismiss $f.onfly $f.freeze $f.nberr $f.print $f.save -pady 3 -side left -padx 5
# pack $f.clear $f.print $f.save -pady 3 -side right -padx 5
 pack $f.dismiss $f.onfly $f.freeze  -side left -anchor w -padx 5 -pady 3
 pack $f.nberr   -side left -anchor c -padx 70 -pady 3
 pack  $f.print $f.save $f.clear -side right -padx 5 -pady 3
 
   set len [llength $MAIN_LIST_ERRORS]
   if {$len >= 0 } {
     foreach line $MAIN_LIST_ERRORS {
       $f1.text insert current $line
     }
                                            
   } ;# ends if {$len >= 0 }
   $f1.text configure -state disabled

 set MAIN_ERROR_WIN_OPENED $TRUE
} ;# ends proc viewError

proc printError { } {
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }
global tcl_platform MAIN_LIST_ERRORS
 switch  -- $tcl_platform(platform)  {
  windows { tk_dialog .warm "Warning" \
            "I don't know how to print under windows " \
            warning 0 "Dismiss"
   }
   unix { 
          if {[llength $MAIN_LIST_ERRORS ] != 0 } {
          set fname /tmp/$MAIN_APPL_NAME.[pid]
          set fid [open $fname w+]
          puts $fid "***************** aplication: $MAIN_APPL_NAME error list  ********************"
          
          foreach line $MAIN_LIST_ERRORS {
            set lline [lreplace $line 0 0 ]
            puts $fid $lline 
          }
          close $fid        
          exec lp -d$MAIN_PRINTER $fname
          tk_messageBox -message "Errors printed on $MAIN_PRINTER" \
                        -title "$MAIN_APPL_NAME" \
                        -icon info
          exec rm -f $fname
          }
   }
 
   default {tk_dialog .warm "Warning" \
            "platform: $tcl_platform(platform)\n not supported yet" \
            warning 0 "Dismiss"
   }
 } ;# ends switch
} ;# ends printError

proc updateErrorWindow {n1 n2 op} {
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }
global MAIN_LIST_ERRORS 
global .wTempError.fr1.text 
   if {$MAIN_ERROR_WIN_OPENED == $FALSE} return
   if {$MAIN_ERROR_WIN_FROZEN == $TRUE} return
   .wTempError.fr1.text configure -state normal
   set len [llength $MAIN_LIST_ERRORS]
   .wTempError.fr1.text delete 1.0 end
   if {$len >= 0 } {
     foreach line $MAIN_LIST_ERRORS {
       .wTempError.fr1.text insert current $line
     }
                                            
   } ;# ends if {$len >= 0 }
} ;# ends proc updateErrorWindow

#*********************************************************************************************************************************
proc DisplayDebug {message} {
#+############################################################################
#NAME:     DisplayDebug
#SYNOPSIS: DisplayDebug message
#DESCRIPTION:  
#              Add $message into the debug window.
#              DisplayDebug "[GetDAte] this is a time stamped debug" 
#ARGIN:    message: text of the debug 
#ARGOUT:   None
#RETURN:   None
#DEBUG :   None
#GLOBAL_CREATED: None
#GLOBAL_USED: MAIN_DEBUG_NB  MAIN_CURR_DEBUGS MAIN_MAX_DEBUGS MAIN_LIST_DEBUGS
#             MAIN_NEW_DEBUG
#GLOBAL_MODIFIED: MAIN_NEW_DEBUG
#PROCEDURE_CALLED: none
#SEE ALSO:
#SOURCE FILE:
#Author: G. Pepellin
#$Date: 98/08/03 11:54:00 $
#$Revision: 2.3 $
#-############################################################################

# Generic globals
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }
global MAIN_LIST_DEBUGS 

  if {$DEBUG} {
    incr MAIN_DEBUG_NB 
    if { $MAIN_CURR_DEBUGS < $MAIN_MAX_DEBUGS} {
      incr MAIN_CURR_DEBUGS
    } else { set MAIN_LIST_DEBUGS [lreplace $MAIN_LIST_DEBUGS 0 0  ] }
    set line "$MAIN_DEBUG_NB> $message \n"
    lappend MAIN_LIST_DEBUGS $line
    set MAIN_NEW_DEBUG $TRUE 
    update idletasks 
  }     
 
} ;# ends  proc DisplayDebug



proc viewDebug {} {
#+###########################################################################
# File		: viewdebug.tk
# Author	: G. Pepellin 
# Date		: july, 1996
# Proc name 	: viewDebug V 
# Description	:
#                
#               
# ARGIN 	: message 
# Argout	: None
# Debug	 	: None
# Return 	: None
# Global created: None 
#-##########################################################################

# Generic globals
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }
global MAIN_LIST_DEBUGS 

.menubar.view configure -fg Black
catch {destroy .wTempDebug}   
UpdateStatusbar " "
toplevel .wTempDebug ; wm title .wTempDebug "$MAIN_WINDOW_TITLE: Debug window"
PositionToplevelWindow . .wTempDebug 100 100
set littlefont "*helvetica-bold-r-*-*-6*"
  set f1 [frame .wTempDebug.fr1]
  scrollbar $f1.scroll -relief flat -width 12 \
                       -command "$f1.text yview"  
  pack $f1.scroll -side right -fill y 
                                   
  text $f1.text -bd 1 -relief raised -yscroll "$f1.scroll set" \
                      -wrap word 

  pack $f1.text -expand yes -fill both
  pack $f1 -expand yes -fill both

 set f [frame .wTempDebug.buttons -relief raised -borderw 1]
 pack $f -side bottom -fill x
 button $f.dismiss \
        -text "Dismiss" -font $littlefont -padx 1 -pady 1 \
        -command {destroy .wTempDebug
                  set MAIN_DEBUG_WIN_OPENED $FALSE
                 }

 button $f.clear \
        -text "Clear debugs" -font $littlefont -padx 1 -pady 1 \
  			-command {
  			           set MAIN_LIST_DEBUGS [list {}]
  			           set MAIN_LIST_DEBUGS [RemoveEmptyListElt $MAIN_LIST_DEBUGS]
  			           set MAIN_DEBUG_NB 0
  			           set MAIN_CURR_DEBUGS 0
  			           .wTempDebug.fr1.text configure -state normal
  			           .wTempDebug.fr1.text delete 1.0 end
  			           .wTempDebug.fr1.text configure -state disabled
  			           UpdateStatusbar ""
  			         }
 
 button $f.onfly  \
        -text "Live\nmode" -font $littlefont -padx 1 -pady 1 \
        -disabledforeground "Red" \
        -command { .wTempDebug.buttons.freeze configure -state normal 
                   .wTempDebug.buttons.onfly configure -state disabled 
                   set MAIN_DEBUG_WIN_FROZEN $FALSE
                   set MAIN_NEW_DEBUG $TRUE
                 }
                        
 button $f.freeze  \
        -text "Frozen\nmode" -font $littlefont -padx 1 -pady 1 \
        -disabledforeground "Red" \
        -state disabled \
        -command { .wTempDebug.buttons.onfly configure -state normal 
                   .wTempDebug.buttons.freeze configure -state disabled 
                   set MAIN_DEBUG_WIN_FROZEN $TRUE
                 }
 button $f.nberr \
        -text "Max debugs\n $MAIN_MAX_DEBUGS" -font $littlefont -padx 1 -pady 1 \
        -command {TopEntryWindow  .wTempDebug \
                                  "nb of max maintained debugs" \
                                  MAIN_MAX_DEBUGS $MAIN_MAX_DEBUGS \
                                  integer 1 500 
                  .wTempDebug.buttons.nberr configure -text "Max debugs\n $MAIN_MAX_DEBUGS"
                 }
                        
 button $f.print \
        -text "Print" -font $littlefont -padx 1 -pady 1 \
        -command printDebug

 button $f.save \
        -text  "Save" -font $littlefont -padx 1 -pady 1 \
        -command {set ret "xxx"
                  set ret [tk_getSaveFile \
                           -initialdir [exec pwd] \
                           -title "Save debugs "]
                  if { $ret != "" } {
                  set fid [open $ret a+]
                  foreach line $MAIN_LIST_DEBUGS {
                    set lline [lreplace $line 0 0 ]
                    puts $fid $lline 
                  }
                  close $fid
                 }
                 }

 pack $f.dismiss $f.onfly $f.freeze  -side left -anchor w -padx 5 -pady 3
 pack $f.nberr   -side left -anchor c -padx 70 -pady 3
 pack  $f.print $f.save $f.clear -side right -padx 5 -pady 3
 
   set len [llength $MAIN_LIST_DEBUGS]
   if {$len >= 0 } {
     foreach line $MAIN_LIST_DEBUGS {
       $f1.text insert current $line
     }
                                            
   } ;# ends if {$len >= 0 }
   $f1.text configure -state disabled

 set MAIN_DEBUG_WIN_OPENED $TRUE
} ;# ends proc viewDebug

proc printDebug { } {
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }
global tcl_platform MAIN_LIST_DEBUGS
 switch  -- $tcl_platform(platform)  {
  windows { tk_dialog .warm "Warning" \
            "I don't know how to print under windows " \
            warning 0 "Dismiss"
   }
   unix { 
          if {[llength $MAIN_LIST_DEBUGS ] != 0 } {
          set fname /tmp/$MAIN_APPL_NAME.[pid]
          set fid [open $fname w+]
          puts $fid "***************** aplication: $MAIN_APPL_NAME debug list  ********************"
          
          foreach line $MAIN_LIST_DEBUGS {
            set lline [lreplace $line 0 0 ]
            puts $fid $lline 
          }
          close $fid        
          exec lp -d$MAIN_PRINTER $fname
          tk_messageBox -message "Debugs printed on $MAIN_PRINTER" \
                        -title "$MAIN_APPL_NAME" \
                        -icon info
          exec rm -f $fname
          }
   }
 
   default {tk_dialog .warm "Warning" \
            "platform: $tcl_platform(platform)\n not supported yet" \
            warning 0 "Dismiss"
   }
 } ;# ends switch
} ;# ends printDebug

proc updateDebugWindow {n1 n2 op} {
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }
global MAIN_LIST_DEBUGS 
global .wTempDebug.fr1.text 
   if {$MAIN_DEBUG_WIN_OPENED == $FALSE} return
   if {$MAIN_DEBUG_WIN_FROZEN == $TRUE} return
   .wTempDebug.fr1.text configure -state normal
   set len [llength $MAIN_LIST_DEBUGS]
   .wTempDebug.fr1.text delete 1.0 end
   if {$len >= 0 } {
     foreach line $MAIN_LIST_DEBUGS {
       .wTempDebug.fr1.text insert current $line
     }
                                            
   } ;# ends if {$len >= 0 }
} ;# ends proc updateDebugWindow

#*********************************************************************************************************************************
proc handleClose {WidgetName} {
# ------------------------------------------------------------------------------ # 	
# Proc name	: handleClose WidgetName					
# Description	: Trap the event generated when the user cliks double on motif
#		  window to exit. This procedure creates a dialog box to ask
#		  the user to confirm its action.
#		  This procedure is also called when the user tries to exit in
#		  using File->Exit menu from within the application
# Argin		: .
# Argout	: none
# Return	: none
# Global created: none
# ------------------------------------------------------------------------------- #
 if {$WidgetName == "."} {
    set Result [tk_dialog .dlg "Exit" "Do you really want to exit ?" question 0 "Yes" "Cancel"]
    if {$Result == 0} {
       if { [info procs userBeforeExiting] == "userBeforeExiting" } userBeforeExiting
       exit
    } 
 }
} ;# ends proc handleClose


proc UpdateStatusbar {msg} {
#--------------------------------------------------------------------------- #
# Proc name 	: UpdateStatusbar msg  
# Description	: Remove the text inside the statusbar and write in msg
# Argin 	: msg     
# Argout	: None
# Error	 	: None
# Return 	: None
# Global created: None
#--------------------------------------------------------------------------- #

.statusbar config -text $msg

};# ends proc UpdateStatusbar	

proc UpdateCommandSent {msg} {
#--------------------------------------------------------------------------- #
# Proc name 	: UpdatecommandSent msg  
# Description	: Write $msg into last command sent aera
# Argin 	: msg     
# Argout	: None
# Error	 	: None
# Return 	: None
# Global created: None
#--------------------------------------------------------------------------- #

.commandSent config -text $msg

};# ends proc UpdateCommandSent	



proc BalloonHelp {x y w msg} {
#+############################################################################
#NAME:     BalloonHelp  
#SYNOPSIS: BalloonHelp %x %y %W $my_help_messsage
#DESCRIPTION: Generates a balloon help whitin the selected widget
#             The 3 first arguments _MUST_ be: %x %y %W
# example: .b is the button you want to attach a balloon help when clicking the button-3
#
#         set helpmess [list "help on button .b"]
#         bind .b <Button-3> " BalloonHelp %x %y %W $helpmess"
#                            or
#         bind .b <Button-3> " BalloonHelp %x %y %W [list "help on button.b"]"
#
#ARGIN:    %x %y %W holds the geometry and the name of the widget selected
#          msg: your help message
#ARGOUT:   NONE
#RETURN:   NONE
#ERROR :   NONE
#GLOBAL_CREATED: NONE
#GLOBAL_USED: NONE
#GLOBAL_MODIFIED: NONE
#PROCEDURE_CALLED: NONE
#SEE ALSO:
#SOURCE FILE:
#$Author: pepellin $ 
#$Date: 98/08/03 11:54:00 $
#$Revision: 2.3 $
#-############################################################################
# Generic globals
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }

set gx [winfo rootx $w]
set gy [winfo rooty $w]
set DY -20			;# To place correctly the popup menu y position

catch {destroy .pophelp}

menu .pophelp -bg #F3E295 -fg black \
              -activeforeground black \
              -activebackground #F3E295 \
              -relief groove

tk_popup .pophelp [expr $x+$gx] [expr $y+$gy+$DY]

.pophelp add command -label "$msg"       

} ;# ends proc BalloonHelp

proc developHelp {} {
#+############################################################################
#NAME:     developHelp  short_description
#SYNOPSIS: developHelp arg1 arg2 ...
#DESCRIPTION: 
#ARGIN:    NOT_DEFINED
#ARGOUT:   NOT_DEFINED
#RETURN:   NOT_DEFINED
#ERROR :   NOT_DEFINED
#GLOBAL_CREATED: none
#GLOBAL_USED: NOT_DEFINED
#GLOBAL_MODIFIED: NOT_DEFINED
#PROCEDURE_CALLED: NOT_DEFINED
#SEE ALSO:
#SOURCE FILE:
#$Author: pepellin $ 
#$Date: 98/08/03 11:54:00 $
#$Revision: 2.3 $
#-############################################################################
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }

catch {destroy .wTempHelp}   
toplevel .wTempHelp ; wm title .wTempHelp "Developer help"
PositionToplevelWindow . .wTempHelp 100 100

# Create a menu bar
menu .wTempHelp.hmenubar
# attach it to the main window
.wTempHelp config -menu .wTempHelp.hmenubar

#Create more cascade menus
foreach m {File } {
  set $m [menu .wTempHelp.hmenubar.m$m]
  .wTempHelp.hmenubar add cascade -label $m -menu .wTempHelp.hmenubar.m$m
}
$File add command -label Print -command {
                        tk_messageBox -message "Not yet implemented" \
                                      -title "$MAIN_APPL_NAME:  print help" \
                                      -icon warning}
$File add command -label Quit -command {catch {destroy .wTempHelp}}
#$Command add radiobutton -label "ShowProc" -command {puts "developHelp showproc"}

set parent .wTempHelp
# create the scrolled text into a frame .wTempHelp.f1

  set f1 [frame $parent.f1]
  scrollbar $f1.scrollV -relief flat -width 12 \
                        -command "$f1.text yview"  
  scrollbar $f1.scrollH -relief flat \
                        -orient horizontal \
                       -command "$f1.text xview"
  pack $f1.scrollV -side right -fill  y 
  pack $f1.scrollH -side bottom -fill x
                                   
  text $f1.text -bd 1 -relief raised -bg white \
                      -yscroll "$f1.scrollV set" \
                      -xscroll "$f1.scrollH set" \
                      -wrap none 
  pack $f1.text -expand yes -fill both

# Create a vertical scrolled list box into a frame .wTempHelp.f2
  set f2 [frame $parent.f2]
  scrollbar $f2.scrollV -relief flat -width 12 \
                        -command "$f2.list yview"
  pack $f2.scrollV -side right -fill  y
  listbox $f2.list -width 25 -bg yellow \
                   -yscroll "$f2.scrollV set" 
  bind $f2.list <ButtonRelease-1> {performHelpOnProc [%W get [%W curselection]] .wTempHelp.f1.text}
  pack $f2.list -expand yes  -fill both

#create a frame that holds radiobuttons
  set f3 [frame $parent.f3]
  #set MAIN_HELP_MODE "whole"
  radiobutton $f3.rb1 -variable MAIN_HELP_MODE -text "Show whole code" -value "whole"
  radiobutton $f3.rb2 -variable MAIN_HELP_MODE -text "Show header" -value "header"
  radiobutton $f3.rb3 -variable MAIN_HELP_MODE -text "Show description" -value "descr"
  button $f3.b1 -text "Show all proc\ndescription" -command "all_proc_descr .wTempHelp.f1.text"
  button $f3.b2 -text "Clear" -command " .wTempHelp.f1.text delete 1.0 end"
  pack $f3.rb1 $f3.rb2 $f3.rb3 $f3.b1 $f3.b2 -side left
#pack the 3 frames
pack $f3 -side bottom -fill x
pack $f1 $f2 -side left -expand yes  -fill both

# Fill th elist box with public procedures
$f2.list insert end "### Tcl proccccedures ###"
set lproc [PublicTclProcs]
foreach p $lproc {
$f2.list insert end $p
}
$f2.list insert end "### TACO commands ###"
$f2.list insert end "dev_io"
$f2.list insert end "db_io"
$f2.list insert end "dc_io"

} ;# ends proc developHelp

proc performHelpOnProc {pname wtext} {
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt } 
 
 if {[regexp {[.]*#} $pname] == 1} return
 # Check if pname corresponds to the TACO interface commands
 switch -regexp $pname {
   {dev_io} -
   {dc_io} -
   {db_io} {displayTacoInterface $pname
            return
           }
 }
 
 # This is a Tcl Public procedure
 
 set lproc [getProcSource $pname]
 
 if {$MAIN_HELP_MODE == "whole" } {
  foreach line $lproc {
   $wtext insert end $line\n  
  }
 $wtext insert end \n\n
 highLightProcLine  
 return
 } ;# ends mode "whole"
 
 if {$MAIN_HELP_MODE == "header" } {
  foreach line $lproc {
    if {[regexp {[.]*#-#} $line] == 1} {
     $wtext insert end $line\n
     $wtext insert end \n\n
     highLightProcLine
     return
    }
    $wtext insert end $line\n  
  }
  $wtext insert end \n\n
  highLightProcLine
  return
 };# ends mode "header"
 
 if {$MAIN_HELP_MODE == "descr" } {
  set first_line $TRUE ; set beg_found $FALSE
  foreach line $lproc {
    if {$first_line == $TRUE } {
      $wtext insert end $line\n
      set first_line $FALSE
      continue
    }
    if {[regexp {[.]*#DESCRIPTION} $line] == 1} {
      set beg_found $TRUE
      $wtext insert end $line\n
      continue
    }
    if {($beg_found == $TRUE) && ( [regexp {[.]*#ARGIN} $line] == 0) } {
     $wtext insert end $line\n
     continue
    }
    if {($beg_found == $TRUE) && ( [regexp {[.]*#ARGIN} $line] == 1) } {
     break
    } 
  }
  $wtext insert end \n\n
  highLightProcLine
 };# ends mode "descr" 
 
}

proc highLightProcLine {} {
  .wTempHelp.f1.text tag remove aproc 1.0 1.end
  foreach {key value index} [.wTempHelp.f1.text dump 1.0 end] {
    if {$key == "text"} {
      if {[regexp {^proc} $value] == 1} {
        set line_number [lindex [split $index .] 0]
        .wTempHelp.f1.text tag add aproc $line_number.0 $line_number.end
      }
    } 

  }
  .wTempHelp.f1.text tag configure aproc -background green
} ;# ends proc highLightProcLine

proc all_proc_descr {wtext} {
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt } 

  set MAIN_HELP_MODE "descr"
  .wTempHelp config -cursor watch
  .wTempHelp.f1.text config -cursor watch
  update idletasks
  set lproc [PublicTclProcs]
  foreach p $lproc {
    performHelpOnProc $p $wtext
  }
  .wTempHelp.f1.text config -cursor xterm
  .wTempHelp config -cursor left_ptr
} ;# ends all_proc_descr


proc displayTacoInterface {pname} {
#+############################################################################
#NAME:     displayTacoInterface  
#SYNOPSIS: displayTacoInterface 
#DESCRIPTION: 
#ARGIN:    NOT_DEFINED
#ARGOUT:   NOT_DEFINED
#RETURN:   NOT_DEFINED
#ERROR :   NOT_DEFINED
#GLOBAL_CREATED: NOT_DEFINED
#GLOBAL_USED: NOT_DEFINED
#GLOBAL_MODIFIED: NOT_DEFINED
#PROCEDURE_CALLED: NOT_DEFINED
#SEE ALSO:
#SOURCE FILE:
#$Author: pepellin $ 
#$Date: 98/08/03 11:54:00 $
#$Revision: 2.3 $
#-#############################################################################
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }
  puts "+++++++++ Display $pname Usage ++++++++++"
  set token [http::geturl http://www.esrf.fr/computing/cs/taco/tcltk/TclTk_api.html]
  
  upvar #0 $token taco_url
  .wTempHelp.f1.text insert end [http::data $token]

} ;# ends proc displayTacoInterface

proc StartTkCon {} {
#+############################################################################
#NAME:     StartTkCon  
#SYNOPSIS: StartTkCon 
#DESCRIPTION: Start a Tk console with the packages rrap and tcltacoapi
#ARGIN:    NONE
#ARGOUT:   NONE
#RETURN:   NONE
#ERROR :   NONE
#GLOBAL_CREATED: NONE
#GLOBAL_USED: NONE
#GLOBAL_MODIFIED: NONE
#PROCEDURE_CALLED: NONE
#SEE ALSO:
#SOURCE FILE:
#$Author: pepellin $ 
#$Date: 98/08/03 11:54:00 $
#$Revision: 2.3 $
#-############################################################################

exec tkcon -package rrap -package tcltacoapi &


} ;# ends proc StartTkCon


proc CreateMainWindow {{app_name Undefined} {win_title Untitled} {app_version Undefined} {author Undefined} {help_file no_help_file}  } {
#+############################################################################
#NAME:     CreateMainWindow  
#SYNOPSIS: CreateMainWindow app_name win_title app_version author help_file
#          When the window is created, the developer can customize a lot
#            of parameters (widgets attributes, main menubar, add or remove
#            services). See the demos files into 
#            /segfs/dserver/system/tclapi/RRAP/demos
#DESCRIPTION: Generate a main window with some services.
#ARGIN:    app_name: Free string defining your appli name
#          win_title: Short alias used for the window title, the icon title
#                     and the internal interpreter name ( in case of using
#                     the "send" command from an external interpreter).
#          app_version: To be maintain by the devepoper
#          author: no comment
#          help_file: an ascii text that  will be displayed using
#                     help->on application usage
#ARGOUT:   NONE
#RETURN:   NONE
#ERROR :   NONE
#GLOBAL_CREATED: All created globals start by MAIN_ except some generic
#                globals like DS_OK, DS_NOTOK TRUE ... (Run the public command
#                ListGenericGlobals to print on stdout all the globals
#                created)
#GLOBAL_USED: Quite all the created
#GLOBAL_MODIFIED: Quite all the created
#PROCEDURE_CALLED: Of course private procedures but also a lot of public
#                  procedures (quite all).
#                  Moreover the following procedures belonging to the user
#                  application level are called only if they are defined:
#                  userBeforeExiting: is executed before definetively exiting
#                  userFileNew:    called on file->new
#                  userFileOpen:   called on file->open
#                  userFileSave:   called on file->save 
#                  userFileSaveAs: called on file->saveas 
#                  userFilePrint:  called on file->print
#SEE ALSO:
#SOURCE FILE: createMainWindow.tcl
#$Author: pepellin $ 
#$Date: 98/08/03 11:54:00 $
#$Revision: 2.3 $
#-############################################################################
### Generic globals
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt } 

### Globals that have not to be seen by the application developper but necessary
###   to internal procedure communication
global MAIN_LIST_ERRORS  MAIN_LIST_DEBUGS
global DEV_IO_DEBUG_MODE DB_IO_DEBUG_MODE 

### Dynamic Initialization
set MAIN_LIST_ERRORS [list {} ]
set MAIN_LIST_ERRORS [ RemoveEmptyListElt $MAIN_LIST_ERRORS]
set MAIN_LIST_DEBUGS [list {} ]
set MAIN_LIST_DEBUGS [ RemoveEmptyListElt $MAIN_LIST_DEBUGS]

set MAIN_APPL_NAME $app_name
set MAIN_WINDOW_TITLE $win_title
set MAIN_APPL_VERSION $app_version
set MAIN_AUTHOR    $author

set DEV_IO_DEBUG_MODE 0
set DB_IO_DEBUG_MODE 0


### Set the exit trap handler 
wm title . $MAIN_WINDOW_TITLE                        
wm protocol . WM_DELETE_WINDOW {handleClose .}
### Set the interpreter name to $MAIN_WINDOW_TITLE
tk appname $MAIN_WINDOW_TITLE
# set options for look and feel
setDefaultOption

####### Define a frame .menubar and its contents 
frame .menubar -relief raised -borderwidth 3 

###### Define File menu 
menubutton .menubar.file -text "File" -menu .menubar.file.menu
menu .menubar.file.menu 
bind .menubar.file <Control-Shift-Button-3> " BalloonHelp %x %y %W %W"

.menubar.file.menu add command \
                   -label "New" \
                   -command { 
                      if { [info procs userFileNew ] == "userFileNew" } {
                        userFileNew                   
                      } else {
                        tk_messageBox -message "Not defined" \
                        -title "$MAIN_APPL_NAME" \
                        -icon warning
                      }
                    }                    
                   
                   
.menubar.file.menu add command \
                   -label "Open" \
                   -command { 
                      if { [info procs userFileOpen ] == "userFileOpen" } {
                        userFileOpen                   
                      } else {
                        tk_messageBox -message "Not defined" \
                        -title "$MAIN_APPL_NAME" \
                        -icon warning
                      }
                    }                    
                   
                   
 
.menubar.file.menu add separator
                  
.menubar.file.menu add command \
                   -label "Save" \
                   -command { 
                      if { [info procs userFileSave ] == "userFileSave" } {
                        userFileSave                  
                      } else {
                        tk_messageBox -message "Not defined" \
                        -title "$MAIN_APPL_NAME" \
                        -icon warning
                      }
                    }                    
                   
                   
.menubar.file.menu add command \
                   -label "Save as" \
                   -command { 
                      if { [info procs userFileSaveAs ] == "userFileSaveAs" } {
                        userFileSaveAs                   
                      } else {
                        tk_messageBox -message "Not defined" \
                        -title "$MAIN_APPL_NAME" \
                        -icon warning
                      }
                    }                    
                     
   
.menubar.file.menu add separator 

.menubar.file.menu add command \
                   -label "Select a printer" \
                   -command {
                    TopEntryWindow . \
                                   "Choose a printer" \
                                   MAIN_PRINTER $MAIN_PRINTER \
                                   string

                   }
.menubar.file.menu add command \
                   -label "Print" \
                   -command { 
                      if { [info procs userFilePrint ] == "userFilePrint" } {
                        userFilePrint                   
                      } else {
                        tk_messageBox -message "Not defined" \
                        -title "$MAIN_APPL_NAME" \
                        -icon warning
                      }
                    }                    
                   
                   
.menubar.file.menu add separator 

.menubar.file.menu add command \
                   -label "Exit" \
                   -command {handleClose .}
                   
                                
##### Define View menu  
menubutton .menubar.view -text "View" -menu .menubar.view.menu 
bind .menubar.view <Control-Shift-Button-3> " BalloonHelp %x %y %W %W"
menu .menubar.view.menu 
.menubar.view.menu add command \
                   -label "Errors " \
                   -command {viewError }
.menubar.view.menu add command \
                   -label "Debugging " \
                   -command {viewDebug }

###### Define Option menu 
menubutton .menubar.option -text "Option" -menu .menubar.option.menu 
bind .menubar.option <Control-Shift-Button-3> " BalloonHelp %x %y %W %W"
menu .menubar.option.menu 
.menubar.option.menu add command \
                   -label "Tcl Console " \
                   -command { StartTkCon }
.menubar.option.menu add command \
                   -label "Set debugging " \
                   -command {set DEBUG $TRUE}
.menubar.option.menu add command \
                   -label "Unset debugging " \
                   -command {set DEBUG $FALSE}
                   
##### Define Command menu 
menubutton .menubar.command -text "Command" -menu .menubar.command.menu 
bind .menubar.command <Control-Shift-Button-3> " BalloonHelp %x %y %W %W"
menu .menubar.command.menu 

                                                                   
###### Define Help menu
menubutton .menubar.help -text "Help" -menu .menubar.help.menu 
bind .menubar.help <Control-Shift-Button-3> " BalloonHelp %x %y %W %W"
menu .menubar.help.menu 
.menubar.help.menu add command \
                   -label "On version" \
                   -command {onVersion}
                   
.menubar.help.menu add command \
                   -label "On application usage" \
                   -command "set MAIN_HELP_FILE $help_file 
                             onApplication"
                   
.menubar.help.menu add command \
                   -label "On application development" \
                   -command "developHelp"                  
                   
###### Define the Status message area

label .statusbar -relief sunken -borderwidth 2 \
                 -text "Status message "  
                 
bind .statusbar <Button-1> {UpdateStatusbar " " 
                            .statusbar configure -bg grey80} 
bind .statusbar <Control-Shift-Button-3> " BalloonHelp %x %y %W %W"

###### Define the Command sent area
label .commandSent -relief sunken -borderwidth 2 \
                   -text "Last command sent " 
bind .commandSent <Button-1> {UpdateCommandSent " " } 
bind .commandSent <Control-Shift-Button-3> " BalloonHelp %x %y %W %W"


###### Define the main working Frame area
frame .fr0 -relief groove -borderwidth 3 
bind .fr0 <Control-Shift-Button-3> " BalloonHelp %x %y %W %W"

pack .menubar -side top -fill x 
pack .menubar.file -side left -padx 3
pack .menubar.view -side left
pack .menubar.option -side left -padx 3
pack .menubar.command -side left
pack .menubar.help -side right -padx 3

pack .fr0 -pady 5 -padx 5  -anchor w
pack .statusbar -fill x -anchor w 
pack .commandSent -fill x -anchor w -side bottom
### Forward event "new error" to update the error window
trace variable MAIN_NEW_ERROR w updateErrorWindow

### Forward event "new error" to update the error window
trace variable MAIN_NEW_DEBUG w updateDebugWindow

update idletasks
} ;# end of proc createMainWindow

### Create the packge rrap
package provide rrap 2.3
