proc TopScrolledTextWindow {wname} {
#+############################################################################
#NAME:     TopScrolledTextWindow  
#SYNOPSIS: TopScrolledTextWindow  wname
#DESCRIPTION: 
#ARGIN:    wname: name of the top level window that will include the
#                 scrolled text widget and command panel
#ARGOUT:   NONE
#RETURN:   The name of the created scrolled text widget: $wname.fr1.text
#ERROR :   NOT_DEFINED
#GLOBAL_CREATED: NONE
#GLOBAL_USED: NONE
#GLOBAL_MODIFIED: NONE
#PROCEDURE_CALLED: CreateScrolledText
#SEE ALSO:
#SOURCE FILE:
#AUTHOR: G. Pepellin
#$Date: 98/08/03 11:53:59 $
#$Revision: 2.3 $
#-############################################################################

global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }

toplevel $wname 
set wtext [CreateScrolledText $wname]
  
set f [frame $wname.fr2 -relief raised -borderw 1]
pack $f -side bottom -fill x
button $f.dismiss -text "Dismiss" -command "destroy $wname" 
button $f.print -text "Print" -command {tk_dialog .warm "Warning" \
                                         "Not yet implemented" \
                                          warning 0 "Dismiss"
                                        }
button $f.save -text "Save" -command {tk_dialog .warm "Warning" \
                                         "Not yet implemented" \
                                          warning 0 "Dismiss"
                                        }
button $f.saveas -text "Save as" -command {tk_dialog .warm "Warning" \
                                         "Not yet implemented" \
                                          warning 0 "Dismiss"
                                        }

pack $f.dismiss  -pady 3 -side left -padx 5
pack $f.print $f.save $f.saveas   -pady 3 -side right -padx 5

return $wtext 

  
} ;#ends proc TopScrolledTextWindow

### Create the packge rrap
package provide rrap 2.3
