proc TopEntryWindow {parent label result default type args} {
#+############################################################################
#NAME:     TopEntryWindow  
#SYNOPSIS: TopEntryWindow parent label result default type ?min max ?
#DESCRIPTION: Create a toplvel shell called .wEntry that holds a labelled
#               entry to prompt the operator to enter a typed value. Currently
#               available types are "integer", "float" and "string".
#             The caller can optionally provide optional arguments "min' and 
#               "max", in this case the value entered is compared to these limits
#             To prompt operator to enter a passwd (typed char are displayed as *)
#               set the default value to the string "default" and the type to "string":
#                 TopEntryWindow $parent "Enter your passwd" result passwd string
#             
#ARGIN:    parent The window's name which wants to create this labelled entry (%W)
#          label: Mandatory. A free text that is display above the entry field
#          result: A variable name that will be updated with the result of the entry
#          default: A default value that will be inserted into the entry field
#          type: Mandatory. Either "interger" or "float" or "string"
#          min: minimum value. Optional. The entry will be compared to it
#          max: maximum value. Optional. The entry will be compared to it      
#          The arguments min max  are optionals but you should provide
#            either no argument or the 2 ones. You can use the wilde char *
#            to descativate the corresponding limit. 
#              TopEntryWindow . "message" result $result integer * * 10
#            
#ARGOUT:   result: Mandatory. A variable name that will hold the value entered
#RETURN:   NONE
#ERROR :   NONE
#GLOBAL_CREATED: For internal management some globals are created but they are
#                unseted at the end of the procedure.
#                All these globals start by the string ENTRY_WINDOW_
#GLOBAL_USED: NONE
#GLOBAL_MODIFIED: NONE
#PROCEDURE_CALLED: UpdateStatusbar checkEntry PositionTopLevelWindow 
#SEE ALSO:
#SOURCE FILE: 
#AUTHOR: G. Pepellin
#$Date: 98/08/03 11:53:58 $
#$Revision: 2.3 $
#-############################################################################
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt } 

if {[winfo exists .wEntry]=="1"} {
  if { [info procs UpdateStatusbar ] == "UpdateStatusbar" } {  
    UpdateStatusbar "There is already a prompt dialog window opened.."
  }
  return
}

# temporary created globals
global ENTRY_WINDOW_ENTRY ENTRY_WINDOW_TYPE
global ENTRY_WINDOW_VALID ENTRY_WINDOW_LIMITS
global ENTRY_WINDOW_MIN ENTRY_WINDOW_MAX ENTRY_WINDOW_DEF

# Val will point to the caller variable result
upvar $result Val

# Dynamic initialization
set ENTRY_WINDOW_ENTRY ""
set ENTRY_WINDOW_TYPE $type
set ENTRY_WINDOW_VALID 0
set ENTRY_WINDOW_LIMITS 0
set ENTRY_WINDOW_MIN "*"
set ENTRY_WINDOW_MAX "*"
if { $default != "passwd" } {
  set ENTRY_WINDOW_DEF $default
  set ENTRY_WINDOW_ENTRY $ENTRY_WINDOW_DEF
} else {set ENTRY_WINDOW_ENTRY ""
        set ENTRY_WINDOW_DEF ""
}

# get min max default if they exits
if {[llength $args] == 2 } {
  set ENTRY_WINDOW_MIN [lindex $args 0]
  set ENTRY_WINDOW_MAX [lindex $args 1]
  if {$ENTRY_WINDOW_MIN == "*" && $ENTRY_WINDOW_MAX == "*" } {
    set ENTRY_WINDOW_LIMITS 0
  } else { set ENTRY_WINDOW_LIMITS 1}
} else { set entry "" ; set check_requested 0 }




toplevel .wEntry      ;# Create a new window
wm title .wEntry "$MAIN_WINDOW_TITLE"   ;# Title the new window
wm iconname .wEntry "prompt dialog"     	         ;# Name of the icon
wm protocol .wEntry WM_DELETE_WINDOW "destroy .wEntry"
wm transient .wEntry $parent
PositionToplevelWindow $parent .wEntry 100 100

label .wEntry.label -text $label \
                    -anchor c -relief flat
pack .wEntry.label -padx 6 -pady 2 -ipadx 6 -ipady 2 -anchor c -side top

if { $ENTRY_WINDOW_LIMITS == 1 } {
label .wEntry.limit -text "min = $ENTRY_WINDOW_MIN  max = $ENTRY_WINDOW_MAX" \
                    -fg Orange  \
                    -anchor c -relief flat
pack .wEntry.limit -padx 6 -pady 2 -ipadx 6 -ipady 2 -anchor c -side top

if { $ENTRY_WINDOW_MIN == "*" } {
  .wEntry.limit configure -text "max = $ENTRY_WINDOW_MAX"
}
if { $ENTRY_WINDOW_MAX == "*" } {
  .wEntry.limit configure -text "min = $ENTRY_WINDOW_MIN"
}
}

entry .wEntry.entry -width 18 \
                    -bg white \
                    -fg Black  \
                    -textvariable ENTRY_WINDOW_ENTRY 
if {$default == "passwd"} {.wEntry.entry configure -show * }                    
pack .wEntry.entry -padx 6 -pady 2 -ipadx 6 -anchor c -side top
bind .wEntry.entry <Control-Shift-Button-3> " BalloonHelp %x %y %W %W"
bind .wEntry.entry <Key-Return> {                                 
                                 if { [checkEntry] == 0} {
                                   set ENTRY_WINDOW_VALID 1
                                   destroy .wEntry
                                 }  
                                }
label .wEntry.err -text "" \
                    -fg black  \
                    -anchor c -relief flat
                    
pack .wEntry.err -padx 6 -pady 2 -ipadx 6 -ipady 2 -anchor c -side top


frame .wEntry.frame  -relief sunken -borderwidth 1
pack .wEntry.frame -padx 6 -pady 6 -ipadx 6 -ipady 6 -side top -expand true \
                   -fill x

button .wEntry.frame.bOk  -fg black -width 3 -height 1 \
                         -relief groove -text "OK" -borderwidth 2 \
                         -command {
                                   if { [checkEntry] == 0} {
                                     set ENTRY_WINDOW_VALID 1
                                     destroy .wEntry
                                   }
                                  }
pack .wEntry.frame.bOk -side left -padx 6 -pady 6


button .wEntry.frame.bCancel -fg black -width 3 -height 1 \
                             -relief raised -text "Cancel" \
                             -command {
                                       set ENTRY_WINDOW_VALID 0
                                       destroy .wEntry
                                      }
pack .wEntry.frame.bCancel -side right -padx 6 -pady 6



tkwait window .wEntry
if {$ENTRY_WINDOW_VALID == 1} {
  set Val $ENTRY_WINDOW_ENTRY
}


unset ENTRY_WINDOW_ENTRY ENTRY_WINDOW_TYPE ENTRY_WINDOW_VALID 
unset ENTRY_WINDOW_MIN ENTRY_WINDOW_MAX ENTRY_WINDOW_DEF ENTRY_WINDOW_LIMITS
} ;# ends proc TopEntryWindow


proc entryError {errormsg} {
global .wEntry.err 
.wEntry.err configure -text $errormsg
.wEntry.err configure -fg Red
}

proc checkEntry {} {
# return 0 if correct entry, -1 if cancel requested
global  ENTRY_WINDOW_ENTRY ENTRY_WINDOW_TYPE ENTRY_WINDOW_LIMITS
global ENTRY_WINDOW_MIN ENTRY_WINDOW_MAX ENTRY_WINDOW_DEF

#### First we check the type    
switch $ENTRY_WINDOW_TYPE {
 
  "string"	{ set return_code 0 }
 
  "float"	{
            switch -regexp -- $ENTRY_WINDOW_ENTRY {
 
              (^[-+]?[0-9]+$) { set return_code 0 }
 
              (^[-+]?[0-9]+[.][0-9]*$) { set return_code 0 }

              (^[-+]?[0-9]*[.][0-9]+$) { set return_code 0 }

              (^[-+]?[0-9]*[.][0-9]+[eE][+-]?[0-9]+$) { set return_code 0}

              (^[-+]?[0-9]+[.]?[0-9]*[eE][+-]?[0-9]+$) { set return_code 0}
 
              default { entryError "Error: Float requested"
                        set return_code -1
                      }
            }
           } ; #ends float case
 
   "integer"	{
                 switch -regexp -- $ENTRY_WINDOW_ENTRY {
                   (^[-+]?[0-9]+$) { set return_code 0}
 
                    default {
                              entryError "Error: Integer requested"
                              set return_code -1
                            }
                         }
                 } ;# ends integer case
 
    default { 
             entryError "$ENTRY_WINDOW_TYPE: UNKNOWN TYPE. Cancel entry and ckeck your script"
             set return_code -1
            }
 
} ;#end of switch type
           
#### Second we check limits if they are requested
if { $return_code == -1 } { return $return_code }
if { $ENTRY_WINDOW_LIMITS == 0 } { return $return_code }

if { ($ENTRY_WINDOW_MIN != "*" ) && ( $ENTRY_WINDOW_ENTRY < $ENTRY_WINDOW_MIN ) } {
  entryError "Value under range"
  set return_code -1
}

if { ($ENTRY_WINDOW_MAX != "*" ) && ( $ENTRY_WINDOW_ENTRY > $ENTRY_WINDOW_MAX ) } {
  entryError "Value over range"
  set return_code -1
}

return $return_code
} ;# ends proc checkEntry

### Create the packge rrap
package provide rrap 2.3
