proc ReadFileIntoTextWidget {w filename} {
#+############################################################################
#NAME:     ReadFileIntoTextWidget  
#SYNOPSIS: ReadFileIntoTextWidge w filename
#DESCRIPTION: The caller provides a top level parent window (w) 
#             A widget scrolled widget text is created within this parent
#             The file is openned and red into this text widget
#ARGIN:    w: The toplevel shell parent window
#          filename: the file to be read into the created text widget
#ARGOUT:   NONE
#RETURN:   OK | NOTOK
#ERROR :   Managed by the procedure itself
#GLOBAL_CREATED: NONE
#GLOBAL_USED: NONE
#GLOBAL_MODIFIED: NONE
#PROCEDURE_CALLED: CreateScrolledText
#SEE ALSO:
#SOURCE FILE:
#$Author: pepellin $ 
#$Date: 98/08/03 11:53:57 $
#$Revision: 2.3 $
#-############################################################################
 global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }

if {[file exists $filename] != 1} {
  tk_messageBox -message "File $filename does not exist or you don't have privileges to read it" \
                -title "$MAIN_APPL_NAME: " \
                -icon warning
  return $NOTOK
}
  
  set wtext [CreateScrolledText $w] 

  set f [frame $w.fr2 -relief raised -borderw 1]
  pack $f -side bottom -fill x
  button $f.dismiss -text "Dismiss" -command "destroy $w" 
  button $f.print -text "Print" -command "
                   tk_messageBox -message \"Not yet implemented\" \
                                 -title \"$MAIN_APPL_NAME: \" \
                                 -icon warning \
                                 -parent $w
                  "
  button $f.save -text "Save" -command "
                   tk_messageBox -message \"Not yet implemented\" \
                                 -title \"$MAIN_APPL_NAME:\" \
                                 -icon warning \
                                 -parent $w "
                                        
  button $f.saveas -text "Save as" -command "
                   tk_messageBox -message \"Not yet implemented\" \
                                 -title \"$MAIN_APPL_NAME: \" \
                                 -icon warning \
                                 -parent $w "
  pack $f.dismiss  -pady 3 -side left -padx 5
  pack $f.print   $f.save $f.saveas -pady 3 -side right -padx 5

  
  set file_id [open $filename r]
  while { [gets $file_id line] >= 0} {
    $wtext insert end $line\n
  }
  $wtext configure -state disabled
  close $file_id 
  return $OK
  
} ;#ends proc ReadFileIntoTextWidget {w fileName}

### Create the packge rrap
package provide rrap 2.3
