proc PositionToplevelWindow {ref w dx dy } {
#+############################################################################
#NAME:     PositionToplevelWindow  with respect to another window or screen
#SYNOPSIS: PositionToplevelWindow ref w dx dy
#DESCRIPTION: Position a toplevel window with respect to the physical screen
#               or to another window. Caller provides 2 offsets, dx and dy.
#             screen reference refers the left upper screen corner
#             window reference refers its left upper  corner 
#ARGIN:    ref: either keyword screen or another toplvel window name
#          w: the window to be positionned
#          dx: offset on x with respect to ref
#          dy: offset on y with respect to ref
#ARGOUT:   NONE
#RETURN:   NONE
#ERROR :   See ARGOUT
#GLOBAL_CREATED:  NONE
#GLOBAL_USED:     NONE
#GLOBAL_MODIFIED: NONE
#SEE ALSO:
#SOURCE FILE:
#AUTHOR: G. Pepellin
#$Date: 98/08/03 11:53:56 $
#$Revision: 2.3 $
#-############################################################################

# get the coordinates of the reference point depending of the requested ref
if {$ref == "screen" } {
  set scrx [winfo screenwidth .] ; set scry [winfo screenheight .]
  set refx 0 ; set refy 0
} else {
  set geom [GetWindowGeometry $ref]
  set refx [lindex $geom 2] ; set refy [lindex $geom 3]
}
set geom [GetWindowGeometry $ref]
wm geometry $w +[expr $refx + $dx ]+[expr $refy + $dy] 

} ;# ends proc PositionToplevelWindow

### Create the packge rrap
package provide rrap 2.3
