proc GetWindowGeometry {w} {
#+############################################################################
#NAME:     GetWindowGeometry: get geometry of a tolevel window
#SYNOPSIS: GetWindowGeometry tolevel_window_name
#DESCRIPTION: 
#ARGIN:    w: a top level window name
#ARGOUT:   NONE
#RETURN:   A list that contains its geometry:
#          elt0: size on x
#          elt1: size on y
#          elt2: position on x with repeect to the top left corner of the screen
#          elt3: position on y with repeect to the top left corner of the screen
#          If the window does not exist return an empty list
#ERROR :   NONE
#GLOBAL_CREATED: NONE
#GLOBAL_USED: NONE
#GLOBAL_MODIFIED: NONE
#SEE ALSO:
#SOURCE FILE:
#AUTHOR: G. pepellin
#$Date: 98/08/03 11:53:54 $
#$Revision: 2.3 $
#-############################################################################

if { [winfo exists $w] != 1  } {return [list {}] }
set ltemp [wm geometry $w]
set ltemp [split $ltemp "+" ]
set posx [lindex $ltemp 1]
set posy [lindex $ltemp 2]
set ltemp [split [lindex $ltemp 0] "x" ]
set sizex [lindex $ltemp 0]
set sizey [lindex $ltemp 1]
#puts "sizex: $sizex sizey: $sizey posx: $posx posy: $posy"
return [list $sizex $sizey $posx $posy]


} ;# ends proc GetWindowGeometry

### Create the packge rrap
package provide rrap 2.3
