proc CreateEntryWindow {parent label callback type min max first} {
#+############################################################################
#NAME:     CreateEntryWindow  
#SYNOPSIS: CreateEntryWindow parent label callback type min max first
#DESCRIPTION: Create a labelled entry widget providing the following service:
#           The validity of the entry is optionally  checked depending of the values of
#               the arguments type min max:
#               type (integer, float or string) is always checked while min and max are 
#               only checked if they are
#               not set to *
#           When the operator  hits return into the entry widget, the callback procedure
#               provided is activated. This procedure is called with 2 argument: 
#               the name of the entry widget and its value
#           At creation the entry is intialized with the value of the argin "first"
#           The caller provides the parent widget which will hold the labelled entry and
#              should pack it
#example:  proc p1 {val} {puts "new val = $val"}
#          set fe1 [frame .fr0.fr1]
#          set fe2 [frame .fr0.fr2]
#          set e1 [CreateEntryWindow $fe1 "Output" p1  integer * * 0 ] #no range. Proc p1 will be called
#          set e1 [CreateEntryWindow $fe1 "Output" p1  integer 1 * 12 ] # positive integer requested.
#          set e2 [CreateEntryWindow $fe2  "enter an float" p2  float * * 34.5 ] #float type. Proc p2 will be called
#          pack $fe1 $fe2 ....
#
#          To disable the entry: $e1 configure -state disabled 
#          To enable the entry: $e1 configure -state normal     
#          
#ARGIN:    parent: the parent widget which will hold the labelled entry. You can create only one
#                  labelled entry into the same parent. The caller has to pack himself this parent
#          label: the text of the label
#          callback: the name of a procedure that will be called when the operator hits the return key
#                    inside the entry widget. This caller procedure is called
#                    with 2 parameters: the name of the entry widget and its value
#          type: currently supported types are: interger  float string (string type is not checked).
#          min, max: range. to disabled them (ex in string type) they must be set to * *
#          first: The value which will be inserted into the entry widget at creation time
#ARGOUT:   NONE
#RETURN:   The entry widget name: $parent.entry
#ERROR :   NONE
#GLOBAL_CREATED: NONE
#GLOBAL_USED: NONE
#GLOBAL_MODIFIED: NONE
#SEE ALSO:
#SOURCE FILE: 
#AUTHOR: G. Pepellin
#$Date: 98/08/03 11:53:53 $
#$Revision: 2.3 $
#-############################################################################
global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }

# Check if there is at least one limit
if {($min == "*") && ($max == "*")} {set range $FALSE} else {set range $TRUE}

# Create a label widget to hold the text 
label $parent.label -text $label -anchor c
pack $parent.label -padx 0 -pady 0 -ipadx 0 -ipady 0 -anchor c -side top

# If there is at least one limit, create a lable widget to hold its value
if { $range == $TRUE } {
  label $parent.limit -text "min = $min  max = $max" -fg Green  -anchor c
  pack $parent.limit -padx 0 -pady 0 -ipadx 0 -ipady 0 -anchor c -side top
  if { $min == "*" } { $parent.limit configure -text "max = $max"}
  if { $max == "*" } {$parent.limit configure -text "min = $min"}
}

# Create the entry widget and fill it with the first value
entry $parent.entry -width 15 -bg white -fg Black
$parent.entry insert 0 "$first"  
pack $parent.entry -padx 1 -pady 1 -ipadx 1 -anchor c -side top
bind $parent.entry <Control-Shift-Button-3> {BalloonHelp %x %y %W %W}
bind $parent.entry <Key-Return> " createEntryWindowCheck  $parent.entry $callback  $type $min $max"

return $parent.entry

} ;# ends proc CreateEntryWindow

proc createEntryWindowCheck {w callback  type min max} {
# check if the entry is valid. If yes activate the callback. 
#                              If not set bg to orange
  set res [CheckEntry [$w get] $type $min $max]
  if {$res == 1} {
    $callback $w [$w get]
    $w configure -bg White
  } else { $w configure -bg Orange }
} ;# ends proc createEntryWindowCheck

### Create the packge rrap
package provide rrap 2.3
