proc CheckEntry {value type  args } {
#+############################################################################
#NAME:     CheckEntry  check an user entry 
#SYNOPSIS: CheckEntry value type limits min max
#DESCRIPTION: Check if a value is syntaxically correct with respect to its
#             requested type (string interger float) and optionally if this
#             value respects the range defines by min and max
#             The range is only tested if arguments min AND max are present
#ARGIN:    value: The value to be tested. MANDATORY. value IS AN ASCII STRING
#          type:  The requested type: integer float string
#          args: either nothing or 2 argin min and max (see below)
#          min and max: Either 0 or both arguments. If they exits they will
#                       be used to check if  value belongs to the range defined
#                       by min and max. min or max can be ste to "*" in this
#                       case the corresponding limit is not checkde.
#                       ex: 0 1000 ; * 100 ; -10.5 100.45 ; 0 *
#          If the number of argin is wrong (valid numbers are 2 or 4) nothing
#            is done and NOTOK (-1) is returned
#
#ARGOUT:   NONE
#RETURN:   TRUE (1) if check succeeded, FALSE (0) if failed 
#          NOTOK (-1) if number of argins is wrong or type is unknown
#ERROR :   NONE
#GLOBAL_CREATED: NONE
#GLOBAL_USED: Generic ones: TRUE and FALSE
#GLOBAL_MODIFIED: NONE
#PROCEDURE_CALLED: NONE
#SEE ALSO:
#SOURCE FILE:
#AUTHOR: G. Pepellin
#$Date: 98/08/03 11:53:51 $
#$Revision: 2.3 $
#-############################################################################
  global ARR_GLOB1; foreach elt [array names ARR_GLOB1] { global $elt }
  global _DEBUG0
  if {([llength $args] != 0 ) && ([llength $args] != 2 )} {
    printDebug0 "CheckEntry: Bad number of arguments"
    return $NOTOK
  }
  printDebug0 "CheckEntry: value= $value type= $type" 
  # Check the return_code of value according to its type
  switch $type {
 
  "string"	{ return $TRUE }
 
  "float"	{
            switch -regexp -- $value {
 
              (^[-+]?[0-9]+$) { set return_code $TRUE }
 
              (^[-+]?[0-9]+[.][0-9]*$) { set return_code $TRUE }

              (^[-+]?[0-9]*[.][0-9]+$) { set return_code $TRUE }

              (^[-+]?[0-9]*[.][0-9]+[eE][+-]?[0-9]+$) { set return_code $TRUE}

              (^[-+]?[0-9]+[.]?[0-9]*[eE][+-]?[0-9]+$) { set return_code $TRUE}
 
              default { set return_code  $FALSE } 

            }
           }
 
   integer	{
                 switch -regexp -- $value {
                   (^[-+]?[0-9]+$) { set return_code $TRUE }
 
                    default { set return_code $FALSE } 
 
                 }
               } 
 
    default { set return_code $FALSE }

 } ;#end of switch type

  # Do we have to check the range?
  if {$return_code == $FALSE} {
    printDebug0  "CheckEntry: Syntax error" 
    return $FALSE
  }
  if {[llength $args] == 0 } { return $return_code}
    # Yes we need
    set min [lindex $args 0] ; set max [lindex $args 1]
		if { ($min != "*" ) && ( $value < $min ) } {
		  printDebug0 "Value under range"
		  set return_code $FALSE
		}

		if { ($max != "*" ) && ( $value > $max ) } {
		  printDebug0 "Value over range"
		  set return_code $FALSE
		}

		return $return_code
} ;# ends proc CheckEntry

### Create the packge rrap
package provide rrap 2.3
