proc CenterToplevelWindow {w} {
#+############################################################################
#NAME:     CenterToplevelWindow  with respect to this physical screen  
#SYNOPSIS: CenterToplevelWindow w
#DESCRIPTION: Center a toplevel window with respect to the physical screen
#ARGIN:    w: the window to be positionned
#ARGOUT:   NONE
#RETURN:   NONE
#ERROR :   See ARGOUT
#GLOBAL_CREATED:  NONE
#GLOBAL_USED:     NONE
#GLOBAL_MODIFIED: NONE
#SEE ALSO:
#SOURCE FILE:
#AUTHOR: G. Pepellin
#-############################################################################
  # get screen sizes
  set scrx [winfo screenwidth $w] ; set scry [winfo screenheight $w]
#  puts "scrx= $scrx scry= $scry"
  # get the  window size
  set geom [GetWindowGeometry $w]
  set wx  [lindex $geom 0] ; set wy  [lindex $geom 1]
  set wdx [lindex $geom 2] ; set wdy [lindex $geom 3]
  # calculate  the window x ofsset dx
  set dx [expr [expr $scrx - $wx ] / 2 ]
  # calculate  the window x ofsset dy
  set dy [expr [expr $scry - $wy ] / 2 ]
  # position the main window
#  puts "w= $w dx= $dx dy=$dy"
  PositionToplevelWindow screen $w $dx $dy
} ;# ends proc CenterToplevelWindow

### Create the packge rrap
package provide rrap 2.3
