//=============================================================================
//
// file :         TemplateDevServClass.h
//
// description :  Include for the TemplateDevServClass root class.
//                This class is represents the singleton class for
//                the TemplateDevServ device class.
//                It contains all properties and methods which the 
//                TemplateDevServ requires only once e.g. the commands.
//			
// project :      TANGO Device Server
//
// $Author:  $
//
// $Revision$
//
// $Log: DevServClass.h,v $
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//             (c) - Pascal Verdier - ESRF
//=============================================================================

#ifndef _TEMPLATEDEVSERVCLASS_H
#define _TEMPLATEDEVSERVCLASS_H

#include <tango.h>


namespace TemplateDevServ
{
//
// Define classes for commands
//
class DevTemplateCmd : public Tango::Command
{
public:
	DevTemplateCmd(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	DevTemplateCmd(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~DevTemplateCmd() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};

//
// The TemplateDevServClass singleton definition
//

class TemplateDevServClass : public Tango::DeviceClass
{
public:

//	Method prototypes
	static TemplateDevServClass *init(const char *);
	static TemplateDevServClass *instance();
	~TemplateDevServClass() {_instance = NULL;}
	
protected:
	TemplateDevServClass(string &);
	static TemplateDevServClass *_instance;
	void command_factory();

private:
	void device_factory(const Tango::DevVarStringArray *);
};


}	//	namespace TemplateDevServ

#endif // _TEMPLATEDEVSERVCLASS_H
