//+============================================================================
// $Source: $
//
// project :     Tango Device Server
//
// Description:	java source code for the TemplateDevServ class and its commands.
//              This class is derived from DeviceImpl class.
//              It represents the CORBA servant obbject which
//              will be accessed from the network. All commands which
//              can be executed on the TemplateDevServ are implemented
//              in this file.
//
// $Author: $
//
// $Revision$
//
// $Log:	$
//
// copyleft :   European Synchrotron Radiation Facility
//              BP 220, Grenoble 38043
//              FRANCE
//
//-============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//             (c) - Pascal Verdier - ESRF
//=============================================================================


/**
 * @author	$Author:  $
 * @version	$Revision: 1.0 $
 */


import java.util.*;
import org.omg.CORBA.*;
import Tango.*;
import TangoDs.*;



public class TemplateDevServ extends DeviceImpl implements TangoConst
{
	protected	int	state;

	//	Start of attributes menmber data.

	//	End of Attributes menmber data.

//=========================================================
/**
 *	Constructor for simulated Time Device Server.
 *
 *	@param	cl	The DeviceClass object
 *	@param	s	The Device name.
 */
//=========================================================
	TemplateDevServ(DeviceClass cl, String s) throws DevFailed
	{
		super(cl,s);
		init_device();
	}
//=========================================================
/**
 *	Constructor for simulated Time Device Server.
 *
 *	@param	cl	The DeviceClass object
 *	@param	s	The Device name.
 *	@param	d	Device description.
 */
//=========================================================
	TemplateDevServ(DeviceClass cl, String s, String d) throws DevFailed
	{
		super(cl,s,d);
		init_device();
	}


//=========================================================
/**
 *	Initialize the device.
 */
//=========================================================
	public void init_device()
	{
		System.out.println("TemplateDevServ() create " + dev_name);
		set_state(DevState.ON);
		System.out.println("TemplateDevServ(" + dev_name + ") initialized");
	}



//	Command Execution Methods

//=========================================================
/**
 *	Command to read the device state
 *
 *	@return the device state code.
 */
//=========================================================
	public DevState state_cmd()
	{

		TangoUtil.out2.println("In PowerSupply state command");
	
		return dev_state;
	}

//=========================================================
/**
 *	Command to read the device status
 *
 *	@return the device state as String.
 */
//=========================================================
	public String status_cmd()
	{

		TangoUtil.out2.println("In PowerSupply status command");
		return dev_status;
	}

//=========================================================
/**
 *	main part for the device server class
 */
//=========================================================
	public static void main(String[] argv)
	{
		try
		{
			TangoUtil tg = TangoUtil.init(argv,"templatedevserv");
			tg.server_init();

			System.out.println("Ready to accept request");

			tg.get_boa().impl_is_ready(null);
		}

		catch (OutOfMemoryError ex)
		{
			System.err.println("Can't allocate memory !!!!");
			System.err.println("Exiting");
		}
		catch (UserException ex)
		{
			TangoUtil.print_exception(ex);
			
			System.err.println("Received a CORBA user exception");
			System.err.println("Exiting");
		}
		catch (SystemException ex)
		{
			TangoUtil.print_exception(ex);
			
			System.err.println("Received a CORBA system exception");
			System.err.println("Exiting");
		}
		
		System.exit(-1);		
	}
}
	

//--------------------------------------------------------------------------
/* end of $Source: $ */
