static const char *RcsId = "$Header: $";
//+=============================================================================
//
// file :        main.cpp
//
// description : C++ source for a TANGO device server main.
//               The main rule is to initialise (and create) the Tango
//               system and to create the DServerClass singleton.
//               The main should be the same for every Tango device server.
//
// project :     TANGO Device Server
//
// $Author:  $
//
// $Revision$
//
// $Log: main.cpp,v $
//
// copyleft :    European Synchrotron Radiation Facility
//               BP 220, Grenoble 38043
//               FRANCE
//
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//             (c) - Pascal Verdier - ESRF
//=============================================================================

#include <tango_ds.h>


int main(int argc,char *argv[])
{

	try
	{
	
//
// Initialise the device server
//

		TangoUtil *tg = TangoUtil::init(argc,argv);

//
// Create the device server singleton which will create everything
//

		tg->server_init();

//
// Run the endless loop
//

		cout << "Ready to accept request" << endl;
		tg->get_boa()->impl_is_ready(CORBA_ImplementationDef::_nil());
	}
	catch (bad_alloc)
	{
		cout << "Can't allocate memory to store device object !!!" << endl;
		cout << "Exiting" << endl;
	}
	catch (CORBA_Exception &e)
	{
		TangoUtil::print_exception(e);
		
		cout << "Received a CORBA_Exception" << endl;
		cout << "Exiting" << endl;
	}
	
	return(0);
}
