//=============================================================================
//
// file :         TemplateDevServClass.h
//
// description :  Include for the TemplateDevServClass root class.
//                This class is represents the singleton class for
//                the TemplateDevServ device class.
//                It contains all properties and methods which the 
//                TemplateDevServ requires only once e.g. the commands.
//			
// project :      TANGO Device Server
//
// $Author:  $
//
// $Revision$
//
// $Log: DevServClass.h,v $
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//             (c) - Pascal Verdier - ESRF
//=============================================================================

#ifndef _TEMPLATEDEVSERVCLASS_H
#define _TEMPLATEDEVSERVCLASS_H

#include <tango_ds.h>

//
// Define classes for commands
//
class DevTemplateCmd : public Command
{
public:
	DevTemplateCmd(const char *,Tango_CmdArgType, Tango_CmdArgType,const char *,const char *);
	DevTemplateCmd(const char *,Tango_CmdArgType, Tango_CmdArgType);
	~DevTemplateCmd() {};
	
	virtual bool is_allowed (DeviceImpl *, const CORBA_Any &);
	virtual CORBA_Any *execute (DeviceImpl *, const CORBA_Any &);
};

//
// The TemplateDevServClass singleton definition
//

class TemplateDevServClass : public DeviceClass
{
public:
	static TemplateDevServClass *init(const char *);
	static TemplateDevServClass *instance();
	~TemplateDevServClass() {_instance = NULL;}
	
protected:
	TemplateDevServClass(string &);
	static TemplateDevServClass *_instance;
	void command_factory();

private:
	void device_factory(Tango_DevVarStringArray *);
};

#endif // _TEMPLATEDEVSERVCLASS_H
