//+======================================================================
// $Source: /segfs/tango/tools/pogo/appli/RCS/StateDialog.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: verdier $
//
// $Version$
//
// $Log: StateDialog.java,v $
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package pogo.appli;


import java.util.*;
import javax.swing.*;
import pogo.gene.*;


//===============================================================
/**
 *	A Dialog Class to get the State parameters.
 */
//===============================================================
public class PropertyDialog extends javax.swing.JDialog implements PogoAppliDefs, PogoDefs {

	private static int returnStatus = PogoAppliDefs.RET_CANCEL;

  /** Initializes the Form */
  public PropertyDialog(java.awt.Frame parent,boolean modal) {
	super (parent, modal);
	initComponents ();

	//  init comboboxes with data type except void type
	//----------------------------------------------------
	for (int i=1 ; i<TangoTypesArray.length ; i++)
		jComboBox1.addItem(TangoTypesArray[i]);

	pack ();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    jPanel1 = new javax.swing.JPanel ();
    okBtn = new javax.swing.JButton ();
    cancelBtn = new javax.swing.JButton ();
    jPanel2 = new javax.swing.JPanel ();
    nameLbl = new javax.swing.JLabel ();
    jLabel5 = new javax.swing.JLabel ();
    jLabel6 = new javax.swing.JLabel ();
    descText = new javax.swing.JTextArea ();
    jComboBox1 = new javax.swing.JComboBox ();
    jLabel1 = new javax.swing.JLabel ();
    nameText = new javax.swing.JTextField ();
    setBackground (new java.awt.Color (198, 178, 168));
    setTitle ("Edit Property Window");
    addWindowListener (new java.awt.event.WindowAdapter () {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        closeDialog (evt);
      }
    }
    );

    jPanel1.setLayout (new java.awt.FlowLayout (2, 5, 5));

      okBtn.setText ("OK");
      okBtn.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          okBtnActionPerformed (evt);
        }
      }
      );
  
      jPanel1.add (okBtn);
  
      cancelBtn.setText ("Cancel");
      cancelBtn.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          cancelBtnActionPerformed (evt);
        }
      }
      );
  
      jPanel1.add (cancelBtn);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.SOUTH);

    jPanel2.setLayout (new java.awt.GridBagLayout ());
    java.awt.GridBagConstraints gridBagConstraints1;

      nameLbl.setText ("Property type");
      nameLbl.setForeground (java.awt.Color.black);
      nameLbl.setFont (new java.awt.Font ("Dialog", 1, 11));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 2;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (nameLbl, gridBagConstraints1);
  
      jLabel5.setText (" ");
      jLabel5.setForeground (java.awt.Color.black);
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 6;
      jPanel2.add (jLabel5, gridBagConstraints1);
  
      jLabel6.setText ("Property Description:  ");
      jLabel6.setForeground (java.awt.Color.black);
      jLabel6.setFont (new java.awt.Font ("Dialog", 1, 11));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 8;
      gridBagConstraints1.gridwidth = 2;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (jLabel6, gridBagConstraints1);
  
      descText.setPreferredSize (new java.awt.Dimension(450, 200));
      descText.setMinimumSize (new java.awt.Dimension(0, 100));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 9;
      gridBagConstraints1.gridwidth = 2;
      gridBagConstraints1.gridheight = 5;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints1.weighty = 5.0;
      jPanel2.add (descText, gridBagConstraints1);
  
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 2;
      jPanel2.add (jComboBox1, gridBagConstraints1);
  
      jLabel1.setText ("Property name");
      jLabel1.setForeground (java.awt.Color.black);
      jLabel1.setFont (new java.awt.Font ("Dialog", 1, 11));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 1;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (jLabel1, gridBagConstraints1);
  
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 1;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jPanel2.add (nameText, gridBagConstraints1);
  

    getContentPane ().add (jPanel2, java.awt.BorderLayout.CENTER);

  }//GEN-END:initComponents



  private void cancelBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBtnActionPerformed
  doClose(PogoAppliDefs.RET_CANCEL);
  }//GEN-LAST:event_cancelBtnActionPerformed

  private void okBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okBtnActionPerformed

	//	Check it at least the property name has been filled.
	//---------------------------------------------------------
	if (nameText.getText().length()<=0)
	{
			JOptionPane.showMessageDialog(this, 
								"Property's name must be filled in !",
								"Error Window",
								JOptionPane.ERROR_MESSAGE);
	}
	else
	    doClose(PogoAppliDefs.RET_OK);
  }//GEN-LAST:event_okBtnActionPerformed

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
  doClose(PogoAppliDefs.RET_CANCEL);
  }//GEN-LAST:event_closeDialog

   //======================================================
 public int showDialog(Property property)
  {
    //  Initialize Window with input parameters
    //-----------------------------------------------
	nameText.setText(property.name);
	for (int i=1 ; i<TangoTypesArray.length ; i++)
      if (TangoTypesArray[i].equals(property.type.code_str))
        jComboBox1.setSelectedIndex(i-1);

    if (property.description!=null)
      descText.setText(property.description);

    setVisible(true);
    return returnStatus;
  }
  //======================================================
  private void doClose(int retStatus)
  {
    returnStatus = retStatus;
    setVisible (false);
    dispose ();
  }

  //======================================================
  public Property  getInput()
  {
	//	Take of space char if exist
	//--------------------------------------
	StringTokenizer stk = new StringTokenizer(nameText.getText());
	String	name = stk.nextToken();

	//	Check if first char is upcase else set it
	//-------------------------------------------------
	if (name.charAt(0) >='a' || name.charAt(0) >='z')
	{
		char	car = (char)(name.charAt(0)-('a'-'A'));
		name = new String(car + name.substring(1));
	}
	return new Property(name,
  						jComboBox1.getSelectedItem().toString(),
						descText.getText());
 }

// Variables declaration - do not modify//GEN-BEGIN:variables
private javax.swing.JPanel jPanel1;
private javax.swing.JButton okBtn;
private javax.swing.JButton cancelBtn;
private javax.swing.JPanel jPanel2;
private javax.swing.JLabel nameLbl;
private javax.swing.JLabel jLabel5;
private javax.swing.JLabel jLabel6;
private javax.swing.JTextArea descText;
private javax.swing.JComboBox jComboBox1;
private javax.swing.JLabel jLabel1;
private javax.swing.JTextField nameText;
// End of variables declaration//GEN-END:variables


  public static void main(java.lang.String[] args) {
    new StateDialog (new java.awt.Frame (), false).show ();
  }

}
