//+======================================================================
// $Source: /segfs/tango/tools/pogo/appli/RCS/PrefGeneDialog.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: verdier $
//
// $Version$
//
// $Log: PrefGeneDialog.java,v $
// Revision 1.23  2000/10/24 06:21:22  verdier
// The compatibility with TANGO2 has been tested on DatabaseDs.
//
// Revision 1.22  2000/10/02 05:52:20  verdier
// Attribute code generated is now compatible with Tango 2.
//
// Revision 1.21  2000/09/22 08:54:31  verdier
// DevState & DevStatus are virtual.
// First tests with Tango2
// Taco import utility added.
//
// Revision 1.20  2000/07/07 13:30:10  verdier
// Utilities added after first users.
//
// Revision 1.18  2000/06/20 06:57:35  verdier
// Right button double click management added for :
// editing src code, creating item, editing class....
// Little bugs fixed on generation/re-read src code.
//
// Revision 1.17  2000/05/12 07:37:10  verdier
//  Attributes management added for java generation.
//
// Revision 1.16  2000/04/26 06:04:00  verdier
// The save/restore file (.pogo) does not exist anymore.
// DevStates and DevStates allowed management is now available for java.
//
// Revision 1.15  2000/04/18 08:12:47  verdier
// Management of DevStates to allow command added.
//
// Revision 1.14  2000/04/12 09:25:43  verdier
// Methods to manage attributes are now generated
//  Only if at leat one attribute exists.
//
// Revision 1.13  2000/04/11 09:35:07  verdier
// Attributes management added.
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================
package pogo.appli;




import javax.swing.*;
import java.io.*;
import pogo.gene.*;


/**
 *	Dialog object to manage generation preferences.
 */

public class PrefGeneDialog extends javax.swing.JDialog implements PogoAppliDefs, PogoDefs {

  private static int returnStatus = PogoAppliDefs.RET_CANCEL;

  /** Initializes the Form */
  public PrefGeneDialog(java.awt.Frame parent,boolean modal) {
      super (parent, modal);
    initComponents ();
   pack ();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    jPanel1 = new javax.swing.JPanel ();
    okBtn = new javax.swing.JButton ();
    cancelBtn = new javax.swing.JButton ();
    jPanel = new javax.swing.JPanel ();
    nameLbl = new javax.swing.JLabel ();
    jLabel5 = new javax.swing.JLabel ();
    outPathText = new javax.swing.JTextField ();
    jButton1 = new javax.swing.JButton ();
    setBackground (new java.awt.Color (198, 178, 168));
    setTitle ("Geneartion Preference  Window");
    addWindowListener (new java.awt.event.WindowAdapter () {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        closeDialog (evt);
      }
    }
    );

    jPanel1.setLayout (new java.awt.FlowLayout (2, 5, 5));

      okBtn.setText ("OK");
      okBtn.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          okBtnActionPerformed (evt);
        }
      }
      );
  
      jPanel1.add (okBtn);
  
      cancelBtn.setText ("Cancel");
      cancelBtn.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          cancelBtnActionPerformed (evt);
        }
      }
      );
  
      jPanel1.add (cancelBtn);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.SOUTH);

    jPanel.setLayout (new java.awt.GridBagLayout ());
    java.awt.GridBagConstraints gridBagConstraints1;

      nameLbl.setText ("  Output Path:    ");
      nameLbl.setForeground (java.awt.Color.black);
      nameLbl.setFont (new java.awt.Font ("Arial", 1, 12));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 1;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel.add (nameLbl, gridBagConstraints1);
  
      jLabel5.setText (" ");
      jLabel5.setForeground (java.awt.Color.black);
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 6;
      jPanel.add (jLabel5, gridBagConstraints1);
  
      outPathText.setPreferredSize (new java.awt.Dimension(450, 25));
      outPathText.setMinimumSize (new java.awt.Dimension(450, 25));
      outPathText.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          okBtnActionPerformed (evt);
        }
      }
      );
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 2;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.weightx = 1.0;
      gridBagConstraints1.weighty = 1.0;
      jPanel.add (outPathText, gridBagConstraints1);
  
      jButton1.setText ("Browse");
      jButton1.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          browsActionPerformed (evt);
        }
      }
      );
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 2;
      jPanel.add (jButton1, gridBagConstraints1);
  

    getContentPane ().add (jPanel, java.awt.BorderLayout.CENTER);

  }//GEN-END:initComponents


//=============================================================
/**
 *	Open a File Chooser Dialog to select the new output directory.
 */
//=============================================================
  private void browsActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browsActionPerformed

	JFileChooser	chooser = new JFileChooser(outPathText.getText());
	chooser.addChoosableFileFilter(new PogoFileFilter("", "Directory"));
	chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
	int retval = chooser.showDialog(this, "Target Dir.");

	if (retval==JFileChooser.APPROVE_OPTION)
	{
		File  file = chooser.getSelectedFile();
		if (file!=null)
			if (file.isDirectory()==true)
      		{
				outPathText.setText(file.getAbsolutePath().toString());
			}
	}
  }//GEN-LAST:event_browsActionPerformed



  private void cancelBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBtnActionPerformed
  doClose(PogoAppliDefs.RET_CANCEL);
  }//GEN-LAST:event_cancelBtnActionPerformed

  private void okBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okBtnActionPerformed
    doClose(PogoAppliDefs.RET_OK);
  }//GEN-LAST:event_okBtnActionPerformed

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
  doClose(PogoAppliDefs.RET_CANCEL);
  }//GEN-LAST:event_closeDialog

   //======================================================
 public int showDialog(String path)
  {
    //  Initialize Window with input parameters
    //-----------------------------------------------
	outPathText.setText(path);
    setVisible(true);
    return returnStatus;
  }
  //======================================================
  private void doClose(int retStatus)
  {
    returnStatus = retStatus;
    setVisible (false);
    dispose ();
  }

  //======================================================
  public String  getInput()
  {
    return new String(outPathText.getText());
  }
  //======================================================



  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel jPanel1;
  private javax.swing.JButton okBtn;
  private javax.swing.JButton cancelBtn;
  private javax.swing.JPanel jPanel;
  private javax.swing.JLabel nameLbl;
  private javax.swing.JLabel jLabel5;
  private javax.swing.JTextField outPathText;
  private javax.swing.JButton jButton1;
  // End of variables declaration//GEN-END:variables


  public static void main(java.lang.String[] args) {
    new PrefGeneDialog (new java.awt.Frame (), false).show ();
  }

}
