//+======================================================================
// $Source: /segfs/tango/tools/pogo/appli/RCS/PogoHelp.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: verdier $
//
// $Version$
//
// $Log: PogoHelp.java,v $
// Revision 1.23  2000/10/24 06:21:22  verdier
// The compatibility with TANGO2 has been tested on DatabaseDs.
//
// Revision 1.22  2000/10/02 05:52:20  verdier
// Attribute code generated is now compatible with Tango 2.
//
// Revision 1.21  2000/09/22 08:54:31  verdier
// DevState & DevStatus are virtual.
// First tests with Tango2
// Taco import utility added.
//
// Revision 1.20  2000/07/07 13:30:10  verdier
// Utilities added after first users.
//
// Revision 1.18  2000/06/20 06:57:35  verdier
// Right button double click management added for :
// editing src code, creating item, editing class....
// Little bugs fixed on generation/re-read src code.
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package pogo.appli;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import javax.swing.*;

import pogo.gene.*;
import pogo.appli.*;

//===========================================================
/**
 *  This class manage the POGO help messages.
 */
//===========================================================
public class PogoHelp
{
	public PogoHelp()
	{
	}
//===========================================================
/**
 *	Read an help message in a file and return it.
 *
 *	@param	itemStr	Help item.
 *	@return	the text read in file.
 */
//===========================================================
	static public String getMessage(String itemStr)
	{
		//	Get the template directory from property
		//--------------------------------------------------
		String templates_dir;
		if ((templates_dir=System.getProperty("TEMPL_HOME"))==null)
			return "No Template Property (TEMPL_HOME) Fixed !";

		try
		{
			String	filename = new String(templates_dir + "/txt/"
													+ itemStr + ".txt");
			//	Open and read file
			//----------------------------------------
			FileInputStream		fidin = new FileInputStream(filename);
			int nb = fidin.available();
			byte[]	inStr  = new byte[nb];
			fidin.read(inStr);
			String str = new String(inStr);
			fidin.close();
			return str;
		}
		catch(FileNotFoundException e){	return e.toString(); }
		catch(IOException e){	return e.toString(); }
	}
//===========================================================
/**
 *	Read an help message in a file and display it in a message dialog.
 *
 *	@param	frame	The parent frame.
 *	@param	itemStr	Help item.
 */
//===========================================================
	static public void displayMessage(JFrame frame, String itemStr)
	{
		String	message = getMessage(itemStr);
		JOptionPane.showMessageDialog(frame,  message, "Help Window",
                          JOptionPane.INFORMATION_MESSAGE);
	}
}
