//+======================================================================
// $Source: /segfs/tango/tools/pogo/appli/RCS/PogoAppli.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: verdier $
//
// $Version$
//
// $Log: PogoAppli.java,v $
// Revision 1.23  2000/10/24 06:21:22  verdier
// The compatibility with TANGO2 has been tested on DatabaseDs.
//
// Revision 1.22  2000/10/02 05:52:20  verdier
// Attribute code generated is now compatible with Tango 2.
//
// Revision 1.21  2000/09/22 08:54:31  verdier
// DevState & DevStatus are virtual.
// First tests with Tango2
// Taco import utility added.
//
// Revision 1.20  2000/07/07 13:30:10  verdier
// Utilities added after first users.
//
// Revision 1.18  2000/06/20 06:57:35  verdier
// Right button double click management added for :
// editing src code, creating item, editing class....
// Little bugs fixed on generation/re-read src code.
//
// Revision 1.17  2000/05/12 07:37:10  verdier
//  Attributes management added for java generation.
//
// Revision 1.16  2000/04/26 06:04:00  verdier
// The save/restore file (.pogo) does not exist anymore.
// DevStates and DevStates allowed management is now available for java.
//
// Revision 1.15  2000/04/18 08:12:47  verdier
// Management of DevStates to allow command added.
//
// Revision 1.14  2000/04/12 09:25:43  verdier
// Methods to manage attributes are now generated
//  Only if at leat one attribute exists.
//
// Revision 1.13  2000/04/11 09:35:07  verdier
// Attributes management added.
//
// Revision 1.3  2000/03/29 13:11:48  verdier
// Doc generation added.
//
// Revision 1.2  2000/03/03 09:43:00  verdier
// States management added
//
// Revision 1.1  2000/02/28 15:41:38  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package pogo.appli;


import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import javax.swing.*;

import pogo.gene.*;

//===========================================================
/**
 *  This is class managing the main window for the POGO
 *  (Program Obviously used to Generate tango Object) application.
 *
 *  @see <a href=/segfs/tango/doc/www/tango/tango.html> Tango Pages</a>
 */
//===========================================================
public class PogoAppli extends javax.swing.JFrame
            implements PogoAppliDefs, PogoDefs {
/**
 *  Initialized by rcs unix utility and used to display title.
 *  @see <a href=../gene/RcsId.html> RcsId </a>
 */
  private static String rcsString
     = "$Header: /segfs/tango/tools/pogo/appli/RCS/PogoAppli.java,v 1.23 2000/10/24 06:21:22 verdier Exp verdier $";
/**
 *  JTree used to display <a href=../gene/PogoClass.html>PogoClass</a> object.
 */
  private PogoTree  tree;
/**
 *  Pogo object definition (used to define project and generate source file).
 */
  private PogoClass  pogo;
/**
 *  Director to start file selection.
 *  Could be set with 'HOME_GENE' property.
 */
  private String  homeDir;
/**
 *	File Chooser Object used in file menu.
 */
  private JFileChooser  chooser;

//===========================================================
/**
 *  Constructor for PogoAppli object.
 *  Initialize JForm.
 *  And initialize some little things.
 */
 //===========================================================
	public PogoAppli()
	{
		initComponents ();

		//  Create Pogo Tree
		//------------------------------
		tree = new PogoTree(this);

		jScrollPane1.setPreferredSize(new Dimension(300, 350));
		jScrollPane1.setViewportView (tree);
		customMenu();
		setPogoDefined(false);
		setTitle (new utilities.RcsId(rcsString).toString());

		pack ();
	}

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
        private void initComponents () {//GEN-BEGIN:initComponents
          menuBar = new javax.swing.JMenuBar ();
          fileMenu = new javax.swing.JMenu ();
          newMenuItem = new javax.swing.JMenuItem ();
          openMenuItem = new javax.swing.JMenuItem ();
          importMenuItem = new javax.swing.JMenuItem ();
          jSeparator1 = new javax.swing.JSeparator ();
          geneSrcBtn = new javax.swing.JMenuItem ();
          geneDocBtn = new javax.swing.JMenuItem ();
          jSeparator2 = new javax.swing.JSeparator ();
          exitMenuItem = new javax.swing.JMenuItem ();
          editMenu = new javax.swing.JMenu ();
          cutMenuItem = new javax.swing.JMenuItem ();
          copyMenuItem = new javax.swing.JMenuItem ();
          pasteMenuItem = new javax.swing.JMenuItem ();
          jSeparator3 = new javax.swing.JSeparator ();
          deleteMenuItem = new javax.swing.JMenuItem ();
          moveUpItem = new javax.swing.JMenuItem ();
          moveDownItem = new javax.swing.JMenuItem ();
          paletteMenu = new javax.swing.JMenu ();
          prefMenu = new javax.swing.JMenu ();
          jMenuItem1 = new javax.swing.JMenuItem ();
          helpMenu = new javax.swing.JMenu ();
          contentsMenuItem = new javax.swing.JMenuItem ();
          jSeparator4 = new javax.swing.JSeparator ();
          aboutMenuItem = new javax.swing.JMenuItem ();
          jScrollPane1 = new javax.swing.JScrollPane ();
          southPanel = new javax.swing.JPanel ();
          mousePanel = new javax.swing.JPanel ();
          leftBtnLabel = new javax.swing.JLabel ();
          rightBtnLabel = new javax.swing.JLabel ();
          jPanel1 = new javax.swing.JPanel ();
          jLabel1 = new javax.swing.JLabel ();
          cppBtn = new javax.swing.JRadioButton ();
          javaBtn = new javax.swing.JRadioButton ();

            fileMenu.setText ("File");
            fileMenu.setName ("File");
  
              newMenuItem.setText ("New Class");
              newMenuItem.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  newMenuItemActionPerformed (evt);
                }
              }
              );
    
              fileMenu.add (newMenuItem);
              openMenuItem.setToolTipText ("Open Class File");
              openMenuItem.setText ("Open");
              openMenuItem.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  openMenuItemActionPerformed (evt);
                }
              }
              );
    
              fileMenu.add (openMenuItem);
              importMenuItem.setToolTipText ("import TACO server");
              importMenuItem.setText ("Import");
              importMenuItem.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  importMenuItemActionPerformed (evt);
                }
              }
              );
    
              fileMenu.add (importMenuItem);
    
              fileMenu.add (jSeparator1);
              geneSrcBtn.setText ("Generate Source");
              geneSrcBtn.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  generateAP (evt);
                }
              }
              );
    
              fileMenu.add (geneSrcBtn);
              geneDocBtn.setText ("Generate Doc.");
              geneDocBtn.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  generateAP (evt);
                }
              }
              );
    
              fileMenu.add (geneDocBtn);
    
              fileMenu.add (jSeparator2);
              exitMenuItem.setText ("Exit");
              exitMenuItem.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  exitMenuItemActionPerformed (evt);
                }
              }
              );
    
              fileMenu.add (exitMenuItem);
            menuBar.add (fileMenu);
            editMenu.setText ("Edit");
            editMenu.addMenuListener (new javax.swing.event.MenuListener () {
              public void menuCanceled (javax.swing.event.MenuEvent evt) {
  
              }
              public void menuDeselected (javax.swing.event.MenuEvent evt) {
  
              }
              public void menuSelected (javax.swing.event.MenuEvent evt) {
                editAP (evt);
              }
            }
            );
  
              cutMenuItem.setText ("Cut");
              cutMenuItem.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  cutMenuItemActionPerformed (evt);
                }
              }
              );
    
              editMenu.add (cutMenuItem);
              copyMenuItem.setText ("Copy");
              copyMenuItem.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  copyMenuItemActionPerformed (evt);
                }
              }
              );
    
              editMenu.add (copyMenuItem);
              pasteMenuItem.setText ("Paste");
              pasteMenuItem.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  pasteMenuItemActionPerformed (evt);
                }
              }
              );
    
              editMenu.add (pasteMenuItem);
    
              editMenu.add (jSeparator3);
              deleteMenuItem.setText ("Delete");
              deleteMenuItem.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  deleteMenuItemActionPerformed (evt);
                }
              }
              );
    
              editMenu.add (deleteMenuItem);
              moveUpItem.setText ("Move Up");
              moveUpItem.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  moveActionPerformed (evt);
                }
              }
              );
    
              editMenu.add (moveUpItem);
              moveDownItem.setText ("Move Down");
              moveDownItem.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  moveActionPerformed (evt);
                }
              }
              );
    
              editMenu.add (moveDownItem);
            menuBar.add (editMenu);
            paletteMenu.setText ("Palette");
  
            menuBar.add (paletteMenu);
            prefMenu.setText ("Preferences");
  
              jMenuItem1.setText ("On Generation");
              jMenuItem1.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  genePrefActionPerformed (evt);
                }
              }
              );
    
              prefMenu.add (jMenuItem1);
            menuBar.add (prefMenu);
            helpMenu.setText ("Help");
  
              contentsMenuItem.setText ("Shortcuts");
              contentsMenuItem.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  helpAP (evt);
                }
              }
              );
    
              helpMenu.add (contentsMenuItem);
    
              helpMenu.add (jSeparator4);
              aboutMenuItem.setText ("About");
              aboutMenuItem.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  helpAP (evt);
                }
              }
              );
    
              helpMenu.add (aboutMenuItem);
            menuBar.add (helpMenu);
          setTitle ("Pogo Appli");
          addWindowListener (new java.awt.event.WindowAdapter () {
            public void windowClosing (java.awt.event.WindowEvent evt) {
              exitForm (evt);
            }
          }
          );

          jScrollPane1.setBackground (java.awt.Color.white);


          getContentPane ().add (jScrollPane1, java.awt.BorderLayout.CENTER);

          southPanel.setLayout (new java.awt.BorderLayout ());

            mousePanel.setLayout (new java.awt.BorderLayout ());
  
              leftBtnLabel.setHorizontalTextPosition (javax.swing.SwingConstants.LEFT);
    
              mousePanel.add (leftBtnLabel, java.awt.BorderLayout.WEST);
    
    
              mousePanel.add (rightBtnLabel, java.awt.BorderLayout.EAST);
    
            southPanel.add (mousePanel, java.awt.BorderLayout.NORTH);
  
  
              jLabel1.setBackground (java.awt.Color.white);
              jLabel1.setText ("Language Generated: ");
    
              jPanel1.add (jLabel1);
    
              cppBtn.setToolTipText ("The device server will be generated in C++");
              cppBtn.setText ("C++");
              cppBtn.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  languageBtnAP (evt);
                }
              }
              );
    
              jPanel1.add (cppBtn);
    
              javaBtn.setToolTipText ("The device server will be generated in Java");
              javaBtn.setText ("Java");
              javaBtn.addActionListener (new java.awt.event.ActionListener () {
                public void actionPerformed (java.awt.event.ActionEvent evt) {
                  languageBtnAP (evt);
                }
              }
              );
    
              jPanel1.add (javaBtn);
    
            southPanel.add (jPanel1, java.awt.BorderLayout.SOUTH);
  

          getContentPane ().add (southPanel, java.awt.BorderLayout.SOUTH);

          setJMenuBar (menuBar);

        }//GEN-END:initComponents


//===========================================================
  private void pasteMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pasteMenuItemActionPerformed
	tree.paste();
  }//GEN-LAST:event_pasteMenuItemActionPerformed

//===========================================================
  private void copyMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_copyMenuItemActionPerformed
	tree.copySelection();
  }//GEN-LAST:event_copyMenuItemActionPerformed

//===========================================================
  private void cutMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cutMenuItemActionPerformed
	tree.cutSelection();
  }//GEN-LAST:event_cutMenuItemActionPerformed

//===========================================================
/**
 *  Called on Move up or down button.
 *  Move up or down the selected item.
 */
//===========================================================
  private void moveActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveActionPerformed
  String  cmd = evt.getActionCommand();

	if (cmd.indexOf("Up")>=0)
		tree.moveUpSelection();
	else
		tree.moveDownSelection();
  }//GEN-LAST:event_moveActionPerformed

//===========================================================
/**
 *  Called on Generation Preferences button.
 *  Open the dialog object to manage preferences and set fields.
 */
//===========================================================
  private void genePrefActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_genePrefActionPerformed
	
	//  Check if home dir has been initialize
	//------------------------------------------------
	if (homeDir==null)
		if ((homeDir=System.getProperty("HOME_GENE"))==null)
			homeDir = new File("").getAbsolutePath();

	PrefGeneDialog	dialog = new PrefGeneDialog(this, true);
	if (dialog.showDialog(homeDir) == PogoAppliDefs.RET_OK)
		homeDir = dialog.getInput();
	tree.setHomeDir(homeDir);
  }//GEN-LAST:event_genePrefActionPerformed

//===========================================================
/**
 *  Called on Edit menu buttoncliked.
 *  Check if a leaf is selected or not.
 *  And then enable or not the buttons.
 */
//===========================================================
  private void editAP (javax.swing.event.MenuEvent evt) {//GEN-FIRST:event_editAP
	boolean		state  = tree.isLeafSelected();

	copyMenuItem.setEnabled(state);
	cutMenuItem.setEnabled(state);
	pasteMenuItem.setEnabled(tree.objToBePasted());
	deleteMenuItem.setEnabled(state);
	moveUpItem.setEnabled(state);
	moveDownItem.setEnabled(state);
  }//GEN-LAST:event_editAP


//===========================================================
/**
 *  Called on one item of help menu cliked.
 */
//===========================================================
  private void helpAP (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpAP

  String  cmd = evt.getActionCommand();
  String  message = null;

	if (cmd.equals("About"))
		message = new String(new utilities.RcsId(rcsString).toString()+
									 "\n\n\n" + PogoAppliDefs.helpAbout);
	else
		PogoHelp.displayMessage(this, cmd);

  if (message!=null)
      JOptionPane.showMessageDialog(this,  message, "Help Window",
                          JOptionPane.INFORMATION_MESSAGE);
 }//GEN-LAST:event_helpAP


//===========================================================
/**
 *  Called on New item menu cliked.
 */
//===========================================================
  private void newMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newMenuItemActionPerformed

	//	Do not open a new project if this one
	//	has been modified and not saved.
	//----------------------------------------------------
	if (tree!=null && tree.hasBeenModified())
	{
		Object[] options = { "OK", "CANCEL" };
		if (JOptionPane.showOptionDialog(tree,
				"This project has not been saved !\n\nDiscard modifications ?",
				"Warning",
				JOptionPane.DEFAULT_OPTION,
				JOptionPane.WARNING_MESSAGE,
				null, options, options[0])!=JOptionPane.OK_OPTION)
			return;
	}
	//  Check if home dir has been initialize
	//------------------------------------------------
	if (homeDir==null)
		if ((homeDir=System.getProperty("HOME_GENE"))==null)
			homeDir = new File("").getAbsolutePath();
	//  Open Dialog
	//------------------
	ClassDialog  classDialog = new ClassDialog(this, true);
	if (classDialog.showClassDialog(null, null, null)== PogoAppliDefs.RET_OK)
	{
		//	Remove Old Project, if exists
		//----------------------------------
		if (tree!=null)
		{
			tree.clear();
			setPogoDefined(false);
			versionLabel.setText ("");
			pogo = null;
		}
		//	Create New Project
		//----------------------------------
		try
		{
			pogo = new PogoClass(classDialog.getClassName(),
						classDialog.getDescription(), new Vector(),
						new Vector(), new Vector(), new Vector(), new Vector());
			pogo.title = classDialog.getProjectTitle();
			//tree.modifyRootLeaf(pogo.class_name, pogo.class_desc, pogo.title);
			tree.setPogoTree(pogo);
			setPogoDefined(true);
			resetLanguage();
			tree.setHomeDir(homeDir);
		}
		catch (PogoException ex) {
			JOptionPane.showMessageDialog(this,
					ex + ex.str[0] , "Error Window", JOptionPane.ERROR_MESSAGE);
		}
	}
  }//GEN-LAST:event_newMenuItemActionPerformed



//===========================================================
/**
 *  Called on Generate item menu cliked.
 */
//===========================================================
  private void generateAP (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_generateAP

	String type = evt.getActionCommand();

	if (type.indexOf("Source")>0)
		generateSource(GENE_SRC);
	else
	if (type.indexOf("Doc.")>0)
	{
		//	Before Doc generation check if project
		//	has been modified and saved.
		//----------------------------------------------------
		
		if (tree!=null)
			if (tree.hasBeenModified())
			{
				Object[] options = {"Generate Source\n Before",
									"Generate Only\n Documentation",
									"CANCEL" };
				switch(JOptionPane.showOptionDialog(tree,
						"The source files have not been generateded !\n" +
						"The programmer's guide generation use source files.\n\n\n",
						"Warning",
						JOptionPane.DEFAULT_OPTION,
						JOptionPane.WARNING_MESSAGE,
						null, options, options[0]))
				{
				case 0:
					generateSource(GENE_SRC);
					generateSource(GENE_DOC);
					break;
				case 1:
					generateSource(GENE_DOC);
					break;
				}
			}
			else
				generateSource(GENE_DOC);
	}
  }//GEN-LAST:event_generateAP

//===========================================================
/**
 *  Called on one of the language toggle buttons is clicked.
 */
//===========================================================
  private void languageBtnAP (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_languageBtnAP
    String  lang = evt.getActionCommand();

  if (lang.equals("Java"))
  {
    cppBtn.setSelected(false);
     javaBtn.setSelected(true);
  }
  else
  {
    cppBtn.setSelected(true);
     javaBtn.setSelected(false);
  }
  //	Update Tree global param.
  try{	tree.setLanguage(getLanguage());	}
  catch(PogoException e){}
 }//GEN-LAST:event_languageBtnAP


//======================================================
/**
 *  Generate source files.
 *
 *  Buid a PogoClass from the interface JTree,
 *  get the output langage to generate and call
 *  the popo.gene.PogoGene Class to generate source files.
 *
 *  @param  item FILE_SAVE to save in .pogo file or
 *        GENE_SRC to generate Cpp or Java source files.
 *  @see <a href=pogo/gene/PogoGene.html> PogoGene Class</a>
 */
//======================================================
  private void generateSource(int item)
  {
	//  Check if home dir has been initialize
	//------------------------------------------------
	if (homeDir==null)
		if ((homeDir=System.getProperty("HOME_GENE"))==null)
			homeDir = new File("").getAbsolutePath();

	//  Build a pogo class from tree
	//---------------------------------------
	PogoClass  pogoTree   = tree.getPogoClass();
	if (pogoTree==null)  return;

	//	Confirm for output files dir.
	//---------------------------------
	if (item==GENE_SRC)
	{
		PrefGeneDialog	dialog = new PrefGeneDialog(this, true);
		if (dialog.showDialog(homeDir) != PogoAppliDefs.RET_OK)
			return;
		homeDir = dialog.getInput();
		tree.setHomeDir(homeDir);
	}
	//	And get the data out of tree from previous pogo object
	//-------------------------------------------------------------
	pogoTree.output_files = homeDir ;
	pogoTree.author       = pogo.author;
	pogoTree.revision     = pogo.revision;

	String  message = null;
	try
	{
		//  get language and generate DS
		//----------------------------------------
		pogoTree.language = pogoTree.in_language = getLanguage();
		GenerateThread	gt = new GenerateThread(this, pogoTree, item, homeDir);
		gt.run();
		tree.setModified(false);
	}
	catch (PogoException ex)
	{
		message = ex.toString();
	}
	if (message!=null)
		JOptionPane.showMessageDialog(this,  message, "Error Window",
													JOptionPane.ERROR_MESSAGE);
  }

//======================================================
/**
 * Label for Palette menu items.
 */
 //======================================================
 private static String[]  palette = {"Edit Class", null,
									"Class  Property",
									"Device Property",
									"Command",
									"Attribute",
									"State"
                  };
JLabel	versionLabel;
//======================================================
/**
 * Create the Palette menu item and add accelerators on other menu items.
 */
//======================================================
  private void customMenu()
  {
  	//	Add the Pogo logo image.
	//-----------------------------------------
	String	templates_dir;
	if ((templates_dir=System.getProperty("TEMPL_HOME"))!=null)
	{
		jLabel1.setIcon (new ImageIcon(
					getClass().getResource("/pogo/img/pogo.jpg")));
		jLabel1.setDisabledIcon ((Icon) null);
	}
	jLabel1.setBackground (java.awt.Color.black);   

	//	Create a label to display Author and revision
	//---------------------------------------------------
    versionLabel = new javax.swing.JLabel ();
    versionLabel.setText ("");
	versionLabel.setBackground (java.awt.Color.black);   
    getContentPane().add(versionLabel, "North");
	tree.setMouseUsageListener(leftBtnLabel, rightBtnLabel);

  //  Add mnemonics on existing buttons
  //----------------------------------------------
  fileMenu.setMnemonic ('F');
  editMenu.setMnemonic ('E');
  helpMenu.setMnemonic ('H');
  newMenuItem.setMnemonic ('N');
  openMenuItem.setMnemonic ('O');
  importMenuItem.setMnemonic ('I');
  exitMenuItem.setMnemonic ('E');
  deleteMenuItem.setMnemonic ('D');

  newMenuItem.setAccelerator (KeyStroke.getKeyStroke('N', Event.CTRL_MASK));
  openMenuItem.setAccelerator(KeyStroke.getKeyStroke('O', Event.CTRL_MASK));
  importMenuItem.setAccelerator(KeyStroke.getKeyStroke('I', Event.CTRL_MASK));
  geneSrcBtn.setAccelerator (KeyStroke.getKeyStroke('G', Event.CTRL_MASK));
  geneDocBtn.setAccelerator (KeyStroke.getKeyStroke('H', Event.CTRL_MASK));
  exitMenuItem.setAccelerator(KeyStroke.getKeyStroke('Q', Event.CTRL_MASK));
  deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke('D', Event.CTRL_MASK));

  //  Add Palette menu Items
    //------------------------------
	paletteMenu.setMnemonic ('P');
	for (int i=0; i<palette.length ; i++)
	{
		if (palette[i]!=null)
		{
			JMenuItem  menuItem = new JMenuItem();
			menuItem.setText (palette[i]);
			menuItem.setMnemonic (palette[i].charAt(0));
			menuItem.setAccelerator(KeyStroke.getKeyStroke(
									palette[i].charAt(0), Event.SHIFT_MASK));
			paletteMenu.add(menuItem);
			menuItem.addActionListener(new ActionListener () {
			public void actionPerformed(ActionEvent evt) {
				paletteItemAP(evt);
			}});
		}
		else
		{
			paletteMenu.addSeparator();
			paletteMenu.addSeparator();
			JLabel  lbl = new JLabel(" Create a New:");
			paletteMenu.add(lbl);
		}
	}
	resetLanguage();
  }

//======================================================
/**
 * Set the language toggle button in compatibility with the
 * <a href=pogo/gene/PogoClass.html> PogoClass field</a>.
 */
//======================================================
  private void setLanguage()
  {
    switch(pogo.language)
	{
	case javaLang:
		cppBtn.setSelected(false);
		javaBtn.setSelected(true);
		break;
	case cppLang:
		cppBtn.setSelected(true);
		javaBtn.setSelected(false);
		break;
	default:
		cppBtn.setSelected(false);
		javaBtn.setSelected(false);
    break;
	}
  }
  
  private void resetLanguage()
  {
  	String	inLang;
  	boolean	cpp = true;
	if ((inLang=System.getProperty("IN_LANG"))!=null)
		if (inLang.indexOf("java")>=0)
			cpp = false;
 	cppBtn.setSelected(cpp==true);
	javaBtn.setSelected(cpp==false);
  }
//======================================================
/**
 * Set the language <a href=pogo/gene/PogoClass.html> PogoClass field</a>
 * in compatibility with the toggle button .
 */
//======================================================
  private int getLanguage() throws PogoException
  {
   if (javaBtn.getSelectedObjects()!=null)
      return javaLang;
    else
    if (cppBtn.getSelectedObjects()!=null)
       return cppLang;
     else
      throw new PogoException("Output Language NOT Selected !");
 }
//======================================================
/**
 *  Called on save menu item cliked.
 */
//======================================================
//======================================================
/**
 *  Called on delete menu item cliked.
 */
//======================================================
  private void deleteMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteMenuItemActionPerformed
  tree.removeSelectedLeaf();
  }//GEN-LAST:event_deleteMenuItemActionPerformed

//======================================================
/**
 *  Dump the pogo objetc.
 */
//======================================================
  private void tracePogo()
  {
      System.out.println("\n\n");
      System.out.println("-----------------------------------------------");
      System.out.println("Class Name:  " + pogo.class_name);
      System.out.println("States:");
      System.out.println(pogo.states);
      System.out.println("Commands:");
      System.out.println(pogo.commands);
      System.out.println("Output Files:  " + pogo.output_files);
      System.out.println("From templates:  " + pogo.templates_dir);
      System.out.println("-----------------------------------------------");
  	/*
	*/
	for (int i=0 ; i<pogo.commands.size() ; i++)
	{
		Cmd		cmd = pogo.commands.cmdIdx(i);
		System.out.println(cmd.command + " -> " + cmd.exec_method);
	}
	
  }
//======================================================
/**
 *  Read the input source file to initialize PogoClass object.
 *  And built a JTree to display this object.
 *
 *  @param  filename  Source file to be read.
 *  @param  action  	open TANGO file or Import TACO file.
 */
//======================================================
  private void readSourceFile(String filename, int action)
  {
    try {
	
		if (action==OPEN_FILE)
			pogo = new PogoClass(filename);
		else
		{
			//	Import File
			Taco2Tango	t2t = new Taco2Tango(filename);
			pogo = t2t.getPogoClass();
		}
		//tracePogo();
		tree.setPogoTree(pogo);
		setPogoDefined(true);

		//	Check for TACO args type unexisting in TANGO
		//-----------------------------------------------
		String  message = pogo.commands.checkArgsType();
		if (message!=null)
			JOptionPane.showMessageDialog(this,  message,
							"Error Window",
							JOptionPane.ERROR_MESSAGE);
		if (action==IMPORT_FILE && pogo.states!=null)
			if (pogo.states.size()>0)
			JOptionPane.showMessageDialog(this,
							"WARNING:\n"+
							"Device States have beeen created \n   BUT Not\n"+
							"the allowed state command !!!",
							"Error Window",
							JOptionPane.WARNING_MESSAGE);
    }
    catch (Exception ex) {
      JOptionPane.showMessageDialog(this,  ex.toString(), "Error Window",
                          JOptionPane.ERROR_MESSAGE);
		ex.printStackTrace();
	}
  }


//===========================================================
/**
 *  Called on Open file item menu cliked.
 */
//===========================================================
  private void openMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openMenuItemActionPerformed
	buildPogoFromFile(OPEN_FILE);
	}

  private void importMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_importMenuItemActionPerformed
	buildPogoFromFile(IMPORT_FILE);
  }//GEN-LAST:event_importMenuItemActionPerformed


	private void buildPogoFromFile(int action)
	{
	//	Do not open a new project if this one
	//	has been modified and not saved.
	//----------------------------------------------------
//	if (tree!=null)
		if (tree.hasBeenModified())
		{
			Object[] options = { "OK", "CANCEL" };
			if (JOptionPane.showOptionDialog(tree,
						"This project has not been saved !\n\nDiscard modifications ?",
						"Warning",
						JOptionPane.DEFAULT_OPTION,
						JOptionPane.WARNING_MESSAGE,
						null, options, options[0])!=JOptionPane.OK_OPTION)
				return;
		}

	PogoFileFilter	cppFF = new PogoFileFilter("Cpp", "Class Name");
	PogoFileFilter	javaFF= new PogoFileFilter("java", "Class Name");
	PogoFileFilter	tacoFF= new PogoFileFilter("c", "TACO 'C' Class");
	//	Fixe the input directory and File Filters
	//-----------------------------------------------------
	if (chooser==null)
	{
		if ((homeDir=System.getProperty("HOME_GENE"))==null)
		{
			homeDir = new File("").getAbsolutePath();
		}
		chooser = new JFileChooser(homeDir);
		chooser.addChoosableFileFilter(tacoFF);
		chooser.addChoosableFileFilter(javaFF);
		chooser.addChoosableFileFilter(cppFF);
		if (action==OPEN_FILE)
		{

			//	Check if java has been set as default language
			//------------------------------------------------
			String	inLang;
			if ((inLang=System.getProperty("IN_LANG"))!=null)
				if (inLang.indexOf("java")>=0)
					chooser.setFileFilter(javaFF);
		}
		else
			chooser.setFileFilter(tacoFF);
	}
	else
	{
		//	Manage File fileter between Open and Import action
		if (action==OPEN_FILE)
		{
			PogoFileFilter	ff = (PogoFileFilter)chooser.getFileFilter();
			if(ff.getDescription().indexOf("TACO")>=0)
			{
				chooser.setFileFilter(cppFF);
				String	inLang;
				if ((inLang=System.getProperty("IN_LANG"))!=null)
					if (inLang.indexOf("java")>=0)
						chooser.setFileFilter(javaFF);
			}
		}
		else
			chooser.setFileFilter(tacoFF);
	}
	chooser.setDialogTitle((action==OPEN_FILE)? "Open": "Import");
	chooser.setCurrentDirectory(new File(homeDir));
	int retval = chooser.showOpenDialog(this);

	//  Check if the selected file is OK and then read it
	//------------------------------------------------------
	if (retval==JFileChooser.APPROVE_OPTION)
	{
		//	Approve option --> remove previous project if exists
		//---------------------------------------------------------
		if (tree!=null)
		{
			tree.clear();
			setPogoDefined(false);
			versionLabel.setText ("");
			pogo = null;
		}
		//	Then get selected path and file to read it
		//----------------------------------------------------
		File  file = chooser.getSelectedFile();
		if (file!=null)
			if (file.isDirectory()==false)
      		{
				readSourceFile(file.getAbsolutePath(), action);
				homeDir = file.getParentFile().toString();
			    if (pogo==null) return;
				versionLabel.setText ("  Author: " + pogo.author +
									"  - Revision: " + pogo.revision);
				//	Set the output language button
				//-----------------------------------------
				if (file.getAbsolutePath().indexOf(cppExtention)>0)
				{
					cppBtn.setSelected(true);
					javaBtn.setSelected(false);
				}
				else
				if (file.getAbsolutePath().indexOf(javaExtention)>0)
				{
					cppBtn.setSelected(false);
					javaBtn.setSelected(true);
				}
				//	Update Tree global param.
				try{	tree.setLanguage(getLanguage());	}
				catch(PogoException e){}
				tree.setHomeDir(homeDir);
			}
	}
  }//GEN-LAST:event_openMenuItemActionPerformed

//===========================================================
/**
 *  Called on Exit item menu cliked.
 *
 */
//===========================================================
  private void exitMenuItemActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
 	//	Do not exit if this project
	//	has been modified and not saved.
	//----------------------------------------------------
	if (tree!=null && tree.hasBeenModified())
	{
		Object[] options = { "Yes", "No", "Cancel" };
		switch (JOptionPane.showOptionDialog(this,
						"This project has not been saved !\n\n" +
						"Would you like to generate modifications ?",
						"Warning",
						JOptionPane.DEFAULT_OPTION,
						JOptionPane.WARNING_MESSAGE,
						null, options, options[0]))
		{
		case 0:	//	OK
			generateSource(GENE_SRC);
			break;
		case 1:	// No
			break;
		case 2:	//	Cancel
			return;
		}
	}
	System.exit(0);
}//GEN-LAST:event_exitMenuItemActionPerformed

 //===========================================================
/**
 *  Called on Exit form button cliked.
 *
 */
//===========================================================
  private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
	//	Do not open a new project if this project
	//	has been modified and not saved.
	//----------------------------------------------------
	if (tree!=null && tree.hasBeenModified())
	{
		if (JOptionPane.showConfirmDialog(this, 
							"This project has not been saved !\n\n" +
							"Would you like to generate modifications ?",
							"information",
							JOptionPane.YES_NO_OPTION)==JOptionPane.OK_OPTION)
			generateSource(GENE_SRC);
	}
	System.exit(0);
  }//GEN-LAST:event_exitForm



//======================================================
/**
 *  Palette menu item Action Performed method.
 *
 *  Call the apropriate method in case of item clicked.
 *
 *  @param evt Action Event .
 */
//======================================================
  private void paletteItemAP(ActionEvent evt)
  {
	String  itemCmd = evt.getActionCommand();
	int  idx = 0 ;

	//  Search item selected
	//------------------------------
	for (int i=0 ; i<palette.length ; i++)
		if (itemCmd.equals(palette[i]))
			idx = i;

	//  Do Action  Command
	//------------------------------
	switch (idx)
	{
	case PALETTE_EDIT_CLASS:
		tree.editClassObject();
		break;

	case PALETTE_CREATE_CLASS_PROP:
		//  Open Dialog
		//------------------
		tree.createNewCollectionObject("Class  Properties");
		break;
	case PALETTE_CREATE_DEV_PROP:
		//  Open Dialog
		//------------------
		tree.createNewCollectionObject("Device Properties");
		break;
	case PALETTE_CREATE_CMD:
		//  Open Dialog
		//------------------
		tree.createNewCollectionObject("Commands");
		break;
    case PALETTE_CREATE_ATTR:
		//	Open Dialog to get Attribute parameters
		//----------------------------------------------
		tree.createNewCollectionObject("Attributes");
		break;
	case PALETTE_CREATE_STATE:
		//  Open Dialog
		//------------------
		tree.createNewCollectionObject("States");
		break;
	}
  }
//======================================================
/**
 *   Set available or not menu items or buttons if PogoClas is
 *  initialized, not initialized or reseted.
 *
 *  @param  state  true if initialized.
 */
//======================================================
   private void setPogoDefined(boolean state)
   {
	tree.setVisible(state);
	geneSrcBtn.setEnabled(state);
	geneDocBtn.setEnabled(state);

	cutMenuItem.setEnabled(false);
	copyMenuItem.setEnabled(false);
	pasteMenuItem.setEnabled(false);

	paletteMenu.setEnabled(state);
	prefMenu.setEnabled(state);
	if (state)
		setLanguage();
  }
   //======================================================

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JMenuBar menuBar;
  private javax.swing.JMenu fileMenu;
  private javax.swing.JMenuItem newMenuItem;
  private javax.swing.JMenuItem openMenuItem;
  private javax.swing.JMenuItem importMenuItem;
  private javax.swing.JSeparator jSeparator1;
  private javax.swing.JMenuItem geneSrcBtn;
  private javax.swing.JMenuItem geneDocBtn;
  private javax.swing.JSeparator jSeparator2;
  private javax.swing.JMenuItem exitMenuItem;
  private javax.swing.JMenu editMenu;
  private javax.swing.JMenuItem cutMenuItem;
  private javax.swing.JMenuItem copyMenuItem;
  private javax.swing.JMenuItem pasteMenuItem;
  private javax.swing.JSeparator jSeparator3;
  private javax.swing.JMenuItem deleteMenuItem;
  private javax.swing.JMenuItem moveUpItem;
  private javax.swing.JMenuItem moveDownItem;
  private javax.swing.JMenu paletteMenu;
  private javax.swing.JMenu prefMenu;
  private javax.swing.JMenuItem jMenuItem1;
  private javax.swing.JMenu helpMenu;
  private javax.swing.JMenuItem contentsMenuItem;
  private javax.swing.JSeparator jSeparator4;
  private javax.swing.JMenuItem aboutMenuItem;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JPanel southPanel;
  private javax.swing.JPanel mousePanel;
  private javax.swing.JLabel leftBtnLabel;
  private javax.swing.JLabel rightBtnLabel;
  private javax.swing.JPanel jPanel1;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JRadioButton cppBtn;
  private javax.swing.JRadioButton javaBtn;
  // End of variables declaration//GEN-END:variables


  public static void main(java.lang.String[] args) {
  	try
	{
    	PogoAppli	pogoAppli = new PogoAppli();
		pogoAppli.show ();
	}
	catch(Exception e)
	{
		System.out.println("POGO Startup Failed.");
		System.out.println(e);
	}
  }

}
