//+======================================================================
// $Source: /segfs/tango/tools/pogo/appli/RCS/NotAllowedDialog.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: verdier $
//
// $Version$
//
// $Log: NotAllowedDialog.java,v $
// Revision 1.23  2000/10/24 06:21:22  verdier
// The compatibility with TANGO2 has been tested on DatabaseDs.
//
// Revision 1.22  2000/10/02 05:52:20  verdier
// Attribute code generated is now compatible with Tango 2.
//
// Revision 1.21  2000/09/22 08:54:31  verdier
// DevState & DevStatus are virtual.
// First tests with Tango2
// Taco import utility added.
//
// Revision 1.20  2000/07/07 13:30:10  verdier
// Utilities added after first users.
//
// Revision 1.18  2000/06/20 06:57:35  verdier
// Right button double click management added for :
// editing src code, creating item, editing class....
// Little bugs fixed on generation/re-read src code.
//
// Revision 1.17  2000/05/12 07:37:10  verdier
//  Attributes management added for java generation.
//
// Revision 1.16  2000/04/26 06:04:00  verdier
// The save/restore file (.pogo) does not exist anymore.
// DevStates and DevStates allowed management is now available for java.
//
// Revision 1.15  2000/04/18 08:12:47  verdier
// Management of DevStates to allow command added.
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================
package pogo.appli;



import java.awt.*;
import java.util.*;
import javax.swing.*;
import pogo.gene.*;

//===============================================================
/**
 *	A Dialog Class to get  <i>DevStateTable</i> where a
 *	<i> Cmd</i> object (a command) is NOT allowed.
 */
//===============================================================
public class NotAllowedDialog extends javax.swing.JDialog implements PogoAppliDefs, PogoDefs {

	private static int returnStatus = PogoAppliDefs.RET_CANCEL;
	private	Vector	stVector;

//===============================================================
/**
 * Initializes the Form
 */
//===============================================================
	public NotAllowedDialog(Frame parent,boolean modal, Vector stVect)
	{
		super (parent, modal);
		stVector = stVect;
		initComponents ();
		pack ();
	}

//===============================================================
/**
 * This method is called from within the constructor to initialize the form.
 */
 //===============================================================
 private void initComponents () {
    jPanel1 = new javax.swing.JPanel ();
    okBtn = new javax.swing.JButton ();
    cancelBtn = new javax.swing.JButton ();
    jPanel2 = new javax.swing.JPanel ();
    nameLbl = new javax.swing.JLabel ();
    setBackground (new java.awt.Color (198, 178, 168));
    setTitle ("Command Allowed Window");
    addWindowListener (new java.awt.event.WindowAdapter () {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        closeDialog (evt);
      }
    }
    );

    jPanel1.setLayout (new java.awt.FlowLayout (2, 5, 5));

      okBtn.setText ("OK");
      okBtn.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          okBtnActionPerformed (evt);
        }
      }
      );
  
      jPanel1.add (okBtn);
  
      cancelBtn.setText ("Cancel");
      cancelBtn.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          cancelBtnActionPerformed (evt);
        }
      }
      );
  
      jPanel1.add (cancelBtn);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.SOUTH);

    jPanel2.setLayout (new java.awt.GridBagLayout ());
    java.awt.GridBagConstraints gridBagConstraints1;

		//	Title Label
		//-----------------------
		nameLbl.setText ("Command Allowed for Selected States: ");
		nameLbl.setForeground (java.awt.Color.black);
		nameLbl.setFont (new java.awt.Font ("Arial", 1, 14));
		nameLbl.setPreferredSize (new java.awt.Dimension(300, 40));
		//nameLbl.setMinimumSize (new java.awt.Dimension(20, 30));

		gridBagConstraints1 = new java.awt.GridBagConstraints ();
		gridBagConstraints1.gridx = 1;
		gridBagConstraints1.gridy = 1;
		gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
		jPanel2.add (nameLbl, gridBagConstraints1);

		//	Create a JRadio Button for each state
		//---------------------------------------------
		radioBtn = new JRadioButton[stVector.size()];
		for (int i=0 ; i<stVector.size() ; i++)
		{
			DevState	state = (DevState) stVector.elementAt(i);
			radioBtn[i] = new JRadioButton(state.name);
			radioBtn[i].setFont (new java.awt.Font ("Arial", 1, 12));
			radioBtn[i].setSelected(true);
			gridBagConstraints1.gridx = 1;
			gridBagConstraints1.gridy = i+2;
			gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
			jPanel2.add(radioBtn[i], gridBagConstraints1);
		}

		getContentPane ().add (jPanel2, java.awt.BorderLayout.CENTER);
	}



   //===============================================================================
	private void cancelBtnActionPerformed (java.awt.event.ActionEvent evt)
	{
		doClose(PogoAppliDefs.RET_CANCEL);
	}

    //===============================================================================
	private void okBtnActionPerformed (java.awt.event.ActionEvent evt)
	{
		doClose(PogoAppliDefs.RET_OK);
	}

   //===============================================================================
	/** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt)
	{
		doClose(PogoAppliDefs.RET_CANCEL);
	}

   //===============================================================================
	public int showDialog(DevStateTable stTable)
	{
		if (stTable!=null)
			for (int i=0 ; i<stTable.size() ; i++)
				for (int j=0 ; j<radioBtn.length ; j++)
				{
					DevState	state = (DevState) stTable.elementAt(i);
					if (state.name.equals(radioBtn[j].getText())==true)
						radioBtn[j].setSelected(false);
				}
		setVisible(true);
		return returnStatus;
	}
	//===============================================================================
	private void doClose(int retStatus)
	{
		returnStatus = retStatus;
		setVisible (false);
		dispose ();
	}

	//===============================================================================
	public DevStateTable  getInput()
	{
		Vector forbStates = new Vector();

		for (int i=0 ; i<stVector.size() ; i++)
			if (radioBtn[i].getSelectedObjects()==null)
				forbStates.addElement(stVector.elementAt(i));
	    return	new DevStateTable(forbStates);
	}
	//======================================================

  private JRadioButton	radioBtn[];
  private javax.swing.JPanel jPanel1;
  private javax.swing.JButton okBtn;
  private javax.swing.JButton cancelBtn;
  private javax.swing.JPanel jPanel2;
  private javax.swing.JLabel nameLbl;

}
