//+======================================================================
// $Source: /segfs/tango/tools/pogo/appli/RCS/GenerateDialog.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: verdier $
//
// $Version$
//
// $Log: GenerateDialog.java,v $
// Revision 1.23  2000/10/24 06:21:22  verdier
// The compatibility with TANGO2 has been tested on DatabaseDs.
//
// Revision 1.22  2000/10/02 05:52:20  verdier
// Attribute code generated is now compatible with Tango 2.
//
// Revision 1.21  2000/09/22 08:54:31  verdier
// DevState & DevStatus are virtual.
// First tests with Tango2
// Taco import utility added.
//
// Revision 1.20  2000/07/07 13:30:10  verdier
// Utilities added after first users.
//
// Revision 1.18  2000/06/20 06:57:35  verdier
// Right button double click management added for :
// editing src code, creating item, editing class....
// Little bugs fixed on generation/re-read src code.
//
// Revision 1.17  2000/05/12 07:37:10  verdier
//  Attributes management added for java generation.
//
// Revision 1.16  2000/04/26 06:04:00  verdier
// The save/restore file (.pogo) does not exist anymore.
// DevStates and DevStates allowed management is now available for java.
//
// Revision 1.15  2000/04/18 08:12:47  verdier
// Management of DevStates to allow command added.
//
// Revision 1.14  2000/04/12 09:25:43  verdier
// Methods to manage attributes are now generated
//  Only if at leat one attribute exists.
//
// Revision 1.13  2000/04/11 09:35:07  verdier
// Attributes management added.
//
// Revision 1.1  2000/03/29 13:11:48  verdier
// Initial revision
//
// Revision 1.2  2000/03/03 09:43:00  verdier
// States management added
//
// Revision 1.1  2000/02/28 15:41:38  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package pogo.appli;


import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import javax.swing.*;

import pogo.gene.*;
import pogo.appli.*;

//===========================================================
/**
 *	Create a thread to display a Process Monitor
 *	and update it during files generation.
 */
//===========================================================
public class GenerateDialog extends JDialog implements ActionListener
{
	static private int		MAX = 100;
	private ProgressMonitor	pbar;
	private int				cnt = 0;
	private int				ratio;

//======================================================================
/**
 *	Constructor for the dialog.
 *
 *	@param	parent	Frame parent to create dialog.
 */
//======================================================================
	public GenerateDialog(Frame parent, int r)
	{
		super(parent, true);
		pbar = new ProgressMonitor(this, "Pogo is Generating Files. Wait a while....",
									"Wait a while", 0, MAX);

		cnt = 0;
		ratio = r;
		//	Fire a timer every once in a while to update the progress
		//--------------------------------------------------------------
		Timer	timer = new Timer(500, this);
		timer.start();
	}
//======================================================================
/**
 *	Invoked by the timer every half second.
 *	Simply place the progress monitor update in event queue.
 */
//======================================================================
	public void actionPerformed(ActionEvent	evt)
	{
		SwingUtilities.invokeLater(new Update());
	}
//======================================================================
/**
 *	Stop the thread (End of process reached).
 */
//======================================================================
	public void stop()
	{
		cnt = MAX;
		pbar.close();
	}
//======================================================================
/**
 *	Start the thread to update Process Monitor.
 */
//======================================================================
	class Update implements Runnable
	{
		public void run()
		{
			if (pbar.isCanceled())
				;
			pbar.setProgress(cnt);
			pbar.setNote("Operation is " + cnt + "% complete...");
			if (cnt< MAX-ratio)
				cnt+=ratio;
		}
	}
 //======================================================================
}
