//+======================================================================
// $Source: /segfs/tango/tools/pogo/appli/RCS/CommandDialog.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: verdier $
//
// $Version$
//
// $Log: CommandDialog.java,v $
// Revision 1.23  2000/10/24 06:21:22  verdier
// The compatibility with TANGO2 has been tested on DatabaseDs.
//
// Revision 1.22  2000/10/02 05:52:20  verdier
// Attribute code generated is now compatible with Tango 2.
//
// Revision 1.21  2000/09/22 08:54:31  verdier
// DevState & DevStatus are virtual.
// First tests with Tango2
// Taco import utility added.
//
// Revision 1.20  2000/07/07 13:30:10  verdier
// Utilities added after first users.
//
// Revision 1.18  2000/06/20 06:57:35  verdier
// Right button double click management added for :
// editing src code, creating item, editing class....
// Little bugs fixed on generation/re-read src code.
//
// Revision 1.17  2000/05/12 07:37:10  verdier
//  Attributes management added for java generation.
//
// Revision 1.16  2000/04/26 06:04:00  verdier
// The save/restore file (.pogo) does not exist anymore.
// DevStates and DevStates allowed management is now available for java.
//
// Revision 1.15  2000/04/18 08:12:47  verdier
// Management of DevStates to allow command added.
//
// Revision 1.14  2000/04/12 09:25:43  verdier
// Methods to manage attributes are now generated
//  Only if at leat one attribute exists.
//
// Revision 1.13  2000/04/11 09:35:07  verdier
// Attributes management added.
//
// Revision 1.2  2000/03/29 13:11:48  verdier
// Doc generation added.
//
// Revision 1.1  2000/02/28 15:41:38  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package pogo.appli;


import java.awt.*;
import java.util.*;
import javax.swing.*;
import pogo.gene.*;

//===============================================================
/**
 *	A Dialog Class to get the Command parameters.
 */
//===============================================================
public class CommandDialog extends javax.swing.JDialog  implements PogoAppliDefs {

	private String	class_name;
	private Frame 	parent;
	private Vector	stVector;
	private	Vector	existingCmd;
	private	int		editingIdx;
	private DevStateTable	notAllowedFor;
	private static int returnStatus = PogoAppliDefs.RET_CANCEL;

//===================================================================
	/** Initializes the Form */
	public CommandDialog(Frame parent, boolean modal, Vector stVect, Vector cmdVect, String class_name) {
		super (parent, modal);
		this.parent = parent;
		stVector = stVect;
		existingCmd = cmdVect;
		initComponents ();

    //  init comboboxes
    //-----------------------
    for (int i=0 ; i<TangoTypesArray.length ; i++)
    {
      arginComboBox.addItem(TangoTypesArray[i]);
      argoutComboBox.addItem(TangoTypesArray[i]);
    }
	arginComboBox.setMaximumRowCount(12);
 	argoutComboBox.setMaximumRowCount(12);
	pack ();
  
	/************
		Does NOTused any more

  	//	Keep only the 6 first chars of class name
	//	To be added to command class name.
	//--------------------------------------------------
 	if (class_name.length()<=6)
		this.class_name = new String(class_name);
	else
		this.class_name = class_name.substring(0, 6);
	**************/
  }

//===================================================================

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    jPanel1 = new javax.swing.JPanel ();
    okBtn = new javax.swing.JButton ();
    cancelBtn = new javax.swing.JButton ();
    jPanel2 = new javax.swing.JPanel ();
    nameLbl = new javax.swing.JLabel ();
    nameText = new javax.swing.JTextField ();
    jLabel1 = new javax.swing.JLabel ();
    arginComboBox = new javax.swing.JComboBox ();
    jLabel2 = new javax.swing.JLabel ();
    argoutComboBox = new javax.swing.JComboBox ();
    jLabel8 = new javax.swing.JLabel ();
    arginDescText = new javax.swing.JTextField ();
    jLabel4 = new javax.swing.JLabel ();
    argoutDescText = new javax.swing.JTextField ();
    jLabel5 = new javax.swing.JLabel ();
    jLabel6 = new javax.swing.JLabel ();
    cmdDescText = new javax.swing.JTextArea ();
    allowedBtn = new javax.swing.JButton ();
    setBackground (new java.awt.Color (198, 178, 168));
    setTitle ("Command Window");
    addWindowListener (new java.awt.event.WindowAdapter () {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        closeDialog (evt);
      }
    }
    );

    jPanel1.setLayout (new java.awt.FlowLayout (2, 5, 5));

      okBtn.setText ("OK");
      okBtn.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          okBtnActionPerformed (evt);
        }
      }
      );
  
      jPanel1.add (okBtn);
  
      cancelBtn.setText ("Cancel");
      cancelBtn.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          cancelBtnActionPerformed (evt);
        }
      }
      );
  
      jPanel1.add (cancelBtn);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.SOUTH);

    jPanel2.setLayout (new java.awt.GridBagLayout ());
    java.awt.GridBagConstraints gridBagConstraints1;

      nameLbl.setText ("Command Name:");
      nameLbl.setForeground (java.awt.Color.black);
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 1;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (nameLbl, gridBagConstraints1);
  
      nameText.setMinimumSize (new java.awt.Dimension(30, 28));
      nameText.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          nameTextActionPerformed (evt);
        }
      }
      );
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 1;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.weightx = 1.0;
      jPanel2.add (nameText, gridBagConstraints1);
  
      jLabel1.setText ("Argin Type:");
      jLabel1.setForeground (java.awt.Color.black);
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 2;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (jLabel1, gridBagConstraints1);
  
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 2;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.weightx = 1.0;
      jPanel2.add (arginComboBox, gridBagConstraints1);
  
      jLabel2.setText ("Argout Type:");
      jLabel2.setForeground (java.awt.Color.black);
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 4;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (jLabel2, gridBagConstraints1);
  
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 4;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.weightx = 1.0;
      jPanel2.add (argoutComboBox, gridBagConstraints1);
  
      jLabel8.setText ("Argin Description:");
      jLabel8.setForeground (java.awt.Color.black);
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 3;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (jLabel8, gridBagConstraints1);
  
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 3;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.weightx = 1.0;
      jPanel2.add (arginDescText, gridBagConstraints1);
  
      jLabel4.setText ("Argout Description:  ");
      jLabel4.setForeground (java.awt.Color.black);
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 5;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (jLabel4, gridBagConstraints1);
  
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 5;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.weightx = 1.0;
      jPanel2.add (argoutDescText, gridBagConstraints1);
  
      jLabel5.setText (" ");
      jLabel5.setForeground (java.awt.Color.black);
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 6;
      jPanel2.add (jLabel5, gridBagConstraints1);
  
      jLabel6.setText ("Command Description:  ");
      jLabel6.setForeground (java.awt.Color.black);
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 8;
      gridBagConstraints1.gridwidth = 2;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (jLabel6, gridBagConstraints1);
  
      cmdDescText.setPreferredSize (new java.awt.Dimension(100, 125));
      cmdDescText.setMinimumSize (new java.awt.Dimension(0, 100));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 9;
      gridBagConstraints1.gridwidth = 2;
      gridBagConstraints1.gridheight = 5;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints1.weighty = 5.0;
      jPanel2.add (cmdDescText, gridBagConstraints1);
  
      allowedBtn.setPreferredSize (new java.awt.Dimension(167, 30));
      allowedBtn.setBorder (new javax.swing.border.BevelBorder(0));
      allowedBtn.setText ("Command Allowed For States....");
      allowedBtn.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          allowedBtnActionPerformed (evt);
        }
      }
      );
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 6;
      gridBagConstraints1.gridwidth = 2;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jPanel2.add (allowedBtn, gridBagConstraints1);
  

    getContentPane ().add (jPanel2, java.awt.BorderLayout.CENTER);

  }//GEN-END:initComponents




//===================================================================
  public int showDialog(Cmd cmd, int idx)
  {
	editingIdx = idx;
  	if (cmd!=null)
	{
        //  Initialize Window with Command's parameters
        //-----------------------------------------------
        nameText.setText(cmd.command);
    	//	Args in/out types
    	//--------------------------------
        for (int i=0 ; i<TangoTypesArray.length ; i++)
        {
          if (TangoTypesArray[i].equals(cmd.argin.code_str))
            arginComboBox.setSelectedIndex(i);
          if (TangoTypesArray[i].equals(cmd.argout.code_str))
            argoutComboBox.setSelectedIndex(i);
        }
    	//	descriptions
	    //-------------------------------
        if (cmd.argin.description!=null)
          arginDescText.setText(cmd.argin.description);
        if (cmd.argout.description!=null)
          argoutDescText.setText(cmd.argout.description);
        if (cmd.description!=null)
          cmdDescText.setText(cmd.description);
	
    	notAllowedFor = new DevStateTable(cmd.notAllowedFor.vect);
    }

	setVisible(true);
    return returnStatus;
  }
  public int showDialog()
  {
    return showDialog(null, -1);
  }

//===================================================================

  private void allowedBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_allowedBtnActionPerformed
	NotAllowedDialog	dialog = new NotAllowedDialog(parent, true, stVector);
	int ret = dialog.showDialog(notAllowedFor);

	if (ret==PogoAppliDefs.RET_OK)
		notAllowedFor = dialog.getInput();

  }//GEN-LAST:event_allowedBtnActionPerformed
//===================================================================


//===================================================================
  private void nameTextActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nameTextActionPerformed
    // Add your handling code here:
  }//GEN-LAST:event_nameTextActionPerformed


//===================================================================
  private void cancelBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBtnActionPerformed
  doClose(PogoAppliDefs.RET_CANCEL);
  }//GEN-LAST:event_cancelBtnActionPerformed

//===================================================================
	private int checkCommandName()
	{
		String cmd_name = nameText.getText();

		//	Check if command name is empty
		if (cmd_name.length()<=0)
		{
			JOptionPane.showMessageDialog(this,
								"Command's name must be filled in !",
								"Message Window",
								JOptionPane.INFORMATION_MESSAGE);
			return RET_ERROR;
		}

		//	Take of space char if exist
		//--------------------------------------
		StringTokenizer stk = new StringTokenizer(cmd_name);
		cmd_name = stk.nextToken();

		//	Check if first char is upcase else set it
		//-------------------------------------------------
		if (cmd_name.charAt(0) >='a' || cmd_name.charAt(0) >='z')
		{
			char	car = (char)(cmd_name.charAt(0)-('a'-'A'));
			cmd_name = new String(car + cmd_name.substring(1));
		}
		nameText.setText(cmd_name);

		// check if char used are OK (No Space, or # $ % @ & ...)
		for (int i=0 ; i<cmd_name.length() ; i++)
		{
			char	c = cmd_name.charAt(i);
			if (c<'0' || (c>'9' && c<'A') || (c>'Z' && c<'a') || c>'z')
			{	
				JOptionPane.showMessageDialog(this,
								"Syntax error in command's name !\n"+
								"Do not use '" + c + "' char.",
								"Message Window",
								JOptionPane.INFORMATION_MESSAGE);
				return RET_ERROR;
			}
		}

		// check if command name already exist
		for (int i=0 ; i<existingCmd.size() ; i++)
		{
			if (i!=editingIdx)
			{
				Cmd	cmd = (Cmd) existingCmd.elementAt(i) ;
				if (cmd_name.equals(cmd.command))
				{
					JOptionPane.showMessageDialog(this,
								"Command "+ cmd_name + " already exists !",
								"Message Window",
								JOptionPane.INFORMATION_MESSAGE);
					return RET_ERROR;
				}
			}
		}
		
		return RET_OK;
	}
//===================================================================
	private void okBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okBtnActionPerformed

	//	Check it at least the property name has been filled.
	//---------------------------------------------------------
	if (nameText.getText().length()<=0)
	{
			JOptionPane.showMessageDialog(this, 
								"Command's name must be filled in !",
								"Error Window",
								JOptionPane.ERROR_MESSAGE);
	}
	else
	if (checkCommandName()==RET_OK)
		doClose(PogoAppliDefs.RET_OK);
	
	}//GEN-LAST:event_okBtnActionPerformed

//===================================================================
  /** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
		doClose(PogoAppliDefs.RET_CANCEL);
	}//GEN-LAST:event_closeDialog

//===================================================================
	private void doClose(int retStatus)
	{
		returnStatus = retStatus;
		setVisible (false);
		dispose ();
	}

 //===================================================================
 public Cmd  getInputCommand()
  {
	String	cmd_name = nameText.getText();
	//	Create a new Cmd object
	//--------------------------------
    Cmd		cmd =  new Cmd(	cmd_name,
							class_name + cmd_name +"Cmd",
							arginComboBox.getSelectedItem().toString(),
							argoutComboBox.getSelectedItem().toString(),
							arginDescText.getText(),
							argoutDescText.getText(),
							cmdDescText.getText() );
	if (notAllowedFor==null)
		notAllowedFor = new DevStateTable();
	cmd.setNotAllowedFor(notAllowedFor);
	return cmd;
  }
//===================================================================

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel jPanel1;
  private javax.swing.JButton okBtn;
  private javax.swing.JButton cancelBtn;
  private javax.swing.JPanel jPanel2;
  private javax.swing.JLabel nameLbl;
  private javax.swing.JTextField nameText;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JComboBox arginComboBox;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JComboBox argoutComboBox;
  private javax.swing.JLabel jLabel8;
  private javax.swing.JTextField arginDescText;
  private javax.swing.JLabel jLabel4;
  private javax.swing.JTextField argoutDescText;
  private javax.swing.JLabel jLabel5;
  private javax.swing.JLabel jLabel6;
  private javax.swing.JTextArea cmdDescText;
  private javax.swing.JButton allowedBtn;
  // End of variables declaration//GEN-END:variables
}
