//+======================================================================
// $Source: /segfs/tango/tools/pogo/appli/RCS/GenerateThread.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: verdier $
//
// $Version$
// $Log: GenerateThread.java,v $
// Revision 1.24  2001/04/04 12:22:58  verdier
// Property management added for cpp.
//
// Revision 1.23  2000/10/24 06:21:22  verdier
// The compatibility with TANGO2 has been tested on DatabaseDs.
//
// Revision 1.22  2000/10/02 05:52:20  verdier
// Attribute code generated is now compatible with Tango 2.
//
// Revision 1.21  2000/09/22 08:54:31  verdier
// DevState & DevStatus are virtual.
// First tests with Tango2
// Taco import utility added.
//
// Revision 1.20  2000/07/07 13:30:10  verdier
// Utilities added after first users.
//
// Revision 1.18  2000/06/20 06:57:35  verdier
// Right button double click management added for :
// editing src code, creating item, editing class....
// Little bugs fixed on generation/re-read src code.
//
// Revision 1.17  2000/05/12 07:37:10  verdier
//  Attributes management added for java generation.
//
// Revision 1.16  2000/04/26 06:04:00  verdier
// The save/restore file (.pogo) does not exist anymore.
// DevStates and DevStates allowed management is now available for java.
//
// Revision 1.15  2000/04/18 08:12:47  verdier
// Management of DevStates to allow command added.
//
// Revision 1.1  2000/02/28 15:41:38  verdier
// Initial revision
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package pogo.appli;


import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import javax.swing.*;

import pogo.gene.*;
import pogo.appli.*;

//========================================================================
/**
 *	This class implemets a thread to generate source files in background time.
 */
//========================================================================
public class GenerateThread extends Thread implements PogoDefs, PogoAppliDefs
{
/**
 *	PogoClass object to be used for files generation.
 */
	private PogoClass		pogo; 
	private int				item;
	private String			homeDir;
	private JFrame			parent;
	private GenerateDialog	dialog;
	
//========================================================================
/**
 *	Constructor for the thread.
 *
 *	@param	frame	Parent frame used to popup dialog.
 *	@param	pogo	<a href=../gene/PogoClass.html>PogoClass </a> object
 *					to be used for files generation.
 *	@param	item	Type of file to be generated.
 *	@param	path	Where the files must be generated.
 */
//========================================================================
	public GenerateThread(JFrame frame, PogoClass pogo, int item, String path)
	{
		this.pogo = pogo;
		this.item = item;
		homeDir  = path;
		parent   = frame;
		
		int ratio;	//	to increase counter to 100% during generation
		if (item==GENE_DOC && pogo.language==javaLang)
			ratio = 7;
		else
			ratio = 20;
		dialog = new GenerateDialog(frame, ratio);
	}
	
	
//========================================================================
/**
 *	Start the thread.
 */
 //========================================================================
   public void run()
	{
		try {
			switch(item)
			{
			//	Generate Source Files
			case GENE_SRC:
				if (pogo.language==javaLang)
				{
					PogoGeneJava gene = new PogoGeneJava(pogo);
					gene.generate();
					dialog.stop();
					JOptionPane.showMessageDialog(parent, 
													gene.getTrace(),
													"Message Window",
													JOptionPane.INFORMATION_MESSAGE);
					
				}
				else
				{
					PogoGeneCpp gene = new PogoGeneCpp(pogo);
					gene.generate();
					dialog.stop();
					JOptionPane.showMessageDialog(parent, 
													gene.getTrace(),
													"Message Window",
													JOptionPane.INFORMATION_MESSAGE);
					
				}
				break;

			//	Generate Doc Files
			//----------------------------
			case GENE_DOC:
				new PogoGeneDoc(pogo).generate();
				dialog.stop();
				JOptionPane.showMessageDialog(parent, 
												"Html Documentation Generated in :\n"+
												pogo.output_files + "/doc_html",
												"Message Window",
												JOptionPane.INFORMATION_MESSAGE);
				break;
			}
		}
		//	catch exceptions occured on file generation
		//------------------------------------------------------
		catch (Exception ex)
		{
			dialog.stop();
			JOptionPane.showMessageDialog(parent, ex.toString(),
													"Error Window",
													JOptionPane.ERROR_MESSAGE);
													ex.printStackTrace();
		
		}
	}
}
