//+======================================================================
// $Source: /segfs/tango/tools/pogo/appli/RCS/EditPogoCode.java,v $
//
// Project:   Tango
//
// Description:	java source code for the Pogo class definition .
//
// $Author: verdier $
//
// $Version$
//
// $Log: EditPogoCode.java,v $
// Revision 1.24  2001/04/04 12:22:58  verdier
// Property management added for cpp.
//
// Revision 1.23  2000/10/24 06:21:22  verdier
// The compatibility with TANGO2 has been tested on DatabaseDs.
//
// Revision 1.22  2000/10/02 05:52:20  verdier
// Attribute code generated is now compatible with Tango 2.
//
// Revision 1.21  2000/09/22 08:54:31  verdier
// DevState & DevStatus are virtual.
// First tests with Tango2
// Taco import utility added.
//
// Revision 1.20  2000/07/07 13:30:10  verdier
// Utilities added after first users.
//
// Revision 1.18  2000/06/20 06:57:35  verdier
// Right button double click management added for :
// editing src code, creating item, editing class....
// Little bugs fixed on generation/re-read src code.
//
//
// Copyright 1999 by European Synchrotron Radiation Facility, Grenoble, France
//							 All Rights Reversed
//-======================================================================
package pogo.appli;

import java.io.*;
import java.util.*;
import Tango.*;
import TangoDs.*;
import pogo.gene.*;


/**
 *	This class start an external editor to
 *	view/edit Pogo file source code.
 */
public class EditPogoCode extends Thread implements PogoDefs
{
/**
 *	Pogo Class to be used for generation.
 */
private PogoClass	pogo;
private String		srcFilename;
private String		editor;
private String		srcCode;
private int			lineNum;
//=======================================================================
/**
 *	Constructors for EditPogoCode use.
 *
 *	@param	pogo	Pogo Class definition used for editing.
 */
//=======================================================================
	public EditPogoCode(PogoClass pogo) throws	FileNotFoundException,
												IOException,
												PogoException
	{
		this.pogo = pogo;
		
		if (pogo.language == cppLang)
			srcFilename = new String(pogo.output_files + "/" +
									pogo.class_name + cppExtention);
		else
			srcFilename = new String(pogo.output_files + "/" +
									pogo.class_name + javaExtention);
		//	Open and read file
		//----------------------------------------
		FileInputStream		fidin  = new FileInputStream(srcFilename);
		int nb = fidin.available();
		byte[]	inStr  = new byte[nb];
		fidin.read(inStr);
		srcCode = new String(inStr);

		//	get the prefered editor
		//----------------------------------
		if ((editor=System.getProperty("EDITOR"))==null)
			editor = "nc -noask";
		else
		if (editor.length()==0)
			editor = "nc -noask";
		else
		if (editor.equals("vi"))
			editor = "xterm -e vi";
		//	else get editor as defined.
	}
	
	
//=======================================================================
/**
 *	Serch the target string into source code 
 *	and count the neumeber of lines.
 *
 *	@param	target	the string to search.
 *	@return the line nuber where target has been found.
 */
//=======================================================================
	private int searchLineNumber(String target) throws PogoException
	{
		//	Search it
		//----------------
		int	end;
		if ((end=srcCode.indexOf(target))<0)
			throw new PogoException(target+"\nMethod not found");
		int line = 0;
		for (int i=0 ; i<end ; i++)
		{
			if (srcCode.charAt(i)=='\n')
				line++;
		}
		line++;
		return line;
	}
//=======================================================================
/**
 *	Search the execute command method and start an editor.
 *
 *	@param	cmdName					the command eecute method to be edited.
 *	@throws	FileNotFoundException	Source file not found.
 *	@throws	PogoException			Method not found.
 *	@throws	InterruptedException	Forking editor failed.
 */
//=======================================================================
	public void setCommandTarget(String cmdName)
							throws	FileNotFoundException,
									IOException,
									PogoException
	{
		//	Serch Command to treated.
		//-------------------------------------
		Cmd		cmd = pogo.commands.cmdIdx(0);
		for (int i=0 ; i<pogo.commands.size() ; i++)
		{
			cmd = pogo.commands.cmdIdx(i);
			if (cmd.command.equals(cmdName))
				break;
		}

		//	Built line to be found.
		//------------------------------
		String		target;
		if (pogo.language == cppLang)
			target = cmd.buildCppExecCmdMethodSignature(pogo.class_name);
		else
			target = cmd.buildJavaExecCmdMethodSignature();

		//	Get only first part, because the argin name could be changed.
		//------------------------------------------------------------------
		target = target.substring(0, target.indexOf("(")+1);

		lineNum = searchLineNumber(target);
	}
//=======================================================================
/**
 *	Search the attributes management method and start an editor.
 *
 *	@throws	FileNotFoundException	Source file not found.
 *	@throws	PogoException			Method not found.
 *	@throws	InterruptedException	Forking editor failed.
 */
//=======================================================================
	public void setAttributeTarget() throws PogoException
	{
		//	Built line to be found.
		//------------------------------
		String	target;
		if (pogo.language == cppLang)
			target = "void " + pogo.class_name + "::read_attr_hardware(vector<long> &attr_list)";
		else
			target = "public void read_attr_hardware(Vector attr_list)";

		lineNum = searchLineNumber(target);
	}

//===============================================================
/**
 *	Fork the editor an go to the line where target has been found.
 */
//===============================================================
	public void run()
	{
		try
		{
			//	Fork an editor for this line
			//----------------------------------
			String	cmdStr = new String(editor + " +" + lineNum + " " + srcFilename);
			Process proc = Runtime.getRuntime().exec(cmdStr);

			// get command's output stream and
			// put a buffered reader input stream on it.
			//-------------------------------------------
			InputStream istr = proc.getInputStream();
			BufferedReader br =
                new BufferedReader(new InputStreamReader(istr));
			StringBuffer	sb = new StringBuffer(cmdStr+"\n\n");
    
			// read output lines from command
			//-------------------------------------------
			String str1;
			while ((str1 = br.readLine()) != null)
				sb.append(str1+"\n");

			// wait for end of command
			//---------------------------------------
			int retVal;
			if ((retVal=proc.waitFor())!=0)
				System.out.println(cmdStr + "\nproc.waitFor() : " + retVal + " !");

			// check its exit value
			//------------------------
			if ((retVal=proc.exitValue()) != 0)
				System.out.println(cmdStr + "\nproc.exitValue() : " + retVal + " !");
		}
		catch(InterruptedException e)
		{
			System.out.println(e);
		}
		catch(IOException e)
		{
			System.out.println(e);
		}
	}
}

//-----------------------------------------------------------------------------
/* end of $Source: /segfs/tango/tools/pogo/appli/RCS/EditPogoCode.java,v $ */
