//+======================================================================
// $Source: /segfs/tango/tools/pogo/appli/RCS/ClassDialog.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: verdier $
//
// $Version$
//
// $Log: ClassDialog.java,v $
// Revision 1.24  2001/04/04 12:22:58  verdier
// Property management added for cpp.
//
// Revision 1.23  2000/10/24 06:21:22  verdier
// The compatibility with TANGO2 has been tested on DatabaseDs.
//
// Revision 1.22  2000/10/02 05:52:20  verdier
// Attribute code generated is now compatible with Tango 2.
//
// Revision 1.21  2000/09/22 08:54:31  verdier
// DevState & DevStatus are virtual.
// First tests with Tango2
// Taco import utility added.
//
// Revision 1.20  2000/07/07 13:30:10  verdier
// Utilities added after first users.
//
// Revision 1.18  2000/06/20 06:57:35  verdier
// Right button double click management added for :
// editing src code, creating item, editing class....
// Little bugs fixed on generation/re-read src code.
//
// Revision 1.17  2000/05/12 07:37:10  verdier
//  Attributes management added for java generation.
//
// Revision 1.16  2000/04/26 06:04:00  verdier
// The save/restore file (.pogo) does not exist anymore.
// DevStates and DevStates allowed management is now available for java.
//
// Revision 1.15  2000/04/18 08:12:47  verdier
// Management of DevStates to allow command added.
//
// Revision 1.14  2000/04/12 09:25:43  verdier
// Methods to manage attributes are now generated
//  Only if at leat one attribute exists.
//
// Revision 1.13  2000/04/11 09:35:07  verdier
// Attributes management added.
//
// Revision 1.3  2000/03/29 13:11:48  verdier
// Doc generation added.
//
// Revision 1.2  2000/03/03 09:43:00  verdier
// States management added
//
// Revision 1.1  2000/02/28 15:41:38  verdier
// Initial revision
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================


package pogo.appli;


import java.util.*;
import javax.swing.*;
import pogo.gene.*;


/**
 * This class manage a dialog window to get or modify class parametes.<Br>
 *	these parameters are Class name, Project title and Class description.
 */
public class ClassDialog extends javax.swing.JDialog implements PogoAppliDefs {

/**
 *	The dialog closed button.
 */
  private static int returnStatus = PogoAppliDefs.RET_CANCEL;

//===========================================================
/** 
 *	Constructor for the dialog
 *
 *	@param	parent	This the frame parent to create dialog
 *	@param	modal	Set the dialog to modal if true.
 */
//===========================================================
  public ClassDialog(java.awt.Frame parent, boolean modal) {
      super (parent, modal);
    initComponents ();
   pack ();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    setBackground (new java.awt.Color (198, 178, 168));
    setTitle ("Edit Class Window");
    addWindowListener (new java.awt.event.WindowAdapter () {
        public void windowClosing (java.awt.event.WindowEvent evt) {
          closeDialog (evt);
        }
      }
    );
    getContentPane ().setLayout (new java.awt.BorderLayout ());

    jPanel1 = new javax.swing.JPanel ();
    jPanel1.setLayout (new java.awt.FlowLayout (2, 5, 5));

      okBtn = new javax.swing.JButton ();
      okBtn.setText ("OK");
      okBtn.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
            okBtnActionPerformed (evt);
          }
        }
      );
      jPanel1.add (okBtn);

      cancelBtn = new javax.swing.JButton ();
      cancelBtn.setText ("Cancel");
      cancelBtn.setActionCommand ("Cancel");
      cancelBtn.addActionListener (new java.awt.event.ActionListener () {
          public void actionPerformed (java.awt.event.ActionEvent evt) {
            cancelBtnActionPerformed (evt);
          }
        }
      );
      jPanel1.add (cancelBtn);

    getContentPane ().add (jPanel1, "South");

    jPanel2 = new javax.swing.JPanel ();
    jPanel2.setLayout (new java.awt.GridBagLayout ());
    java.awt.GridBagConstraints gridBagConstraints1;

      nameText = new javax.swing.JTextField ();
      nameText.setMinimumSize (new java.awt.Dimension(30, 28));
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 2;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.weightx = 1.0;
      jPanel2.add (nameText, gridBagConstraints1);

      nameLbl = new javax.swing.JLabel ();
      nameLbl.setText ("Class Name:");
      nameLbl.setForeground (java.awt.Color.black);
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 2;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (nameLbl, gridBagConstraints1);

      jLabel5 = new javax.swing.JLabel ();
      jLabel5.setText (" ");
      jLabel5.setForeground (java.awt.Color.black);
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 6;
      jPanel2.add (jLabel5, gridBagConstraints1);

      jLabel6 = new javax.swing.JLabel ();
      jLabel6.setText ("Class Description:  ");
      jLabel6.setForeground (java.awt.Color.black);
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 8;
      gridBagConstraints1.gridwidth = 2;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (jLabel6, gridBagConstraints1);

      descText = new javax.swing.JTextArea ();
      descText.setPreferredSize (new java.awt.Dimension(450, 200));
      descText.setMinimumSize (new java.awt.Dimension(0, 100));
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 9;
      gridBagConstraints1.gridwidth = 2;
      gridBagConstraints1.gridheight = 5;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
      gridBagConstraints1.weighty = 5.0;
      jPanel2.add (descText, gridBagConstraints1);

      jLabel1 = new javax.swing.JLabel ();
      jLabel1.setText ("Project Title");
      jLabel1.setForeground (java.awt.Color.black);
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 1;
      jPanel2.add (jLabel1, gridBagConstraints1);

      projectTitle = new javax.swing.JTextField ();
      projectTitle.setMinimumSize (new java.awt.Dimension(30, 28));
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 1;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints1.weightx = 1.0;
      jPanel2.add (projectTitle, gridBagConstraints1);

    getContentPane ().add (jPanel2, "Center");

  }//GEN-END:initComponents



//===========================================================
/** 
 *	method called on Cancel button clicked.
 *
 *	@param	evt	event recieved.
 */
//===========================================================
  private void cancelBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBtnActionPerformed
  doClose(PogoAppliDefs.RET_CANCEL);
  }//GEN-LAST:event_cancelBtnActionPerformed

//===========================================================
/** 
 *	method called on OK button clicked.
 *
 *	@param	evt	event recieved.
 */
//===========================================================
  private void okBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okBtnActionPerformed
  if (nameText.getText().length()>0)
    doClose(PogoAppliDefs.RET_OK);
  else
    JOptionPane.showMessageDialog(this,
              "Class' name must be filled in !",
              "Message Window",
                    JOptionPane.INFORMATION_MESSAGE);
  }//GEN-LAST:event_okBtnActionPerformed

//===========================================================
/** 
 *	method called on close window button clicked.
 *
 *	@param	evt	event recieved.
 */
//===========================================================
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
  doClose(PogoAppliDefs.RET_CANCEL);
  }//GEN-LAST:event_closeDialog

//===========================================================
/** 
 *	Popup the dialog and initialize text field.
 *
 *	@param	name		Class name.
 *	@param	description	Class description.
 */
//===========================================================
 public int showClassDialog(String name, String description, String title)
  {
    //  Initialize Window with input parameters
    //-----------------------------------------------
    if (name!=null)
        nameText.setText(name);

     if (title!=null)
        projectTitle.setText(title);
	else
    if (name!=null)
        projectTitle.setText(name);

   if (description!=null)
      descText.setText(description);
    setVisible(true);
    return returnStatus;
  }
//===========================================================
/** 
 *	Close th dialog and set the reurn status.
 *
 *	@param	retStatus	value to b used to set the return status.
 */
//===========================================================
  private void doClose(int retStatus)
  {
    returnStatus = retStatus;
    setVisible (false);
    dispose ();
  }

//===========================================================
/** 
 *	Read project title text field.
 *
 *	@return the String read in project title text field.
 */
//===========================================================
  public String  getProjectTitle()
  {
    return projectTitle.getText();
  }
//===========================================================
/** 
 *	Set project title text field.
 *
 *	@param s the String to set the project title text field.
 */
//===========================================================
  public void  setProjectTitle(String s)
  {
    projectTitle.setText(s);
  }
//===========================================================
/** 
 *	Read class name text field.
 *
 *	@return the String read in class name text field.
 */
//===========================================================
  public String  getClassName()
  {
	//	Take of space char if exist
	//--------------------------------------
	StringTokenizer stk = new StringTokenizer(nameText.getText());
	String	name = stk.nextToken();

	//	Check if first char is upcase else set it
	//-------------------------------------------------
	if (name.charAt(0) >='a' || name.charAt(0) >='z')
	{
		char	car = (char)(name.charAt(0)-('a'-'A'));
		name = new String(car + name.substring(1));
	}
	return name;
  }
//===========================================================
/** 
 *	Set class name text field.
 *
 *	@param s the String to set the class name text field.
 */
//===========================================================
  public void  setClassName(String s)
  {
    nameText.setText(s);
  }
//===========================================================
/** 
 *	Read class description text field.
 *
 *	@return the String read in class description text field.
 */
//===========================================================
  public String  getDescription()
  {
    return descText.getText();
  }
//===========================================================
/** 
 *	Set class description text field.
 *
 *	@param s the String to set the class description text field.
 */
//===========================================================
  public void  setDescription(String s)
  {
    descText.setText(s);
  }

// Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel jPanel1;
  private javax.swing.JPanel jPanel2;
  private javax.swing.JButton okBtn;
  private javax.swing.JButton cancelBtn;
  private javax.swing.JTextField nameText;
  private javax.swing.JLabel nameLbl;
  private javax.swing.JLabel jLabel5;
  private javax.swing.JLabel jLabel6;
  private javax.swing.JTextArea descText;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JTextField projectTitle;
// End of variables declaration//GEN-END:variables


  public static void main(java.lang.String[] args) {
    new ClassDialog (new java.awt.Frame (), false).show ();
  }

}
