//+======================================================================
// $Source: /segfs/tango/tools/pogo/appli/RCS/AttributeDialog.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: verdier $
//
// $Version$
//
// $Log: AttributeDialog.java,v $
// Revision 1.24  2001/04/04 12:22:58  verdier
// Property management added for cpp.
//
// Revision 1.23  2000/10/24 06:21:22  verdier
// The compatibility with TANGO2 has been tested on DatabaseDs.
//
// Revision 1.22  2000/10/02 05:52:20  verdier
// Attribute code generated is now compatible with Tango 2.
//
// Revision 1.21  2000/09/22 08:54:31  verdier
// DevState & DevStatus are virtual.
// First tests with Tango2
// Taco import utility added.
//
// Revision 1.20  2000/07/07 13:30:10  verdier
// Utilities added after first users.
//
// Revision 1.18  2000/06/20 06:57:35  verdier
// Right button double click management added for :
// editing src code, creating item, editing class....
// Little bugs fixed on generation/re-read src code.
//
// Revision 1.17  2000/05/12 07:37:10  verdier
//  Attributes management added for java generation.
//
// Revision 1.16  2000/04/26 06:04:00  verdier
// The save/restore file (.pogo) does not exist anymore.
// DevStates and DevStates allowed management is now available for java.
//
// Revision 1.15  2000/04/18 08:12:47  verdier
// Management of DevStates to allow command added.
//
// Revision 1.14  2000/04/12 09:25:43  verdier
// Methods to manage attributes are now generated
//  Only if at leat one attribute exists.
//
// Revision 1.13  2000/04/11 09:35:07  verdier
// Attributes management added.
//
//
// Copyright 1995 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================
package pogo.appli;



import java.util.*;
import javax.swing.*;
import pogo.gene.*;

//===============================================================
/**
 *	A Dialog Class to get the Attribute parameters.
 */
//===============================================================
public class AttributeDialog extends javax.swing.JDialog implements PogoAppliDefs, PogoDefs {

  private static int returnStatus = PogoAppliDefs.RET_CANCEL;

	private String	name;
	private String	assAttr;
	private int		attrType;
	private int		xSize;
	private int		ySize;
  /**
   * Initializes the Form
   */
  public AttributeDialog(java.awt.Frame parent,boolean modal) {
      super (parent, modal);
    initComponents ();

    //  init comboboxes
    //-----------------------
    for (int i=0 ; i<AttrTypeArray.length ; i++)
      attrTypeCB.addItem(AttrTypeArray[i]);
    for (int i=0 ; i<AttrDataArray.length ; i++)
      dataTypeCB.addItem(AttrDataArray[i]);
    for (int i=0 ; i<AttrRWtypeArray.length ; i++)
      rwTypeCB.addItem(AttrRWtypeArray[i]);

   pack ();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the FormEditor.
   */
  private void initComponents () {//GEN-BEGIN:initComponents
    jPanel2 = new javax.swing.JPanel ();
    nameLbl = new javax.swing.JLabel ();
    attrTypeCB = new javax.swing.JComboBox ();
    jLabel1 = new javax.swing.JLabel ();
    nameText = new javax.swing.JTextField ();
    jLabel2 = new javax.swing.JLabel ();
    jLabel3 = new javax.swing.JLabel ();
    jLabel4 = new javax.swing.JLabel ();
    dataTypeCB = new javax.swing.JComboBox ();
    xDataLBL = new javax.swing.JLabel ();
    yDataLBL = new javax.swing.JLabel ();
    xDataTF = new javax.swing.JTextField ();
    yDataTF = new javax.swing.JTextField ();
    rwTypeCB = new javax.swing.JComboBox ();
    jLabel5 = new javax.swing.JLabel ();
    assAttrLBL = new javax.swing.JLabel ();
    assAttrTF = new javax.swing.JTextField ();
    rwTypeLBL = new javax.swing.JLabel ();
    jPanel1 = new javax.swing.JPanel ();
    okBtn = new javax.swing.JButton ();
    cancelBtn = new javax.swing.JButton ();
    setBackground (new java.awt.Color (198, 178, 168));
    setTitle ("Edit Attribute Window");
    addWindowListener (new java.awt.event.WindowAdapter () {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        closeDialog (evt);
      }
    }
    );

    jPanel2.setLayout (new java.awt.GridBagLayout ());
    java.awt.GridBagConstraints gridBagConstraints1;

      nameLbl.setText ("Attribute Type: ");
      nameLbl.setForeground (java.awt.Color.black);
      nameLbl.setFont (new java.awt.Font ("Arial", 1, 12));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 2;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (nameLbl, gridBagConstraints1);
  
      attrTypeCB.setFont (new java.awt.Font ("Arial", 1, 12));
      attrTypeCB.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          attrTypeCBActionPerformed (evt);
        }
      }
      );
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 2;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jPanel2.add (attrTypeCB, gridBagConstraints1);
  
      jLabel1.setText ("Attribute Name: ");
      jLabel1.setForeground (java.awt.Color.black);
      jLabel1.setFont (new java.awt.Font ("Arial", 1, 12));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 1;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (jLabel1, gridBagConstraints1);
  
      nameText.setFont (new java.awt.Font ("Arial", 1, 12));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 1;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jPanel2.add (nameText, gridBagConstraints1);
  
      jLabel2.setPreferredSize (new java.awt.Dimension(50, 50));
      jLabel2.setMinimumSize (new java.awt.Dimension(50, 50));
      jLabel2.setText (" ");
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 10;
      jPanel2.add (jLabel2, gridBagConstraints1);
  
      jLabel3.setPreferredSize (new java.awt.Dimension(20, 15));
      jLabel3.setMinimumSize (new java.awt.Dimension(20, 15));
      jLabel3.setText (" ");
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 3;
      gridBagConstraints1.gridy = 2;
      jPanel2.add (jLabel3, gridBagConstraints1);
  
      jLabel4.setText ("Data Type: ");
      jLabel4.setForeground (java.awt.Color.black);
      jLabel4.setFont (new java.awt.Font ("Arial", 1, 12));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 3;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (jLabel4, gridBagConstraints1);
  
      dataTypeCB.setFont (new java.awt.Font ("Arial", 1, 12));
      dataTypeCB.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          dataTypeCBActionPerformed (evt);
        }
      }
      );
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 3;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jPanel2.add (dataTypeCB, gridBagConstraints1);
  
      xDataLBL.setText ("Maximum X data size");
      xDataLBL.setForeground (java.awt.Color.black);
      xDataLBL.setFont (new java.awt.Font ("Arial", 1, 12));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 6;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (xDataLBL, gridBagConstraints1);
  
      yDataLBL.setText ("Maximum Y data size: ");
      yDataLBL.setForeground (java.awt.Color.black);
      yDataLBL.setFont (new java.awt.Font ("Arial", 1, 12));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 7;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (yDataLBL, gridBagConstraints1);
  
      xDataTF.setPreferredSize (new java.awt.Dimension(100, 20));
      xDataTF.setMinimumSize (new java.awt.Dimension(100, 20));
      xDataTF.setFont (new java.awt.Font ("Arial", 1, 12));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 6;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jPanel2.add (xDataTF, gridBagConstraints1);
  
      yDataTF.setPreferredSize (new java.awt.Dimension(100, 20));
      yDataTF.setMinimumSize (new java.awt.Dimension(100, 20));
      yDataTF.setFont (new java.awt.Font ("Arial", 1, 12));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 7;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jPanel2.add (yDataTF, gridBagConstraints1);
  
      rwTypeCB.setFont (new java.awt.Font ("Arial", 1, 12));
      rwTypeCB.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          rwTypeCBActionPerformed (evt);
        }
      }
      );
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 4;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jPanel2.add (rwTypeCB, gridBagConstraints1);
  
      jLabel5.setText (" ");
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 5;
      jPanel2.add (jLabel5, gridBagConstraints1);
  
      assAttrLBL.setText ("Associated Attribute:");
      assAttrLBL.setForeground (java.awt.Color.black);
      assAttrLBL.setFont (new java.awt.Font ("Arial", 1, 12));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 8;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (assAttrLBL, gridBagConstraints1);
  
      assAttrTF.setPreferredSize (new java.awt.Dimension(100, 20));
      assAttrTF.setMinimumSize (new java.awt.Dimension(100, 20));
      assAttrTF.setFont (new java.awt.Font ("Arial", 1, 12));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 2;
      gridBagConstraints1.gridy = 8;
      gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
      jPanel2.add (assAttrTF, gridBagConstraints1);
  
      rwTypeLBL.setText ("Read/Write Type: ");
      rwTypeLBL.setForeground (java.awt.Color.black);
      rwTypeLBL.setFont (new java.awt.Font ("Arial", 1, 12));
  
      gridBagConstraints1 = new java.awt.GridBagConstraints ();
      gridBagConstraints1.gridx = 1;
      gridBagConstraints1.gridy = 4;
      gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
      jPanel2.add (rwTypeLBL, gridBagConstraints1);
  

    getContentPane ().add (jPanel2, java.awt.BorderLayout.CENTER);

    jPanel1.setLayout (new java.awt.FlowLayout (2, 5, 5));

      okBtn.setText ("OK");
      okBtn.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          okBtnActionPerformed (evt);
        }
      }
      );
  
      jPanel1.add (okBtn);
  
      cancelBtn.setText ("Cancel");
      cancelBtn.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          cancelBtnActionPerformed (evt);
        }
      }
      );
  
      jPanel1.add (cancelBtn);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.SOUTH);

  }//GEN-END:initComponents

  private void rwTypeCBActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rwTypeCBActionPerformed
	updateWindow();
  }//GEN-LAST:event_rwTypeCBActionPerformed

  private void dataTypeCBActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dataTypeCBActionPerformed
	updateWindow();
  }//GEN-LAST:event_dataTypeCBActionPerformed

  private void attrTypeCBActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_attrTypeCBActionPerformed
	updateWindow();
  }//GEN-LAST:event_attrTypeCBActionPerformed



  private void cancelBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBtnActionPerformed
  doClose(PogoAppliDefs.RET_CANCEL);
  }//GEN-LAST:event_cancelBtnActionPerformed

	//==============================================================
	private final int	EMPTY_FIELD    = -1;
	private final int	NEGATIVE_FIELD = -2;
	private int checkIntField(String s)
	{
		int	value;
		int end = s.indexOf('.');
		if (end>=0)
			s = s.substring(0, end);

		if (s.length()==0)
			return EMPTY_FIELD;
		else
		if ((value=(new Integer(s)).intValue()) < 0)
			return NEGATIVE_FIELD;
		else
			return value;
		
	}
	//==============================================================
  private void okBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okBtnActionPerformed
  	String	message = null;
	String	s;

	//	Control if Name, xSize and ySize fields have been filled.
	//--------------------------------------------------------------
	name = nameText.getText();
	if (name.length()==0)
		message = "The attribute needs a name to be defined";
	else
	{
		//	Take of space char if exist
		//--------------------------------------
		StringTokenizer stk = new StringTokenizer(nameText.getText());
		String	name = stk.nextToken();

		//	Check if first char is upcase else set it
		//-------------------------------------------------
		if (name.charAt(0) >='a' || name.charAt(0) >='z')
		{
			char	car = (char)(name.charAt(0)-('a'-'A'));
			name = new String(car + name.substring(1));
		}
		nameText.setText(name);

		switch (attrType=attrTypeCB.getSelectedIndex())
		{
		case ATTR_SCALAR:
			if (rwTypeCB.getSelectedIndex()==ATTR_READ_WITH_WRITE)
				assAttr = assAttrTF.getText();
			else
				assAttr = "";
			break;
		case ATTR_SPECTRUM:
			switch(xSize=checkIntField(xDataTF.getText()))
			{
			case EMPTY_FIELD:
				message = "Spectrum Attribute needs an X length of data";
				break;
			case NEGATIVE_FIELD:
				message = "Spectrum Attribute needs a POSITIVE X length of data";
				break;
			}
			break;
		case ATTR_IMAGE:
			switch(xSize=checkIntField(xDataTF.getText()))
			{
			case EMPTY_FIELD:
				message = "Image Attribute needs an X length of data";
				break;
			case NEGATIVE_FIELD:
				message = "Image Attribute needs a POSITIVE X length of data";
				break;
			}
			switch(ySize=checkIntField(yDataTF.getText()))
			{
			case EMPTY_FIELD:
				message = "Image Attribute needs an Y length of data";
				break;
			case NEGATIVE_FIELD:
				message = "Image Attribute needs a POSITIVE Y length of data";
				break;
			}
		}
	}
	if (message!=null)
		JOptionPane.showMessageDialog(this,  message, "Error Window",
													JOptionPane.ERROR_MESSAGE);
	else
	    doClose(PogoAppliDefs.RET_OK);
  }//GEN-LAST:event_okBtnActionPerformed

  /** Closes the dialog */
  private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
  doClose(PogoAppliDefs.RET_CANCEL);
  }//GEN-LAST:event_closeDialog

   //======================================================
  public int showDialog(Attrib attr)
  {
    //  Initialize Window with input parameters
    //-----------------------------------------------
	nameText.setText(attr.name);
	xDataTF.setText((new Integer(attr.xSize)).toString());
	yDataTF.setText((new Integer(attr.ySize)).toString());
	assAttrTF.setText(attr.assAttr);

	attrTypeCB.setSelectedIndex(attr.attrType);
	rwTypeCB.setSelectedIndex(attr.rwType);

	for (int i=0 ; i<AttrDataArray.length ; i++)
		if (AttrDataArray[i].equals(attr.dataType.code_str))
			dataTypeCB.setSelectedIndex(i);

	updateWindow();
    setVisible(true);
    return returnStatus;
  }
  //======================================================
  private void doClose(int retStatus)
  {
    returnStatus = retStatus;
    setVisible (false);
    dispose ();
  }

  //======================================================
  public Attrib  getInput()
  {
  	Attrib	attr = null;
	switch(attrTypeCB.getSelectedIndex())
	{
	case ATTR_SCALAR:
		attr = new Attrib(name,
						ATTR_SCALAR,
						dataTypeCB.getSelectedItem().toString(),
						rwTypeCB.getSelectedIndex(),
						assAttr);
		break;
	case ATTR_SPECTRUM:
		attr = new Attrib(name,
						ATTR_SPECTRUM,
						dataTypeCB.getSelectedItem().toString(),
						xSize);
		break;
	case ATTR_IMAGE:
		attr = new Attrib(name,
						ATTR_IMAGE,
						dataTypeCB.getSelectedItem().toString(),
						xSize,
						ySize);
		break;
	}
	return attr;
  }
  //======================================================
  private void updateWindow()
  {
 	switch(attrTypeCB.getSelectedIndex())
	{
	case ATTR_SCALAR:
		rwTypeCB.setVisible(true);
		rwTypeLBL.setVisible(true);
		xDataTF.setVisible(false);
		yDataTF.setVisible(false);
		xDataLBL.setVisible(false);
		yDataLBL.setVisible(false);
		switch(rwTypeCB.getSelectedIndex())
		{
		case ATTR_READ_WITH_WRITE:
			assAttrTF.setVisible(true);
			assAttrLBL.setVisible(true);
			break;
		default:
			assAttrTF.setVisible(false);
			assAttrLBL.setVisible(false);
			break;
		}
		break;
	case ATTR_SPECTRUM:
		rwTypeCB.setVisible(false);
		rwTypeLBL.setVisible(false);
		xDataTF.setVisible(true);
		yDataTF.setVisible(false);
		xDataLBL.setVisible(true);
		yDataLBL.setVisible(false);
		assAttrTF.setVisible(false);
		assAttrLBL.setVisible(false);
		break;
	case ATTR_IMAGE:
		rwTypeCB.setVisible(false);
		rwTypeLBL.setVisible(false);
		xDataTF.setVisible(true);
		yDataTF.setVisible(true);
		xDataLBL.setVisible(true);
		yDataLBL.setVisible(true);
		assAttrTF.setVisible(false);
		assAttrLBL.setVisible(false);
		break;
	}
	pack();
  }
  //======================================================

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel jPanel2;
  private javax.swing.JLabel nameLbl;
  private javax.swing.JComboBox attrTypeCB;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JTextField nameText;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JLabel jLabel3;
  private javax.swing.JLabel jLabel4;
  private javax.swing.JComboBox dataTypeCB;
  private javax.swing.JLabel xDataLBL;
  private javax.swing.JLabel yDataLBL;
  private javax.swing.JTextField xDataTF;
  private javax.swing.JTextField yDataTF;
  private javax.swing.JComboBox rwTypeCB;
  private javax.swing.JLabel jLabel5;
  private javax.swing.JLabel assAttrLBL;
  private javax.swing.JTextField assAttrTF;
  private javax.swing.JLabel rwTypeLBL;
  private javax.swing.JPanel jPanel1;
  private javax.swing.JButton okBtn;
  private javax.swing.JButton cancelBtn;
  // End of variables declaration//GEN-END:variables

  //======================================================

  public static void main(java.lang.String[] args) {
    new AttributeDialog (new java.awt.Frame (), false).show ();
  }

}
